/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MemberSummary;
import com.launchdarkly.api.model.RecentTriggerBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TriggerWorkflowRep {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    private Integer version;
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_MAINTAINER_ID = "_maintainerId";
    @SerializedName(value="_maintainerId")
    private String maintainerId;
    public static final String SERIALIZED_NAME_MAINTAINER = "_maintainer";
    @SerializedName(value="_maintainer")
    private MemberSummary maintainer;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_INTEGRATION_KEY = "_integrationKey";
    @SerializedName(value="_integrationKey")
    private String integrationKey;
    public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
    @SerializedName(value="instructions")
    private List<Map<String, Object>> instructions = null;
    public static final String SERIALIZED_NAME_LAST_TRIGGERED_AT = "_lastTriggeredAt";
    @SerializedName(value="_lastTriggeredAt")
    private Long lastTriggeredAt;
    public static final String SERIALIZED_NAME_RECENT_TRIGGER_BODIES = "_recentTriggerBodies";
    @SerializedName(value="_recentTriggerBodies")
    private List<RecentTriggerBody> recentTriggerBodies = null;
    public static final String SERIALIZED_NAME_TRIGGER_COUNT = "_triggerCount";
    @SerializedName(value="_triggerCount")
    private Integer triggerCount;
    public static final String SERIALIZED_NAME_TRIGGER_U_R_L = "triggerURL";
    @SerializedName(value="triggerURL")
    private String triggerURL;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TriggerWorkflowRep id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TriggerWorkflowRep version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The flag trigger version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public TriggerWorkflowRep creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public TriggerWorkflowRep maintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12ab3c45de678910abc12345", value="The ID of the flag trigger maintainer")
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public TriggerWorkflowRep maintainer(MemberSummary maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MemberSummary getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(MemberSummary maintainer) {
        this.maintainer = maintainer;
    }

    public TriggerWorkflowRep enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the flag trigger is currently enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TriggerWorkflowRep integrationKey(String integrationKey) {
        this.integrationKey = integrationKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="generic-trigger", value="The unique identifier of the integration for your trigger")
    public String getIntegrationKey() {
        return this.integrationKey;
    }

    public void setIntegrationKey(String integrationKey) {
        this.integrationKey = integrationKey;
    }

    public TriggerWorkflowRep instructions(List<Map<String, Object>> instructions) {
        this.instructions = instructions;
        return this;
    }

    public TriggerWorkflowRep addInstructionsItem(Map<String, Object> instructionsItem) {
        if (this.instructions == null) {
            this.instructions = new ArrayList<Map<String, Object>>();
        }
        this.instructions.add(instructionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<Map<String, Object>> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<Map<String, Object>> instructions) {
        this.instructions = instructions;
    }

    public TriggerWorkflowRep lastTriggeredAt(Long lastTriggeredAt) {
        this.lastTriggeredAt = lastTriggeredAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastTriggeredAt() {
        return this.lastTriggeredAt;
    }

    public void setLastTriggeredAt(Long lastTriggeredAt) {
        this.lastTriggeredAt = lastTriggeredAt;
    }

    public TriggerWorkflowRep recentTriggerBodies(List<RecentTriggerBody> recentTriggerBodies) {
        this.recentTriggerBodies = recentTriggerBodies;
        return this;
    }

    public TriggerWorkflowRep addRecentTriggerBodiesItem(RecentTriggerBody recentTriggerBodiesItem) {
        if (this.recentTriggerBodies == null) {
            this.recentTriggerBodies = new ArrayList<RecentTriggerBody>();
        }
        this.recentTriggerBodies.add(recentTriggerBodiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on recent flag trigger requests.")
    public List<RecentTriggerBody> getRecentTriggerBodies() {
        return this.recentTriggerBodies;
    }

    public void setRecentTriggerBodies(List<RecentTriggerBody> recentTriggerBodies) {
        this.recentTriggerBodies = recentTriggerBodies;
    }

    public TriggerWorkflowRep triggerCount(Integer triggerCount) {
        this.triggerCount = triggerCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="Number of times the trigger has been executed")
    public Integer getTriggerCount() {
        return this.triggerCount;
    }

    public void setTriggerCount(Integer triggerCount) {
        this.triggerCount = triggerCount;
    }

    public TriggerWorkflowRep triggerURL(String triggerURL) {
        this.triggerURL = triggerURL;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unguessable URL for this flag trigger")
    public String getTriggerURL() {
        return this.triggerURL;
    }

    public void setTriggerURL(String triggerURL) {
        this.triggerURL = triggerURL;
    }

    public TriggerWorkflowRep links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public TriggerWorkflowRep putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public TriggerWorkflowRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerWorkflowRep triggerWorkflowRep = (TriggerWorkflowRep)o;
        return Objects.equals(this.id, triggerWorkflowRep.id) && Objects.equals(this.version, triggerWorkflowRep.version) && Objects.equals(this.creationDate, triggerWorkflowRep.creationDate) && Objects.equals(this.maintainerId, triggerWorkflowRep.maintainerId) && Objects.equals(this.maintainer, triggerWorkflowRep.maintainer) && Objects.equals(this.enabled, triggerWorkflowRep.enabled) && Objects.equals(this.integrationKey, triggerWorkflowRep.integrationKey) && Objects.equals(this.instructions, triggerWorkflowRep.instructions) && Objects.equals(this.lastTriggeredAt, triggerWorkflowRep.lastTriggeredAt) && Objects.equals(this.recentTriggerBodies, triggerWorkflowRep.recentTriggerBodies) && Objects.equals(this.triggerCount, triggerWorkflowRep.triggerCount) && Objects.equals(this.triggerURL, triggerWorkflowRep.triggerURL) && Objects.equals(this.links, triggerWorkflowRep.links) && Objects.equals(this.additionalProperties, triggerWorkflowRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.creationDate, this.maintainerId, this.maintainer, this.enabled, this.integrationKey, this.instructions, this.lastTriggeredAt, this.recentTriggerBodies, this.triggerCount, this.triggerURL, this.links, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TriggerWorkflowRep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    maintainer: ").append(this.toIndentedString(this.maintainer)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    integrationKey: ").append(this.toIndentedString(this.integrationKey)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    lastTriggeredAt: ").append(this.toIndentedString(this.lastTriggeredAt)).append("\n");
        sb.append("    recentTriggerBodies: ").append(this.toIndentedString(this.recentTriggerBodies)).append("\n");
        sb.append("    triggerCount: ").append(this.toIndentedString(this.triggerCount)).append("\n");
        sb.append("    triggerURL: ").append(this.toIndentedString(this.triggerURL)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TriggerWorkflowRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_maintainerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINER) != null) {
            MemberSummary.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MAINTAINER));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY) != null && !jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_integrationKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS) != null && !jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `instructions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS).toString()));
        }
        JsonArray jsonArrayrecentTriggerBodies = jsonObj.getAsJsonArray(SERIALIZED_NAME_RECENT_TRIGGER_BODIES);
        if (jsonArrayrecentTriggerBodies != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECENT_TRIGGER_BODIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `_recentTriggerBodies` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECENT_TRIGGER_BODIES).toString()));
            }
            for (int i = 0; i < jsonArrayrecentTriggerBodies.size(); ++i) {
                RecentTriggerBody.validateJsonObject(jsonArrayrecentTriggerBodies.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TRIGGER_U_R_L) != null && !jsonObj.get(SERIALIZED_NAME_TRIGGER_U_R_L).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `triggerURL` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRIGGER_U_R_L).toString()));
        }
    }

    public static TriggerWorkflowRep fromJson(String jsonString) throws IOException {
        return (TriggerWorkflowRep)JSON.getGson().fromJson(jsonString, TriggerWorkflowRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER_ID);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_INTEGRATION_KEY);
        openapiFields.add(SERIALIZED_NAME_INSTRUCTIONS);
        openapiFields.add(SERIALIZED_NAME_LAST_TRIGGERED_AT);
        openapiFields.add(SERIALIZED_NAME_RECENT_TRIGGER_BODIES);
        openapiFields.add(SERIALIZED_NAME_TRIGGER_COUNT);
        openapiFields.add(SERIALIZED_NAME_TRIGGER_U_R_L);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!TriggerWorkflowRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TriggerWorkflowRep.class));
            return new TypeAdapter<TriggerWorkflowRep>(){

                public void write(JsonWriter out, TriggerWorkflowRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public TriggerWorkflowRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TriggerWorkflowRep.validateJsonObject(jsonObj);
                    TriggerWorkflowRep instance = (TriggerWorkflowRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

