/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VersionsRep {
    public static final String SERIALIZED_NAME_VALID_VERSIONS = "validVersions";
    @SerializedName(value="validVersions")
    private List<Integer> validVersions = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_LATEST_VERSION = "latestVersion";
    @SerializedName(value="latestVersion")
    private Integer latestVersion;
    public static final String SERIALIZED_NAME_CURRENT_VERSION = "currentVersion";
    @SerializedName(value="currentVersion")
    private Integer currentVersion;
    public static final String SERIALIZED_NAME_BETA = "beta";
    @SerializedName(value="beta")
    private Boolean beta;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VersionsRep validVersions(List<Integer> validVersions) {
        this.validVersions = validVersions;
        return this;
    }

    public VersionsRep addValidVersionsItem(Integer validVersionsItem) {
        this.validVersions.add(validVersionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A list of all valid API versions. To learn more about our versioning, read [Versioning](https://apidocs.launchdarkly.com/#section/Overview/Versioning).")
    public List<Integer> getValidVersions() {
        return this.validVersions;
    }

    public void setValidVersions(List<Integer> validVersions) {
        this.validVersions = validVersions;
    }

    public VersionsRep latestVersion(Integer latestVersion) {
        this.latestVersion = latestVersion;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Integer getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(Integer latestVersion) {
        this.latestVersion = latestVersion;
    }

    public VersionsRep currentVersion(Integer currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Integer getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(Integer currentVersion) {
        this.currentVersion = currentVersion;
    }

    public VersionsRep beta(Boolean beta) {
        this.beta = beta;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether the version of the API currently is use is a beta version. This is always <code>true</code> if you add the <code>LD-API-Version: beta</code> header to your request.")
    public Boolean getBeta() {
        return this.beta;
    }

    public void setBeta(Boolean beta) {
        this.beta = beta;
    }

    public VersionsRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionsRep versionsRep = (VersionsRep)o;
        return Objects.equals(this.validVersions, versionsRep.validVersions) && Objects.equals(this.latestVersion, versionsRep.latestVersion) && Objects.equals(this.currentVersion, versionsRep.currentVersion) && Objects.equals(this.beta, versionsRep.beta) && Objects.equals(this.additionalProperties, versionsRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.validVersions, this.latestVersion, this.currentVersion, this.beta, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VersionsRep {\n");
        sb.append("    validVersions: ").append(this.toIndentedString(this.validVersions)).append("\n");
        sb.append("    latestVersion: ").append(this.toIndentedString(this.latestVersion)).append("\n");
        sb.append("    currentVersion: ").append(this.toIndentedString(this.currentVersion)).append("\n");
        sb.append("    beta: ").append(this.toIndentedString(this.beta)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in VersionsRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALID_VERSIONS) != null && !jsonObj.get(SERIALIZED_NAME_VALID_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `validVersions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALID_VERSIONS).toString()));
        }
    }

    public static VersionsRep fromJson(String jsonString) throws IOException {
        return (VersionsRep)JSON.getGson().fromJson(jsonString, VersionsRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_VALID_VERSIONS);
        openapiFields.add(SERIALIZED_NAME_LATEST_VERSION);
        openapiFields.add(SERIALIZED_NAME_CURRENT_VERSION);
        openapiFields.add(SERIALIZED_NAME_BETA);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_VALID_VERSIONS);
        openapiRequiredFields.add(SERIALIZED_NAME_LATEST_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENT_VERSION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!VersionsRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VersionsRep.class));
            return new TypeAdapter<VersionsRep>(){

                public void write(JsonWriter out, VersionsRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public VersionsRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    VersionsRep.validateJsonObject(jsonObj);
                    VersionsRep instance = (VersionsRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

