/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.AIConfig;
import com.launchdarkly.api.model.AIConfigPatch;
import com.launchdarkly.api.model.AIConfigPost;
import com.launchdarkly.api.model.AIConfigVariation;
import com.launchdarkly.api.model.AIConfigVariationPatch;
import com.launchdarkly.api.model.AIConfigVariationPost;
import com.launchdarkly.api.model.AIConfigVariationsResponse;
import com.launchdarkly.api.model.AIConfigs;
import com.launchdarkly.api.model.MetricByVariation;
import com.launchdarkly.api.model.Metrics;
import com.launchdarkly.api.model.ModelConfig;
import com.launchdarkly.api.model.ModelConfigPost;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class AiConfigsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AiConfigsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AiConfigsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteAIConfigCall(String ldAPIVersion, String projectKey, String configKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAIConfigValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteAIConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteAIConfig(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling deleteAIConfig(Async)");
        }
        Call localVarCall = this.deleteAIConfigCall(ldAPIVersion, projectKey, configKey, _callback);
        return localVarCall;
    }

    public void deleteAIConfig(String ldAPIVersion, String projectKey, String configKey) throws ApiException {
        this.deleteAIConfigWithHttpInfo(ldAPIVersion, projectKey, configKey);
    }

    public ApiResponse<Void> deleteAIConfigWithHttpInfo(String ldAPIVersion, String projectKey, String configKey) throws ApiException {
        Call localVarCall = this.deleteAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAIConfigAsync(String ldAPIVersion, String projectKey, String configKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteAIConfigVariationCall(String ldAPIVersion, String projectKey, String configKey, String variationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/variations/{variationKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString())).replaceAll("\\{variationKey\\}", this.localVarApiClient.escapeString(variationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAIConfigVariationValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, String variationKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteAIConfigVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteAIConfigVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling deleteAIConfigVariation(Async)");
        }
        if (variationKey == null) {
            throw new ApiException("Missing the required parameter 'variationKey' when calling deleteAIConfigVariation(Async)");
        }
        Call localVarCall = this.deleteAIConfigVariationCall(ldAPIVersion, projectKey, configKey, variationKey, _callback);
        return localVarCall;
    }

    public void deleteAIConfigVariation(String ldAPIVersion, String projectKey, String configKey, String variationKey) throws ApiException {
        this.deleteAIConfigVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, variationKey);
    }

    public ApiResponse<Void> deleteAIConfigVariationWithHttpInfo(String ldAPIVersion, String projectKey, String configKey, String variationKey) throws ApiException {
        Call localVarCall = this.deleteAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAIConfigVariationAsync(String ldAPIVersion, String projectKey, String configKey, String variationKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteModelConfigCall(String ldAPIVersion, String projectKey, String modelConfigKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs/{modelConfigKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{modelConfigKey\\}", this.localVarApiClient.escapeString(modelConfigKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteModelConfigValidateBeforeCall(String ldAPIVersion, String projectKey, String modelConfigKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteModelConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteModelConfig(Async)");
        }
        if (modelConfigKey == null) {
            throw new ApiException("Missing the required parameter 'modelConfigKey' when calling deleteModelConfig(Async)");
        }
        Call localVarCall = this.deleteModelConfigCall(ldAPIVersion, projectKey, modelConfigKey, _callback);
        return localVarCall;
    }

    public void deleteModelConfig(String ldAPIVersion, String projectKey, String modelConfigKey) throws ApiException {
        this.deleteModelConfigWithHttpInfo(ldAPIVersion, projectKey, modelConfigKey);
    }

    public ApiResponse<Void> deleteModelConfigWithHttpInfo(String ldAPIVersion, String projectKey, String modelConfigKey) throws ApiException {
        Call localVarCall = this.deleteModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteModelConfigAsync(String ldAPIVersion, String projectKey, String modelConfigKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAIConfigCall(String ldAPIVersion, String projectKey, String configKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfig(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfig(Async)");
        }
        Call localVarCall = this.getAIConfigCall(ldAPIVersion, projectKey, configKey, _callback);
        return localVarCall;
    }

    public AIConfig getAIConfig(String ldAPIVersion, String projectKey, String configKey) throws ApiException {
        ApiResponse<AIConfig> localVarResp = this.getAIConfigWithHttpInfo(ldAPIVersion, projectKey, configKey);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfig> getAIConfigWithHttpInfo(String ldAPIVersion, String projectKey, String configKey) throws ApiException {
        Call localVarCall = this.getAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, null);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigAsync(String ldAPIVersion, String projectKey, String configKey, ApiCallback<AIConfig> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, _callback);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigMetricsCall(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/metrics".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (env != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("env", env));
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigMetricsValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigMetrics(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigMetrics(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfigMetrics(Async)");
        }
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling getAIConfigMetrics(Async)");
        }
        if (to == null) {
            throw new ApiException("Missing the required parameter 'to' when calling getAIConfigMetrics(Async)");
        }
        if (env == null) {
            throw new ApiException("Missing the required parameter 'env' when calling getAIConfigMetrics(Async)");
        }
        Call localVarCall = this.getAIConfigMetricsCall(ldAPIVersion, projectKey, configKey, from, to, env, _callback);
        return localVarCall;
    }

    public Metrics getAIConfigMetrics(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env) throws ApiException {
        ApiResponse<Metrics> localVarResp = this.getAIConfigMetricsWithHttpInfo(ldAPIVersion, projectKey, configKey, from, to, env);
        return localVarResp.getData();
    }

    public ApiResponse<Metrics> getAIConfigMetricsWithHttpInfo(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env) throws ApiException {
        Call localVarCall = this.getAIConfigMetricsValidateBeforeCall(ldAPIVersion, projectKey, configKey, from, to, env, null);
        Type localVarReturnType = new TypeToken<Metrics>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigMetricsAsync(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env, ApiCallback<Metrics> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigMetricsValidateBeforeCall(ldAPIVersion, projectKey, configKey, from, to, env, _callback);
        Type localVarReturnType = new TypeToken<Metrics>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigMetricsByVariationCall(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/metrics-by-variation".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (env != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("env", env));
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigMetricsByVariationValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (to == null) {
            throw new ApiException("Missing the required parameter 'to' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (env == null) {
            throw new ApiException("Missing the required parameter 'env' when calling getAIConfigMetricsByVariation(Async)");
        }
        Call localVarCall = this.getAIConfigMetricsByVariationCall(ldAPIVersion, projectKey, configKey, from, to, env, _callback);
        return localVarCall;
    }

    public List<MetricByVariation> getAIConfigMetricsByVariation(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env) throws ApiException {
        ApiResponse<List<MetricByVariation>> localVarResp = this.getAIConfigMetricsByVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, from, to, env);
        return localVarResp.getData();
    }

    public ApiResponse<List<MetricByVariation>> getAIConfigMetricsByVariationWithHttpInfo(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env) throws ApiException {
        Call localVarCall = this.getAIConfigMetricsByVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, from, to, env, null);
        Type localVarReturnType = new TypeToken<List<MetricByVariation>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigMetricsByVariationAsync(String ldAPIVersion, String projectKey, String configKey, Integer from, Integer to, String env, ApiCallback<List<MetricByVariation>> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigMetricsByVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, from, to, env, _callback);
        Type localVarReturnType = new TypeToken<List<MetricByVariation>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigVariationCall(String ldAPIVersion, String projectKey, String configKey, String variationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/variations/{variationKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString())).replaceAll("\\{variationKey\\}", this.localVarApiClient.escapeString(variationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigVariationValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, String variationKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfigVariation(Async)");
        }
        if (variationKey == null) {
            throw new ApiException("Missing the required parameter 'variationKey' when calling getAIConfigVariation(Async)");
        }
        Call localVarCall = this.getAIConfigVariationCall(ldAPIVersion, projectKey, configKey, variationKey, _callback);
        return localVarCall;
    }

    public AIConfigVariationsResponse getAIConfigVariation(String ldAPIVersion, String projectKey, String configKey, String variationKey) throws ApiException {
        ApiResponse<AIConfigVariationsResponse> localVarResp = this.getAIConfigVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, variationKey);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigVariationsResponse> getAIConfigVariationWithHttpInfo(String ldAPIVersion, String projectKey, String configKey, String variationKey) throws ApiException {
        Call localVarCall = this.getAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, null);
        Type localVarReturnType = new TypeToken<AIConfigVariationsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigVariationAsync(String ldAPIVersion, String projectKey, String configKey, String variationKey, ApiCallback<AIConfigVariationsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, _callback);
        Type localVarReturnType = new TypeToken<AIConfigVariationsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigsCall(String ldAPIVersion, String projectKey, String sort, Integer limit, Integer offset, String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigsValidateBeforeCall(String ldAPIVersion, String projectKey, String sort, Integer limit, Integer offset, String filter, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigs(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigs(Async)");
        }
        Call localVarCall = this.getAIConfigsCall(ldAPIVersion, projectKey, sort, limit, offset, filter, _callback);
        return localVarCall;
    }

    public AIConfigs getAIConfigs(String ldAPIVersion, String projectKey, String sort, Integer limit, Integer offset, String filter) throws ApiException {
        ApiResponse<AIConfigs> localVarResp = this.getAIConfigsWithHttpInfo(ldAPIVersion, projectKey, sort, limit, offset, filter);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigs> getAIConfigsWithHttpInfo(String ldAPIVersion, String projectKey, String sort, Integer limit, Integer offset, String filter) throws ApiException {
        Call localVarCall = this.getAIConfigsValidateBeforeCall(ldAPIVersion, projectKey, sort, limit, offset, filter, null);
        Type localVarReturnType = new TypeToken<AIConfigs>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigsAsync(String ldAPIVersion, String projectKey, String sort, Integer limit, Integer offset, String filter, ApiCallback<AIConfigs> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigsValidateBeforeCall(ldAPIVersion, projectKey, sort, limit, offset, filter, _callback);
        Type localVarReturnType = new TypeToken<AIConfigs>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getModelConfigCall(String ldAPIVersion, String projectKey, String modelConfigKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs/{modelConfigKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{modelConfigKey\\}", this.localVarApiClient.escapeString(modelConfigKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getModelConfigValidateBeforeCall(String ldAPIVersion, String projectKey, String modelConfigKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getModelConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getModelConfig(Async)");
        }
        if (modelConfigKey == null) {
            throw new ApiException("Missing the required parameter 'modelConfigKey' when calling getModelConfig(Async)");
        }
        Call localVarCall = this.getModelConfigCall(ldAPIVersion, projectKey, modelConfigKey, _callback);
        return localVarCall;
    }

    public ModelConfig getModelConfig(String ldAPIVersion, String projectKey, String modelConfigKey) throws ApiException {
        ApiResponse<ModelConfig> localVarResp = this.getModelConfigWithHttpInfo(ldAPIVersion, projectKey, modelConfigKey);
        return localVarResp.getData();
    }

    public ApiResponse<ModelConfig> getModelConfigWithHttpInfo(String ldAPIVersion, String projectKey, String modelConfigKey) throws ApiException {
        Call localVarCall = this.getModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigKey, null);
        Type localVarReturnType = new TypeToken<ModelConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getModelConfigAsync(String ldAPIVersion, String projectKey, String modelConfigKey, ApiCallback<ModelConfig> _callback) throws ApiException {
        Call localVarCall = this.getModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigKey, _callback);
        Type localVarReturnType = new TypeToken<ModelConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listModelConfigsCall(String ldAPIVersion, String projectKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listModelConfigsValidateBeforeCall(String ldAPIVersion, String projectKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling listModelConfigs(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling listModelConfigs(Async)");
        }
        Call localVarCall = this.listModelConfigsCall(ldAPIVersion, projectKey, _callback);
        return localVarCall;
    }

    public List<ModelConfig> listModelConfigs(String ldAPIVersion, String projectKey) throws ApiException {
        ApiResponse<List<ModelConfig>> localVarResp = this.listModelConfigsWithHttpInfo(ldAPIVersion, projectKey);
        return localVarResp.getData();
    }

    public ApiResponse<List<ModelConfig>> listModelConfigsWithHttpInfo(String ldAPIVersion, String projectKey) throws ApiException {
        Call localVarCall = this.listModelConfigsValidateBeforeCall(ldAPIVersion, projectKey, null);
        Type localVarReturnType = new TypeToken<List<ModelConfig>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listModelConfigsAsync(String ldAPIVersion, String projectKey, ApiCallback<List<ModelConfig>> _callback) throws ApiException {
        Call localVarCall = this.listModelConfigsValidateBeforeCall(ldAPIVersion, projectKey, _callback);
        Type localVarReturnType = new TypeToken<List<ModelConfig>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchAIConfigCall(String ldAPIVersion, String projectKey, String configKey, AIConfigPatch aiConfigPatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigPatch localVarPostBody = aiConfigPatch;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchAIConfigValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, AIConfigPatch aiConfigPatch, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling patchAIConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchAIConfig(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling patchAIConfig(Async)");
        }
        Call localVarCall = this.patchAIConfigCall(ldAPIVersion, projectKey, configKey, aiConfigPatch, _callback);
        return localVarCall;
    }

    public AIConfig patchAIConfig(String ldAPIVersion, String projectKey, String configKey, AIConfigPatch aiConfigPatch) throws ApiException {
        ApiResponse<AIConfig> localVarResp = this.patchAIConfigWithHttpInfo(ldAPIVersion, projectKey, configKey, aiConfigPatch);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfig> patchAIConfigWithHttpInfo(String ldAPIVersion, String projectKey, String configKey, AIConfigPatch aiConfigPatch) throws ApiException {
        Call localVarCall = this.patchAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigPatch, null);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchAIConfigAsync(String ldAPIVersion, String projectKey, String configKey, AIConfigPatch aiConfigPatch, ApiCallback<AIConfig> _callback) throws ApiException {
        Call localVarCall = this.patchAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigPatch, _callback);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchAIConfigVariationCall(String ldAPIVersion, String projectKey, String configKey, String variationKey, AIConfigVariationPatch aiConfigVariationPatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigVariationPatch localVarPostBody = aiConfigVariationPatch;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/variations/{variationKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString())).replaceAll("\\{variationKey\\}", this.localVarApiClient.escapeString(variationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchAIConfigVariationValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, String variationKey, AIConfigVariationPatch aiConfigVariationPatch, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling patchAIConfigVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchAIConfigVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling patchAIConfigVariation(Async)");
        }
        if (variationKey == null) {
            throw new ApiException("Missing the required parameter 'variationKey' when calling patchAIConfigVariation(Async)");
        }
        Call localVarCall = this.patchAIConfigVariationCall(ldAPIVersion, projectKey, configKey, variationKey, aiConfigVariationPatch, _callback);
        return localVarCall;
    }

    public AIConfigVariation patchAIConfigVariation(String ldAPIVersion, String projectKey, String configKey, String variationKey, AIConfigVariationPatch aiConfigVariationPatch) throws ApiException {
        ApiResponse<AIConfigVariation> localVarResp = this.patchAIConfigVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, variationKey, aiConfigVariationPatch);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigVariation> patchAIConfigVariationWithHttpInfo(String ldAPIVersion, String projectKey, String configKey, String variationKey, AIConfigVariationPatch aiConfigVariationPatch) throws ApiException {
        Call localVarCall = this.patchAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, aiConfigVariationPatch, null);
        Type localVarReturnType = new TypeToken<AIConfigVariation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchAIConfigVariationAsync(String ldAPIVersion, String projectKey, String configKey, String variationKey, AIConfigVariationPatch aiConfigVariationPatch, ApiCallback<AIConfigVariation> _callback) throws ApiException {
        Call localVarCall = this.patchAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, aiConfigVariationPatch, _callback);
        Type localVarReturnType = new TypeToken<AIConfigVariation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postAIConfigCall(String ldAPIVersion, String projectKey, AIConfigPost aiConfigPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigPost localVarPostBody = aiConfigPost;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAIConfigValidateBeforeCall(String ldAPIVersion, String projectKey, AIConfigPost aiConfigPost, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling postAIConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postAIConfig(Async)");
        }
        if (aiConfigPost == null) {
            throw new ApiException("Missing the required parameter 'aiConfigPost' when calling postAIConfig(Async)");
        }
        Call localVarCall = this.postAIConfigCall(ldAPIVersion, projectKey, aiConfigPost, _callback);
        return localVarCall;
    }

    public AIConfig postAIConfig(String ldAPIVersion, String projectKey, AIConfigPost aiConfigPost) throws ApiException {
        ApiResponse<AIConfig> localVarResp = this.postAIConfigWithHttpInfo(ldAPIVersion, projectKey, aiConfigPost);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfig> postAIConfigWithHttpInfo(String ldAPIVersion, String projectKey, AIConfigPost aiConfigPost) throws ApiException {
        Call localVarCall = this.postAIConfigValidateBeforeCall(ldAPIVersion, projectKey, aiConfigPost, null);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postAIConfigAsync(String ldAPIVersion, String projectKey, AIConfigPost aiConfigPost, ApiCallback<AIConfig> _callback) throws ApiException {
        Call localVarCall = this.postAIConfigValidateBeforeCall(ldAPIVersion, projectKey, aiConfigPost, _callback);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postAIConfigVariationCall(String ldAPIVersion, String projectKey, String configKey, AIConfigVariationPost aiConfigVariationPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigVariationPost localVarPostBody = aiConfigVariationPost;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/variations".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{configKey\\}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAIConfigVariationValidateBeforeCall(String ldAPIVersion, String projectKey, String configKey, AIConfigVariationPost aiConfigVariationPost, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling postAIConfigVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postAIConfigVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling postAIConfigVariation(Async)");
        }
        if (aiConfigVariationPost == null) {
            throw new ApiException("Missing the required parameter 'aiConfigVariationPost' when calling postAIConfigVariation(Async)");
        }
        Call localVarCall = this.postAIConfigVariationCall(ldAPIVersion, projectKey, configKey, aiConfigVariationPost, _callback);
        return localVarCall;
    }

    public AIConfigVariation postAIConfigVariation(String ldAPIVersion, String projectKey, String configKey, AIConfigVariationPost aiConfigVariationPost) throws ApiException {
        ApiResponse<AIConfigVariation> localVarResp = this.postAIConfigVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, aiConfigVariationPost);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigVariation> postAIConfigVariationWithHttpInfo(String ldAPIVersion, String projectKey, String configKey, AIConfigVariationPost aiConfigVariationPost) throws ApiException {
        Call localVarCall = this.postAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigVariationPost, null);
        Type localVarReturnType = new TypeToken<AIConfigVariation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postAIConfigVariationAsync(String ldAPIVersion, String projectKey, String configKey, AIConfigVariationPost aiConfigVariationPost, ApiCallback<AIConfigVariation> _callback) throws ApiException {
        Call localVarCall = this.postAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigVariationPost, _callback);
        Type localVarReturnType = new TypeToken<AIConfigVariation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postModelConfigCall(String ldAPIVersion, String projectKey, ModelConfigPost modelConfigPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModelConfigPost localVarPostBody = modelConfigPost;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postModelConfigValidateBeforeCall(String ldAPIVersion, String projectKey, ModelConfigPost modelConfigPost, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling postModelConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postModelConfig(Async)");
        }
        if (modelConfigPost == null) {
            throw new ApiException("Missing the required parameter 'modelConfigPost' when calling postModelConfig(Async)");
        }
        Call localVarCall = this.postModelConfigCall(ldAPIVersion, projectKey, modelConfigPost, _callback);
        return localVarCall;
    }

    public ModelConfig postModelConfig(String ldAPIVersion, String projectKey, ModelConfigPost modelConfigPost) throws ApiException {
        ApiResponse<ModelConfig> localVarResp = this.postModelConfigWithHttpInfo(ldAPIVersion, projectKey, modelConfigPost);
        return localVarResp.getData();
    }

    public ApiResponse<ModelConfig> postModelConfigWithHttpInfo(String ldAPIVersion, String projectKey, ModelConfigPost modelConfigPost) throws ApiException {
        Call localVarCall = this.postModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigPost, null);
        Type localVarReturnType = new TypeToken<ModelConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postModelConfigAsync(String ldAPIVersion, String projectKey, ModelConfigPost modelConfigPost, ApiCallback<ModelConfig> _callback) throws ApiException {
        Call localVarCall = this.postModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigPost, _callback);
        Type localVarReturnType = new TypeToken<ModelConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

