/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.BranchCollectionRep;
import com.launchdarkly.api.model.BranchRep;
import com.launchdarkly.api.model.Extinction;
import com.launchdarkly.api.model.ExtinctionCollectionRep;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.PutBranch;
import com.launchdarkly.api.model.RepositoryCollectionRep;
import com.launchdarkly.api.model.RepositoryPost;
import com.launchdarkly.api.model.RepositoryRep;
import com.launchdarkly.api.model.StatisticCollectionRep;
import com.launchdarkly.api.model.StatisticsRoot;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class CodeReferencesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CodeReferencesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CodeReferencesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteBranchesCall(String repo, List<String> requestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<String> localVarPostBody = requestBody;
        String localVarPath = "/api/v2/code-refs/repositories/{repo}/branch-delete-tasks".replaceAll("\\{repo\\}", this.localVarApiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBranchesValidateBeforeCall(String repo, List<String> requestBody, ApiCallback _callback) throws ApiException {
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling deleteBranches(Async)");
        }
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling deleteBranches(Async)");
        }
        Call localVarCall = this.deleteBranchesCall(repo, requestBody, _callback);
        return localVarCall;
    }

    public void deleteBranches(String repo, List<String> requestBody) throws ApiException {
        this.deleteBranchesWithHttpInfo(repo, requestBody);
    }

    public ApiResponse<Void> deleteBranchesWithHttpInfo(String repo, List<String> requestBody) throws ApiException {
        Call localVarCall = this.deleteBranchesValidateBeforeCall(repo, requestBody, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteBranchesAsync(String repo, List<String> requestBody, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteBranchesValidateBeforeCall(repo, requestBody, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteRepositoryCall(String repo, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/code-refs/repositories/{repo}".replaceAll("\\{repo\\}", this.localVarApiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRepositoryValidateBeforeCall(String repo, ApiCallback _callback) throws ApiException {
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling deleteRepository(Async)");
        }
        Call localVarCall = this.deleteRepositoryCall(repo, _callback);
        return localVarCall;
    }

    public void deleteRepository(String repo) throws ApiException {
        this.deleteRepositoryWithHttpInfo(repo);
    }

    public ApiResponse<Void> deleteRepositoryWithHttpInfo(String repo) throws ApiException {
        Call localVarCall = this.deleteRepositoryValidateBeforeCall(repo, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteRepositoryAsync(String repo, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRepositoryValidateBeforeCall(repo, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getBranchCall(String repo, String branch, String projKey, String flagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/code-refs/repositories/{repo}/branches/{branch}".replaceAll("\\{repo\\}", this.localVarApiClient.escapeString(repo.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (projKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("projKey", projKey));
        }
        if (flagKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("flagKey", flagKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBranchValidateBeforeCall(String repo, String branch, String projKey, String flagKey, ApiCallback _callback) throws ApiException {
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling getBranch(Async)");
        }
        Call localVarCall = this.getBranchCall(repo, branch, projKey, flagKey, _callback);
        return localVarCall;
    }

    public BranchRep getBranch(String repo, String branch, String projKey, String flagKey) throws ApiException {
        ApiResponse<BranchRep> localVarResp = this.getBranchWithHttpInfo(repo, branch, projKey, flagKey);
        return localVarResp.getData();
    }

    public ApiResponse<BranchRep> getBranchWithHttpInfo(String repo, String branch, String projKey, String flagKey) throws ApiException {
        Call localVarCall = this.getBranchValidateBeforeCall(repo, branch, projKey, flagKey, null);
        Type localVarReturnType = new TypeToken<BranchRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBranchAsync(String repo, String branch, String projKey, String flagKey, ApiCallback<BranchRep> _callback) throws ApiException {
        Call localVarCall = this.getBranchValidateBeforeCall(repo, branch, projKey, flagKey, _callback);
        Type localVarReturnType = new TypeToken<BranchRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBranchesCall(String repo, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/code-refs/repositories/{repo}/branches".replaceAll("\\{repo\\}", this.localVarApiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBranchesValidateBeforeCall(String repo, ApiCallback _callback) throws ApiException {
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getBranches(Async)");
        }
        Call localVarCall = this.getBranchesCall(repo, _callback);
        return localVarCall;
    }

    public BranchCollectionRep getBranches(String repo) throws ApiException {
        ApiResponse<BranchCollectionRep> localVarResp = this.getBranchesWithHttpInfo(repo);
        return localVarResp.getData();
    }

    public ApiResponse<BranchCollectionRep> getBranchesWithHttpInfo(String repo) throws ApiException {
        Call localVarCall = this.getBranchesValidateBeforeCall(repo, null);
        Type localVarReturnType = new TypeToken<BranchCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBranchesAsync(String repo, ApiCallback<BranchCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getBranchesValidateBeforeCall(repo, _callback);
        Type localVarReturnType = new TypeToken<BranchCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExtinctionsCall(String repoName, String branchName, String projKey, String flagKey, Long from, Long to, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/code-refs/extinctions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (repoName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("repoName", repoName));
        }
        if (branchName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("branchName", branchName));
        }
        if (projKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("projKey", projKey));
        }
        if (flagKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("flagKey", flagKey));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExtinctionsValidateBeforeCall(String repoName, String branchName, String projKey, String flagKey, Long from, Long to, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExtinctionsCall(repoName, branchName, projKey, flagKey, from, to, _callback);
        return localVarCall;
    }

    public ExtinctionCollectionRep getExtinctions(String repoName, String branchName, String projKey, String flagKey, Long from, Long to) throws ApiException {
        ApiResponse<ExtinctionCollectionRep> localVarResp = this.getExtinctionsWithHttpInfo(repoName, branchName, projKey, flagKey, from, to);
        return localVarResp.getData();
    }

    public ApiResponse<ExtinctionCollectionRep> getExtinctionsWithHttpInfo(String repoName, String branchName, String projKey, String flagKey, Long from, Long to) throws ApiException {
        Call localVarCall = this.getExtinctionsValidateBeforeCall(repoName, branchName, projKey, flagKey, from, to, null);
        Type localVarReturnType = new TypeToken<ExtinctionCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExtinctionsAsync(String repoName, String branchName, String projKey, String flagKey, Long from, Long to, ApiCallback<ExtinctionCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getExtinctionsValidateBeforeCall(repoName, branchName, projKey, flagKey, from, to, _callback);
        Type localVarReturnType = new TypeToken<ExtinctionCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRepositoriesCall(String withBranches, String withReferencesForDefaultBranch, String projKey, String flagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/code-refs/repositories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (withBranches != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withBranches", withBranches));
        }
        if (withReferencesForDefaultBranch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withReferencesForDefaultBranch", withReferencesForDefaultBranch));
        }
        if (projKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("projKey", projKey));
        }
        if (flagKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("flagKey", flagKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRepositoriesValidateBeforeCall(String withBranches, String withReferencesForDefaultBranch, String projKey, String flagKey, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getRepositoriesCall(withBranches, withReferencesForDefaultBranch, projKey, flagKey, _callback);
        return localVarCall;
    }

    public RepositoryCollectionRep getRepositories(String withBranches, String withReferencesForDefaultBranch, String projKey, String flagKey) throws ApiException {
        ApiResponse<RepositoryCollectionRep> localVarResp = this.getRepositoriesWithHttpInfo(withBranches, withReferencesForDefaultBranch, projKey, flagKey);
        return localVarResp.getData();
    }

    public ApiResponse<RepositoryCollectionRep> getRepositoriesWithHttpInfo(String withBranches, String withReferencesForDefaultBranch, String projKey, String flagKey) throws ApiException {
        Call localVarCall = this.getRepositoriesValidateBeforeCall(withBranches, withReferencesForDefaultBranch, projKey, flagKey, null);
        Type localVarReturnType = new TypeToken<RepositoryCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRepositoriesAsync(String withBranches, String withReferencesForDefaultBranch, String projKey, String flagKey, ApiCallback<RepositoryCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getRepositoriesValidateBeforeCall(withBranches, withReferencesForDefaultBranch, projKey, flagKey, _callback);
        Type localVarReturnType = new TypeToken<RepositoryCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRepositoryCall(String repo, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/code-refs/repositories/{repo}".replaceAll("\\{repo\\}", this.localVarApiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRepositoryValidateBeforeCall(String repo, ApiCallback _callback) throws ApiException {
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling getRepository(Async)");
        }
        Call localVarCall = this.getRepositoryCall(repo, _callback);
        return localVarCall;
    }

    public RepositoryRep getRepository(String repo) throws ApiException {
        ApiResponse<RepositoryRep> localVarResp = this.getRepositoryWithHttpInfo(repo);
        return localVarResp.getData();
    }

    public ApiResponse<RepositoryRep> getRepositoryWithHttpInfo(String repo) throws ApiException {
        Call localVarCall = this.getRepositoryValidateBeforeCall(repo, null);
        Type localVarReturnType = new TypeToken<RepositoryRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRepositoryAsync(String repo, ApiCallback<RepositoryRep> _callback) throws ApiException {
        Call localVarCall = this.getRepositoryValidateBeforeCall(repo, _callback);
        Type localVarReturnType = new TypeToken<RepositoryRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRootStatisticCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/code-refs/statistics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRootStatisticValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getRootStatisticCall(_callback);
        return localVarCall;
    }

    public StatisticsRoot getRootStatistic() throws ApiException {
        ApiResponse<StatisticsRoot> localVarResp = this.getRootStatisticWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<StatisticsRoot> getRootStatisticWithHttpInfo() throws ApiException {
        Call localVarCall = this.getRootStatisticValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<StatisticsRoot>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRootStatisticAsync(ApiCallback<StatisticsRoot> _callback) throws ApiException {
        Call localVarCall = this.getRootStatisticValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<StatisticsRoot>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStatisticsCall(String projectKey, String flagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/code-refs/statistics/{projectKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (flagKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("flagKey", flagKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStatisticsValidateBeforeCall(String projectKey, String flagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getStatistics(Async)");
        }
        Call localVarCall = this.getStatisticsCall(projectKey, flagKey, _callback);
        return localVarCall;
    }

    public StatisticCollectionRep getStatistics(String projectKey, String flagKey) throws ApiException {
        ApiResponse<StatisticCollectionRep> localVarResp = this.getStatisticsWithHttpInfo(projectKey, flagKey);
        return localVarResp.getData();
    }

    public ApiResponse<StatisticCollectionRep> getStatisticsWithHttpInfo(String projectKey, String flagKey) throws ApiException {
        Call localVarCall = this.getStatisticsValidateBeforeCall(projectKey, flagKey, null);
        Type localVarReturnType = new TypeToken<StatisticCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStatisticsAsync(String projectKey, String flagKey, ApiCallback<StatisticCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getStatisticsValidateBeforeCall(projectKey, flagKey, _callback);
        Type localVarReturnType = new TypeToken<StatisticCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchRepositoryCall(String repo, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/code-refs/repositories/{repo}".replaceAll("\\{repo\\}", this.localVarApiClient.escapeString(repo.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchRepositoryValidateBeforeCall(String repo, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling patchRepository(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchRepository(Async)");
        }
        Call localVarCall = this.patchRepositoryCall(repo, patchOperation, _callback);
        return localVarCall;
    }

    public RepositoryRep patchRepository(String repo, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<RepositoryRep> localVarResp = this.patchRepositoryWithHttpInfo(repo, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<RepositoryRep> patchRepositoryWithHttpInfo(String repo, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchRepositoryValidateBeforeCall(repo, patchOperation, null);
        Type localVarReturnType = new TypeToken<RepositoryRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchRepositoryAsync(String repo, List<PatchOperation> patchOperation, ApiCallback<RepositoryRep> _callback) throws ApiException {
        Call localVarCall = this.patchRepositoryValidateBeforeCall(repo, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<RepositoryRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postExtinctionCall(String repo, String branch, List<Extinction> extinction, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<Extinction> localVarPostBody = extinction;
        String localVarPath = "/api/v2/code-refs/repositories/{repo}/branches/{branch}/extinction-events".replaceAll("\\{repo\\}", this.localVarApiClient.escapeString(repo.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postExtinctionValidateBeforeCall(String repo, String branch, List<Extinction> extinction, ApiCallback _callback) throws ApiException {
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling postExtinction(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling postExtinction(Async)");
        }
        if (extinction == null) {
            throw new ApiException("Missing the required parameter 'extinction' when calling postExtinction(Async)");
        }
        Call localVarCall = this.postExtinctionCall(repo, branch, extinction, _callback);
        return localVarCall;
    }

    public void postExtinction(String repo, String branch, List<Extinction> extinction) throws ApiException {
        this.postExtinctionWithHttpInfo(repo, branch, extinction);
    }

    public ApiResponse<Void> postExtinctionWithHttpInfo(String repo, String branch, List<Extinction> extinction) throws ApiException {
        Call localVarCall = this.postExtinctionValidateBeforeCall(repo, branch, extinction, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call postExtinctionAsync(String repo, String branch, List<Extinction> extinction, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.postExtinctionValidateBeforeCall(repo, branch, extinction, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call postRepositoryCall(RepositoryPost repositoryPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RepositoryPost localVarPostBody = repositoryPost;
        String localVarPath = "/api/v2/code-refs/repositories";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postRepositoryValidateBeforeCall(RepositoryPost repositoryPost, ApiCallback _callback) throws ApiException {
        if (repositoryPost == null) {
            throw new ApiException("Missing the required parameter 'repositoryPost' when calling postRepository(Async)");
        }
        Call localVarCall = this.postRepositoryCall(repositoryPost, _callback);
        return localVarCall;
    }

    public RepositoryRep postRepository(RepositoryPost repositoryPost) throws ApiException {
        ApiResponse<RepositoryRep> localVarResp = this.postRepositoryWithHttpInfo(repositoryPost);
        return localVarResp.getData();
    }

    public ApiResponse<RepositoryRep> postRepositoryWithHttpInfo(RepositoryPost repositoryPost) throws ApiException {
        Call localVarCall = this.postRepositoryValidateBeforeCall(repositoryPost, null);
        Type localVarReturnType = new TypeToken<RepositoryRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postRepositoryAsync(RepositoryPost repositoryPost, ApiCallback<RepositoryRep> _callback) throws ApiException {
        Call localVarCall = this.postRepositoryValidateBeforeCall(repositoryPost, _callback);
        Type localVarReturnType = new TypeToken<RepositoryRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putBranchCall(String repo, String branch, PutBranch putBranch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PutBranch localVarPostBody = putBranch;
        String localVarPath = "/api/v2/code-refs/repositories/{repo}/branches/{branch}".replaceAll("\\{repo\\}", this.localVarApiClient.escapeString(repo.toString())).replaceAll("\\{branch\\}", this.localVarApiClient.escapeString(branch.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putBranchValidateBeforeCall(String repo, String branch, PutBranch putBranch, ApiCallback _callback) throws ApiException {
        if (repo == null) {
            throw new ApiException("Missing the required parameter 'repo' when calling putBranch(Async)");
        }
        if (branch == null) {
            throw new ApiException("Missing the required parameter 'branch' when calling putBranch(Async)");
        }
        if (putBranch == null) {
            throw new ApiException("Missing the required parameter 'putBranch' when calling putBranch(Async)");
        }
        Call localVarCall = this.putBranchCall(repo, branch, putBranch, _callback);
        return localVarCall;
    }

    public void putBranch(String repo, String branch, PutBranch putBranch) throws ApiException {
        this.putBranchWithHttpInfo(repo, branch, putBranch);
    }

    public ApiResponse<Void> putBranchWithHttpInfo(String repo, String branch, PutBranch putBranch) throws ApiException {
        Call localVarCall = this.putBranchValidateBeforeCall(repo, branch, putBranch, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putBranchAsync(String repo, String branch, PutBranch putBranch, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putBranchValidateBeforeCall(repo, branch, putBranch, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

