/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.Destination;
import com.launchdarkly.api.model.DestinationPost;
import com.launchdarkly.api.model.Destinations;
import com.launchdarkly.api.model.GenerateWarehouseDestinationKeyPairPostRep;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class DataExportDestinationsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DataExportDestinationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataExportDestinationsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteDestinationCall(String projectKey, String environmentKey, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/destinations/{projectKey}/{environmentKey}/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDestinationValidateBeforeCall(String projectKey, String environmentKey, String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteDestination(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteDestination(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteDestination(Async)");
        }
        Call localVarCall = this.deleteDestinationCall(projectKey, environmentKey, id, _callback);
        return localVarCall;
    }

    public void deleteDestination(String projectKey, String environmentKey, String id) throws ApiException {
        this.deleteDestinationWithHttpInfo(projectKey, environmentKey, id);
    }

    public ApiResponse<Void> deleteDestinationWithHttpInfo(String projectKey, String environmentKey, String id) throws ApiException {
        Call localVarCall = this.deleteDestinationValidateBeforeCall(projectKey, environmentKey, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteDestinationAsync(String projectKey, String environmentKey, String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteDestinationValidateBeforeCall(projectKey, environmentKey, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getDestinationCall(String projectKey, String environmentKey, String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/destinations/{projectKey}/{environmentKey}/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDestinationValidateBeforeCall(String projectKey, String environmentKey, String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getDestination(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getDestination(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDestination(Async)");
        }
        Call localVarCall = this.getDestinationCall(projectKey, environmentKey, id, _callback);
        return localVarCall;
    }

    public Destination getDestination(String projectKey, String environmentKey, String id) throws ApiException {
        ApiResponse<Destination> localVarResp = this.getDestinationWithHttpInfo(projectKey, environmentKey, id);
        return localVarResp.getData();
    }

    public ApiResponse<Destination> getDestinationWithHttpInfo(String projectKey, String environmentKey, String id) throws ApiException {
        Call localVarCall = this.getDestinationValidateBeforeCall(projectKey, environmentKey, id, null);
        Type localVarReturnType = new TypeToken<Destination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDestinationAsync(String projectKey, String environmentKey, String id, ApiCallback<Destination> _callback) throws ApiException {
        Call localVarCall = this.getDestinationValidateBeforeCall(projectKey, environmentKey, id, _callback);
        Type localVarReturnType = new TypeToken<Destination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDestinationsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/destinations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDestinationsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getDestinationsCall(_callback);
        return localVarCall;
    }

    public Destinations getDestinations() throws ApiException {
        ApiResponse<Destinations> localVarResp = this.getDestinationsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<Destinations> getDestinationsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getDestinationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Destinations>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDestinationsAsync(ApiCallback<Destinations> _callback) throws ApiException {
        Call localVarCall = this.getDestinationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Destinations>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchDestinationCall(String projectKey, String environmentKey, String id, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/destinations/{projectKey}/{environmentKey}/{id}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchDestinationValidateBeforeCall(String projectKey, String environmentKey, String id, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchDestination(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchDestination(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling patchDestination(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchDestination(Async)");
        }
        Call localVarCall = this.patchDestinationCall(projectKey, environmentKey, id, patchOperation, _callback);
        return localVarCall;
    }

    public Destination patchDestination(String projectKey, String environmentKey, String id, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<Destination> localVarResp = this.patchDestinationWithHttpInfo(projectKey, environmentKey, id, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<Destination> patchDestinationWithHttpInfo(String projectKey, String environmentKey, String id, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchDestinationValidateBeforeCall(projectKey, environmentKey, id, patchOperation, null);
        Type localVarReturnType = new TypeToken<Destination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchDestinationAsync(String projectKey, String environmentKey, String id, List<PatchOperation> patchOperation, ApiCallback<Destination> _callback) throws ApiException {
        Call localVarCall = this.patchDestinationValidateBeforeCall(projectKey, environmentKey, id, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<Destination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postDestinationCall(String projectKey, String environmentKey, DestinationPost destinationPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DestinationPost localVarPostBody = destinationPost;
        String localVarPath = "/api/v2/destinations/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postDestinationValidateBeforeCall(String projectKey, String environmentKey, DestinationPost destinationPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postDestination(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postDestination(Async)");
        }
        if (destinationPost == null) {
            throw new ApiException("Missing the required parameter 'destinationPost' when calling postDestination(Async)");
        }
        Call localVarCall = this.postDestinationCall(projectKey, environmentKey, destinationPost, _callback);
        return localVarCall;
    }

    public Destination postDestination(String projectKey, String environmentKey, DestinationPost destinationPost) throws ApiException {
        ApiResponse<Destination> localVarResp = this.postDestinationWithHttpInfo(projectKey, environmentKey, destinationPost);
        return localVarResp.getData();
    }

    public ApiResponse<Destination> postDestinationWithHttpInfo(String projectKey, String environmentKey, DestinationPost destinationPost) throws ApiException {
        Call localVarCall = this.postDestinationValidateBeforeCall(projectKey, environmentKey, destinationPost, null);
        Type localVarReturnType = new TypeToken<Destination>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postDestinationAsync(String projectKey, String environmentKey, DestinationPost destinationPost, ApiCallback<Destination> _callback) throws ApiException {
        Call localVarCall = this.postDestinationValidateBeforeCall(projectKey, environmentKey, destinationPost, _callback);
        Type localVarReturnType = new TypeToken<Destination>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postGenerateWarehouseDestinationKeyPairCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/destinations/generate-warehouse-destination-key-pair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postGenerateWarehouseDestinationKeyPairValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.postGenerateWarehouseDestinationKeyPairCall(_callback);
        return localVarCall;
    }

    public GenerateWarehouseDestinationKeyPairPostRep postGenerateWarehouseDestinationKeyPair() throws ApiException {
        ApiResponse<GenerateWarehouseDestinationKeyPairPostRep> localVarResp = this.postGenerateWarehouseDestinationKeyPairWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<GenerateWarehouseDestinationKeyPairPostRep> postGenerateWarehouseDestinationKeyPairWithHttpInfo() throws ApiException {
        Call localVarCall = this.postGenerateWarehouseDestinationKeyPairValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GenerateWarehouseDestinationKeyPairPostRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postGenerateWarehouseDestinationKeyPairAsync(ApiCallback<GenerateWarehouseDestinationKeyPairPostRep> _callback) throws ApiException {
        Call localVarCall = this.postGenerateWarehouseDestinationKeyPairValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GenerateWarehouseDestinationKeyPairPostRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

