/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.Environment;
import com.launchdarkly.api.model.EnvironmentPost;
import com.launchdarkly.api.model.Environments;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class EnvironmentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public EnvironmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvironmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteEnvironmentCall(String projectKey, String environmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteEnvironmentValidateBeforeCall(String projectKey, String environmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteEnvironment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteEnvironment(Async)");
        }
        Call localVarCall = this.deleteEnvironmentCall(projectKey, environmentKey, _callback);
        return localVarCall;
    }

    public void deleteEnvironment(String projectKey, String environmentKey) throws ApiException {
        this.deleteEnvironmentWithHttpInfo(projectKey, environmentKey);
    }

    public ApiResponse<Void> deleteEnvironmentWithHttpInfo(String projectKey, String environmentKey) throws ApiException {
        Call localVarCall = this.deleteEnvironmentValidateBeforeCall(projectKey, environmentKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteEnvironmentAsync(String projectKey, String environmentKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteEnvironmentValidateBeforeCall(projectKey, environmentKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getEnvironmentCall(String projectKey, String environmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEnvironmentValidateBeforeCall(String projectKey, String environmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getEnvironment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getEnvironment(Async)");
        }
        Call localVarCall = this.getEnvironmentCall(projectKey, environmentKey, _callback);
        return localVarCall;
    }

    public Environment getEnvironment(String projectKey, String environmentKey) throws ApiException {
        ApiResponse<Environment> localVarResp = this.getEnvironmentWithHttpInfo(projectKey, environmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<Environment> getEnvironmentWithHttpInfo(String projectKey, String environmentKey) throws ApiException {
        Call localVarCall = this.getEnvironmentValidateBeforeCall(projectKey, environmentKey, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEnvironmentAsync(String projectKey, String environmentKey, ApiCallback<Environment> _callback) throws ApiException {
        Call localVarCall = this.getEnvironmentValidateBeforeCall(projectKey, environmentKey, _callback);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEnvironmentsByProjectCall(String projectKey, Long limit, Long offset, String filter, String sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEnvironmentsByProjectValidateBeforeCall(String projectKey, Long limit, Long offset, String filter, String sort, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getEnvironmentsByProject(Async)");
        }
        Call localVarCall = this.getEnvironmentsByProjectCall(projectKey, limit, offset, filter, sort, _callback);
        return localVarCall;
    }

    public Environments getEnvironmentsByProject(String projectKey, Long limit, Long offset, String filter, String sort) throws ApiException {
        ApiResponse<Environments> localVarResp = this.getEnvironmentsByProjectWithHttpInfo(projectKey, limit, offset, filter, sort);
        return localVarResp.getData();
    }

    public ApiResponse<Environments> getEnvironmentsByProjectWithHttpInfo(String projectKey, Long limit, Long offset, String filter, String sort) throws ApiException {
        Call localVarCall = this.getEnvironmentsByProjectValidateBeforeCall(projectKey, limit, offset, filter, sort, null);
        Type localVarReturnType = new TypeToken<Environments>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEnvironmentsByProjectAsync(String projectKey, Long limit, Long offset, String filter, String sort, ApiCallback<Environments> _callback) throws ApiException {
        Call localVarCall = this.getEnvironmentsByProjectValidateBeforeCall(projectKey, limit, offset, filter, sort, _callback);
        Type localVarReturnType = new TypeToken<Environments>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchEnvironmentCall(String projectKey, String environmentKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchEnvironmentValidateBeforeCall(String projectKey, String environmentKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchEnvironment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchEnvironment(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchEnvironment(Async)");
        }
        Call localVarCall = this.patchEnvironmentCall(projectKey, environmentKey, patchOperation, _callback);
        return localVarCall;
    }

    public Environment patchEnvironment(String projectKey, String environmentKey, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<Environment> localVarResp = this.patchEnvironmentWithHttpInfo(projectKey, environmentKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<Environment> patchEnvironmentWithHttpInfo(String projectKey, String environmentKey, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchEnvironmentValidateBeforeCall(projectKey, environmentKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchEnvironmentAsync(String projectKey, String environmentKey, List<PatchOperation> patchOperation, ApiCallback<Environment> _callback) throws ApiException {
        Call localVarCall = this.patchEnvironmentValidateBeforeCall(projectKey, environmentKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postEnvironmentCall(String projectKey, EnvironmentPost environmentPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        EnvironmentPost localVarPostBody = environmentPost;
        String localVarPath = "/api/v2/projects/{projectKey}/environments".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postEnvironmentValidateBeforeCall(String projectKey, EnvironmentPost environmentPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postEnvironment(Async)");
        }
        if (environmentPost == null) {
            throw new ApiException("Missing the required parameter 'environmentPost' when calling postEnvironment(Async)");
        }
        Call localVarCall = this.postEnvironmentCall(projectKey, environmentPost, _callback);
        return localVarCall;
    }

    public Environment postEnvironment(String projectKey, EnvironmentPost environmentPost) throws ApiException {
        ApiResponse<Environment> localVarResp = this.postEnvironmentWithHttpInfo(projectKey, environmentPost);
        return localVarResp.getData();
    }

    public ApiResponse<Environment> postEnvironmentWithHttpInfo(String projectKey, EnvironmentPost environmentPost) throws ApiException {
        Call localVarCall = this.postEnvironmentValidateBeforeCall(projectKey, environmentPost, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postEnvironmentAsync(String projectKey, EnvironmentPost environmentPost, ApiCallback<Environment> _callback) throws ApiException {
        Call localVarCall = this.postEnvironmentValidateBeforeCall(projectKey, environmentPost, _callback);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resetEnvironmentMobileKeyCall(String projectKey, String environmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/mobileKey".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetEnvironmentMobileKeyValidateBeforeCall(String projectKey, String environmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling resetEnvironmentMobileKey(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling resetEnvironmentMobileKey(Async)");
        }
        Call localVarCall = this.resetEnvironmentMobileKeyCall(projectKey, environmentKey, _callback);
        return localVarCall;
    }

    public Environment resetEnvironmentMobileKey(String projectKey, String environmentKey) throws ApiException {
        ApiResponse<Environment> localVarResp = this.resetEnvironmentMobileKeyWithHttpInfo(projectKey, environmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<Environment> resetEnvironmentMobileKeyWithHttpInfo(String projectKey, String environmentKey) throws ApiException {
        Call localVarCall = this.resetEnvironmentMobileKeyValidateBeforeCall(projectKey, environmentKey, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resetEnvironmentMobileKeyAsync(String projectKey, String environmentKey, ApiCallback<Environment> _callback) throws ApiException {
        Call localVarCall = this.resetEnvironmentMobileKeyValidateBeforeCall(projectKey, environmentKey, _callback);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resetEnvironmentSDKKeyCall(String projectKey, String environmentKey, Long expiry, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/apiKey".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expiry != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiry", expiry));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetEnvironmentSDKKeyValidateBeforeCall(String projectKey, String environmentKey, Long expiry, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling resetEnvironmentSDKKey(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling resetEnvironmentSDKKey(Async)");
        }
        Call localVarCall = this.resetEnvironmentSDKKeyCall(projectKey, environmentKey, expiry, _callback);
        return localVarCall;
    }

    public Environment resetEnvironmentSDKKey(String projectKey, String environmentKey, Long expiry) throws ApiException {
        ApiResponse<Environment> localVarResp = this.resetEnvironmentSDKKeyWithHttpInfo(projectKey, environmentKey, expiry);
        return localVarResp.getData();
    }

    public ApiResponse<Environment> resetEnvironmentSDKKeyWithHttpInfo(String projectKey, String environmentKey, Long expiry) throws ApiException {
        Call localVarCall = this.resetEnvironmentSDKKeyValidateBeforeCall(projectKey, environmentKey, expiry, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call resetEnvironmentSDKKeyAsync(String projectKey, String environmentKey, Long expiry, ApiCallback<Environment> _callback) throws ApiException {
        Call localVarCall = this.resetEnvironmentSDKKeyValidateBeforeCall(projectKey, environmentKey, expiry, _callback);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

