/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.HoldoutDetailRep;
import com.launchdarkly.api.model.HoldoutPatchInput;
import com.launchdarkly.api.model.HoldoutPostRequest;
import com.launchdarkly.api.model.HoldoutRep;
import com.launchdarkly.api.model.HoldoutsCollectionRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class HoldoutsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public HoldoutsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HoldoutsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getAllHoldoutsCall(String projectKey, String environmentKey, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/holdouts".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllHoldoutsValidateBeforeCall(String projectKey, String environmentKey, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAllHoldouts(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getAllHoldouts(Async)");
        }
        Call localVarCall = this.getAllHoldoutsCall(projectKey, environmentKey, limit, offset, _callback);
        return localVarCall;
    }

    public HoldoutsCollectionRep getAllHoldouts(String projectKey, String environmentKey, Long limit, Long offset) throws ApiException {
        ApiResponse<HoldoutsCollectionRep> localVarResp = this.getAllHoldoutsWithHttpInfo(projectKey, environmentKey, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<HoldoutsCollectionRep> getAllHoldoutsWithHttpInfo(String projectKey, String environmentKey, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getAllHoldoutsValidateBeforeCall(projectKey, environmentKey, limit, offset, null);
        Type localVarReturnType = new TypeToken<HoldoutsCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllHoldoutsAsync(String projectKey, String environmentKey, Long limit, Long offset, ApiCallback<HoldoutsCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getAllHoldoutsValidateBeforeCall(projectKey, environmentKey, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<HoldoutsCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHoldoutCall(String projectKey, String environmentKey, String holdoutKey, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/holdouts/{holdoutKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{holdoutKey\\}", this.localVarApiClient.escapeString(holdoutKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHoldoutValidateBeforeCall(String projectKey, String environmentKey, String holdoutKey, String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getHoldout(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getHoldout(Async)");
        }
        if (holdoutKey == null) {
            throw new ApiException("Missing the required parameter 'holdoutKey' when calling getHoldout(Async)");
        }
        Call localVarCall = this.getHoldoutCall(projectKey, environmentKey, holdoutKey, expand, _callback);
        return localVarCall;
    }

    public HoldoutDetailRep getHoldout(String projectKey, String environmentKey, String holdoutKey, String expand) throws ApiException {
        ApiResponse<HoldoutDetailRep> localVarResp = this.getHoldoutWithHttpInfo(projectKey, environmentKey, holdoutKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<HoldoutDetailRep> getHoldoutWithHttpInfo(String projectKey, String environmentKey, String holdoutKey, String expand) throws ApiException {
        Call localVarCall = this.getHoldoutValidateBeforeCall(projectKey, environmentKey, holdoutKey, expand, null);
        Type localVarReturnType = new TypeToken<HoldoutDetailRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHoldoutAsync(String projectKey, String environmentKey, String holdoutKey, String expand, ApiCallback<HoldoutDetailRep> _callback) throws ApiException {
        Call localVarCall = this.getHoldoutValidateBeforeCall(projectKey, environmentKey, holdoutKey, expand, _callback);
        Type localVarReturnType = new TypeToken<HoldoutDetailRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getHoldoutByIdCall(String projectKey, String environmentKey, String holdoutId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/holdouts/id/{holdoutId}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{holdoutId\\}", this.localVarApiClient.escapeString(holdoutId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getHoldoutByIdValidateBeforeCall(String projectKey, String environmentKey, String holdoutId, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getHoldoutById(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getHoldoutById(Async)");
        }
        if (holdoutId == null) {
            throw new ApiException("Missing the required parameter 'holdoutId' when calling getHoldoutById(Async)");
        }
        Call localVarCall = this.getHoldoutByIdCall(projectKey, environmentKey, holdoutId, _callback);
        return localVarCall;
    }

    public HoldoutRep getHoldoutById(String projectKey, String environmentKey, String holdoutId) throws ApiException {
        ApiResponse<HoldoutRep> localVarResp = this.getHoldoutByIdWithHttpInfo(projectKey, environmentKey, holdoutId);
        return localVarResp.getData();
    }

    public ApiResponse<HoldoutRep> getHoldoutByIdWithHttpInfo(String projectKey, String environmentKey, String holdoutId) throws ApiException {
        Call localVarCall = this.getHoldoutByIdValidateBeforeCall(projectKey, environmentKey, holdoutId, null);
        Type localVarReturnType = new TypeToken<HoldoutRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getHoldoutByIdAsync(String projectKey, String environmentKey, String holdoutId, ApiCallback<HoldoutRep> _callback) throws ApiException {
        Call localVarCall = this.getHoldoutByIdValidateBeforeCall(projectKey, environmentKey, holdoutId, _callback);
        Type localVarReturnType = new TypeToken<HoldoutRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchHoldoutCall(String projectKey, String environmentKey, String holdoutKey, HoldoutPatchInput holdoutPatchInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        HoldoutPatchInput localVarPostBody = holdoutPatchInput;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/holdouts/{holdoutKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{holdoutKey\\}", this.localVarApiClient.escapeString(holdoutKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchHoldoutValidateBeforeCall(String projectKey, String environmentKey, String holdoutKey, HoldoutPatchInput holdoutPatchInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchHoldout(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchHoldout(Async)");
        }
        if (holdoutKey == null) {
            throw new ApiException("Missing the required parameter 'holdoutKey' when calling patchHoldout(Async)");
        }
        if (holdoutPatchInput == null) {
            throw new ApiException("Missing the required parameter 'holdoutPatchInput' when calling patchHoldout(Async)");
        }
        Call localVarCall = this.patchHoldoutCall(projectKey, environmentKey, holdoutKey, holdoutPatchInput, _callback);
        return localVarCall;
    }

    public HoldoutRep patchHoldout(String projectKey, String environmentKey, String holdoutKey, HoldoutPatchInput holdoutPatchInput) throws ApiException {
        ApiResponse<HoldoutRep> localVarResp = this.patchHoldoutWithHttpInfo(projectKey, environmentKey, holdoutKey, holdoutPatchInput);
        return localVarResp.getData();
    }

    public ApiResponse<HoldoutRep> patchHoldoutWithHttpInfo(String projectKey, String environmentKey, String holdoutKey, HoldoutPatchInput holdoutPatchInput) throws ApiException {
        Call localVarCall = this.patchHoldoutValidateBeforeCall(projectKey, environmentKey, holdoutKey, holdoutPatchInput, null);
        Type localVarReturnType = new TypeToken<HoldoutRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchHoldoutAsync(String projectKey, String environmentKey, String holdoutKey, HoldoutPatchInput holdoutPatchInput, ApiCallback<HoldoutRep> _callback) throws ApiException {
        Call localVarCall = this.patchHoldoutValidateBeforeCall(projectKey, environmentKey, holdoutKey, holdoutPatchInput, _callback);
        Type localVarReturnType = new TypeToken<HoldoutRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postHoldoutCall(String projectKey, String environmentKey, HoldoutPostRequest holdoutPostRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        HoldoutPostRequest localVarPostBody = holdoutPostRequest;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/holdouts".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postHoldoutValidateBeforeCall(String projectKey, String environmentKey, HoldoutPostRequest holdoutPostRequest, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postHoldout(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postHoldout(Async)");
        }
        if (holdoutPostRequest == null) {
            throw new ApiException("Missing the required parameter 'holdoutPostRequest' when calling postHoldout(Async)");
        }
        Call localVarCall = this.postHoldoutCall(projectKey, environmentKey, holdoutPostRequest, _callback);
        return localVarCall;
    }

    public HoldoutRep postHoldout(String projectKey, String environmentKey, HoldoutPostRequest holdoutPostRequest) throws ApiException {
        ApiResponse<HoldoutRep> localVarResp = this.postHoldoutWithHttpInfo(projectKey, environmentKey, holdoutPostRequest);
        return localVarResp.getData();
    }

    public ApiResponse<HoldoutRep> postHoldoutWithHttpInfo(String projectKey, String environmentKey, HoldoutPostRequest holdoutPostRequest) throws ApiException {
        Call localVarCall = this.postHoldoutValidateBeforeCall(projectKey, environmentKey, holdoutPostRequest, null);
        Type localVarReturnType = new TypeToken<HoldoutRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postHoldoutAsync(String projectKey, String environmentKey, HoldoutPostRequest holdoutPostRequest, ApiCallback<HoldoutRep> _callback) throws ApiException {
        Call localVarCall = this.postHoldoutValidateBeforeCall(projectKey, environmentKey, holdoutPostRequest, _callback);
        Type localVarReturnType = new TypeToken<HoldoutRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

