/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.InsightGroup;
import com.launchdarkly.api.model.InsightGroupCollection;
import com.launchdarkly.api.model.InsightScores;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.PostInsightGroupParams;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class InsightsScoresBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InsightsScoresBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InsightsScoresBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createInsightGroupCall(PostInsightGroupParams postInsightGroupParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostInsightGroupParams localVarPostBody = postInsightGroupParams;
        String localVarPath = "/api/v2/engineering-insights/insights/group";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createInsightGroupValidateBeforeCall(PostInsightGroupParams postInsightGroupParams, ApiCallback _callback) throws ApiException {
        if (postInsightGroupParams == null) {
            throw new ApiException("Missing the required parameter 'postInsightGroupParams' when calling createInsightGroup(Async)");
        }
        Call localVarCall = this.createInsightGroupCall(postInsightGroupParams, _callback);
        return localVarCall;
    }

    public InsightGroup createInsightGroup(PostInsightGroupParams postInsightGroupParams) throws ApiException {
        ApiResponse<InsightGroup> localVarResp = this.createInsightGroupWithHttpInfo(postInsightGroupParams);
        return localVarResp.getData();
    }

    public ApiResponse<InsightGroup> createInsightGroupWithHttpInfo(PostInsightGroupParams postInsightGroupParams) throws ApiException {
        Call localVarCall = this.createInsightGroupValidateBeforeCall(postInsightGroupParams, null);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createInsightGroupAsync(PostInsightGroupParams postInsightGroupParams, ApiCallback<InsightGroup> _callback) throws ApiException {
        Call localVarCall = this.createInsightGroupValidateBeforeCall(postInsightGroupParams, _callback);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteInsightGroupCall(String insightGroupKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/insights/groups/{insightGroupKey}".replaceAll("\\{insightGroupKey\\}", this.localVarApiClient.escapeString(insightGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteInsightGroupValidateBeforeCall(String insightGroupKey, ApiCallback _callback) throws ApiException {
        if (insightGroupKey == null) {
            throw new ApiException("Missing the required parameter 'insightGroupKey' when calling deleteInsightGroup(Async)");
        }
        Call localVarCall = this.deleteInsightGroupCall(insightGroupKey, _callback);
        return localVarCall;
    }

    public void deleteInsightGroup(String insightGroupKey) throws ApiException {
        this.deleteInsightGroupWithHttpInfo(insightGroupKey);
    }

    public ApiResponse<Void> deleteInsightGroupWithHttpInfo(String insightGroupKey) throws ApiException {
        Call localVarCall = this.deleteInsightGroupValidateBeforeCall(insightGroupKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteInsightGroupAsync(String insightGroupKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteInsightGroupValidateBeforeCall(insightGroupKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getInsightGroupCall(String insightGroupKey, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/insights/groups/{insightGroupKey}".replaceAll("\\{insightGroupKey\\}", this.localVarApiClient.escapeString(insightGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInsightGroupValidateBeforeCall(String insightGroupKey, String expand, ApiCallback _callback) throws ApiException {
        if (insightGroupKey == null) {
            throw new ApiException("Missing the required parameter 'insightGroupKey' when calling getInsightGroup(Async)");
        }
        Call localVarCall = this.getInsightGroupCall(insightGroupKey, expand, _callback);
        return localVarCall;
    }

    public InsightGroup getInsightGroup(String insightGroupKey, String expand) throws ApiException {
        ApiResponse<InsightGroup> localVarResp = this.getInsightGroupWithHttpInfo(insightGroupKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<InsightGroup> getInsightGroupWithHttpInfo(String insightGroupKey, String expand) throws ApiException {
        Call localVarCall = this.getInsightGroupValidateBeforeCall(insightGroupKey, expand, null);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInsightGroupAsync(String insightGroupKey, String expand, ApiCallback<InsightGroup> _callback) throws ApiException {
        Call localVarCall = this.getInsightGroupValidateBeforeCall(insightGroupKey, expand, _callback);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInsightGroupsCall(Long limit, Long offset, String sort, String query, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/insights/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInsightGroupsValidateBeforeCall(Long limit, Long offset, String sort, String query, String expand, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getInsightGroupsCall(limit, offset, sort, query, expand, _callback);
        return localVarCall;
    }

    public InsightGroupCollection getInsightGroups(Long limit, Long offset, String sort, String query, String expand) throws ApiException {
        ApiResponse<InsightGroupCollection> localVarResp = this.getInsightGroupsWithHttpInfo(limit, offset, sort, query, expand);
        return localVarResp.getData();
    }

    public ApiResponse<InsightGroupCollection> getInsightGroupsWithHttpInfo(Long limit, Long offset, String sort, String query, String expand) throws ApiException {
        Call localVarCall = this.getInsightGroupsValidateBeforeCall(limit, offset, sort, query, expand, null);
        Type localVarReturnType = new TypeToken<InsightGroupCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInsightGroupsAsync(Long limit, Long offset, String sort, String query, String expand, ApiCallback<InsightGroupCollection> _callback) throws ApiException {
        Call localVarCall = this.getInsightGroupsValidateBeforeCall(limit, offset, sort, query, expand, _callback);
        Type localVarReturnType = new TypeToken<InsightGroupCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInsightsScoresCall(String projectKey, String environmentKey, String applicationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/insights/scores";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (projectKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("projectKey", projectKey));
        }
        if (environmentKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("environmentKey", environmentKey));
        }
        if (applicationKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("applicationKey", applicationKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInsightsScoresValidateBeforeCall(String projectKey, String environmentKey, String applicationKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getInsightsScores(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getInsightsScores(Async)");
        }
        Call localVarCall = this.getInsightsScoresCall(projectKey, environmentKey, applicationKey, _callback);
        return localVarCall;
    }

    public InsightScores getInsightsScores(String projectKey, String environmentKey, String applicationKey) throws ApiException {
        ApiResponse<InsightScores> localVarResp = this.getInsightsScoresWithHttpInfo(projectKey, environmentKey, applicationKey);
        return localVarResp.getData();
    }

    public ApiResponse<InsightScores> getInsightsScoresWithHttpInfo(String projectKey, String environmentKey, String applicationKey) throws ApiException {
        Call localVarCall = this.getInsightsScoresValidateBeforeCall(projectKey, environmentKey, applicationKey, null);
        Type localVarReturnType = new TypeToken<InsightScores>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInsightsScoresAsync(String projectKey, String environmentKey, String applicationKey, ApiCallback<InsightScores> _callback) throws ApiException {
        Call localVarCall = this.getInsightsScoresValidateBeforeCall(projectKey, environmentKey, applicationKey, _callback);
        Type localVarReturnType = new TypeToken<InsightScores>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchInsightGroupCall(String insightGroupKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/engineering-insights/insights/groups/{insightGroupKey}".replaceAll("\\{insightGroupKey\\}", this.localVarApiClient.escapeString(insightGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchInsightGroupValidateBeforeCall(String insightGroupKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (insightGroupKey == null) {
            throw new ApiException("Missing the required parameter 'insightGroupKey' when calling patchInsightGroup(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchInsightGroup(Async)");
        }
        Call localVarCall = this.patchInsightGroupCall(insightGroupKey, patchOperation, _callback);
        return localVarCall;
    }

    public InsightGroup patchInsightGroup(String insightGroupKey, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<InsightGroup> localVarResp = this.patchInsightGroupWithHttpInfo(insightGroupKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<InsightGroup> patchInsightGroupWithHttpInfo(String insightGroupKey, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchInsightGroupValidateBeforeCall(insightGroupKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchInsightGroupAsync(String insightGroupKey, List<PatchOperation> patchOperation, ApiCallback<InsightGroup> _callback) throws ApiException {
        Call localVarCall = this.patchInsightGroupValidateBeforeCall(insightGroupKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

