/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.LayerCollectionRep;
import com.launchdarkly.api.model.LayerPatchInput;
import com.launchdarkly.api.model.LayerPost;
import com.launchdarkly.api.model.LayerRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class LayersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public LayersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LayersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createLayerCall(String projectKey, LayerPost layerPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        LayerPost localVarPostBody = layerPost;
        String localVarPath = "/api/v2/projects/{projectKey}/layers".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createLayerValidateBeforeCall(String projectKey, LayerPost layerPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createLayer(Async)");
        }
        if (layerPost == null) {
            throw new ApiException("Missing the required parameter 'layerPost' when calling createLayer(Async)");
        }
        Call localVarCall = this.createLayerCall(projectKey, layerPost, _callback);
        return localVarCall;
    }

    public LayerRep createLayer(String projectKey, LayerPost layerPost) throws ApiException {
        ApiResponse<LayerRep> localVarResp = this.createLayerWithHttpInfo(projectKey, layerPost);
        return localVarResp.getData();
    }

    public ApiResponse<LayerRep> createLayerWithHttpInfo(String projectKey, LayerPost layerPost) throws ApiException {
        Call localVarCall = this.createLayerValidateBeforeCall(projectKey, layerPost, null);
        Type localVarReturnType = new TypeToken<LayerRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createLayerAsync(String projectKey, LayerPost layerPost, ApiCallback<LayerRep> _callback) throws ApiException {
        Call localVarCall = this.createLayerValidateBeforeCall(projectKey, layerPost, _callback);
        Type localVarReturnType = new TypeToken<LayerRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLayersCall(String projectKey, String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/layers".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLayersValidateBeforeCall(String projectKey, String filter, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getLayers(Async)");
        }
        Call localVarCall = this.getLayersCall(projectKey, filter, _callback);
        return localVarCall;
    }

    public LayerCollectionRep getLayers(String projectKey, String filter) throws ApiException {
        ApiResponse<LayerCollectionRep> localVarResp = this.getLayersWithHttpInfo(projectKey, filter);
        return localVarResp.getData();
    }

    public ApiResponse<LayerCollectionRep> getLayersWithHttpInfo(String projectKey, String filter) throws ApiException {
        Call localVarCall = this.getLayersValidateBeforeCall(projectKey, filter, null);
        Type localVarReturnType = new TypeToken<LayerCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLayersAsync(String projectKey, String filter, ApiCallback<LayerCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getLayersValidateBeforeCall(projectKey, filter, _callback);
        Type localVarReturnType = new TypeToken<LayerCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateLayerCall(String projectKey, String layerKey, LayerPatchInput layerPatchInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        LayerPatchInput localVarPostBody = layerPatchInput;
        String localVarPath = "/api/v2/projects/{projectKey}/layers/{layerKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{layerKey\\}", this.localVarApiClient.escapeString(layerKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateLayerValidateBeforeCall(String projectKey, String layerKey, LayerPatchInput layerPatchInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateLayer(Async)");
        }
        if (layerKey == null) {
            throw new ApiException("Missing the required parameter 'layerKey' when calling updateLayer(Async)");
        }
        if (layerPatchInput == null) {
            throw new ApiException("Missing the required parameter 'layerPatchInput' when calling updateLayer(Async)");
        }
        Call localVarCall = this.updateLayerCall(projectKey, layerKey, layerPatchInput, _callback);
        return localVarCall;
    }

    public LayerRep updateLayer(String projectKey, String layerKey, LayerPatchInput layerPatchInput) throws ApiException {
        ApiResponse<LayerRep> localVarResp = this.updateLayerWithHttpInfo(projectKey, layerKey, layerPatchInput);
        return localVarResp.getData();
    }

    public ApiResponse<LayerRep> updateLayerWithHttpInfo(String projectKey, String layerKey, LayerPatchInput layerPatchInput) throws ApiException {
        Call localVarCall = this.updateLayerValidateBeforeCall(projectKey, layerKey, layerPatchInput, null);
        Type localVarReturnType = new TypeToken<LayerRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateLayerAsync(String projectKey, String layerKey, LayerPatchInput layerPatchInput, ApiCallback<LayerRep> _callback) throws ApiException {
        Call localVarCall = this.updateLayerValidateBeforeCall(projectKey, layerKey, layerPatchInput, _callback);
        Type localVarReturnType = new TypeToken<LayerRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

