/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.MetricGroupCollectionRep;
import com.launchdarkly.api.model.MetricGroupPost;
import com.launchdarkly.api.model.MetricGroupRep;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class MetricsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MetricsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createMetricGroupCall(String projectKey, MetricGroupPost metricGroupPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MetricGroupPost localVarPostBody = metricGroupPost;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createMetricGroupValidateBeforeCall(String projectKey, MetricGroupPost metricGroupPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createMetricGroup(Async)");
        }
        if (metricGroupPost == null) {
            throw new ApiException("Missing the required parameter 'metricGroupPost' when calling createMetricGroup(Async)");
        }
        Call localVarCall = this.createMetricGroupCall(projectKey, metricGroupPost, _callback);
        return localVarCall;
    }

    public MetricGroupRep createMetricGroup(String projectKey, MetricGroupPost metricGroupPost) throws ApiException {
        ApiResponse<MetricGroupRep> localVarResp = this.createMetricGroupWithHttpInfo(projectKey, metricGroupPost);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupRep> createMetricGroupWithHttpInfo(String projectKey, MetricGroupPost metricGroupPost) throws ApiException {
        Call localVarCall = this.createMetricGroupValidateBeforeCall(projectKey, metricGroupPost, null);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createMetricGroupAsync(String projectKey, MetricGroupPost metricGroupPost, ApiCallback<MetricGroupRep> _callback) throws ApiException {
        Call localVarCall = this.createMetricGroupValidateBeforeCall(projectKey, metricGroupPost, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteMetricGroupCall(String projectKey, String metricGroupKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups/{metricGroupKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{metricGroupKey\\}", this.localVarApiClient.escapeString(metricGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteMetricGroupValidateBeforeCall(String projectKey, String metricGroupKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteMetricGroup(Async)");
        }
        if (metricGroupKey == null) {
            throw new ApiException("Missing the required parameter 'metricGroupKey' when calling deleteMetricGroup(Async)");
        }
        Call localVarCall = this.deleteMetricGroupCall(projectKey, metricGroupKey, _callback);
        return localVarCall;
    }

    public void deleteMetricGroup(String projectKey, String metricGroupKey) throws ApiException {
        this.deleteMetricGroupWithHttpInfo(projectKey, metricGroupKey);
    }

    public ApiResponse<Void> deleteMetricGroupWithHttpInfo(String projectKey, String metricGroupKey) throws ApiException {
        Call localVarCall = this.deleteMetricGroupValidateBeforeCall(projectKey, metricGroupKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteMetricGroupAsync(String projectKey, String metricGroupKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteMetricGroupValidateBeforeCall(projectKey, metricGroupKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getMetricGroupCall(String projectKey, String metricGroupKey, String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups/{metricGroupKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{metricGroupKey\\}", this.localVarApiClient.escapeString(metricGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetricGroupValidateBeforeCall(String projectKey, String metricGroupKey, String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getMetricGroup(Async)");
        }
        if (metricGroupKey == null) {
            throw new ApiException("Missing the required parameter 'metricGroupKey' when calling getMetricGroup(Async)");
        }
        Call localVarCall = this.getMetricGroupCall(projectKey, metricGroupKey, expand, _callback);
        return localVarCall;
    }

    public MetricGroupRep getMetricGroup(String projectKey, String metricGroupKey, String expand) throws ApiException {
        ApiResponse<MetricGroupRep> localVarResp = this.getMetricGroupWithHttpInfo(projectKey, metricGroupKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupRep> getMetricGroupWithHttpInfo(String projectKey, String metricGroupKey, String expand) throws ApiException {
        Call localVarCall = this.getMetricGroupValidateBeforeCall(projectKey, metricGroupKey, expand, null);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMetricGroupAsync(String projectKey, String metricGroupKey, String expand, ApiCallback<MetricGroupRep> _callback) throws ApiException {
        Call localVarCall = this.getMetricGroupValidateBeforeCall(projectKey, metricGroupKey, expand, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMetricGroupsCall(String projectKey, String filter, String sort, String expand, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetricGroupsValidateBeforeCall(String projectKey, String filter, String sort, String expand, Long limit, Long offset, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getMetricGroups(Async)");
        }
        Call localVarCall = this.getMetricGroupsCall(projectKey, filter, sort, expand, limit, offset, _callback);
        return localVarCall;
    }

    public MetricGroupCollectionRep getMetricGroups(String projectKey, String filter, String sort, String expand, Long limit, Long offset) throws ApiException {
        ApiResponse<MetricGroupCollectionRep> localVarResp = this.getMetricGroupsWithHttpInfo(projectKey, filter, sort, expand, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupCollectionRep> getMetricGroupsWithHttpInfo(String projectKey, String filter, String sort, String expand, Long limit, Long offset) throws ApiException {
        Call localVarCall = this.getMetricGroupsValidateBeforeCall(projectKey, filter, sort, expand, limit, offset, null);
        Type localVarReturnType = new TypeToken<MetricGroupCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMetricGroupsAsync(String projectKey, String filter, String sort, String expand, Long limit, Long offset, ApiCallback<MetricGroupCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getMetricGroupsValidateBeforeCall(projectKey, filter, sort, expand, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchMetricGroupCall(String projectKey, String metricGroupKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups/{metricGroupKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{metricGroupKey\\}", this.localVarApiClient.escapeString(metricGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchMetricGroupValidateBeforeCall(String projectKey, String metricGroupKey, List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchMetricGroup(Async)");
        }
        if (metricGroupKey == null) {
            throw new ApiException("Missing the required parameter 'metricGroupKey' when calling patchMetricGroup(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchMetricGroup(Async)");
        }
        Call localVarCall = this.patchMetricGroupCall(projectKey, metricGroupKey, patchOperation, _callback);
        return localVarCall;
    }

    public MetricGroupRep patchMetricGroup(String projectKey, String metricGroupKey, List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<MetricGroupRep> localVarResp = this.patchMetricGroupWithHttpInfo(projectKey, metricGroupKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupRep> patchMetricGroupWithHttpInfo(String projectKey, String metricGroupKey, List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchMetricGroupValidateBeforeCall(projectKey, metricGroupKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchMetricGroupAsync(String projectKey, String metricGroupKey, List<PatchOperation> patchOperation, ApiCallback<MetricGroupRep> _callback) throws ApiException {
        Call localVarCall = this.patchMetricGroupValidateBeforeCall(projectKey, metricGroupKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

