/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.BigSegmentTarget;
import com.launchdarkly.api.model.ContextInstanceSegmentMemberships;
import com.launchdarkly.api.model.ExpiringTargetGetResponse;
import com.launchdarkly.api.model.ExpiringTargetPatchResponse;
import com.launchdarkly.api.model.ExpiringUserTargetGetResponse;
import com.launchdarkly.api.model.ExpiringUserTargetPatchResponse;
import com.launchdarkly.api.model.Export;
import com.launchdarkly.api.model.ModelImport;
import com.launchdarkly.api.model.PatchSegmentExpiringTargetInputRep;
import com.launchdarkly.api.model.PatchSegmentRequest;
import com.launchdarkly.api.model.PatchWithComment;
import com.launchdarkly.api.model.SegmentBody;
import com.launchdarkly.api.model.SegmentUserState;
import com.launchdarkly.api.model.UserSegment;
import com.launchdarkly.api.model.UserSegments;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class SegmentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SegmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createBigSegmentExportCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/exports".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBigSegmentExportValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createBigSegmentExport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createBigSegmentExport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling createBigSegmentExport(Async)");
        }
        Call localVarCall = this.createBigSegmentExportCall(projectKey, environmentKey, segmentKey, _callback);
        return localVarCall;
    }

    public void createBigSegmentExport(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        this.createBigSegmentExportWithHttpInfo(projectKey, environmentKey, segmentKey);
    }

    public ApiResponse<Void> createBigSegmentExportWithHttpInfo(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        Call localVarCall = this.createBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createBigSegmentExportAsync(String projectKey, String environmentKey, String segmentKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createBigSegmentImportCall(String projectKey, String environmentKey, String segmentKey, File _file, String mode, Boolean waitOnApprovals, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/imports".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (mode != null) {
            localVarFormParams.put("mode", mode);
        }
        if (waitOnApprovals != null) {
            localVarFormParams.put("waitOnApprovals", waitOnApprovals);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBigSegmentImportValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, File _file, String mode, Boolean waitOnApprovals, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createBigSegmentImport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createBigSegmentImport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling createBigSegmentImport(Async)");
        }
        Call localVarCall = this.createBigSegmentImportCall(projectKey, environmentKey, segmentKey, _file, mode, waitOnApprovals, _callback);
        return localVarCall;
    }

    public void createBigSegmentImport(String projectKey, String environmentKey, String segmentKey, File _file, String mode, Boolean waitOnApprovals) throws ApiException {
        this.createBigSegmentImportWithHttpInfo(projectKey, environmentKey, segmentKey, _file, mode, waitOnApprovals);
    }

    public ApiResponse<Void> createBigSegmentImportWithHttpInfo(String projectKey, String environmentKey, String segmentKey, File _file, String mode, Boolean waitOnApprovals) throws ApiException {
        Call localVarCall = this.createBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, _file, mode, waitOnApprovals, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createBigSegmentImportAsync(String projectKey, String environmentKey, String segmentKey, File _file, String mode, Boolean waitOnApprovals, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, _file, mode, waitOnApprovals, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteSegmentCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSegmentValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling deleteSegment(Async)");
        }
        Call localVarCall = this.deleteSegmentCall(projectKey, environmentKey, segmentKey, _callback);
        return localVarCall;
    }

    public void deleteSegment(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        this.deleteSegmentWithHttpInfo(projectKey, environmentKey, segmentKey);
    }

    public ApiResponse<Void> deleteSegmentWithHttpInfo(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        Call localVarCall = this.deleteSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSegmentAsync(String projectKey, String environmentKey, String segmentKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getBigSegmentExportCall(String projectKey, String environmentKey, String segmentKey, String exportID, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/exports/{exportID}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString())).replaceAll("\\{exportID\\}", this.localVarApiClient.escapeString(exportID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBigSegmentExportValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, String exportID, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getBigSegmentExport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getBigSegmentExport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getBigSegmentExport(Async)");
        }
        if (exportID == null) {
            throw new ApiException("Missing the required parameter 'exportID' when calling getBigSegmentExport(Async)");
        }
        Call localVarCall = this.getBigSegmentExportCall(projectKey, environmentKey, segmentKey, exportID, _callback);
        return localVarCall;
    }

    public Export getBigSegmentExport(String projectKey, String environmentKey, String segmentKey, String exportID) throws ApiException {
        ApiResponse<Export> localVarResp = this.getBigSegmentExportWithHttpInfo(projectKey, environmentKey, segmentKey, exportID);
        return localVarResp.getData();
    }

    public ApiResponse<Export> getBigSegmentExportWithHttpInfo(String projectKey, String environmentKey, String segmentKey, String exportID) throws ApiException {
        Call localVarCall = this.getBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, exportID, null);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBigSegmentExportAsync(String projectKey, String environmentKey, String segmentKey, String exportID, ApiCallback<Export> _callback) throws ApiException {
        Call localVarCall = this.getBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, exportID, _callback);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBigSegmentImportCall(String projectKey, String environmentKey, String segmentKey, String importID, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/imports/{importID}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString())).replaceAll("\\{importID\\}", this.localVarApiClient.escapeString(importID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBigSegmentImportValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, String importID, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getBigSegmentImport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getBigSegmentImport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getBigSegmentImport(Async)");
        }
        if (importID == null) {
            throw new ApiException("Missing the required parameter 'importID' when calling getBigSegmentImport(Async)");
        }
        Call localVarCall = this.getBigSegmentImportCall(projectKey, environmentKey, segmentKey, importID, _callback);
        return localVarCall;
    }

    public ModelImport getBigSegmentImport(String projectKey, String environmentKey, String segmentKey, String importID) throws ApiException {
        ApiResponse<ModelImport> localVarResp = this.getBigSegmentImportWithHttpInfo(projectKey, environmentKey, segmentKey, importID);
        return localVarResp.getData();
    }

    public ApiResponse<ModelImport> getBigSegmentImportWithHttpInfo(String projectKey, String environmentKey, String segmentKey, String importID) throws ApiException {
        Call localVarCall = this.getBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, importID, null);
        Type localVarReturnType = new TypeToken<ModelImport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBigSegmentImportAsync(String projectKey, String environmentKey, String segmentKey, String importID, ApiCallback<ModelImport> _callback) throws ApiException {
        Call localVarCall = this.getBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, importID, _callback);
        Type localVarReturnType = new TypeToken<ModelImport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContextInstanceSegmentsMembershipByEnvCall(String projectKey, String environmentKey, Map<String, Object> requestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Map<String, Object> localVarPostBody = requestBody;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/segments/evaluate".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContextInstanceSegmentsMembershipByEnvValidateBeforeCall(String projectKey, String environmentKey, Map<String, Object> requestBody, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getContextInstanceSegmentsMembershipByEnv(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getContextInstanceSegmentsMembershipByEnv(Async)");
        }
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling getContextInstanceSegmentsMembershipByEnv(Async)");
        }
        Call localVarCall = this.getContextInstanceSegmentsMembershipByEnvCall(projectKey, environmentKey, requestBody, _callback);
        return localVarCall;
    }

    public ContextInstanceSegmentMemberships getContextInstanceSegmentsMembershipByEnv(String projectKey, String environmentKey, Map<String, Object> requestBody) throws ApiException {
        ApiResponse<ContextInstanceSegmentMemberships> localVarResp = this.getContextInstanceSegmentsMembershipByEnvWithHttpInfo(projectKey, environmentKey, requestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ContextInstanceSegmentMemberships> getContextInstanceSegmentsMembershipByEnvWithHttpInfo(String projectKey, String environmentKey, Map<String, Object> requestBody) throws ApiException {
        Call localVarCall = this.getContextInstanceSegmentsMembershipByEnvValidateBeforeCall(projectKey, environmentKey, requestBody, null);
        Type localVarReturnType = new TypeToken<ContextInstanceSegmentMemberships>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContextInstanceSegmentsMembershipByEnvAsync(String projectKey, String environmentKey, Map<String, Object> requestBody, ApiCallback<ContextInstanceSegmentMemberships> _callback) throws ApiException {
        Call localVarCall = this.getContextInstanceSegmentsMembershipByEnvValidateBeforeCall(projectKey, environmentKey, requestBody, _callback);
        Type localVarReturnType = new TypeToken<ContextInstanceSegmentMemberships>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExpiringTargetsForSegmentCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{segmentKey}/expiring-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiringTargetsForSegmentValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringTargetsForSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringTargetsForSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getExpiringTargetsForSegment(Async)");
        }
        Call localVarCall = this.getExpiringTargetsForSegmentCall(projectKey, environmentKey, segmentKey, _callback);
        return localVarCall;
    }

    public ExpiringTargetGetResponse getExpiringTargetsForSegment(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        ApiResponse<ExpiringTargetGetResponse> localVarResp = this.getExpiringTargetsForSegmentWithHttpInfo(projectKey, environmentKey, segmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringTargetGetResponse> getExpiringTargetsForSegmentWithHttpInfo(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        Call localVarCall = this.getExpiringTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        Type localVarReturnType = new TypeToken<ExpiringTargetGetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiringTargetsForSegmentAsync(String projectKey, String environmentKey, String segmentKey, ApiCallback<ExpiringTargetGetResponse> _callback) throws ApiException {
        Call localVarCall = this.getExpiringTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        Type localVarReturnType = new TypeToken<ExpiringTargetGetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExpiringUserTargetsForSegmentCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{segmentKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiringUserTargetsForSegmentValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringUserTargetsForSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringUserTargetsForSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getExpiringUserTargetsForSegment(Async)");
        }
        Call localVarCall = this.getExpiringUserTargetsForSegmentCall(projectKey, environmentKey, segmentKey, _callback);
        return localVarCall;
    }

    public ExpiringUserTargetGetResponse getExpiringUserTargetsForSegment(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        ApiResponse<ExpiringUserTargetGetResponse> localVarResp = this.getExpiringUserTargetsForSegmentWithHttpInfo(projectKey, environmentKey, segmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringUserTargetGetResponse> getExpiringUserTargetsForSegmentWithHttpInfo(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        Call localVarCall = this.getExpiringUserTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetGetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiringUserTargetsForSegmentAsync(String projectKey, String environmentKey, String segmentKey, ApiCallback<ExpiringUserTargetGetResponse> _callback) throws ApiException {
        Call localVarCall = this.getExpiringUserTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetGetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSegmentCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSegmentValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getSegment(Async)");
        }
        Call localVarCall = this.getSegmentCall(projectKey, environmentKey, segmentKey, _callback);
        return localVarCall;
    }

    public UserSegment getSegment(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        ApiResponse<UserSegment> localVarResp = this.getSegmentWithHttpInfo(projectKey, environmentKey, segmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<UserSegment> getSegmentWithHttpInfo(String projectKey, String environmentKey, String segmentKey) throws ApiException {
        Call localVarCall = this.getSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSegmentAsync(String projectKey, String environmentKey, String segmentKey, ApiCallback<UserSegment> _callback) throws ApiException {
        Call localVarCall = this.getSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSegmentMembershipForContextCall(String projectKey, String environmentKey, String segmentKey, String contextKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/contexts/{contextKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString())).replaceAll("\\{contextKey\\}", this.localVarApiClient.escapeString(contextKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSegmentMembershipForContextValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, String contextKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSegmentMembershipForContext(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSegmentMembershipForContext(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getSegmentMembershipForContext(Async)");
        }
        if (contextKey == null) {
            throw new ApiException("Missing the required parameter 'contextKey' when calling getSegmentMembershipForContext(Async)");
        }
        Call localVarCall = this.getSegmentMembershipForContextCall(projectKey, environmentKey, segmentKey, contextKey, _callback);
        return localVarCall;
    }

    public BigSegmentTarget getSegmentMembershipForContext(String projectKey, String environmentKey, String segmentKey, String contextKey) throws ApiException {
        ApiResponse<BigSegmentTarget> localVarResp = this.getSegmentMembershipForContextWithHttpInfo(projectKey, environmentKey, segmentKey, contextKey);
        return localVarResp.getData();
    }

    public ApiResponse<BigSegmentTarget> getSegmentMembershipForContextWithHttpInfo(String projectKey, String environmentKey, String segmentKey, String contextKey) throws ApiException {
        Call localVarCall = this.getSegmentMembershipForContextValidateBeforeCall(projectKey, environmentKey, segmentKey, contextKey, null);
        Type localVarReturnType = new TypeToken<BigSegmentTarget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSegmentMembershipForContextAsync(String projectKey, String environmentKey, String segmentKey, String contextKey, ApiCallback<BigSegmentTarget> _callback) throws ApiException {
        Call localVarCall = this.getSegmentMembershipForContextValidateBeforeCall(projectKey, environmentKey, segmentKey, contextKey, _callback);
        Type localVarReturnType = new TypeToken<BigSegmentTarget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSegmentMembershipForUserCall(String projectKey, String environmentKey, String segmentKey, String userKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/users/{userKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString())).replaceAll("\\{userKey\\}", this.localVarApiClient.escapeString(userKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSegmentMembershipForUserValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, String userKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSegmentMembershipForUser(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSegmentMembershipForUser(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getSegmentMembershipForUser(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getSegmentMembershipForUser(Async)");
        }
        Call localVarCall = this.getSegmentMembershipForUserCall(projectKey, environmentKey, segmentKey, userKey, _callback);
        return localVarCall;
    }

    public BigSegmentTarget getSegmentMembershipForUser(String projectKey, String environmentKey, String segmentKey, String userKey) throws ApiException {
        ApiResponse<BigSegmentTarget> localVarResp = this.getSegmentMembershipForUserWithHttpInfo(projectKey, environmentKey, segmentKey, userKey);
        return localVarResp.getData();
    }

    public ApiResponse<BigSegmentTarget> getSegmentMembershipForUserWithHttpInfo(String projectKey, String environmentKey, String segmentKey, String userKey) throws ApiException {
        Call localVarCall = this.getSegmentMembershipForUserValidateBeforeCall(projectKey, environmentKey, segmentKey, userKey, null);
        Type localVarReturnType = new TypeToken<BigSegmentTarget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSegmentMembershipForUserAsync(String projectKey, String environmentKey, String segmentKey, String userKey, ApiCallback<BigSegmentTarget> _callback) throws ApiException {
        Call localVarCall = this.getSegmentMembershipForUserValidateBeforeCall(projectKey, environmentKey, segmentKey, userKey, _callback);
        Type localVarReturnType = new TypeToken<BigSegmentTarget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSegmentsCall(String projectKey, String environmentKey, Long limit, Long offset, String sort, String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSegmentsValidateBeforeCall(String projectKey, String environmentKey, Long limit, Long offset, String sort, String filter, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSegments(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSegments(Async)");
        }
        Call localVarCall = this.getSegmentsCall(projectKey, environmentKey, limit, offset, sort, filter, _callback);
        return localVarCall;
    }

    public UserSegments getSegments(String projectKey, String environmentKey, Long limit, Long offset, String sort, String filter) throws ApiException {
        ApiResponse<UserSegments> localVarResp = this.getSegmentsWithHttpInfo(projectKey, environmentKey, limit, offset, sort, filter);
        return localVarResp.getData();
    }

    public ApiResponse<UserSegments> getSegmentsWithHttpInfo(String projectKey, String environmentKey, Long limit, Long offset, String sort, String filter) throws ApiException {
        Call localVarCall = this.getSegmentsValidateBeforeCall(projectKey, environmentKey, limit, offset, sort, filter, null);
        Type localVarReturnType = new TypeToken<UserSegments>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSegmentsAsync(String projectKey, String environmentKey, Long limit, Long offset, String sort, String filter, ApiCallback<UserSegments> _callback) throws ApiException {
        Call localVarCall = this.getSegmentsValidateBeforeCall(projectKey, environmentKey, limit, offset, sort, filter, _callback);
        Type localVarReturnType = new TypeToken<UserSegments>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExpiringTargetsForSegmentCall(String projectKey, String environmentKey, String segmentKey, PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchSegmentExpiringTargetInputRep localVarPostBody = patchSegmentExpiringTargetInputRep;
        String localVarPath = "/api/v2/segments/{projectKey}/{segmentKey}/expiring-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExpiringTargetsForSegmentValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringTargetsForSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringTargetsForSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling patchExpiringTargetsForSegment(Async)");
        }
        if (patchSegmentExpiringTargetInputRep == null) {
            throw new ApiException("Missing the required parameter 'patchSegmentExpiringTargetInputRep' when calling patchExpiringTargetsForSegment(Async)");
        }
        Call localVarCall = this.patchExpiringTargetsForSegmentCall(projectKey, environmentKey, segmentKey, patchSegmentExpiringTargetInputRep, _callback);
        return localVarCall;
    }

    public ExpiringTargetPatchResponse patchExpiringTargetsForSegment(String projectKey, String environmentKey, String segmentKey, PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep) throws ApiException {
        ApiResponse<ExpiringTargetPatchResponse> localVarResp = this.patchExpiringTargetsForSegmentWithHttpInfo(projectKey, environmentKey, segmentKey, patchSegmentExpiringTargetInputRep);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringTargetPatchResponse> patchExpiringTargetsForSegmentWithHttpInfo(String projectKey, String environmentKey, String segmentKey, PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep) throws ApiException {
        Call localVarCall = this.patchExpiringTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchSegmentExpiringTargetInputRep, null);
        Type localVarReturnType = new TypeToken<ExpiringTargetPatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExpiringTargetsForSegmentAsync(String projectKey, String environmentKey, String segmentKey, PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep, ApiCallback<ExpiringTargetPatchResponse> _callback) throws ApiException {
        Call localVarCall = this.patchExpiringTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchSegmentExpiringTargetInputRep, _callback);
        Type localVarReturnType = new TypeToken<ExpiringTargetPatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExpiringUserTargetsForSegmentCall(String projectKey, String environmentKey, String segmentKey, PatchSegmentRequest patchSegmentRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchSegmentRequest localVarPostBody = patchSegmentRequest;
        String localVarPath = "/api/v2/segments/{projectKey}/{segmentKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExpiringUserTargetsForSegmentValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, PatchSegmentRequest patchSegmentRequest, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringUserTargetsForSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringUserTargetsForSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling patchExpiringUserTargetsForSegment(Async)");
        }
        if (patchSegmentRequest == null) {
            throw new ApiException("Missing the required parameter 'patchSegmentRequest' when calling patchExpiringUserTargetsForSegment(Async)");
        }
        Call localVarCall = this.patchExpiringUserTargetsForSegmentCall(projectKey, environmentKey, segmentKey, patchSegmentRequest, _callback);
        return localVarCall;
    }

    public ExpiringUserTargetPatchResponse patchExpiringUserTargetsForSegment(String projectKey, String environmentKey, String segmentKey, PatchSegmentRequest patchSegmentRequest) throws ApiException {
        ApiResponse<ExpiringUserTargetPatchResponse> localVarResp = this.patchExpiringUserTargetsForSegmentWithHttpInfo(projectKey, environmentKey, segmentKey, patchSegmentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringUserTargetPatchResponse> patchExpiringUserTargetsForSegmentWithHttpInfo(String projectKey, String environmentKey, String segmentKey, PatchSegmentRequest patchSegmentRequest) throws ApiException {
        Call localVarCall = this.patchExpiringUserTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchSegmentRequest, null);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetPatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExpiringUserTargetsForSegmentAsync(String projectKey, String environmentKey, String segmentKey, PatchSegmentRequest patchSegmentRequest, ApiCallback<ExpiringUserTargetPatchResponse> _callback) throws ApiException {
        Call localVarCall = this.patchExpiringUserTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchSegmentRequest, _callback);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetPatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSegmentCall(String projectKey, String environmentKey, String segmentKey, PatchWithComment patchWithComment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchWithComment localVarPostBody = patchWithComment;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSegmentValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, PatchWithComment patchWithComment, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling patchSegment(Async)");
        }
        if (patchWithComment == null) {
            throw new ApiException("Missing the required parameter 'patchWithComment' when calling patchSegment(Async)");
        }
        Call localVarCall = this.patchSegmentCall(projectKey, environmentKey, segmentKey, patchWithComment, _callback);
        return localVarCall;
    }

    public UserSegment patchSegment(String projectKey, String environmentKey, String segmentKey, PatchWithComment patchWithComment) throws ApiException {
        ApiResponse<UserSegment> localVarResp = this.patchSegmentWithHttpInfo(projectKey, environmentKey, segmentKey, patchWithComment);
        return localVarResp.getData();
    }

    public ApiResponse<UserSegment> patchSegmentWithHttpInfo(String projectKey, String environmentKey, String segmentKey, PatchWithComment patchWithComment) throws ApiException {
        Call localVarCall = this.patchSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchWithComment, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSegmentAsync(String projectKey, String environmentKey, String segmentKey, PatchWithComment patchWithComment, ApiCallback<UserSegment> _callback) throws ApiException {
        Call localVarCall = this.patchSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchWithComment, _callback);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postSegmentCall(String projectKey, String environmentKey, SegmentBody segmentBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SegmentBody localVarPostBody = segmentBody;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postSegmentValidateBeforeCall(String projectKey, String environmentKey, SegmentBody segmentBody, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postSegment(Async)");
        }
        if (segmentBody == null) {
            throw new ApiException("Missing the required parameter 'segmentBody' when calling postSegment(Async)");
        }
        Call localVarCall = this.postSegmentCall(projectKey, environmentKey, segmentBody, _callback);
        return localVarCall;
    }

    public UserSegment postSegment(String projectKey, String environmentKey, SegmentBody segmentBody) throws ApiException {
        ApiResponse<UserSegment> localVarResp = this.postSegmentWithHttpInfo(projectKey, environmentKey, segmentBody);
        return localVarResp.getData();
    }

    public ApiResponse<UserSegment> postSegmentWithHttpInfo(String projectKey, String environmentKey, SegmentBody segmentBody) throws ApiException {
        Call localVarCall = this.postSegmentValidateBeforeCall(projectKey, environmentKey, segmentBody, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postSegmentAsync(String projectKey, String environmentKey, SegmentBody segmentBody, ApiCallback<UserSegment> _callback) throws ApiException {
        Call localVarCall = this.postSegmentValidateBeforeCall(projectKey, environmentKey, segmentBody, _callback);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateBigSegmentContextTargetsCall(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SegmentUserState localVarPostBody = segmentUserState;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/contexts".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateBigSegmentContextTargetsValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateBigSegmentContextTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling updateBigSegmentContextTargets(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling updateBigSegmentContextTargets(Async)");
        }
        if (segmentUserState == null) {
            throw new ApiException("Missing the required parameter 'segmentUserState' when calling updateBigSegmentContextTargets(Async)");
        }
        Call localVarCall = this.updateBigSegmentContextTargetsCall(projectKey, environmentKey, segmentKey, segmentUserState, _callback);
        return localVarCall;
    }

    public void updateBigSegmentContextTargets(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState) throws ApiException {
        this.updateBigSegmentContextTargetsWithHttpInfo(projectKey, environmentKey, segmentKey, segmentUserState);
    }

    public ApiResponse<Void> updateBigSegmentContextTargetsWithHttpInfo(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState) throws ApiException {
        Call localVarCall = this.updateBigSegmentContextTargetsValidateBeforeCall(projectKey, environmentKey, segmentKey, segmentUserState, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateBigSegmentContextTargetsAsync(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateBigSegmentContextTargetsValidateBeforeCall(projectKey, environmentKey, segmentKey, segmentUserState, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateBigSegmentTargetsCall(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SegmentUserState localVarPostBody = segmentUserState;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/users".replaceAll("\\{projectKey\\}", this.localVarApiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.localVarApiClient.escapeString(environmentKey.toString())).replaceAll("\\{segmentKey\\}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateBigSegmentTargetsValidateBeforeCall(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateBigSegmentTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling updateBigSegmentTargets(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling updateBigSegmentTargets(Async)");
        }
        if (segmentUserState == null) {
            throw new ApiException("Missing the required parameter 'segmentUserState' when calling updateBigSegmentTargets(Async)");
        }
        Call localVarCall = this.updateBigSegmentTargetsCall(projectKey, environmentKey, segmentKey, segmentUserState, _callback);
        return localVarCall;
    }

    public void updateBigSegmentTargets(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState) throws ApiException {
        this.updateBigSegmentTargetsWithHttpInfo(projectKey, environmentKey, segmentKey, segmentUserState);
    }

    public ApiResponse<Void> updateBigSegmentTargetsWithHttpInfo(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState) throws ApiException {
        Call localVarCall = this.updateBigSegmentTargetsValidateBeforeCall(projectKey, environmentKey, segmentKey, segmentUserState, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateBigSegmentTargetsAsync(String projectKey, String environmentKey, String segmentKey, SegmentUserState segmentUserState, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateBigSegmentTargetsValidateBeforeCall(projectKey, environmentKey, segmentKey, segmentUserState, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

