/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AbstractOpenApiSchema;
import com.launchdarkly.api.model.AiConfigsMaintainerTeam;
import com.launchdarkly.api.model.MaintainerMember;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.GenericType;

public class AIConfigMaintainer
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(AIConfigMaintainer.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public AIConfigMaintainer() {
        super("oneOf", Boolean.FALSE);
    }

    public AIConfigMaintainer(AiConfigsMaintainerTeam o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public AIConfigMaintainer(MaintainerMember o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof AiConfigsMaintainerTeam) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof MaintainerMember) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be AiConfigsMaintainerTeam, MaintainerMember");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public AiConfigsMaintainerTeam getAiConfigsMaintainerTeam() throws ClassCastException {
        return (AiConfigsMaintainerTeam)super.getActualInstance();
    }

    public MaintainerMember getMaintainerMember() throws ClassCastException {
        return (MaintainerMember)super.getActualInstance();
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            AiConfigsMaintainerTeam.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for AiConfigsMaintainerTeam failed with `%s`.", e.getMessage()));
        }
        try {
            MaintainerMember.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for MaintainerMember failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for AIConfigMaintainer with oneOf schemas: AiConfigsMaintainerTeam, MaintainerMember. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonObj.toString()));
        }
    }

    public static AIConfigMaintainer fromJson(String jsonString) throws IOException {
        return (AIConfigMaintainer)JSON.getGson().fromJson(jsonString, AIConfigMaintainer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("AiConfigsMaintainerTeam", (GenericType)new GenericType<AiConfigsMaintainerTeam>(){});
        schemas.put("MaintainerMember", (GenericType)new GenericType<MaintainerMember>(){});
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AIConfigMaintainer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterAiConfigsMaintainerTeam = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AiConfigsMaintainerTeam.class));
            final TypeAdapter adapterMaintainerMember = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MaintainerMember.class));
            return new TypeAdapter<AIConfigMaintainer>(){

                public void write(JsonWriter out, AIConfigMaintainer value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof AiConfigsMaintainerTeam) {
                        JsonObject obj = adapterAiConfigsMaintainerTeam.toJsonTree((Object)((AiConfigsMaintainerTeam)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    if (value.getActualInstance() instanceof MaintainerMember) {
                        JsonObject obj = adapterMaintainerMember.toJsonTree((Object)((MaintainerMember)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: AiConfigsMaintainerTeam, MaintainerMember");
                }

                public AIConfigMaintainer read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonObject jsonObject = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        AiConfigsMaintainerTeam.validateJsonObject(jsonObject);
                        actualAdapter = adapterAiConfigsMaintainerTeam;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'AiConfigsMaintainerTeam'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for AiConfigsMaintainerTeam failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'AiConfigsMaintainerTeam'", e);
                    }
                    try {
                        MaintainerMember.validateJsonObject(jsonObject);
                        actualAdapter = adapterMaintainerMember;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'MaintainerMember'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for MaintainerMember failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'MaintainerMember'", e);
                    }
                    if (match == 1) {
                        AIConfigMaintainer ret = new AIConfigMaintainer();
                        ret.setActualInstance(actualAdapter.fromJsonTree((JsonElement)jsonObject));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for AIConfigMaintainer: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonObject.toString()));
                }
            }.nullSafe();
        }
    }
}

