/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.StatementPost;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class AccessTokenPost {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private RoleEnum role;
    public static final String SERIALIZED_NAME_CUSTOM_ROLE_IDS = "customRoleIds";
    @SerializedName(value="customRoleIds")
    private List<String> customRoleIds = null;
    public static final String SERIALIZED_NAME_INLINE_ROLE = "inlineRole";
    @SerializedName(value="inlineRole")
    private List<StatementPost> inlineRole = null;
    public static final String SERIALIZED_NAME_SERVICE_TOKEN = "serviceToken";
    @SerializedName(value="serviceToken")
    private Boolean serviceToken;
    public static final String SERIALIZED_NAME_DEFAULT_API_VERSION = "defaultApiVersion";
    @SerializedName(value="defaultApiVersion")
    private Integer defaultApiVersion;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AccessTokenPost name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-friendly name for the access token")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccessTokenPost description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A description for the access token")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AccessTokenPost role(RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Built-in role for the token")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public AccessTokenPost customRoleIds(List<String> customRoleIds) {
        this.customRoleIds = customRoleIds;
        return this;
    }

    public AccessTokenPost addCustomRoleIdsItem(String customRoleIdsItem) {
        if (this.customRoleIds == null) {
            this.customRoleIds = new ArrayList<String>();
        }
        this.customRoleIds.add(customRoleIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of custom role IDs to use as access limits for the access token")
    public List<String> getCustomRoleIds() {
        return this.customRoleIds;
    }

    public void setCustomRoleIds(List<String> customRoleIds) {
        this.customRoleIds = customRoleIds;
    }

    public AccessTokenPost inlineRole(List<StatementPost> inlineRole) {
        this.inlineRole = inlineRole;
        return this;
    }

    public AccessTokenPost addInlineRoleItem(StatementPost inlineRoleItem) {
        if (this.inlineRole == null) {
            this.inlineRole = new ArrayList<StatementPost>();
        }
        this.inlineRole.add(inlineRoleItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array of statements represented as JSON objects with three attributes: effect, resources, actions. May be used in place of a built-in or custom role.")
    public List<StatementPost> getInlineRole() {
        return this.inlineRole;
    }

    public void setInlineRole(List<StatementPost> inlineRole) {
        this.inlineRole = inlineRole;
    }

    public AccessTokenPost serviceToken(Boolean serviceToken) {
        this.serviceToken = serviceToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the token is a service token")
    public Boolean getServiceToken() {
        return this.serviceToken;
    }

    public void setServiceToken(Boolean serviceToken) {
        this.serviceToken = serviceToken;
    }

    public AccessTokenPost defaultApiVersion(Integer defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default API version for this token")
    public Integer getDefaultApiVersion() {
        return this.defaultApiVersion;
    }

    public void setDefaultApiVersion(Integer defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
    }

    public AccessTokenPost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessTokenPost accessTokenPost = (AccessTokenPost)o;
        return Objects.equals(this.name, accessTokenPost.name) && Objects.equals(this.description, accessTokenPost.description) && Objects.equals((Object)this.role, (Object)accessTokenPost.role) && Objects.equals(this.customRoleIds, accessTokenPost.customRoleIds) && Objects.equals(this.inlineRole, accessTokenPost.inlineRole) && Objects.equals(this.serviceToken, accessTokenPost.serviceToken) && Objects.equals(this.defaultApiVersion, accessTokenPost.defaultApiVersion) && Objects.equals(this.additionalProperties, accessTokenPost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.role, this.customRoleIds, this.inlineRole, this.serviceToken, this.defaultApiVersion, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessTokenPost {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    customRoleIds: ").append(this.toIndentedString(this.customRoleIds)).append("\n");
        sb.append("    inlineRole: ").append(this.toIndentedString(this.inlineRole)).append("\n");
        sb.append("    serviceToken: ").append(this.toIndentedString(this.serviceToken)).append("\n");
        sb.append("    defaultApiVersion: ").append(this.toIndentedString(this.defaultApiVersion)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccessTokenPost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLE) != null && !jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLE_IDS) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLE_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `customRoleIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLE_IDS).toString()));
        }
        JsonArray jsonArrayinlineRole = jsonObj.getAsJsonArray(SERIALIZED_NAME_INLINE_ROLE);
        if (jsonArrayinlineRole != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INLINE_ROLE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `inlineRole` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INLINE_ROLE).toString()));
            }
            for (int i = 0; i < jsonArrayinlineRole.size(); ++i) {
                StatementPost.validateJsonObject(jsonArrayinlineRole.get(i).getAsJsonObject());
            }
        }
    }

    public static AccessTokenPost fromJson(String jsonString) throws IOException {
        return (AccessTokenPost)JSON.getGson().fromJson(jsonString, AccessTokenPost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_ROLE_IDS);
        openapiFields.add(SERIALIZED_NAME_INLINE_ROLE);
        openapiFields.add(SERIALIZED_NAME_SERVICE_TOKEN);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_API_VERSION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AccessTokenPost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccessTokenPost.class));
            return new TypeAdapter<AccessTokenPost>(){

                public void write(JsonWriter out, AccessTokenPost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AccessTokenPost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccessTokenPost.validateJsonObject(jsonObj);
                    AccessTokenPost instance = (AccessTokenPost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        READER("reader"),
        WRITER("writer"),
        ADMIN("admin");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }
}

