/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AiConfigsAccessAllowedReason {
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<String> resources = null;
    public static final String SERIALIZED_NAME_NOT_RESOURCES = "notResources";
    @SerializedName(value="notResources")
    private List<String> notResources = null;
    public static final String SERIALIZED_NAME_ACTIONS = "actions";
    @SerializedName(value="actions")
    private List<String> actions = null;
    public static final String SERIALIZED_NAME_NOT_ACTIONS = "notActions";
    @SerializedName(value="notActions")
    private List<String> notActions = null;
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    private EffectEnum effect;
    public static final String SERIALIZED_NAME_ROLE_NAME = "role_name";
    @SerializedName(value="role_name")
    private String roleName;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AiConfigsAccessAllowedReason resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public AiConfigsAccessAllowedReason addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"proj/_*:env/_*;qa_*:/flag/_*\"]", value="Resource specifier strings")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public AiConfigsAccessAllowedReason notResources(List<String> notResources) {
        this.notResources = notResources;
        return this;
    }

    public AiConfigsAccessAllowedReason addNotResourcesItem(String notResourcesItem) {
        if (this.notResources == null) {
            this.notResources = new ArrayList<String>();
        }
        this.notResources.add(notResourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Targeted resources are the resources NOT in this list. The <code>resources</code> and <code>notActions</code> fields must be empty to use this field.")
    public List<String> getNotResources() {
        return this.notResources;
    }

    public void setNotResources(List<String> notResources) {
        this.notResources = notResources;
    }

    public AiConfigsAccessAllowedReason actions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public AiConfigsAccessAllowedReason addActionsItem(String actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<String>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"*\"]", value="Actions to perform on a resource")
    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public AiConfigsAccessAllowedReason notActions(List<String> notActions) {
        this.notActions = notActions;
        return this;
    }

    public AiConfigsAccessAllowedReason addNotActionsItem(String notActionsItem) {
        if (this.notActions == null) {
            this.notActions = new ArrayList<String>();
        }
        this.notActions.add(notActionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Targeted actions are the actions NOT in this list. The <code>actions</code> and <code>notResources</code> fields must be empty to use this field.")
    public List<String> getNotActions() {
        return this.notActions;
    }

    public void setNotActions(List<String> notActions) {
        this.notActions = notActions;
    }

    public AiConfigsAccessAllowedReason effect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="allow", required=true, value="Whether this statement should allow or deny actions on the resources.")
    public EffectEnum getEffect() {
        return this.effect;
    }

    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public AiConfigsAccessAllowedReason roleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public AiConfigsAccessAllowedReason putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AiConfigsAccessAllowedReason aiConfigsAccessAllowedReason = (AiConfigsAccessAllowedReason)o;
        return Objects.equals(this.resources, aiConfigsAccessAllowedReason.resources) && Objects.equals(this.notResources, aiConfigsAccessAllowedReason.notResources) && Objects.equals(this.actions, aiConfigsAccessAllowedReason.actions) && Objects.equals(this.notActions, aiConfigsAccessAllowedReason.notActions) && Objects.equals((Object)this.effect, (Object)aiConfigsAccessAllowedReason.effect) && Objects.equals(this.roleName, aiConfigsAccessAllowedReason.roleName) && Objects.equals(this.additionalProperties, aiConfigsAccessAllowedReason.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resources, this.notResources, this.actions, this.notActions, this.effect, this.roleName, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AiConfigsAccessAllowedReason {\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    notResources: ").append(this.toIndentedString(this.notResources)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    notActions: ").append(this.toIndentedString(this.notActions)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString((Object)this.effect)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AiConfigsAccessAllowedReason is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOT_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_NOT_RESOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notResources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOT_RESOURCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `actions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOT_ACTIONS) != null && !jsonObj.get(SERIALIZED_NAME_NOT_ACTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `notActions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOT_ACTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EFFECT) != null && !jsonObj.get(SERIALIZED_NAME_EFFECT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `effect` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EFFECT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_ROLE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE_NAME).toString()));
        }
    }

    public static AiConfigsAccessAllowedReason fromJson(String jsonString) throws IOException {
        return (AiConfigsAccessAllowedReason)JSON.getGson().fromJson(jsonString, AiConfigsAccessAllowedReason.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_NOT_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_NOT_ACTIONS);
        openapiFields.add(SERIALIZED_NAME_EFFECT);
        openapiFields.add(SERIALIZED_NAME_ROLE_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EFFECT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AiConfigsAccessAllowedReason.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AiConfigsAccessAllowedReason.class));
            return new TypeAdapter<AiConfigsAccessAllowedReason>(){

                public void write(JsonWriter out, AiConfigsAccessAllowedReason value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AiConfigsAccessAllowedReason read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AiConfigsAccessAllowedReason.validateJsonObject(jsonObj);
                    AiConfigsAccessAllowedReason instance = (AiConfigsAccessAllowedReason)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EffectEnum {
        ALLOW("allow"),
        DENY("deny");

        private String value;

        private EffectEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EffectEnum fromValue(String value) {
            for (EffectEnum b : EffectEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EffectEnum> {
            public void write(JsonWriter jsonWriter, EffectEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EffectEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EffectEnum.fromValue(value);
            }
        }
    }
}

