/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AnnouncementAccessRep;
import com.launchdarkly.api.model.AnnouncementResponseLinks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Announcement response")
public class AnnouncementResponse {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_IS_DISMISSIBLE = "isDismissible";
    @SerializedName(value="isDismissible")
    private Boolean isDismissible;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private Long startTime;
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    private Long endTime;
    public static final String SERIALIZED_NAME_SEVERITY = "severity";
    @SerializedName(value="severity")
    private SeverityEnum severity;
    public static final String SERIALIZED_NAME_STATUS = "_status";
    @SerializedName(value="_status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private AnnouncementAccessRep access;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private AnnouncementResponseLinks links;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AnnouncementResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234567890", required=true, value="The ID of the announcement")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AnnouncementResponse isDismissible(Boolean isDismissible) {
        this.isDismissible = isDismissible;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="true if the announcement is dismissible")
    public Boolean getIsDismissible() {
        return this.isDismissible;
    }

    public void setIsDismissible(Boolean isDismissible) {
        this.isDismissible = isDismissible;
    }

    public AnnouncementResponse title(String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="System Maintenance Notice", required=true, value="The title of the announcement")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AnnouncementResponse message(String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="**Important Update:**  Please be aware of the upcoming maintenance scheduled for *October 31st, 2024*. The system will be unavailable from **12:00 AM** to **4:00 AM**.", required=true, value="The message of the announcement")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public AnnouncementResponse startTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1731439812", required=true, value="The start time of the announcement. This is a Unix timestamp in milliseconds.")
    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public AnnouncementResponse endTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1731439880", value="The end time of the announcement. This is a Unix timestamp in milliseconds.")
    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public AnnouncementResponse severity(SeverityEnum severity) {
        this.severity = severity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The severity of the announcement")
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityEnum severity) {
        this.severity = severity;
    }

    public AnnouncementResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The status of the announcement")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AnnouncementResponse access(AnnouncementAccessRep access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AnnouncementAccessRep getAccess() {
        return this.access;
    }

    public void setAccess(AnnouncementAccessRep access) {
        this.access = access;
    }

    public AnnouncementResponse links(AnnouncementResponseLinks links) {
        this.links = links;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public AnnouncementResponseLinks getLinks() {
        return this.links;
    }

    public void setLinks(AnnouncementResponseLinks links) {
        this.links = links;
    }

    public AnnouncementResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnouncementResponse announcementResponse = (AnnouncementResponse)o;
        return Objects.equals(this.id, announcementResponse.id) && Objects.equals(this.isDismissible, announcementResponse.isDismissible) && Objects.equals(this.title, announcementResponse.title) && Objects.equals(this.message, announcementResponse.message) && Objects.equals(this.startTime, announcementResponse.startTime) && Objects.equals(this.endTime, announcementResponse.endTime) && Objects.equals((Object)this.severity, (Object)announcementResponse.severity) && Objects.equals((Object)this.status, (Object)announcementResponse.status) && Objects.equals(this.access, announcementResponse.access) && Objects.equals(this.links, announcementResponse.links) && Objects.equals(this.additionalProperties, announcementResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.isDismissible, this.title, this.message, this.startTime, this.endTime, this.severity, this.status, this.access, this.links, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnnouncementResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isDismissible: ").append(this.toIndentedString(this.isDismissible)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AnnouncementResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SEVERITY) != null && !jsonObj.get(SERIALIZED_NAME_SEVERITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `severity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SEVERITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            AnnouncementAccessRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            AnnouncementResponseLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
    }

    public static AnnouncementResponse fromJson(String jsonString) throws IOException {
        return (AnnouncementResponse)JSON.getGson().fromJson(jsonString, AnnouncementResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_IS_DISMISSIBLE);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiFields.add(SERIALIZED_NAME_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_START_TIME);
        openapiFields.add(SERIALIZED_NAME_END_TIME);
        openapiFields.add(SERIALIZED_NAME_SEVERITY);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_IS_DISMISSIBLE);
        openapiRequiredFields.add(SERIALIZED_NAME_TITLE);
        openapiRequiredFields.add(SERIALIZED_NAME_MESSAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_START_TIME);
        openapiRequiredFields.add(SERIALIZED_NAME_SEVERITY);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AnnouncementResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AnnouncementResponse.class));
            return new TypeAdapter<AnnouncementResponse>(){

                public void write(JsonWriter out, AnnouncementResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AnnouncementResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AnnouncementResponse.validateJsonObject(jsonObj);
                    AnnouncementResponse instance = (AnnouncementResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive"),
        SCHEDULED("scheduled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SeverityEnum {
        INFO("info"),
        WARNING("warning"),
        CRITICAL("critical");

        private String value;

        private SeverityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SeverityEnum fromValue(String value) {
            for (SeverityEnum b : SeverityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SeverityEnum> {
            public void write(JsonWriter jsonWriter, SeverityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SeverityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SeverityEnum.fromValue(value);
            }
        }
    }
}

