/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApprovalSettings {
    public static final String SERIALIZED_NAME_REQUIRED = "required";
    @SerializedName(value="required")
    private Boolean required;
    public static final String SERIALIZED_NAME_BYPASS_APPROVALS_FOR_PENDING_CHANGES = "bypassApprovalsForPendingChanges";
    @SerializedName(value="bypassApprovalsForPendingChanges")
    private Boolean bypassApprovalsForPendingChanges;
    public static final String SERIALIZED_NAME_MIN_NUM_APPROVALS = "minNumApprovals";
    @SerializedName(value="minNumApprovals")
    private Integer minNumApprovals;
    public static final String SERIALIZED_NAME_CAN_REVIEW_OWN_REQUEST = "canReviewOwnRequest";
    @SerializedName(value="canReviewOwnRequest")
    private Boolean canReviewOwnRequest;
    public static final String SERIALIZED_NAME_CAN_APPLY_DECLINED_CHANGES = "canApplyDeclinedChanges";
    @SerializedName(value="canApplyDeclinedChanges")
    private Boolean canApplyDeclinedChanges;
    public static final String SERIALIZED_NAME_AUTO_APPLY_APPROVED_CHANGES = "autoApplyApprovedChanges";
    @SerializedName(value="autoApplyApprovedChanges")
    private Boolean autoApplyApprovedChanges;
    public static final String SERIALIZED_NAME_SERVICE_KIND = "serviceKind";
    @SerializedName(value="serviceKind")
    private String serviceKind;
    public static final String SERIALIZED_NAME_SERVICE_CONFIG = "serviceConfig";
    @SerializedName(value="serviceConfig")
    private Map<String, Object> serviceConfig = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_REQUIRED_APPROVAL_TAGS = "requiredApprovalTags";
    @SerializedName(value="requiredApprovalTags")
    private List<String> requiredApprovalTags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SERVICE_KIND_CONFIGURATION_ID = "serviceKindConfigurationId";
    @SerializedName(value="serviceKindConfigurationId")
    private String serviceKindConfigurationId;
    public static final String SERIALIZED_NAME_RESOURCE_KIND = "resourceKind";
    @SerializedName(value="resourceKind")
    private String resourceKind;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ApprovalSettings required(Boolean required) {
        this.required = required;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="If approvals are required for this environment")
    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public ApprovalSettings bypassApprovalsForPendingChanges(Boolean bypassApprovalsForPendingChanges) {
        this.bypassApprovalsForPendingChanges = bypassApprovalsForPendingChanges;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Whether to skip approvals for pending changes")
    public Boolean getBypassApprovalsForPendingChanges() {
        return this.bypassApprovalsForPendingChanges;
    }

    public void setBypassApprovalsForPendingChanges(Boolean bypassApprovalsForPendingChanges) {
        this.bypassApprovalsForPendingChanges = bypassApprovalsForPendingChanges;
    }

    public ApprovalSettings minNumApprovals(Integer minNumApprovals) {
        this.minNumApprovals = minNumApprovals;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="Sets the amount of approvals required before a member can apply a change. The minimum is one and the maximum is five.")
    public Integer getMinNumApprovals() {
        return this.minNumApprovals;
    }

    public void setMinNumApprovals(Integer minNumApprovals) {
        this.minNumApprovals = minNumApprovals;
    }

    public ApprovalSettings canReviewOwnRequest(Boolean canReviewOwnRequest) {
        this.canReviewOwnRequest = canReviewOwnRequest;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Allow someone who makes an approval request to apply their own change")
    public Boolean getCanReviewOwnRequest() {
        return this.canReviewOwnRequest;
    }

    public void setCanReviewOwnRequest(Boolean canReviewOwnRequest) {
        this.canReviewOwnRequest = canReviewOwnRequest;
    }

    public ApprovalSettings canApplyDeclinedChanges(Boolean canApplyDeclinedChanges) {
        this.canApplyDeclinedChanges = canApplyDeclinedChanges;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Allow applying the change as long as at least one person has approved")
    public Boolean getCanApplyDeclinedChanges() {
        return this.canApplyDeclinedChanges;
    }

    public void setCanApplyDeclinedChanges(Boolean canApplyDeclinedChanges) {
        this.canApplyDeclinedChanges = canApplyDeclinedChanges;
    }

    public ApprovalSettings autoApplyApprovedChanges(Boolean autoApplyApprovedChanges) {
        this.autoApplyApprovedChanges = autoApplyApprovedChanges;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Automatically apply changes that have been approved by all reviewers. This field is only applicable for approval services other than LaunchDarkly.")
    public Boolean getAutoApplyApprovedChanges() {
        return this.autoApplyApprovedChanges;
    }

    public void setAutoApplyApprovedChanges(Boolean autoApplyApprovedChanges) {
        this.autoApplyApprovedChanges = autoApplyApprovedChanges;
    }

    public ApprovalSettings serviceKind(String serviceKind) {
        this.serviceKind = serviceKind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="launchdarkly", required=true, value="Which service to use for managing approvals")
    public String getServiceKind() {
        return this.serviceKind;
    }

    public void setServiceKind(String serviceKind) {
        this.serviceKind = serviceKind;
    }

    public ApprovalSettings serviceConfig(Map<String, Object> serviceConfig) {
        this.serviceConfig = serviceConfig;
        return this;
    }

    public ApprovalSettings putServiceConfigItem(String key, Object serviceConfigItem) {
        this.serviceConfig.put(key, serviceConfigItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{}", required=true, value="")
    public Map<String, Object> getServiceConfig() {
        return this.serviceConfig;
    }

    public void setServiceConfig(Map<String, Object> serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public ApprovalSettings requiredApprovalTags(List<String> requiredApprovalTags) {
        this.requiredApprovalTags = requiredApprovalTags;
        return this;
    }

    public ApprovalSettings addRequiredApprovalTagsItem(String requiredApprovalTagsItem) {
        this.requiredApprovalTags.add(requiredApprovalTagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"require-approval\"]", required=true, value="Require approval only on flags with the provided tags. Otherwise all flags will require approval.")
    public List<String> getRequiredApprovalTags() {
        return this.requiredApprovalTags;
    }

    public void setRequiredApprovalTags(List<String> requiredApprovalTags) {
        this.requiredApprovalTags = requiredApprovalTags;
    }

    public ApprovalSettings serviceKindConfigurationId(String serviceKindConfigurationId) {
        this.serviceKindConfigurationId = serviceKindConfigurationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1ef45a85-218f-4428-a8b2-a97e5f56c258", value="Optional field for integration configuration ID of a custom approval integration. This is an Enterprise-only feature.")
    public String getServiceKindConfigurationId() {
        return this.serviceKindConfigurationId;
    }

    public void setServiceKindConfigurationId(String serviceKindConfigurationId) {
        this.serviceKindConfigurationId = serviceKindConfigurationId;
    }

    public ApprovalSettings resourceKind(String resourceKind) {
        this.resourceKind = resourceKind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The kind of resource for which the approval settings apply, for example, flag or segment")
    public String getResourceKind() {
        return this.resourceKind;
    }

    public void setResourceKind(String resourceKind) {
        this.resourceKind = resourceKind;
    }

    public ApprovalSettings putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalSettings approvalSettings = (ApprovalSettings)o;
        return Objects.equals(this.required, approvalSettings.required) && Objects.equals(this.bypassApprovalsForPendingChanges, approvalSettings.bypassApprovalsForPendingChanges) && Objects.equals(this.minNumApprovals, approvalSettings.minNumApprovals) && Objects.equals(this.canReviewOwnRequest, approvalSettings.canReviewOwnRequest) && Objects.equals(this.canApplyDeclinedChanges, approvalSettings.canApplyDeclinedChanges) && Objects.equals(this.autoApplyApprovedChanges, approvalSettings.autoApplyApprovedChanges) && Objects.equals(this.serviceKind, approvalSettings.serviceKind) && Objects.equals(this.serviceConfig, approvalSettings.serviceConfig) && Objects.equals(this.requiredApprovalTags, approvalSettings.requiredApprovalTags) && Objects.equals(this.serviceKindConfigurationId, approvalSettings.serviceKindConfigurationId) && Objects.equals(this.resourceKind, approvalSettings.resourceKind) && Objects.equals(this.additionalProperties, approvalSettings.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.required, this.bypassApprovalsForPendingChanges, this.minNumApprovals, this.canReviewOwnRequest, this.canApplyDeclinedChanges, this.autoApplyApprovedChanges, this.serviceKind, this.serviceConfig, this.requiredApprovalTags, this.serviceKindConfigurationId, this.resourceKind, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApprovalSettings {\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    bypassApprovalsForPendingChanges: ").append(this.toIndentedString(this.bypassApprovalsForPendingChanges)).append("\n");
        sb.append("    minNumApprovals: ").append(this.toIndentedString(this.minNumApprovals)).append("\n");
        sb.append("    canReviewOwnRequest: ").append(this.toIndentedString(this.canReviewOwnRequest)).append("\n");
        sb.append("    canApplyDeclinedChanges: ").append(this.toIndentedString(this.canApplyDeclinedChanges)).append("\n");
        sb.append("    autoApplyApprovedChanges: ").append(this.toIndentedString(this.autoApplyApprovedChanges)).append("\n");
        sb.append("    serviceKind: ").append(this.toIndentedString(this.serviceKind)).append("\n");
        sb.append("    serviceConfig: ").append(this.toIndentedString(this.serviceConfig)).append("\n");
        sb.append("    requiredApprovalTags: ").append(this.toIndentedString(this.requiredApprovalTags)).append("\n");
        sb.append("    serviceKindConfigurationId: ").append(this.toIndentedString(this.serviceKindConfigurationId)).append("\n");
        sb.append("    resourceKind: ").append(this.toIndentedString(this.resourceKind)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ApprovalSettings is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_KIND) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serviceKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRED_APPROVAL_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRED_APPROVAL_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requiredApprovalTags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRED_APPROVAL_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_KIND_CONFIGURATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_KIND_CONFIGURATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serviceKindConfigurationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_KIND_CONFIGURATION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_KIND) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_KIND).toString()));
        }
    }

    public static ApprovalSettings fromJson(String jsonString) throws IOException {
        return (ApprovalSettings)JSON.getGson().fromJson(jsonString, ApprovalSettings.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REQUIRED);
        openapiFields.add(SERIALIZED_NAME_BYPASS_APPROVALS_FOR_PENDING_CHANGES);
        openapiFields.add(SERIALIZED_NAME_MIN_NUM_APPROVALS);
        openapiFields.add(SERIALIZED_NAME_CAN_REVIEW_OWN_REQUEST);
        openapiFields.add(SERIALIZED_NAME_CAN_APPLY_DECLINED_CHANGES);
        openapiFields.add(SERIALIZED_NAME_AUTO_APPLY_APPROVED_CHANGES);
        openapiFields.add(SERIALIZED_NAME_SERVICE_KIND);
        openapiFields.add(SERIALIZED_NAME_SERVICE_CONFIG);
        openapiFields.add(SERIALIZED_NAME_REQUIRED_APPROVAL_TAGS);
        openapiFields.add(SERIALIZED_NAME_SERVICE_KIND_CONFIGURATION_ID);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_KIND);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_REQUIRED);
        openapiRequiredFields.add(SERIALIZED_NAME_BYPASS_APPROVALS_FOR_PENDING_CHANGES);
        openapiRequiredFields.add(SERIALIZED_NAME_MIN_NUM_APPROVALS);
        openapiRequiredFields.add(SERIALIZED_NAME_CAN_REVIEW_OWN_REQUEST);
        openapiRequiredFields.add(SERIALIZED_NAME_CAN_APPLY_DECLINED_CHANGES);
        openapiRequiredFields.add(SERIALIZED_NAME_SERVICE_KIND);
        openapiRequiredFields.add(SERIALIZED_NAME_SERVICE_CONFIG);
        openapiRequiredFields.add(SERIALIZED_NAME_REQUIRED_APPROVAL_TAGS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ApprovalSettings.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ApprovalSettings.class));
            return new TypeAdapter<ApprovalSettings>(){

                public void write(JsonWriter out, ApprovalSettings value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ApprovalSettings read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ApprovalSettings.validateJsonObject(jsonObj);
                    ApprovalSettings instance = (ApprovalSettings)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

