/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.StatementPost;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomRolePost {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_POLICY = "policy";
    @SerializedName(value="policy")
    private List<StatementPost> policy = new ArrayList<StatementPost>();
    public static final String SERIALIZED_NAME_BASE_PERMISSIONS = "basePermissions";
    @SerializedName(value="basePermissions")
    private String basePermissions;
    public static final String SERIALIZED_NAME_RESOURCE_CATEGORY = "resourceCategory";
    @SerializedName(value="resourceCategory")
    private String resourceCategory;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CustomRolePost name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Ops team", required=true, value="A human-friendly name for the custom role")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomRolePost key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="role-key-123abc", required=true, value="The custom role key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public CustomRolePost description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="An example role for members of the ops team", value="Description of custom role")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CustomRolePost policy(List<StatementPost> policy) {
        this.policy = policy;
        return this;
    }

    public CustomRolePost addPolicyItem(StatementPost policyItem) {
        this.policy.add(policyItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<StatementPost> getPolicy() {
        return this.policy;
    }

    public void setPolicy(List<StatementPost> policy) {
        this.policy = policy;
    }

    public CustomRolePost basePermissions(String basePermissions) {
        this.basePermissions = basePermissions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBasePermissions() {
        return this.basePermissions;
    }

    public void setBasePermissions(String basePermissions) {
        this.basePermissions = basePermissions;
    }

    public CustomRolePost resourceCategory(String resourceCategory) {
        this.resourceCategory = resourceCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getResourceCategory() {
        return this.resourceCategory;
    }

    public void setResourceCategory(String resourceCategory) {
        this.resourceCategory = resourceCategory;
    }

    public CustomRolePost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomRolePost customRolePost = (CustomRolePost)o;
        return Objects.equals(this.name, customRolePost.name) && Objects.equals(this.key, customRolePost.key) && Objects.equals(this.description, customRolePost.description) && Objects.equals(this.policy, customRolePost.policy) && Objects.equals(this.basePermissions, customRolePost.basePermissions) && Objects.equals(this.resourceCategory, customRolePost.resourceCategory) && Objects.equals(this.additionalProperties, customRolePost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.description, this.policy, this.basePermissions, this.resourceCategory, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomRolePost {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    basePermissions: ").append(this.toIndentedString(this.basePermissions)).append("\n");
        sb.append("    resourceCategory: ").append(this.toIndentedString(this.resourceCategory)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CustomRolePost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        JsonArray jsonArraypolicy = jsonObj.getAsJsonArray(SERIALIZED_NAME_POLICY);
        if (jsonArraypolicy != null) {
            if (!jsonObj.get(SERIALIZED_NAME_POLICY).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `policy` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POLICY).toString()));
            }
            for (int i = 0; i < jsonArraypolicy.size(); ++i) {
                StatementPost.validateJsonObject(jsonArraypolicy.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_BASE_PERMISSIONS) != null && !jsonObj.get(SERIALIZED_NAME_BASE_PERMISSIONS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `basePermissions` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BASE_PERMISSIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CATEGORY) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CATEGORY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceCategory` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CATEGORY).toString()));
        }
    }

    public static CustomRolePost fromJson(String jsonString) throws IOException {
        return (CustomRolePost)JSON.getGson().fromJson(jsonString, CustomRolePost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_POLICY);
        openapiFields.add(SERIALIZED_NAME_BASE_PERMISSIONS);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CATEGORY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_POLICY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CustomRolePost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CustomRolePost.class));
            return new TypeAdapter<CustomRolePost>(){

                public void write(JsonWriter out, CustomRolePost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public CustomRolePost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CustomRolePost.validateJsonObject(jsonObj);
                    CustomRolePost instance = (CustomRolePost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

