/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.HMACSignature;
import com.launchdarkly.api.model.HeaderItems;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Endpoint {
    public static final String SERIALIZED_NAME_HEADERS = "headers";
    @SerializedName(value="headers")
    private List<HeaderItems> headers = null;
    public static final String SERIALIZED_NAME_HMAC_SIGNATURE = "hmacSignature";
    @SerializedName(value="hmacSignature")
    private HMACSignature hmacSignature;
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    private String method;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Endpoint headers(List<HeaderItems> headers) {
        this.headers = headers;
        return this;
    }

    public Endpoint addHeadersItem(HeaderItems headersItem) {
        if (this.headers == null) {
            this.headers = new ArrayList<HeaderItems>();
        }
        this.headers.add(headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<HeaderItems> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<HeaderItems> headers) {
        this.headers = headers;
    }

    public Endpoint hmacSignature(HMACSignature hmacSignature) {
        this.hmacSignature = hmacSignature;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HMACSignature getHmacSignature() {
        return this.hmacSignature;
    }

    public void setHmacSignature(HMACSignature hmacSignature) {
        this.hmacSignature = hmacSignature;
    }

    public Endpoint method(String method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Endpoint url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Endpoint putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return Objects.equals(this.headers, endpoint.headers) && Objects.equals(this.hmacSignature, endpoint.hmacSignature) && Objects.equals(this.method, endpoint.method) && Objects.equals(this.url, endpoint.url) && Objects.equals(this.additionalProperties, endpoint.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.hmacSignature, this.method, this.url, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Endpoint {\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    hmacSignature: ").append(this.toIndentedString(this.hmacSignature)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Endpoint is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonArray jsonArrayheaders = jsonObj.getAsJsonArray(SERIALIZED_NAME_HEADERS);
        if (jsonArrayheaders != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HEADERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `headers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEADERS).toString()));
            }
            for (int i = 0; i < jsonArrayheaders.size(); ++i) {
                HeaderItems.validateJsonObject(jsonArrayheaders.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_HMAC_SIGNATURE) != null) {
            HMACSignature.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_HMAC_SIGNATURE));
        }
        if (jsonObj.get(SERIALIZED_NAME_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_METHOD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `method` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
    }

    public static Endpoint fromJson(String jsonString) throws IOException {
        return (Endpoint)JSON.getGson().fromJson(jsonString, Endpoint.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HEADERS);
        openapiFields.add(SERIALIZED_NAME_HMAC_SIGNATURE);
        openapiFields.add(SERIALIZED_NAME_METHOD);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Endpoint.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Endpoint.class));
            return new TypeAdapter<Endpoint>(){

                public void write(JsonWriter out, Endpoint value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Endpoint read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Endpoint.validateJsonObject(jsonObj);
                    Endpoint instance = (Endpoint)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

