/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ResourceIDResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExpiringUserTargetItem {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    private Integer version;
    public static final String SERIALIZED_NAME_EXPIRATION_DATE = "expirationDate";
    @SerializedName(value="expirationDate")
    private Long expirationDate;
    public static final String SERIALIZED_NAME_USER_KEY = "userKey";
    @SerializedName(value="userKey")
    private String userKey;
    public static final String SERIALIZED_NAME_TARGET_TYPE = "targetType";
    @SerializedName(value="targetType")
    private String targetType;
    public static final String SERIALIZED_NAME_VARIATION_ID = "variationId";
    @SerializedName(value="variationId")
    private String variationId;
    public static final String SERIALIZED_NAME_RESOURCE_ID = "_resourceId";
    @SerializedName(value="_resourceId")
    private ResourceIDResponse resourceId;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ExpiringUserTargetItem id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="12ab3c45de678910fgh12345", required=true, value="The ID of this expiring user target")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExpiringUserTargetItem version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="The version of this expiring user target")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ExpiringUserTargetItem expirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public ExpiringUserTargetItem userKey(String userKey) {
        this.userKey = userKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="example-user-key", required=true, value="A unique key used to represent the user")
    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public ExpiringUserTargetItem targetType(String targetType) {
        this.targetType = targetType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="included", value="A segment's target type. Included when expiring user targets are updated on a segment.")
    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public ExpiringUserTargetItem variationId(String variationId) {
        this.variationId = variationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ce67d625-a8b9-4fb5-a344-ab909d9d4f4d", value="A unique key used to represent the flag variation. Included when expiring user targets are updated on a feature flag.")
    public String getVariationId() {
        return this.variationId;
    }

    public void setVariationId(String variationId) {
        this.variationId = variationId;
    }

    public ExpiringUserTargetItem resourceId(ResourceIDResponse resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public ResourceIDResponse getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(ResourceIDResponse resourceId) {
        this.resourceId = resourceId;
    }

    public ExpiringUserTargetItem putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpiringUserTargetItem expiringUserTargetItem = (ExpiringUserTargetItem)o;
        return Objects.equals(this.id, expiringUserTargetItem.id) && Objects.equals(this.version, expiringUserTargetItem.version) && Objects.equals(this.expirationDate, expiringUserTargetItem.expirationDate) && Objects.equals(this.userKey, expiringUserTargetItem.userKey) && Objects.equals(this.targetType, expiringUserTargetItem.targetType) && Objects.equals(this.variationId, expiringUserTargetItem.variationId) && Objects.equals(this.resourceId, expiringUserTargetItem.resourceId) && Objects.equals(this.additionalProperties, expiringUserTargetItem.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.expirationDate, this.userKey, this.targetType, this.variationId, this.resourceId, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpiringUserTargetItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    userKey: ").append(this.toIndentedString(this.userKey)).append("\n");
        sb.append("    targetType: ").append(this.toIndentedString(this.targetType)).append("\n");
        sb.append("    variationId: ").append(this.toIndentedString(this.variationId)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ExpiringUserTargetItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER_KEY) != null && !jsonObj.get(SERIALIZED_NAME_USER_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `userKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `targetType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIATION_ID) != null && !jsonObj.get(SERIALIZED_NAME_VARIATION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `variationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIATION_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RESOURCE_ID) != null) {
            ResourceIDResponse.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RESOURCE_ID));
        }
    }

    public static ExpiringUserTargetItem fromJson(String jsonString) throws IOException {
        return (ExpiringUserTargetItem)JSON.getGson().fromJson(jsonString, ExpiringUserTargetItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_EXPIRATION_DATE);
        openapiFields.add(SERIALIZED_NAME_USER_KEY);
        openapiFields.add(SERIALIZED_NAME_TARGET_TYPE);
        openapiFields.add(SERIALIZED_NAME_VARIATION_ID);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_EXPIRATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_USER_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ExpiringUserTargetItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExpiringUserTargetItem.class));
            return new TypeAdapter<ExpiringUserTargetItem>(){

                public void write(JsonWriter out, ExpiringUserTargetItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ExpiringUserTargetItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ExpiringUserTargetItem.validateJsonObject(jsonObj);
                    ExpiringUserTargetItem instance = (ExpiringUserTargetItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

