/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.EvaluationsSummary;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class FlagEventImpactRep {
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private SizeEnum size;
    public static final String SERIALIZED_NAME_PERCENTAGE = "percentage";
    @SerializedName(value="percentage")
    private BigDecimal percentage;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_EVALUATIONS_SUMMARY = "evaluationsSummary";
    @SerializedName(value="evaluationsSummary")
    private EvaluationsSummary evaluationsSummary;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlagEventImpactRep size(SizeEnum size) {
        this.size = size;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="medium", value="The size of the flag event impact. Sizes are defined as: none (0%), small (0-20%), medium (20-80%), large (>80%)")
    public SizeEnum getSize() {
        return this.size;
    }

    public void setSize(SizeEnum size) {
        this.size = size;
    }

    public FlagEventImpactRep percentage(BigDecimal percentage) {
        this.percentage = percentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="50", value="The percentage of the flag event impact")
    public BigDecimal getPercentage() {
        return this.percentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    public FlagEventImpactRep reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public FlagEventImpactRep evaluationsSummary(EvaluationsSummary evaluationsSummary) {
        this.evaluationsSummary = evaluationsSummary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EvaluationsSummary getEvaluationsSummary() {
        return this.evaluationsSummary;
    }

    public void setEvaluationsSummary(EvaluationsSummary evaluationsSummary) {
        this.evaluationsSummary = evaluationsSummary;
    }

    public FlagEventImpactRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagEventImpactRep flagEventImpactRep = (FlagEventImpactRep)o;
        return Objects.equals((Object)this.size, (Object)flagEventImpactRep.size) && Objects.equals(this.percentage, flagEventImpactRep.percentage) && Objects.equals(this.reason, flagEventImpactRep.reason) && Objects.equals(this.evaluationsSummary, flagEventImpactRep.evaluationsSummary) && Objects.equals(this.additionalProperties, flagEventImpactRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.percentage, this.reason, this.evaluationsSummary, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlagEventImpactRep {\n");
        sb.append("    size: ").append(this.toIndentedString((Object)this.size)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    evaluationsSummary: ").append(this.toIndentedString(this.evaluationsSummary)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlagEventImpactRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_SIZE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `size` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SIZE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EVALUATIONS_SUMMARY) != null) {
            EvaluationsSummary.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EVALUATIONS_SUMMARY));
        }
    }

    public static FlagEventImpactRep fromJson(String jsonString) throws IOException {
        return (FlagEventImpactRep)JSON.getGson().fromJson(jsonString, FlagEventImpactRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_PERCENTAGE);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_EVALUATIONS_SUMMARY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlagEventImpactRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlagEventImpactRep.class));
            return new TypeAdapter<FlagEventImpactRep>(){

                public void write(JsonWriter out, FlagEventImpactRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlagEventImpactRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FlagEventImpactRep.validateJsonObject(jsonObj);
                    FlagEventImpactRep instance = (FlagEventImpactRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SizeEnum {
        NONE("none"),
        SMALL("small"),
        MEDIUM("medium"),
        LARGE("large");

        private String value;

        private SizeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SizeEnum fromValue(String value) {
            for (SizeEnum b : SizeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SizeEnum> {
            public void write(JsonWriter jsonWriter, SizeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SizeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SizeEnum.fromValue(value);
            }
        }
    }
}

