/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.StatusResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class FlagImportStatus {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_LAST_IMPORT = "lastImport";
    @SerializedName(value="lastImport")
    private Long lastImport;
    public static final String SERIALIZED_NAME_LAST_ERROR = "lastError";
    @SerializedName(value="lastError")
    private Long lastError;
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<StatusResponse> errors = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FlagImportStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pending", value="The current status of the import integrations related import job")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public FlagImportStatus lastImport(Long lastImport) {
        this.lastImport = lastImport;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastImport() {
        return this.lastImport;
    }

    public void setLastImport(Long lastImport) {
        this.lastImport = lastImport;
    }

    public FlagImportStatus lastError(Long lastError) {
        this.lastError = lastError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLastError() {
        return this.lastError;
    }

    public void setLastError(Long lastError) {
        this.lastError = lastError;
    }

    public FlagImportStatus errors(List<StatusResponse> errors) {
        this.errors = errors;
        return this;
    }

    public FlagImportStatus addErrorsItem(StatusResponse errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<StatusResponse>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<StatusResponse> getErrors() {
        return this.errors;
    }

    public void setErrors(List<StatusResponse> errors) {
        this.errors = errors;
    }

    public FlagImportStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlagImportStatus flagImportStatus = (FlagImportStatus)o;
        return Objects.equals((Object)this.status, (Object)flagImportStatus.status) && Objects.equals(this.lastImport, flagImportStatus.lastImport) && Objects.equals(this.lastError, flagImportStatus.lastError) && Objects.equals(this.errors, flagImportStatus.errors) && Objects.equals(this.additionalProperties, flagImportStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.lastImport, this.lastError, this.errors, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlagImportStatus {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lastImport: ").append(this.toIndentedString(this.lastImport)).append("\n");
        sb.append("    lastError: ").append(this.toIndentedString(this.lastError)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FlagImportStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        JsonArray jsonArrayerrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_ERRORS);
        if (jsonArrayerrors != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ERRORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `errors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERRORS).toString()));
            }
            for (int i = 0; i < jsonArrayerrors.size(); ++i) {
                StatusResponse.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
            }
        }
    }

    public static FlagImportStatus fromJson(String jsonString) throws IOException {
        return (FlagImportStatus)JSON.getGson().fromJson(jsonString, FlagImportStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_LAST_IMPORT);
        openapiFields.add(SERIALIZED_NAME_LAST_ERROR);
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FlagImportStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FlagImportStatus.class));
            return new TypeAdapter<FlagImportStatus>(){

                public void write(JsonWriter out, FlagImportStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FlagImportStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FlagImportStatus.validateJsonObject(jsonObj);
                    FlagImportStatus instance = (FlagImportStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        COMPLETE("complete"),
        IMPORTING("importing"),
        PENDING("pending"),
        FAILED("failed"),
        PARTIAL("partial");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

