/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Experiment;
import com.launchdarkly.api.model.RelatedExperimentRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HoldoutRep {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_HOLDOUT_AMOUNT = "holdoutAmount";
    @SerializedName(value="holdoutAmount")
    private String holdoutAmount;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private Long createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private Long updatedAt;
    public static final String SERIALIZED_NAME_BASE_EXPERIMENT = "baseExperiment";
    @SerializedName(value="baseExperiment")
    private Experiment baseExperiment;
    public static final String SERIALIZED_NAME_EXPERIMENTS = "experiments";
    @SerializedName(value="experiments")
    private List<RelatedExperimentRep> experiments = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public HoldoutRep id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HoldoutRep status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public HoldoutRep description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HoldoutRep holdoutAmount(String holdoutAmount) {
        this.holdoutAmount = holdoutAmount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The percentage of traffic allocated to this holdout.")
    public String getHoldoutAmount() {
        return this.holdoutAmount;
    }

    public void setHoldoutAmount(String holdoutAmount) {
        this.holdoutAmount = holdoutAmount;
    }

    public HoldoutRep createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public HoldoutRep updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public HoldoutRep baseExperiment(Experiment baseExperiment) {
        this.baseExperiment = baseExperiment;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Experiment getBaseExperiment() {
        return this.baseExperiment;
    }

    public void setBaseExperiment(Experiment baseExperiment) {
        this.baseExperiment = baseExperiment;
    }

    public HoldoutRep experiments(List<RelatedExperimentRep> experiments) {
        this.experiments = experiments;
        return this;
    }

    public HoldoutRep addExperimentsItem(RelatedExperimentRep experimentsItem) {
        if (this.experiments == null) {
            this.experiments = new ArrayList<RelatedExperimentRep>();
        }
        this.experiments.add(experimentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<RelatedExperimentRep> getExperiments() {
        return this.experiments;
    }

    public void setExperiments(List<RelatedExperimentRep> experiments) {
        this.experiments = experiments;
    }

    public HoldoutRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoldoutRep holdoutRep = (HoldoutRep)o;
        return Objects.equals(this.id, holdoutRep.id) && Objects.equals((Object)this.status, (Object)holdoutRep.status) && Objects.equals(this.description, holdoutRep.description) && Objects.equals(this.holdoutAmount, holdoutRep.holdoutAmount) && Objects.equals(this.createdAt, holdoutRep.createdAt) && Objects.equals(this.updatedAt, holdoutRep.updatedAt) && Objects.equals(this.baseExperiment, holdoutRep.baseExperiment) && Objects.equals(this.experiments, holdoutRep.experiments) && Objects.equals(this.additionalProperties, holdoutRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.description, this.holdoutAmount, this.createdAt, this.updatedAt, this.baseExperiment, this.experiments, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HoldoutRep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    holdoutAmount: ").append(this.toIndentedString(this.holdoutAmount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    baseExperiment: ").append(this.toIndentedString(this.baseExperiment)).append("\n");
        sb.append("    experiments: ").append(this.toIndentedString(this.experiments)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayexperiments;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in HoldoutRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOLDOUT_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_HOLDOUT_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `holdoutAmount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOLDOUT_AMOUNT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BASE_EXPERIMENT) != null) {
            Experiment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BASE_EXPERIMENT));
        }
        if ((jsonArrayexperiments = jsonObj.getAsJsonArray(SERIALIZED_NAME_EXPERIMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EXPERIMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `experiments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPERIMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayexperiments.size(); ++i) {
                RelatedExperimentRep.validateJsonObject(jsonArrayexperiments.get(i).getAsJsonObject());
            }
        }
    }

    public static HoldoutRep fromJson(String jsonString) throws IOException {
        return (HoldoutRep)JSON.getGson().fromJson(jsonString, HoldoutRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_HOLDOUT_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_BASE_EXPERIMENT);
        openapiFields.add(SERIALIZED_NAME_EXPERIMENTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_HOLDOUT_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_BASE_EXPERIMENT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!HoldoutRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(HoldoutRep.class));
            return new TypeAdapter<HoldoutRep>(){

                public void write(JsonWriter out, HoldoutRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public HoldoutRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    HoldoutRep.validateJsonObject(jsonObj);
                    HoldoutRep instance = (HoldoutRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        CREATED("created"),
        ENABLED("enabled"),
        RUNNING("running"),
        ENDED("ended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

