/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.InsightsMetricTierDefinition;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class InsightsChartMetric {
    public static final String SERIALIZED_NAME_INDICATOR = "indicator";
    @SerializedName(value="indicator")
    private String indicator;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private BigDecimal value;
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private String unit;
    public static final String SERIALIZED_NAME_MODIFIER = "modifier";
    @SerializedName(value="modifier")
    private String modifier;
    public static final String SERIALIZED_NAME_TIERS = "tiers";
    @SerializedName(value="tiers")
    private List<InsightsMetricTierDefinition> tiers = new ArrayList<InsightsMetricTierDefinition>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InsightsChartMetric indicator(String indicator) {
        this.indicator = indicator;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="excellent", required=true, value="Metric indicator tier")
    public String getIndicator() {
        return this.indicator;
    }

    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public InsightsChartMetric value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="5", required=true, value="Metric value")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public InsightsChartMetric unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="count", required=true, value="Metric unit")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public InsightsChartMetric modifier(String modifier) {
        this.modifier = modifier;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="per day", required=true, value="Metric modifier")
    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public InsightsChartMetric tiers(List<InsightsMetricTierDefinition> tiers) {
        this.tiers = tiers;
        return this;
    }

    public InsightsChartMetric addTiersItem(InsightsMetricTierDefinition tiersItem) {
        this.tiers.add(tiersItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Metric indicator tiers")
    public List<InsightsMetricTierDefinition> getTiers() {
        return this.tiers;
    }

    public void setTiers(List<InsightsMetricTierDefinition> tiers) {
        this.tiers = tiers;
    }

    public InsightsChartMetric putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsightsChartMetric insightsChartMetric = (InsightsChartMetric)o;
        return Objects.equals(this.indicator, insightsChartMetric.indicator) && Objects.equals(this.value, insightsChartMetric.value) && Objects.equals(this.unit, insightsChartMetric.unit) && Objects.equals(this.modifier, insightsChartMetric.modifier) && Objects.equals(this.tiers, insightsChartMetric.tiers) && Objects.equals(this.additionalProperties, insightsChartMetric.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.indicator, this.value, this.unit, this.modifier, this.tiers, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsightsChartMetric {\n");
        sb.append("    indicator: ").append(this.toIndentedString(this.indicator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    modifier: ").append(this.toIndentedString(this.modifier)).append("\n");
        sb.append("    tiers: ").append(this.toIndentedString(this.tiers)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InsightsChartMetric is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INDICATOR) != null && !jsonObj.get(SERIALIZED_NAME_INDICATOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `indicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INDICATOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODIFIER) != null && !jsonObj.get(SERIALIZED_NAME_MODIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `modifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODIFIER).toString()));
        }
        JsonArray jsonArraytiers = jsonObj.getAsJsonArray(SERIALIZED_NAME_TIERS);
        if (jsonArraytiers != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TIERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `tiers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIERS).toString()));
            }
            for (int i = 0; i < jsonArraytiers.size(); ++i) {
                InsightsMetricTierDefinition.validateJsonObject(jsonArraytiers.get(i).getAsJsonObject());
            }
        }
    }

    public static InsightsChartMetric fromJson(String jsonString) throws IOException {
        return (InsightsChartMetric)JSON.getGson().fromJson(jsonString, InsightsChartMetric.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiFields.add(SERIALIZED_NAME_UNIT);
        openapiFields.add(SERIALIZED_NAME_MODIFIER);
        openapiFields.add(SERIALIZED_NAME_TIERS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_INDICATOR);
        openapiRequiredFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields.add(SERIALIZED_NAME_UNIT);
        openapiRequiredFields.add(SERIALIZED_NAME_MODIFIER);
        openapiRequiredFields.add(SERIALIZED_NAME_TIERS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!InsightsChartMetric.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InsightsChartMetric.class));
            return new TypeAdapter<InsightsChartMetric>(){

                public void write(JsonWriter out, InsightsChartMetric value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public InsightsChartMetric read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InsightsChartMetric.validateJsonObject(jsonObj);
                    InsightsChartMetric instance = (InsightsChartMetric)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

