/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.CapabilityConfigPost;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IntegrationConfigurationPost {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_CONFIG_VALUES = "configValues";
    @SerializedName(value="configValues")
    private Map<String, Object> configValues = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_CAPABILITY_CONFIG = "capabilityConfig";
    @SerializedName(value="capabilityConfig")
    private CapabilityConfigPost capabilityConfig;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IntegrationConfigurationPost name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Example integration configuration", required=true, value="The name of the integration configuration")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IntegrationConfigurationPost enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the integration configuration is enabled. If omitted, defaults to true")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public IntegrationConfigurationPost tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public IntegrationConfigurationPost addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"ops\"]", value="Tags for the integration")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public IntegrationConfigurationPost configValues(Map<String, Object> configValues) {
        this.configValues = configValues;
        return this;
    }

    public IntegrationConfigurationPost putConfigValuesItem(String key, Object configValuesItem) {
        this.configValues.put(key, configValuesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="{\"optional\":\"an optional property\",\"required\":\"the required property\",\"url\":\"https://example.com\"}", required=true, value="The unique set of fields required to configure the integration. Refer to the <code>formVariables</code> field in the corresponding <code>manifest.json</code> at https://github.com/launchdarkly/integration-framework/tree/main/integrations for a full list of fields for the integration you wish to configure.")
    public Map<String, Object> getConfigValues() {
        return this.configValues;
    }

    public void setConfigValues(Map<String, Object> configValues) {
        this.configValues = configValues;
    }

    public IntegrationConfigurationPost capabilityConfig(CapabilityConfigPost capabilityConfig) {
        this.capabilityConfig = capabilityConfig;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CapabilityConfigPost getCapabilityConfig() {
        return this.capabilityConfig;
    }

    public void setCapabilityConfig(CapabilityConfigPost capabilityConfig) {
        this.capabilityConfig = capabilityConfig;
    }

    public IntegrationConfigurationPost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationConfigurationPost integrationConfigurationPost = (IntegrationConfigurationPost)o;
        return Objects.equals(this.name, integrationConfigurationPost.name) && Objects.equals(this.enabled, integrationConfigurationPost.enabled) && Objects.equals(this.tags, integrationConfigurationPost.tags) && Objects.equals(this.configValues, integrationConfigurationPost.configValues) && Objects.equals(this.capabilityConfig, integrationConfigurationPost.capabilityConfig) && Objects.equals(this.additionalProperties, integrationConfigurationPost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.enabled, this.tags, this.configValues, this.capabilityConfig, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegrationConfigurationPost {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    configValues: ").append(this.toIndentedString(this.configValues)).append("\n");
        sb.append("    capabilityConfig: ").append(this.toIndentedString(this.capabilityConfig)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in IntegrationConfigurationPost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CAPABILITY_CONFIG) != null) {
            CapabilityConfigPost.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CAPABILITY_CONFIG));
        }
    }

    public static IntegrationConfigurationPost fromJson(String jsonString) throws IOException {
        return (IntegrationConfigurationPost)JSON.getGson().fromJson(jsonString, IntegrationConfigurationPost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_CONFIG_VALUES);
        openapiFields.add(SERIALIZED_NAME_CAPABILITY_CONFIG);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_CONFIG_VALUES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!IntegrationConfigurationPost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IntegrationConfigurationPost.class));
            return new TypeAdapter<IntegrationConfigurationPost>(){

                public void write(JsonWriter out, IntegrationConfigurationPost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public IntegrationConfigurationPost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    IntegrationConfigurationPost.validateJsonObject(jsonObj);
                    IntegrationConfigurationPost instance = (IntegrationConfigurationPost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

