/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.DependentMetricGroupRepWithMetrics;
import com.launchdarkly.api.model.DependentMetricOrMetricGroupRep;
import com.launchdarkly.api.model.FlagRep;
import com.launchdarkly.api.model.LayerSnapshotRep;
import com.launchdarkly.api.model.MetricV2Rep;
import com.launchdarkly.api.model.TreatmentRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IterationRep {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_HYPOTHESIS = "hypothesis";
    @SerializedName(value="hypothesis")
    private String hypothesis;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private Long createdAt;
    public static final String SERIALIZED_NAME_STARTED_AT = "startedAt";
    @SerializedName(value="startedAt")
    private Long startedAt;
    public static final String SERIALIZED_NAME_ENDED_AT = "endedAt";
    @SerializedName(value="endedAt")
    private Long endedAt;
    public static final String SERIALIZED_NAME_WINNING_TREATMENT_ID = "winningTreatmentId";
    @SerializedName(value="winningTreatmentId")
    private String winningTreatmentId;
    public static final String SERIALIZED_NAME_WINNING_REASON = "winningReason";
    @SerializedName(value="winningReason")
    private String winningReason;
    public static final String SERIALIZED_NAME_CAN_RESHUFFLE_TRAFFIC = "canReshuffleTraffic";
    @SerializedName(value="canReshuffleTraffic")
    private Boolean canReshuffleTraffic;
    public static final String SERIALIZED_NAME_FLAGS = "flags";
    @SerializedName(value="flags")
    private Map<String, FlagRep> flags = null;
    public static final String SERIALIZED_NAME_PRIMARY_METRIC = "primaryMetric";
    @SerializedName(value="primaryMetric")
    private DependentMetricOrMetricGroupRep primaryMetric;
    public static final String SERIALIZED_NAME_PRIMARY_SINGLE_METRIC = "primarySingleMetric";
    @SerializedName(value="primarySingleMetric")
    private MetricV2Rep primarySingleMetric;
    public static final String SERIALIZED_NAME_PRIMARY_FUNNEL = "primaryFunnel";
    @SerializedName(value="primaryFunnel")
    private DependentMetricGroupRepWithMetrics primaryFunnel;
    public static final String SERIALIZED_NAME_RANDOMIZATION_UNIT = "randomizationUnit";
    @SerializedName(value="randomizationUnit")
    private String randomizationUnit;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private List<String> attributes = null;
    public static final String SERIALIZED_NAME_TREATMENTS = "treatments";
    @SerializedName(value="treatments")
    private List<TreatmentRep> treatments = null;
    public static final String SERIALIZED_NAME_SECONDARY_METRICS = "secondaryMetrics";
    @SerializedName(value="secondaryMetrics")
    private List<MetricV2Rep> secondaryMetrics = null;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private List<DependentMetricOrMetricGroupRep> metrics = null;
    public static final String SERIALIZED_NAME_LAYER_SNAPSHOT = "layerSnapshot";
    @SerializedName(value="layerSnapshot")
    private LayerSnapshotRep layerSnapshot;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IterationRep id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12ab3c45de678910fgh12345", value="The iteration ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IterationRep hypothesis(String hypothesis) {
        this.hypothesis = hypothesis;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="The new button placement will increase conversion", required=true, value="The expected outcome of this experiment")
    public String getHypothesis() {
        return this.hypothesis;
    }

    public void setHypothesis(String hypothesis) {
        this.hypothesis = hypothesis;
    }

    public IterationRep status(String status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="running", required=true, value="The status of the iteration: <code>not_started</code>, <code>running</code>, <code>stopped</code>")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public IterationRep createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public IterationRep startedAt(Long startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Long startedAt) {
        this.startedAt = startedAt;
    }

    public IterationRep endedAt(Long endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    public IterationRep winningTreatmentId(String winningTreatmentId) {
        this.winningTreatmentId = winningTreatmentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="122c9f3e-da26-4321-ba68-e0fc02eced58", value="The ID of the treatment chosen when the experiment stopped")
    public String getWinningTreatmentId() {
        return this.winningTreatmentId;
    }

    public void setWinningTreatmentId(String winningTreatmentId) {
        this.winningTreatmentId = winningTreatmentId;
    }

    public IterationRep winningReason(String winningReason) {
        this.winningReason = winningReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="We ran this iteration for two weeks and the winning variation was clear", value="The reason you stopped the experiment")
    public String getWinningReason() {
        return this.winningReason;
    }

    public void setWinningReason(String winningReason) {
        this.winningReason = winningReason;
    }

    public IterationRep canReshuffleTraffic(Boolean canReshuffleTraffic) {
        this.canReshuffleTraffic = canReshuffleTraffic;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether the experiment may reassign traffic to different variations when the experiment audience changes (true) or must keep all traffic assigned to its initial variation (false).")
    public Boolean getCanReshuffleTraffic() {
        return this.canReshuffleTraffic;
    }

    public void setCanReshuffleTraffic(Boolean canReshuffleTraffic) {
        this.canReshuffleTraffic = canReshuffleTraffic;
    }

    public IterationRep flags(Map<String, FlagRep> flags) {
        this.flags = flags;
        return this;
    }

    public IterationRep putFlagsItem(String key, FlagRep flagsItem) {
        if (this.flags == null) {
            this.flags = new HashMap<String, FlagRep>();
        }
        this.flags.put(key, flagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the flag used in this experiment")
    public Map<String, FlagRep> getFlags() {
        return this.flags;
    }

    public void setFlags(Map<String, FlagRep> flags) {
        this.flags = flags;
    }

    public IterationRep primaryMetric(DependentMetricOrMetricGroupRep primaryMetric) {
        this.primaryMetric = primaryMetric;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DependentMetricOrMetricGroupRep getPrimaryMetric() {
        return this.primaryMetric;
    }

    public void setPrimaryMetric(DependentMetricOrMetricGroupRep primaryMetric) {
        this.primaryMetric = primaryMetric;
    }

    public IterationRep primarySingleMetric(MetricV2Rep primarySingleMetric) {
        this.primarySingleMetric = primarySingleMetric;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MetricV2Rep getPrimarySingleMetric() {
        return this.primarySingleMetric;
    }

    public void setPrimarySingleMetric(MetricV2Rep primarySingleMetric) {
        this.primarySingleMetric = primarySingleMetric;
    }

    public IterationRep primaryFunnel(DependentMetricGroupRepWithMetrics primaryFunnel) {
        this.primaryFunnel = primaryFunnel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DependentMetricGroupRepWithMetrics getPrimaryFunnel() {
        return this.primaryFunnel;
    }

    public void setPrimaryFunnel(DependentMetricGroupRepWithMetrics primaryFunnel) {
        this.primaryFunnel = primaryFunnel;
    }

    public IterationRep randomizationUnit(String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user", value="The unit of randomization for this iteration")
    public String getRandomizationUnit() {
        return this.randomizationUnit;
    }

    public void setRandomizationUnit(String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
    }

    public IterationRep attributes(List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public IterationRep addAttributesItem(String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The available attribute filters for this iteration")
    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public IterationRep treatments(List<TreatmentRep> treatments) {
        this.treatments = treatments;
        return this;
    }

    public IterationRep addTreatmentsItem(TreatmentRep treatmentsItem) {
        if (this.treatments == null) {
            this.treatments = new ArrayList<TreatmentRep>();
        }
        this.treatments.add(treatmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the variations you are testing in the experiment")
    public List<TreatmentRep> getTreatments() {
        return this.treatments;
    }

    public void setTreatments(List<TreatmentRep> treatments) {
        this.treatments = treatments;
    }

    public IterationRep secondaryMetrics(List<MetricV2Rep> secondaryMetrics) {
        this.secondaryMetrics = secondaryMetrics;
        return this;
    }

    public IterationRep addSecondaryMetricsItem(MetricV2Rep secondaryMetricsItem) {
        if (this.secondaryMetrics == null) {
            this.secondaryMetrics = new ArrayList<MetricV2Rep>();
        }
        this.secondaryMetrics.add(secondaryMetricsItem);
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Deprecated, use <code>metrics</code> instead. Details on the secondary metrics for this experiment.")
    public List<MetricV2Rep> getSecondaryMetrics() {
        return this.secondaryMetrics;
    }

    public void setSecondaryMetrics(List<MetricV2Rep> secondaryMetrics) {
        this.secondaryMetrics = secondaryMetrics;
    }

    public IterationRep metrics(List<DependentMetricOrMetricGroupRep> metrics) {
        this.metrics = metrics;
        return this;
    }

    public IterationRep addMetricsItem(DependentMetricOrMetricGroupRep metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<DependentMetricOrMetricGroupRep>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the metrics for this experiment")
    public List<DependentMetricOrMetricGroupRep> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<DependentMetricOrMetricGroupRep> metrics) {
        this.metrics = metrics;
    }

    public IterationRep layerSnapshot(LayerSnapshotRep layerSnapshot) {
        this.layerSnapshot = layerSnapshot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LayerSnapshotRep getLayerSnapshot() {
        return this.layerSnapshot;
    }

    public void setLayerSnapshot(LayerSnapshotRep layerSnapshot) {
        this.layerSnapshot = layerSnapshot;
    }

    public IterationRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IterationRep iterationRep = (IterationRep)o;
        return Objects.equals(this.id, iterationRep.id) && Objects.equals(this.hypothesis, iterationRep.hypothesis) && Objects.equals(this.status, iterationRep.status) && Objects.equals(this.createdAt, iterationRep.createdAt) && Objects.equals(this.startedAt, iterationRep.startedAt) && Objects.equals(this.endedAt, iterationRep.endedAt) && Objects.equals(this.winningTreatmentId, iterationRep.winningTreatmentId) && Objects.equals(this.winningReason, iterationRep.winningReason) && Objects.equals(this.canReshuffleTraffic, iterationRep.canReshuffleTraffic) && Objects.equals(this.flags, iterationRep.flags) && Objects.equals(this.primaryMetric, iterationRep.primaryMetric) && Objects.equals(this.primarySingleMetric, iterationRep.primarySingleMetric) && Objects.equals(this.primaryFunnel, iterationRep.primaryFunnel) && Objects.equals(this.randomizationUnit, iterationRep.randomizationUnit) && Objects.equals(this.attributes, iterationRep.attributes) && Objects.equals(this.treatments, iterationRep.treatments) && Objects.equals(this.secondaryMetrics, iterationRep.secondaryMetrics) && Objects.equals(this.metrics, iterationRep.metrics) && Objects.equals(this.layerSnapshot, iterationRep.layerSnapshot) && Objects.equals(this.additionalProperties, iterationRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.hypothesis, this.status, this.createdAt, this.startedAt, this.endedAt, this.winningTreatmentId, this.winningReason, this.canReshuffleTraffic, this.flags, this.primaryMetric, this.primarySingleMetric, this.primaryFunnel, this.randomizationUnit, this.attributes, this.treatments, this.secondaryMetrics, this.metrics, this.layerSnapshot, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IterationRep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    hypothesis: ").append(this.toIndentedString(this.hypothesis)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    endedAt: ").append(this.toIndentedString(this.endedAt)).append("\n");
        sb.append("    winningTreatmentId: ").append(this.toIndentedString(this.winningTreatmentId)).append("\n");
        sb.append("    winningReason: ").append(this.toIndentedString(this.winningReason)).append("\n");
        sb.append("    canReshuffleTraffic: ").append(this.toIndentedString(this.canReshuffleTraffic)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    primaryMetric: ").append(this.toIndentedString(this.primaryMetric)).append("\n");
        sb.append("    primarySingleMetric: ").append(this.toIndentedString(this.primarySingleMetric)).append("\n");
        sb.append("    primaryFunnel: ").append(this.toIndentedString(this.primaryFunnel)).append("\n");
        sb.append("    randomizationUnit: ").append(this.toIndentedString(this.randomizationUnit)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    treatments: ").append(this.toIndentedString(this.treatments)).append("\n");
        sb.append("    secondaryMetrics: ").append(this.toIndentedString(this.secondaryMetrics)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    layerSnapshot: ").append(this.toIndentedString(this.layerSnapshot)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraymetrics;
        JsonArray jsonArraysecondaryMetrics;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in IterationRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HYPOTHESIS) != null && !jsonObj.get(SERIALIZED_NAME_HYPOTHESIS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hypothesis` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HYPOTHESIS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WINNING_TREATMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_WINNING_TREATMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `winningTreatmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WINNING_TREATMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WINNING_REASON) != null && !jsonObj.get(SERIALIZED_NAME_WINNING_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `winningReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WINNING_REASON).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PRIMARY_METRIC) != null) {
            DependentMetricOrMetricGroupRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PRIMARY_METRIC));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC) != null) {
            MetricV2Rep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PRIMARY_FUNNEL) != null) {
            DependentMetricGroupRepWithMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PRIMARY_FUNNEL));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `randomizationUnit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).toString()));
        }
        JsonArray jsonArraytreatments = jsonObj.getAsJsonArray(SERIALIZED_NAME_TREATMENTS);
        if (jsonArraytreatments != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TREATMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `treatments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENTS).toString()));
            }
            for (int i = 0; i < jsonArraytreatments.size(); ++i) {
                TreatmentRep.validateJsonObject(jsonArraytreatments.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraysecondaryMetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECONDARY_METRICS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECONDARY_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `secondaryMetrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECONDARY_METRICS).toString()));
            }
            for (int i = 0; i < jsonArraysecondaryMetrics.size(); ++i) {
                MetricV2Rep.validateJsonObject(jsonArraysecondaryMetrics.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraymetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_METRICS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `metrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METRICS).toString()));
            }
            for (int i = 0; i < jsonArraymetrics.size(); ++i) {
                DependentMetricOrMetricGroupRep.validateJsonObject(jsonArraymetrics.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LAYER_SNAPSHOT) != null) {
            LayerSnapshotRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LAYER_SNAPSHOT));
        }
    }

    public static IterationRep fromJson(String jsonString) throws IOException {
        return (IterationRep)JSON.getGson().fromJson(jsonString, IterationRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_HYPOTHESIS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_STARTED_AT);
        openapiFields.add(SERIALIZED_NAME_ENDED_AT);
        openapiFields.add(SERIALIZED_NAME_WINNING_TREATMENT_ID);
        openapiFields.add(SERIALIZED_NAME_WINNING_REASON);
        openapiFields.add(SERIALIZED_NAME_CAN_RESHUFFLE_TRAFFIC);
        openapiFields.add(SERIALIZED_NAME_FLAGS);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_METRIC);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC);
        openapiFields.add(SERIALIZED_NAME_PRIMARY_FUNNEL);
        openapiFields.add(SERIALIZED_NAME_RANDOMIZATION_UNIT);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_TREATMENTS);
        openapiFields.add(SERIALIZED_NAME_SECONDARY_METRICS);
        openapiFields.add(SERIALIZED_NAME_METRICS);
        openapiFields.add(SERIALIZED_NAME_LAYER_SNAPSHOT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_HYPOTHESIS);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!IterationRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IterationRep.class));
            return new TypeAdapter<IterationRep>(){

                public void write(JsonWriter out, IterationRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public IterationRep read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    IterationRep.validateJsonObject(jsonObj);
                    IterationRep instance = (IterationRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

