/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.IntegrationMetadata;
import com.launchdarkly.api.model.LastSeenMetadata;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MemberPermissionGrantSummaryRep;
import com.launchdarkly.api.model.MemberTeamSummaryRep;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Member {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_FIRST_NAME = "firstName";
    @SerializedName(value="firstName")
    private String firstName;
    public static final String SERIALIZED_NAME_LAST_NAME = "lastName";
    @SerializedName(value="lastName")
    private String lastName;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private String role;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_PENDING_INVITE = "_pendingInvite";
    @SerializedName(value="_pendingInvite")
    private Boolean pendingInvite;
    public static final String SERIALIZED_NAME_VERIFIED = "_verified";
    @SerializedName(value="_verified")
    private Boolean verified;
    public static final String SERIALIZED_NAME_PENDING_EMAIL = "_pendingEmail";
    @SerializedName(value="_pendingEmail")
    private String pendingEmail;
    public static final String SERIALIZED_NAME_CUSTOM_ROLES = "customRoles";
    @SerializedName(value="customRoles")
    private List<String> customRoles = new ArrayList<String>();
    public static final String SERIALIZED_NAME_MFA = "mfa";
    @SerializedName(value="mfa")
    private String mfa;
    public static final String SERIALIZED_NAME_EXCLUDED_DASHBOARDS = "excludedDashboards";
    @SerializedName(value="excludedDashboards")
    private List<String> excludedDashboards = null;
    public static final String SERIALIZED_NAME_LAST_SEEN = "_lastSeen";
    @SerializedName(value="_lastSeen")
    private Long lastSeen;
    public static final String SERIALIZED_NAME_LAST_SEEN_METADATA = "_lastSeenMetadata";
    @SerializedName(value="_lastSeenMetadata")
    private LastSeenMetadata lastSeenMetadata;
    public static final String SERIALIZED_NAME_INTEGRATION_METADATA = "_integrationMetadata";
    @SerializedName(value="_integrationMetadata")
    private IntegrationMetadata integrationMetadata;
    public static final String SERIALIZED_NAME_TEAMS = "teams";
    @SerializedName(value="teams")
    private List<MemberTeamSummaryRep> teams = null;
    public static final String SERIALIZED_NAME_PERMISSION_GRANTS = "permissionGrants";
    @SerializedName(value="permissionGrants")
    private List<MemberPermissionGrantSummaryRep> permissionGrants = null;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_OAUTH_PROVIDERS = "oauthProviders";
    @SerializedName(value="oauthProviders")
    private List<String> oauthProviders = null;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_ROLE_ATTRIBUTES = "roleAttributes";
    @SerializedName(value="roleAttributes")
    private Map<String, List<String>> roleAttributes = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Member links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Member putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public Member id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="507f1f77bcf86cd799439011", required=true, value="The member's ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Member firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Ariel", value="The member's first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Member lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Flores", value="The member's last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Member role(String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="reader", required=true, value="The member's built-in role. If the member has no custom roles, this role will be in effect.")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Member email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="ariel@acme.com", required=true, value="The member's email address")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Member pendingInvite(Boolean pendingInvite) {
        this.pendingInvite = pendingInvite;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="false", required=true, value="Whether the member has a pending invitation")
    public Boolean getPendingInvite() {
        return this.pendingInvite;
    }

    public void setPendingInvite(Boolean pendingInvite) {
        this.pendingInvite = pendingInvite;
    }

    public Member verified(Boolean verified) {
        this.verified = verified;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether the member's email address has been verified")
    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    public Member pendingEmail(String pendingEmail) {
        this.pendingEmail = pendingEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The member's email address before it has been verified, for accounts where email verification is required")
    public String getPendingEmail() {
        return this.pendingEmail;
    }

    public void setPendingEmail(String pendingEmail) {
        this.pendingEmail = pendingEmail;
    }

    public Member customRoles(List<String> customRoles) {
        this.customRoles = customRoles;
        return this;
    }

    public Member addCustomRolesItem(String customRolesItem) {
        this.customRoles.add(customRolesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"devOps\",\"backend-devs\"]", required=true, value="The set of custom roles (as keys) assigned to the member")
    public List<String> getCustomRoles() {
        return this.customRoles;
    }

    public void setCustomRoles(List<String> customRoles) {
        this.customRoles = customRoles;
    }

    public Member mfa(String mfa) {
        this.mfa = mfa;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Whether multi-factor authentication is enabled for this member")
    public String getMfa() {
        return this.mfa;
    }

    public void setMfa(String mfa) {
        this.mfa = mfa;
    }

    public Member excludedDashboards(List<String> excludedDashboards) {
        this.excludedDashboards = excludedDashboards;
        return this;
    }

    public Member addExcludedDashboardsItem(String excludedDashboardsItem) {
        if (this.excludedDashboards == null) {
            this.excludedDashboards = new ArrayList<String>();
        }
        this.excludedDashboards.add(excludedDashboardsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Default dashboards that the member has chosen to ignore")
    public List<String> getExcludedDashboards() {
        return this.excludedDashboards;
    }

    public void setExcludedDashboards(List<String> excludedDashboards) {
        this.excludedDashboards = excludedDashboards;
    }

    public Member lastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public Member lastSeenMetadata(LastSeenMetadata lastSeenMetadata) {
        this.lastSeenMetadata = lastSeenMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public LastSeenMetadata getLastSeenMetadata() {
        return this.lastSeenMetadata;
    }

    public void setLastSeenMetadata(LastSeenMetadata lastSeenMetadata) {
        this.lastSeenMetadata = lastSeenMetadata;
    }

    public Member integrationMetadata(IntegrationMetadata integrationMetadata) {
        this.integrationMetadata = integrationMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IntegrationMetadata getIntegrationMetadata() {
        return this.integrationMetadata;
    }

    public void setIntegrationMetadata(IntegrationMetadata integrationMetadata) {
        this.integrationMetadata = integrationMetadata;
    }

    public Member teams(List<MemberTeamSummaryRep> teams) {
        this.teams = teams;
        return this;
    }

    public Member addTeamsItem(MemberTeamSummaryRep teamsItem) {
        if (this.teams == null) {
            this.teams = new ArrayList<MemberTeamSummaryRep>();
        }
        this.teams.add(teamsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Details on the teams this member is assigned to")
    public List<MemberTeamSummaryRep> getTeams() {
        return this.teams;
    }

    public void setTeams(List<MemberTeamSummaryRep> teams) {
        this.teams = teams;
    }

    public Member permissionGrants(List<MemberPermissionGrantSummaryRep> permissionGrants) {
        this.permissionGrants = permissionGrants;
        return this;
    }

    public Member addPermissionGrantsItem(MemberPermissionGrantSummaryRep permissionGrantsItem) {
        if (this.permissionGrants == null) {
            this.permissionGrants = new ArrayList<MemberPermissionGrantSummaryRep>();
        }
        this.permissionGrants.add(permissionGrantsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of permission grants. Permission grants allow a member to have access to a specific action, without having to create or update a custom role.")
    public List<MemberPermissionGrantSummaryRep> getPermissionGrants() {
        return this.permissionGrants;
    }

    public void setPermissionGrants(List<MemberPermissionGrantSummaryRep> permissionGrants) {
        this.permissionGrants = permissionGrants;
    }

    public Member creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Member oauthProviders(List<String> oauthProviders) {
        this.oauthProviders = oauthProviders;
        return this;
    }

    public Member addOauthProvidersItem(String oauthProvidersItem) {
        if (this.oauthProviders == null) {
            this.oauthProviders = new ArrayList<String>();
        }
        this.oauthProviders.add(oauthProvidersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of OAuth providers")
    public List<String> getOauthProviders() {
        return this.oauthProviders;
    }

    public void setOauthProviders(List<String> oauthProviders) {
        this.oauthProviders = oauthProviders;
    }

    public Member version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Version of the current configuration")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Member roleAttributes(Map<String, List<String>> roleAttributes) {
        this.roleAttributes = roleAttributes;
        return this;
    }

    public Member putRoleAttributesItem(String key, List<String> roleAttributesItem) {
        if (this.roleAttributes == null) {
            this.roleAttributes = new HashMap<String, List<String>>();
        }
        this.roleAttributes.put(key, roleAttributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, List<String>> getRoleAttributes() {
        return this.roleAttributes;
    }

    public void setRoleAttributes(Map<String, List<String>> roleAttributes) {
        this.roleAttributes = roleAttributes;
    }

    public Member putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        return Objects.equals(this.links, member.links) && Objects.equals(this.id, member.id) && Objects.equals(this.firstName, member.firstName) && Objects.equals(this.lastName, member.lastName) && Objects.equals(this.role, member.role) && Objects.equals(this.email, member.email) && Objects.equals(this.pendingInvite, member.pendingInvite) && Objects.equals(this.verified, member.verified) && Objects.equals(this.pendingEmail, member.pendingEmail) && Objects.equals(this.customRoles, member.customRoles) && Objects.equals(this.mfa, member.mfa) && Objects.equals(this.excludedDashboards, member.excludedDashboards) && Objects.equals(this.lastSeen, member.lastSeen) && Objects.equals(this.lastSeenMetadata, member.lastSeenMetadata) && Objects.equals(this.integrationMetadata, member.integrationMetadata) && Objects.equals(this.teams, member.teams) && Objects.equals(this.permissionGrants, member.permissionGrants) && Objects.equals(this.creationDate, member.creationDate) && Objects.equals(this.oauthProviders, member.oauthProviders) && Objects.equals(this.version, member.version) && Objects.equals(this.roleAttributes, member.roleAttributes) && Objects.equals(this.additionalProperties, member.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.firstName, this.lastName, this.role, this.email, this.pendingInvite, this.verified, this.pendingEmail, this.customRoles, this.mfa, this.excludedDashboards, this.lastSeen, this.lastSeenMetadata, this.integrationMetadata, this.teams, this.permissionGrants, this.creationDate, this.oauthProviders, this.version, this.roleAttributes, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Member {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    pendingInvite: ").append(this.toIndentedString(this.pendingInvite)).append("\n");
        sb.append("    verified: ").append(this.toIndentedString(this.verified)).append("\n");
        sb.append("    pendingEmail: ").append(this.toIndentedString(this.pendingEmail)).append("\n");
        sb.append("    customRoles: ").append(this.toIndentedString(this.customRoles)).append("\n");
        sb.append("    mfa: ").append(this.toIndentedString(this.mfa)).append("\n");
        sb.append("    excludedDashboards: ").append(this.toIndentedString(this.excludedDashboards)).append("\n");
        sb.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        sb.append("    lastSeenMetadata: ").append(this.toIndentedString(this.lastSeenMetadata)).append("\n");
        sb.append("    integrationMetadata: ").append(this.toIndentedString(this.integrationMetadata)).append("\n");
        sb.append("    teams: ").append(this.toIndentedString(this.teams)).append("\n");
        sb.append("    permissionGrants: ").append(this.toIndentedString(this.permissionGrants)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    oauthProviders: ").append(this.toIndentedString(this.oauthProviders)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    roleAttributes: ").append(this.toIndentedString(this.roleAttributes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraypermissionGrants;
        JsonArray jsonArrayteams;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Member is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIRST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FIRST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `firstName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIRST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_LAST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `lastName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLE) != null && !jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PENDING_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_PENDING_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_pendingEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PENDING_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `customRoles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MFA) != null && !jsonObj.get(SERIALIZED_NAME_MFA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mfa` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MFA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXCLUDED_DASHBOARDS) != null && !jsonObj.get(SERIALIZED_NAME_EXCLUDED_DASHBOARDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `excludedDashboards` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXCLUDED_DASHBOARDS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LAST_SEEN_METADATA) != null) {
            LastSeenMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LAST_SEEN_METADATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INTEGRATION_METADATA) != null) {
            IntegrationMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INTEGRATION_METADATA));
        }
        if ((jsonArrayteams = jsonObj.getAsJsonArray(SERIALIZED_NAME_TEAMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TEAMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `teams` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEAMS).toString()));
            }
            for (int i = 0; i < jsonArrayteams.size(); ++i) {
                MemberTeamSummaryRep.validateJsonObject(jsonArrayteams.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraypermissionGrants = jsonObj.getAsJsonArray(SERIALIZED_NAME_PERMISSION_GRANTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PERMISSION_GRANTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `permissionGrants` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERMISSION_GRANTS).toString()));
            }
            for (int i = 0; i < jsonArraypermissionGrants.size(); ++i) {
                MemberPermissionGrantSummaryRep.validateJsonObject(jsonArraypermissionGrants.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_OAUTH_PROVIDERS) != null && !jsonObj.get(SERIALIZED_NAME_OAUTH_PROVIDERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `oauthProviders` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OAUTH_PROVIDERS).toString()));
        }
    }

    public static Member fromJson(String jsonString) throws IOException {
        return (Member)JSON.getGson().fromJson(jsonString, Member.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_FIRST_NAME);
        openapiFields.add(SERIALIZED_NAME_LAST_NAME);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_PENDING_INVITE);
        openapiFields.add(SERIALIZED_NAME_VERIFIED);
        openapiFields.add(SERIALIZED_NAME_PENDING_EMAIL);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_ROLES);
        openapiFields.add(SERIALIZED_NAME_MFA);
        openapiFields.add(SERIALIZED_NAME_EXCLUDED_DASHBOARDS);
        openapiFields.add(SERIALIZED_NAME_LAST_SEEN);
        openapiFields.add(SERIALIZED_NAME_LAST_SEEN_METADATA);
        openapiFields.add(SERIALIZED_NAME_INTEGRATION_METADATA);
        openapiFields.add(SERIALIZED_NAME_TEAMS);
        openapiFields.add(SERIALIZED_NAME_PERMISSION_GRANTS);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_OAUTH_PROVIDERS);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_ROLE_ATTRIBUTES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ROLE);
        openapiRequiredFields.add(SERIALIZED_NAME_EMAIL);
        openapiRequiredFields.add(SERIALIZED_NAME_PENDING_INVITE);
        openapiRequiredFields.add(SERIALIZED_NAME_VERIFIED);
        openapiRequiredFields.add(SERIALIZED_NAME_CUSTOM_ROLES);
        openapiRequiredFields.add(SERIALIZED_NAME_MFA);
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_SEEN);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Member.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Member.class));
            return new TypeAdapter<Member>(){

                public void write(JsonWriter out, Member value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Member read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Member.validateJsonObject(jsonObj);
                    Member instance = (Member)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

