/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.MetricEventDefaultRep;
import com.launchdarkly.api.model.UrlPost;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetricPost {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private KindEnum kind;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private String selector;
    public static final String SERIALIZED_NAME_URLS = "urls";
    @SerializedName(value="urls")
    private List<UrlPost> urls = null;
    public static final String SERIALIZED_NAME_IS_NUMERIC = "isNumeric";
    @SerializedName(value="isNumeric")
    private Boolean isNumeric;
    public static final String SERIALIZED_NAME_UNIT = "unit";
    @SerializedName(value="unit")
    private String unit;
    public static final String SERIALIZED_NAME_EVENT_KEY = "eventKey";
    @SerializedName(value="eventKey")
    private String eventKey;
    public static final String SERIALIZED_NAME_SUCCESS_CRITERIA = "successCriteria";
    @SerializedName(value="successCriteria")
    private SuccessCriteriaEnum successCriteria;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_RANDOMIZATION_UNITS = "randomizationUnits";
    @SerializedName(value="randomizationUnits")
    private List<String> randomizationUnits = null;
    public static final String SERIALIZED_NAME_MAINTAINER_ID = "maintainerId";
    @SerializedName(value="maintainerId")
    private String maintainerId;
    public static final String SERIALIZED_NAME_UNIT_AGGREGATION_TYPE = "unitAggregationType";
    @SerializedName(value="unitAggregationType")
    private UnitAggregationTypeEnum unitAggregationType;
    public static final String SERIALIZED_NAME_ANALYSIS_TYPE = "analysisType";
    @SerializedName(value="analysisType")
    private String analysisType;
    public static final String SERIALIZED_NAME_PERCENTILE_VALUE = "percentileValue";
    @SerializedName(value="percentileValue")
    private Integer percentileValue;
    public static final String SERIALIZED_NAME_EVENT_DEFAULT = "eventDefault";
    @SerializedName(value="eventDefault")
    private MetricEventDefaultRep eventDefault;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MetricPost key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="metric-key-123abc", required=true, value="A unique key to reference the metric")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MetricPost name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Example metric", value="A human-friendly name for the metric")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricPost description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="optional description", value="Description of the metric")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MetricPost kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="custom", required=true, value="The kind of event your metric will track")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public MetricPost selector(String selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(example=".dropdown-toggle", value="One or more CSS selectors. Required for click metrics only.")
    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public MetricPost urls(List<UrlPost> urls) {
        this.urls = urls;
        return this;
    }

    public MetricPost addUrlsItem(UrlPost urlsItem) {
        if (this.urls == null) {
            this.urls = new ArrayList<UrlPost>();
        }
        this.urls.add(urlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="invalid example", value="One or more target URLs. Required for click and pageview metrics only.")
    public List<UrlPost> getUrls() {
        return this.urls;
    }

    public void setUrls(List<UrlPost> urls) {
        this.urls = urls;
    }

    public MetricPost isNumeric(Boolean isNumeric) {
        this.isNumeric = isNumeric;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether to track numeric changes in value against a baseline (<code>true</code>) or to track a conversion when an end user takes an action (<code>false</code>). Required for custom metrics only.")
    public Boolean getIsNumeric() {
        return this.isNumeric;
    }

    public void setIsNumeric(Boolean isNumeric) {
        this.isNumeric = isNumeric;
    }

    public MetricPost unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="orders", value="The unit of measure. Applicable for numeric custom metrics only.")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public MetricPost eventKey(String eventKey) {
        this.eventKey = eventKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Order placed", value="The event key to use in your code. Required for custom conversion/binary and custom numeric metrics only.")
    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public MetricPost successCriteria(SuccessCriteriaEnum successCriteria) {
        this.successCriteria = successCriteria;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="HigherThanBaseline", value="Success criteria. Required for custom numeric metrics, optional for custom conversion metrics.")
    public SuccessCriteriaEnum getSuccessCriteria() {
        return this.successCriteria;
    }

    public void setSuccessCriteria(SuccessCriteriaEnum successCriteria) {
        this.successCriteria = successCriteria;
    }

    public MetricPost tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricPost addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"example-tag\"]", value="Tags for the metric")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public MetricPost randomizationUnits(List<String> randomizationUnits) {
        this.randomizationUnits = randomizationUnits;
        return this;
    }

    public MetricPost addRandomizationUnitsItem(String randomizationUnitsItem) {
        if (this.randomizationUnits == null) {
            this.randomizationUnits = new ArrayList<String>();
        }
        this.randomizationUnits.add(randomizationUnitsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"user\"]", value="An array of randomization units allowed for this metric")
    public List<String> getRandomizationUnits() {
        return this.randomizationUnits;
    }

    public void setRandomizationUnits(List<String> randomizationUnits) {
        this.randomizationUnits = randomizationUnits;
    }

    public MetricPost maintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="569fdeadbeef1644facecafe", value="The ID of the member who maintains this metric")
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public MetricPost unitAggregationType(UnitAggregationTypeEnum unitAggregationType) {
        this.unitAggregationType = unitAggregationType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="average", value="The method by which multiple unit event values are aggregated")
    public UnitAggregationTypeEnum getUnitAggregationType() {
        return this.unitAggregationType;
    }

    public void setUnitAggregationType(UnitAggregationTypeEnum unitAggregationType) {
        this.unitAggregationType = unitAggregationType;
    }

    public MetricPost analysisType(String analysisType) {
        this.analysisType = analysisType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mean", value="The method for analyzing metric events")
    public String getAnalysisType() {
        return this.analysisType;
    }

    public void setAnalysisType(String analysisType) {
        this.analysisType = analysisType;
    }

    public MetricPost percentileValue(Integer percentileValue) {
        this.percentileValue = percentileValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="95", value="The percentile for the analysis method. An integer denoting the target percentile between 0 and 100. Required when <code>analysisType</code> is <code>percentile</code>.")
    public Integer getPercentileValue() {
        return this.percentileValue;
    }

    public void setPercentileValue(Integer percentileValue) {
        this.percentileValue = percentileValue;
    }

    public MetricPost eventDefault(MetricEventDefaultRep eventDefault) {
        this.eventDefault = eventDefault;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MetricEventDefaultRep getEventDefault() {
        return this.eventDefault;
    }

    public void setEventDefault(MetricEventDefaultRep eventDefault) {
        this.eventDefault = eventDefault;
    }

    public MetricPost putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricPost metricPost = (MetricPost)o;
        return Objects.equals(this.key, metricPost.key) && Objects.equals(this.name, metricPost.name) && Objects.equals(this.description, metricPost.description) && Objects.equals((Object)this.kind, (Object)metricPost.kind) && Objects.equals(this.selector, metricPost.selector) && Objects.equals(this.urls, metricPost.urls) && Objects.equals(this.isNumeric, metricPost.isNumeric) && Objects.equals(this.unit, metricPost.unit) && Objects.equals(this.eventKey, metricPost.eventKey) && Objects.equals((Object)this.successCriteria, (Object)metricPost.successCriteria) && Objects.equals(this.tags, metricPost.tags) && Objects.equals(this.randomizationUnits, metricPost.randomizationUnits) && Objects.equals(this.maintainerId, metricPost.maintainerId) && Objects.equals((Object)this.unitAggregationType, (Object)metricPost.unitAggregationType) && Objects.equals(this.analysisType, metricPost.analysisType) && Objects.equals(this.percentileValue, metricPost.percentileValue) && Objects.equals(this.eventDefault, metricPost.eventDefault) && Objects.equals(this.additionalProperties, metricPost.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.name, this.description, this.kind, this.selector, this.urls, this.isNumeric, this.unit, this.eventKey, this.successCriteria, this.tags, this.randomizationUnits, this.maintainerId, this.unitAggregationType, this.analysisType, this.percentileValue, this.eventDefault, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricPost {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("    isNumeric: ").append(this.toIndentedString(this.isNumeric)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    eventKey: ").append(this.toIndentedString(this.eventKey)).append("\n");
        sb.append("    successCriteria: ").append(this.toIndentedString((Object)this.successCriteria)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    randomizationUnits: ").append(this.toIndentedString(this.randomizationUnits)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    unitAggregationType: ").append(this.toIndentedString((Object)this.unitAggregationType)).append("\n");
        sb.append("    analysisType: ").append(this.toIndentedString(this.analysisType)).append("\n");
        sb.append("    percentileValue: ").append(this.toIndentedString(this.percentileValue)).append("\n");
        sb.append("    eventDefault: ").append(this.toIndentedString(this.eventDefault)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MetricPost is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_SELECTOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selector` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTOR).toString()));
        }
        JsonArray jsonArrayurls = jsonObj.getAsJsonArray(SERIALIZED_NAME_URLS);
        if (jsonArrayurls != null) {
            if (!jsonObj.get(SERIALIZED_NAME_URLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `urls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URLS).toString()));
            }
            for (int i = 0; i < jsonArrayurls.size(); ++i) {
                UrlPost.validateJsonObject(jsonArrayurls.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_EVENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `eventKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUCCESS_CRITERIA) != null && !jsonObj.get(SERIALIZED_NAME_SUCCESS_CRITERIA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `successCriteria` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUCCESS_CRITERIA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNITS) != null && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNITS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `randomizationUnits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNITS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `maintainerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIT_AGGREGATION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_UNIT_AGGREGATION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `unitAggregationType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIT_AGGREGATION_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ANALYSIS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ANALYSIS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `analysisType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ANALYSIS_TYPE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_EVENT_DEFAULT) != null) {
            MetricEventDefaultRep.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_EVENT_DEFAULT));
        }
    }

    public static MetricPost fromJson(String jsonString) throws IOException {
        return (MetricPost)JSON.getGson().fromJson(jsonString, MetricPost.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_URLS);
        openapiFields.add(SERIALIZED_NAME_IS_NUMERIC);
        openapiFields.add(SERIALIZED_NAME_UNIT);
        openapiFields.add(SERIALIZED_NAME_EVENT_KEY);
        openapiFields.add(SERIALIZED_NAME_SUCCESS_CRITERIA);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_RANDOMIZATION_UNITS);
        openapiFields.add(SERIALIZED_NAME_MAINTAINER_ID);
        openapiFields.add(SERIALIZED_NAME_UNIT_AGGREGATION_TYPE);
        openapiFields.add(SERIALIZED_NAME_ANALYSIS_TYPE);
        openapiFields.add(SERIALIZED_NAME_PERCENTILE_VALUE);
        openapiFields.add(SERIALIZED_NAME_EVENT_DEFAULT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_KIND);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!MetricPost.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MetricPost.class));
            return new TypeAdapter<MetricPost>(){

                public void write(JsonWriter out, MetricPost value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public MetricPost read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MetricPost.validateJsonObject(jsonObj);
                    MetricPost instance = (MetricPost)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitAggregationTypeEnum {
        AVERAGE("average"),
        SUM("sum");

        private String value;

        private UnitAggregationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitAggregationTypeEnum fromValue(String value) {
            for (UnitAggregationTypeEnum b : UnitAggregationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<UnitAggregationTypeEnum> {
            public void write(JsonWriter jsonWriter, UnitAggregationTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UnitAggregationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitAggregationTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SuccessCriteriaEnum {
        HIGHERTHANBASELINE("HigherThanBaseline"),
        LOWERTHANBASELINE("LowerThanBaseline");

        private String value;

        private SuccessCriteriaEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SuccessCriteriaEnum fromValue(String value) {
            for (SuccessCriteriaEnum b : SuccessCriteriaEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SuccessCriteriaEnum> {
            public void write(JsonWriter jsonWriter, SuccessCriteriaEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SuccessCriteriaEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SuccessCriteriaEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        PAGEVIEW("pageview"),
        CLICK("click"),
        CUSTOM("custom");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

