/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AiConfigsAccess;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ModelConfig {
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    private AiConfigsAccess access;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ICON = "icon";
    @SerializedName(value="icon")
    private String icon;
    public static final String SERIALIZED_NAME_PROVIDER = "provider";
    @SerializedName(value="provider")
    private String provider;
    public static final String SERIALIZED_NAME_GLOBAL = "global";
    @SerializedName(value="global")
    private Boolean global;
    public static final String SERIALIZED_NAME_PARAMS = "params";
    @SerializedName(value="params")
    private Object params;
    public static final String SERIALIZED_NAME_CUSTOM_PARAMS = "customParams";
    @SerializedName(value="customParams")
    private Object customParams;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_COST_PER_INPUT_TOKEN = "costPerInputToken";
    @SerializedName(value="costPerInputToken")
    private Double costPerInputToken;
    public static final String SERIALIZED_NAME_COST_PER_OUTPUT_TOKEN = "costPerOutputToken";
    @SerializedName(value="costPerOutputToken")
    private Double costPerOutputToken;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ModelConfig access(AiConfigsAccess access) {
        this.access = access;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AiConfigsAccess getAccess() {
        return this.access;
    }

    public void setAccess(AiConfigsAccess access) {
        this.access = access;
    }

    public ModelConfig name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Human readable name of the model")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelConfig key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unique key for the model")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ModelConfig id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifier for the model, for use with third party providers")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ModelConfig icon(String icon) {
        this.icon = icon;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Icon for the model")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public ModelConfig provider(String provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Provider for the model")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public ModelConfig global(Boolean global) {
        this.global = global;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Whether the model is global")
    public Boolean getGlobal() {
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public ModelConfig params(Object params) {
        this.params = params;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getParams() {
        return this.params;
    }

    public void setParams(Object params) {
        this.params = params;
    }

    public ModelConfig customParams(Object customParams) {
        this.customParams = customParams;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Object customParams) {
        this.customParams = customParams;
    }

    public ModelConfig tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ModelConfig addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ModelConfig version(Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ModelConfig costPerInputToken(Double costPerInputToken) {
        this.costPerInputToken = costPerInputToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cost per input token in USD")
    public Double getCostPerInputToken() {
        return this.costPerInputToken;
    }

    public void setCostPerInputToken(Double costPerInputToken) {
        this.costPerInputToken = costPerInputToken;
    }

    public ModelConfig costPerOutputToken(Double costPerOutputToken) {
        this.costPerOutputToken = costPerOutputToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cost per output token in USD")
    public Double getCostPerOutputToken() {
        return this.costPerOutputToken;
    }

    public void setCostPerOutputToken(Double costPerOutputToken) {
        this.costPerOutputToken = costPerOutputToken;
    }

    public ModelConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelConfig modelConfig = (ModelConfig)o;
        return Objects.equals(this.access, modelConfig.access) && Objects.equals(this.name, modelConfig.name) && Objects.equals(this.key, modelConfig.key) && Objects.equals(this.id, modelConfig.id) && Objects.equals(this.icon, modelConfig.icon) && Objects.equals(this.provider, modelConfig.provider) && Objects.equals(this.global, modelConfig.global) && Objects.equals(this.params, modelConfig.params) && Objects.equals(this.customParams, modelConfig.customParams) && Objects.equals(this.tags, modelConfig.tags) && Objects.equals(this.version, modelConfig.version) && Objects.equals(this.costPerInputToken, modelConfig.costPerInputToken) && Objects.equals(this.costPerOutputToken, modelConfig.costPerOutputToken) && Objects.equals(this.additionalProperties, modelConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.access, this.name, this.key, this.id, this.icon, this.provider, this.global, this.params, this.customParams, this.tags, this.version, this.costPerInputToken, this.costPerOutputToken, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModelConfig {\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    icon: ").append(this.toIndentedString(this.icon)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    global: ").append(this.toIndentedString(this.global)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    customParams: ").append(this.toIndentedString(this.customParams)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    costPerInputToken: ").append(this.toIndentedString(this.costPerInputToken)).append("\n");
        sb.append("    costPerOutputToken: ").append(this.toIndentedString(this.costPerOutputToken)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ModelConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS) != null) {
            AiConfigsAccess.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ICON) != null && !jsonObj.get(SERIALIZED_NAME_ICON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `icon` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ICON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROVIDER) != null && !jsonObj.get(SERIALIZED_NAME_PROVIDER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `provider` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROVIDER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
    }

    public static ModelConfig fromJson(String jsonString) throws IOException {
        return (ModelConfig)JSON.getGson().fromJson(jsonString, ModelConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ICON);
        openapiFields.add(SERIALIZED_NAME_PROVIDER);
        openapiFields.add(SERIALIZED_NAME_GLOBAL);
        openapiFields.add(SERIALIZED_NAME_PARAMS);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_PARAMS);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_COST_PER_INPUT_TOKEN);
        openapiFields.add(SERIALIZED_NAME_COST_PER_OUTPUT_TOKEN);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_GLOBAL);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ModelConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ModelConfig.class));
            return new TypeAdapter<ModelConfig>(){

                public void write(JsonWriter out, ModelConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ModelConfig read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ModelConfig.validateJsonObject(jsonObj);
                    ModelConfig instance = (ModelConfig)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

