/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.FileRep;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ModelImport {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_SEGMENT_KEY = "segmentKey";
    @SerializedName(value="segmentKey")
    private String segmentKey;
    public static final String SERIALIZED_NAME_CREATION_TIME = "creationTime";
    @SerializedName(value="creationTime")
    private Long creationTime;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    private String mode;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_FILES = "files";
    @SerializedName(value="files")
    private List<FileRep> files = null;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = new HashMap<String, Link>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ModelImport id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234a567-bcd8-9123-4567-abcd1234567f", required=true, value="The import ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ModelImport segmentKey(String segmentKey) {
        this.segmentKey = segmentKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="example-big-segment", required=true, value="The segment key")
    public String getSegmentKey() {
        return this.segmentKey;
    }

    public void setSegmentKey(String segmentKey) {
        this.segmentKey = segmentKey;
    }

    public ModelImport creationTime(Long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public ModelImport mode(String mode) {
        this.mode = mode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="replace", required=true, value="The import mode used, either <code>merge</code> or <code>replace</code>")
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public ModelImport status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="complete", required=true, value="The import status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ModelImport files(List<FileRep> files) {
        this.files = files;
        return this;
    }

    public ModelImport addFilesItem(FileRep filesItem) {
        if (this.files == null) {
            this.files = new ArrayList<FileRep>();
        }
        this.files.add(filesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"filename\":\"bigsegimport.csv\",\"status\":\"complete\"}]", value="The imported files and their status")
    public List<FileRep> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileRep> files) {
        this.files = files;
    }

    public ModelImport links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ModelImport putLinksItem(String key, Link linksItem) {
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ModelImport putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelImport _import = (ModelImport)o;
        return Objects.equals(this.id, _import.id) && Objects.equals(this.segmentKey, _import.segmentKey) && Objects.equals(this.creationTime, _import.creationTime) && Objects.equals(this.mode, _import.mode) && Objects.equals((Object)this.status, (Object)_import.status) && Objects.equals(this.files, _import.files) && Objects.equals(this.links, _import.links) && Objects.equals(this.additionalProperties, _import.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.segmentKey, this.creationTime, this.mode, this.status, this.files, this.links, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModelImport {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    segmentKey: ").append(this.toIndentedString(this.segmentKey)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ModelImport is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SEGMENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_SEGMENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `segmentKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SEGMENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODE) != null && !jsonObj.get(SERIALIZED_NAME_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        JsonArray jsonArrayfiles = jsonObj.getAsJsonArray(SERIALIZED_NAME_FILES);
        if (jsonArrayfiles != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FILES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `files` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILES).toString()));
            }
            for (int i = 0; i < jsonArrayfiles.size(); ++i) {
                FileRep.validateJsonObject(jsonArrayfiles.get(i).getAsJsonObject());
            }
        }
    }

    public static ModelImport fromJson(String jsonString) throws IOException {
        return (ModelImport)JSON.getGson().fromJson(jsonString, ModelImport.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_SEGMENT_KEY);
        openapiFields.add(SERIALIZED_NAME_CREATION_TIME);
        openapiFields.add(SERIALIZED_NAME_MODE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_FILES);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_SEGMENT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_TIME);
        openapiRequiredFields.add(SERIALIZED_NAME_MODE);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_LINKS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ModelImport.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ModelImport.class));
            return new TypeAdapter<ModelImport>(){

                public void write(JsonWriter out, ModelImport value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ModelImport read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ModelImport.validateJsonObject(jsonObj);
                    ModelImport instance = (ModelImport)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        PREPARING("preparing"),
        PENDING_APPROVAL("pending_approval"),
        READY("ready"),
        IN_PROGRESS("in_progress"),
        COMPLETE("complete"),
        STOPPED("stopped");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

