/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NewMemberForm {
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_FIRST_NAME = "firstName";
    @SerializedName(value="firstName")
    private String firstName;
    public static final String SERIALIZED_NAME_LAST_NAME = "lastName";
    @SerializedName(value="lastName")
    private String lastName;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private RoleEnum role;
    public static final String SERIALIZED_NAME_CUSTOM_ROLES = "customRoles";
    @SerializedName(value="customRoles")
    private List<String> customRoles = null;
    public static final String SERIALIZED_NAME_TEAM_KEYS = "teamKeys";
    @SerializedName(value="teamKeys")
    private List<String> teamKeys = null;
    public static final String SERIALIZED_NAME_ROLE_ATTRIBUTES = "roleAttributes";
    @SerializedName(value="roleAttributes")
    private Map<String, List<String>> roleAttributes = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NewMemberForm email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="sandy@acme.com", required=true, value="The member's email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public NewMemberForm password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="***", value="The member's password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public NewMemberForm firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Ariel", value="The member's first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public NewMemberForm lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Flores", value="The member's last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public NewMemberForm role(RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="reader", value="The member's built-in role")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public NewMemberForm customRoles(List<String> customRoles) {
        this.customRoles = customRoles;
        return this;
    }

    public NewMemberForm addCustomRolesItem(String customRolesItem) {
        if (this.customRoles == null) {
            this.customRoles = new ArrayList<String>();
        }
        this.customRoles.add(customRolesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"customRole1\",\"customRole2\"]", value="An array of the member's custom roles")
    public List<String> getCustomRoles() {
        return this.customRoles;
    }

    public void setCustomRoles(List<String> customRoles) {
        this.customRoles = customRoles;
    }

    public NewMemberForm teamKeys(List<String> teamKeys) {
        this.teamKeys = teamKeys;
        return this;
    }

    public NewMemberForm addTeamKeysItem(String teamKeysItem) {
        if (this.teamKeys == null) {
            this.teamKeys = new ArrayList<String>();
        }
        this.teamKeys.add(teamKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"team-1\",\"team-2\"]", value="An array of the member's teams")
    public List<String> getTeamKeys() {
        return this.teamKeys;
    }

    public void setTeamKeys(List<String> teamKeys) {
        this.teamKeys = teamKeys;
    }

    public NewMemberForm roleAttributes(Map<String, List<String>> roleAttributes) {
        this.roleAttributes = roleAttributes;
        return this;
    }

    public NewMemberForm putRoleAttributesItem(String key, List<String> roleAttributesItem) {
        if (this.roleAttributes == null) {
            this.roleAttributes = new HashMap<String, List<String>>();
        }
        this.roleAttributes.put(key, roleAttributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, List<String>> getRoleAttributes() {
        return this.roleAttributes;
    }

    public void setRoleAttributes(Map<String, List<String>> roleAttributes) {
        this.roleAttributes = roleAttributes;
    }

    public NewMemberForm putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewMemberForm newMemberForm = (NewMemberForm)o;
        return Objects.equals(this.email, newMemberForm.email) && Objects.equals(this.password, newMemberForm.password) && Objects.equals(this.firstName, newMemberForm.firstName) && Objects.equals(this.lastName, newMemberForm.lastName) && Objects.equals((Object)this.role, (Object)newMemberForm.role) && Objects.equals(this.customRoles, newMemberForm.customRoles) && Objects.equals(this.teamKeys, newMemberForm.teamKeys) && Objects.equals(this.roleAttributes, newMemberForm.roleAttributes) && Objects.equals(this.additionalProperties, newMemberForm.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.email, this.password, this.firstName, this.lastName, this.role, this.customRoles, this.teamKeys, this.roleAttributes, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewMemberForm {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    customRoles: ").append(this.toIndentedString(this.customRoles)).append("\n");
        sb.append("    teamKeys: ").append(this.toIndentedString(this.teamKeys)).append("\n");
        sb.append("    roleAttributes: ").append(this.toIndentedString(this.roleAttributes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in NewMemberForm is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIRST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FIRST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `firstName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIRST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_LAST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `lastName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLE) != null && !jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `customRoles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEAM_KEYS) != null && !jsonObj.get(SERIALIZED_NAME_TEAM_KEYS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `teamKeys` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEAM_KEYS).toString()));
        }
    }

    public static NewMemberForm fromJson(String jsonString) throws IOException {
        return (NewMemberForm)JSON.getGson().fromJson(jsonString, NewMemberForm.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_FIRST_NAME);
        openapiFields.add(SERIALIZED_NAME_LAST_NAME);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_ROLES);
        openapiFields.add(SERIALIZED_NAME_TEAM_KEYS);
        openapiFields.add(SERIALIZED_NAME_ROLE_ATTRIBUTES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EMAIL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!NewMemberForm.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NewMemberForm.class));
            return new TypeAdapter<NewMemberForm>(){

                public void write(JsonWriter out, NewMemberForm value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public NewMemberForm read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    NewMemberForm.validateJsonObject(jsonObj);
                    NewMemberForm instance = (NewMemberForm)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        READER("reader"),
        WRITER("writer"),
        ADMIN("admin"),
        NO_ACCESS("no_access");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }
}

