/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PostDeploymentEventInput {
    public static final String SERIALIZED_NAME_PROJECT_KEY = "projectKey";
    @SerializedName(value="projectKey")
    private String projectKey;
    public static final String SERIALIZED_NAME_ENVIRONMENT_KEY = "environmentKey";
    @SerializedName(value="environmentKey")
    private String environmentKey;
    public static final String SERIALIZED_NAME_APPLICATION_KEY = "applicationKey";
    @SerializedName(value="applicationKey")
    private String applicationKey;
    public static final String SERIALIZED_NAME_APPLICATION_NAME = "applicationName";
    @SerializedName(value="applicationName")
    private String applicationName;
    public static final String SERIALIZED_NAME_APPLICATION_KIND = "applicationKind";
    @SerializedName(value="applicationKind")
    private ApplicationKindEnum applicationKind;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_VERSION_NAME = "versionName";
    @SerializedName(value="versionName")
    private String versionName;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "eventType";
    @SerializedName(value="eventType")
    private EventTypeEnum eventType;
    public static final String SERIALIZED_NAME_EVENT_TIME = "eventTime";
    @SerializedName(value="eventTime")
    private Long eventTime;
    public static final String SERIALIZED_NAME_EVENT_METADATA = "eventMetadata";
    @SerializedName(value="eventMetadata")
    private Map<String, Object> eventMetadata = null;
    public static final String SERIALIZED_NAME_DEPLOYMENT_METADATA = "deploymentMetadata";
    @SerializedName(value="deploymentMetadata")
    private Map<String, Object> deploymentMetadata = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PostDeploymentEventInput projectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="default", required=true, value="The project key")
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public PostDeploymentEventInput environmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="production", required=true, value="The environment key")
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    public void setEnvironmentKey(String environmentKey) {
        this.environmentKey = environmentKey;
    }

    public PostDeploymentEventInput applicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="billing-service", required=true, value="The application key. This defines the granularity at which you want to view your insights metrics. Typically it is the name of one of the GitHub repositories that you use in this project.<br/><br/>LaunchDarkly automatically creates a new application each time you send a unique application key.")
    public String getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public PostDeploymentEventInput applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Billing Service", value="The application name. This defines how the application is displayed")
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public PostDeploymentEventInput applicationKind(ApplicationKindEnum applicationKind) {
        this.applicationKind = applicationKind;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="server", value="The kind of application. Default: <code>server</code>")
    public ApplicationKindEnum getApplicationKind() {
        return this.applicationKind;
    }

    public void setApplicationKind(ApplicationKindEnum applicationKind) {
        this.applicationKind = applicationKind;
    }

    public PostDeploymentEventInput version(String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="a90a8a2", required=true, value="The application version. You can set the application version to any string that includes only letters, numbers, periods (<code>.</code>), hyphens (<code>-</code>), or underscores (<code>_</code>).<br/><br/>We recommend setting the application version to at least the first seven characters of the SHA or to the tag of the GitHub commit for this deployment.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public PostDeploymentEventInput versionName(String versionName) {
        this.versionName = versionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="v1.0.0", value="The version name. This defines how the version is displayed")
    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public PostDeploymentEventInput eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="started", required=true, value="The event type")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public PostDeploymentEventInput eventTime(Long eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Long eventTime) {
        this.eventTime = eventTime;
    }

    public PostDeploymentEventInput eventMetadata(Map<String, Object> eventMetadata) {
        this.eventMetadata = eventMetadata;
        return this;
    }

    public PostDeploymentEventInput putEventMetadataItem(String key, Object eventMetadataItem) {
        if (this.eventMetadata == null) {
            this.eventMetadata = new HashMap<String, Object>();
        }
        this.eventMetadata.put(key, eventMetadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"buildSystemVersion\":\"v1.2.3\"}", value="A JSON object containing metadata about the event")
    public Map<String, Object> getEventMetadata() {
        return this.eventMetadata;
    }

    public void setEventMetadata(Map<String, Object> eventMetadata) {
        this.eventMetadata = eventMetadata;
    }

    public PostDeploymentEventInput deploymentMetadata(Map<String, Object> deploymentMetadata) {
        this.deploymentMetadata = deploymentMetadata;
        return this;
    }

    public PostDeploymentEventInput putDeploymentMetadataItem(String key, Object deploymentMetadataItem) {
        if (this.deploymentMetadata == null) {
            this.deploymentMetadata = new HashMap<String, Object>();
        }
        this.deploymentMetadata.put(key, deploymentMetadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"buildNumber\":\"1234\"}", value="A JSON object containing metadata about the deployment")
    public Map<String, Object> getDeploymentMetadata() {
        return this.deploymentMetadata;
    }

    public void setDeploymentMetadata(Map<String, Object> deploymentMetadata) {
        this.deploymentMetadata = deploymentMetadata;
    }

    public PostDeploymentEventInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostDeploymentEventInput postDeploymentEventInput = (PostDeploymentEventInput)o;
        return Objects.equals(this.projectKey, postDeploymentEventInput.projectKey) && Objects.equals(this.environmentKey, postDeploymentEventInput.environmentKey) && Objects.equals(this.applicationKey, postDeploymentEventInput.applicationKey) && Objects.equals(this.applicationName, postDeploymentEventInput.applicationName) && Objects.equals((Object)this.applicationKind, (Object)postDeploymentEventInput.applicationKind) && Objects.equals(this.version, postDeploymentEventInput.version) && Objects.equals(this.versionName, postDeploymentEventInput.versionName) && Objects.equals((Object)this.eventType, (Object)postDeploymentEventInput.eventType) && Objects.equals(this.eventTime, postDeploymentEventInput.eventTime) && Objects.equals(this.eventMetadata, postDeploymentEventInput.eventMetadata) && Objects.equals(this.deploymentMetadata, postDeploymentEventInput.deploymentMetadata) && Objects.equals(this.additionalProperties, postDeploymentEventInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.projectKey, this.environmentKey, this.applicationKey, this.applicationName, this.applicationKind, this.version, this.versionName, this.eventType, this.eventTime, this.eventMetadata, this.deploymentMetadata, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostDeploymentEventInput {\n");
        sb.append("    projectKey: ").append(this.toIndentedString(this.projectKey)).append("\n");
        sb.append("    environmentKey: ").append(this.toIndentedString(this.environmentKey)).append("\n");
        sb.append("    applicationKey: ").append(this.toIndentedString(this.applicationKey)).append("\n");
        sb.append("    applicationName: ").append(this.toIndentedString(this.applicationName)).append("\n");
        sb.append("    applicationKind: ").append(this.toIndentedString((Object)this.applicationKind)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    versionName: ").append(this.toIndentedString(this.versionName)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventMetadata: ").append(this.toIndentedString(this.eventMetadata)).append("\n");
        sb.append("    deploymentMetadata: ").append(this.toIndentedString(this.deploymentMetadata)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PostDeploymentEventInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROJECT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `projectKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `environmentKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_KEY) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `applicationKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_NAME) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `applicationName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `applicationKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION_NAME) != null && !jsonObj.get(SERIALIZED_NAME_VERSION_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `versionName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_EVENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `eventType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_TYPE).toString()));
        }
    }

    public static PostDeploymentEventInput fromJson(String jsonString) throws IOException {
        return (PostDeploymentEventInput)JSON.getGson().fromJson(jsonString, PostDeploymentEventInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PROJECT_KEY);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT_KEY);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_KEY);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_NAME);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_KIND);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiFields.add(SERIALIZED_NAME_VERSION_NAME);
        openapiFields.add(SERIALIZED_NAME_EVENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_EVENT_TIME);
        openapiFields.add(SERIALIZED_NAME_EVENT_METADATA);
        openapiFields.add(SERIALIZED_NAME_DEPLOYMENT_METADATA);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PROJECT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_ENVIRONMENT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_APPLICATION_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_EVENT_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PostDeploymentEventInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PostDeploymentEventInput.class));
            return new TypeAdapter<PostDeploymentEventInput>(){

                public void write(JsonWriter out, PostDeploymentEventInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PostDeploymentEventInput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PostDeploymentEventInput.validateJsonObject(jsonObj);
                    PostDeploymentEventInput instance = (PostDeploymentEventInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventTypeEnum {
        STARTED("started"),
        FAILED("failed"),
        FINISHED("finished"),
        CUSTOM("custom");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EventTypeEnum> {
            public void write(JsonWriter jsonWriter, EventTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ApplicationKindEnum {
        SERVER("server"),
        BROWSER("browser"),
        MOBILE("mobile");

        private String value;

        private ApplicationKindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ApplicationKindEnum fromValue(String value) {
            for (ApplicationKindEnum b : ApplicationKindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ApplicationKindEnum> {
            public void write(JsonWriter jsonWriter, ApplicationKindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ApplicationKindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ApplicationKindEnum.fromValue(value);
            }
        }
    }
}

