/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AudienceConfiguration;
import com.launchdarkly.api.model.EnvironmentSummary;
import com.launchdarkly.api.model.Link;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReleaseAudience {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Map<String, Link> links = null;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private EnvironmentSummary environment;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private AudienceConfiguration _configuration;
    public static final String SERIALIZED_NAME_SEGMENT_KEYS = "segmentKeys";
    @SerializedName(value="segmentKeys")
    private List<String> segmentKeys = null;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_RULE_IDS = "_ruleIds";
    @SerializedName(value="_ruleIds")
    private List<String> ruleIds = null;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ReleaseAudience id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234a56b7c89d012345e678g", required=true, value="The audience ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ReleaseAudience links(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ReleaseAudience putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location and content type of related resources")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, Link> links) {
        this.links = links;
    }

    public ReleaseAudience environment(EnvironmentSummary environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EnvironmentSummary getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(EnvironmentSummary environment) {
        this.environment = environment;
    }

    public ReleaseAudience name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Phase 1 - Testing", required=true, value="The release phase name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReleaseAudience _configuration(AudienceConfiguration _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AudienceConfiguration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(AudienceConfiguration _configuration) {
        this._configuration = _configuration;
    }

    public ReleaseAudience segmentKeys(List<String> segmentKeys) {
        this.segmentKeys = segmentKeys;
        return this;
    }

    public ReleaseAudience addSegmentKeysItem(String segmentKeysItem) {
        if (this.segmentKeys == null) {
            this.segmentKeys = new ArrayList<String>();
        }
        this.segmentKeys.add(segmentKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"segment-key-123abc\"]", value="A list of segment keys")
    public List<String> getSegmentKeys() {
        return this.segmentKeys;
    }

    public void setSegmentKeys(List<String> segmentKeys) {
        this.segmentKeys = segmentKeys;
    }

    public ReleaseAudience status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ReleaseAudience ruleIds(List<String> ruleIds) {
        this.ruleIds = ruleIds;
        return this;
    }

    public ReleaseAudience addRuleIdsItem(String ruleIdsItem) {
        if (this.ruleIds == null) {
            this.ruleIds = new ArrayList<String>();
        }
        this.ruleIds.add(ruleIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The rules IDs added or updated by this audience")
    public List<String> getRuleIds() {
        return this.ruleIds;
    }

    public void setRuleIds(List<String> ruleIds) {
        this.ruleIds = ruleIds;
    }

    public ReleaseAudience putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleaseAudience releaseAudience = (ReleaseAudience)o;
        return Objects.equals(this.id, releaseAudience.id) && Objects.equals(this.links, releaseAudience.links) && Objects.equals(this.environment, releaseAudience.environment) && Objects.equals(this.name, releaseAudience.name) && Objects.equals(this._configuration, releaseAudience._configuration) && Objects.equals(this.segmentKeys, releaseAudience.segmentKeys) && Objects.equals(this.status, releaseAudience.status) && Objects.equals(this.ruleIds, releaseAudience.ruleIds) && Objects.equals(this.additionalProperties, releaseAudience.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.links, this.environment, this.name, this._configuration, this.segmentKeys, this.status, this.ruleIds, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReleaseAudience {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString(this.environment)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    segmentKeys: ").append(this.toIndentedString(this.segmentKeys)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    ruleIds: ").append(this.toIndentedString(this.ruleIds)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ReleaseAudience is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENT) != null) {
            EnvironmentSummary.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENVIRONMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CONFIGURATION) != null) {
            AudienceConfiguration.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_SEGMENT_KEYS) != null && !jsonObj.get(SERIALIZED_NAME_SEGMENT_KEYS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `segmentKeys` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SEGMENT_KEYS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RULE_IDS) != null && !jsonObj.get(SERIALIZED_NAME_RULE_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `_ruleIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RULE_IDS).toString()));
        }
    }

    public static ReleaseAudience fromJson(String jsonString) throws IOException {
        return (ReleaseAudience)JSON.getGson().fromJson(jsonString, ReleaseAudience.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ENVIRONMENT);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_SEGMENT_KEYS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_RULE_IDS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ReleaseAudience.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ReleaseAudience.class));
            return new TypeAdapter<ReleaseAudience>(){

                public void write(JsonWriter out, ReleaseAudience value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ReleaseAudience read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ReleaseAudience.validateJsonObject(jsonObj);
                    ReleaseAudience instance = (ReleaseAudience)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

