/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.CompletedBy;
import com.launchdarkly.api.model.ReleaseAudience;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReleasePhase {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "_name";
    @SerializedName(value="_name")
    private String name;
    public static final String SERIALIZED_NAME_COMPLETE = "complete";
    @SerializedName(value="complete")
    private Boolean complete;
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    private Long creationDate;
    public static final String SERIALIZED_NAME_COMPLETION_DATE = "_completionDate";
    @SerializedName(value="_completionDate")
    private Long completionDate;
    public static final String SERIALIZED_NAME_COMPLETED_BY = "_completedBy";
    @SerializedName(value="_completedBy")
    private CompletedBy completedBy;
    public static final String SERIALIZED_NAME_AUDIENCES = "_audiences";
    @SerializedName(value="_audiences")
    private List<ReleaseAudience> audiences = new ArrayList<ReleaseAudience>();
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_STARTED = "started";
    @SerializedName(value="started")
    private Boolean started;
    public static final String SERIALIZED_NAME_STARTED_DATE = "_startedDate";
    @SerializedName(value="_startedDate")
    private Long startedDate;
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private Object _configuration;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ReleasePhase id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1234a56b7c89d012345e678f", required=true, value="The phase ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ReleasePhase name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Phase 1 - Testing", required=true, value="The release phase name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReleasePhase complete(Boolean complete) {
        this.complete = complete;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="true", required=true, value="Whether this phase is complete")
    public Boolean getComplete() {
        return this.complete;
    }

    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public ReleasePhase creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public ReleasePhase completionDate(Long completionDate) {
        this.completionDate = completionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Long completionDate) {
        this.completionDate = completionDate;
    }

    public ReleasePhase completedBy(CompletedBy completedBy) {
        this.completedBy = completedBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CompletedBy getCompletedBy() {
        return this.completedBy;
    }

    public void setCompletedBy(CompletedBy completedBy) {
        this.completedBy = completedBy;
    }

    public ReleasePhase audiences(List<ReleaseAudience> audiences) {
        this.audiences = audiences;
        return this;
    }

    public ReleasePhase addAudiencesItem(ReleaseAudience audiencesItem) {
        this.audiences.add(audiencesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A logical grouping of one or more environments that share attributes for rolling out changes")
    public List<ReleaseAudience> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<ReleaseAudience> audiences) {
        this.audiences = audiences;
    }

    public ReleasePhase status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ReleasePhase started(Boolean started) {
        this.started = started;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not this phase has started")
    public Boolean getStarted() {
        return this.started;
    }

    public void setStarted(Boolean started) {
        this.started = started;
    }

    public ReleasePhase startedDate(Long startedDate) {
        this.startedDate = startedDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getStartedDate() {
        return this.startedDate;
    }

    public void setStartedDate(Long startedDate) {
        this.startedDate = startedDate;
    }

    public ReleasePhase _configuration(Object _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(Object _configuration) {
        this._configuration = _configuration;
    }

    public ReleasePhase putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReleasePhase releasePhase = (ReleasePhase)o;
        return Objects.equals(this.id, releasePhase.id) && Objects.equals(this.name, releasePhase.name) && Objects.equals(this.complete, releasePhase.complete) && Objects.equals(this.creationDate, releasePhase.creationDate) && Objects.equals(this.completionDate, releasePhase.completionDate) && Objects.equals(this.completedBy, releasePhase.completedBy) && Objects.equals(this.audiences, releasePhase.audiences) && Objects.equals(this.status, releasePhase.status) && Objects.equals(this.started, releasePhase.started) && Objects.equals(this.startedDate, releasePhase.startedDate) && Objects.equals(this._configuration, releasePhase._configuration) && Objects.equals(this.additionalProperties, releasePhase.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.complete, this.creationDate, this.completionDate, this.completedBy, this.audiences, this.status, this.started, this.startedDate, this._configuration, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReleasePhase {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    complete: ").append(this.toIndentedString(this.complete)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    completionDate: ").append(this.toIndentedString(this.completionDate)).append("\n");
        sb.append("    completedBy: ").append(this.toIndentedString(this.completedBy)).append("\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    startedDate: ").append(this.toIndentedString(this.startedDate)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayaudiences;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ReleasePhase is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COMPLETED_BY) != null) {
            CompletedBy.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COMPLETED_BY));
        }
        if ((jsonArrayaudiences = jsonObj.getAsJsonArray(SERIALIZED_NAME_AUDIENCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AUDIENCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `_audiences` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUDIENCES).toString()));
            }
            for (int i = 0; i < jsonArrayaudiences.size(); ++i) {
                ReleaseAudience.validateJsonObject(jsonArrayaudiences.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
    }

    public static ReleasePhase fromJson(String jsonString) throws IOException {
        return (ReleasePhase)JSON.getGson().fromJson(jsonString, ReleasePhase.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_COMPLETE);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_COMPLETION_DATE);
        openapiFields.add(SERIALIZED_NAME_COMPLETED_BY);
        openapiFields.add(SERIALIZED_NAME_AUDIENCES);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_STARTED);
        openapiFields.add(SERIALIZED_NAME_STARTED_DATE);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_COMPLETE);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_AUDIENCES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ReleasePhase.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ReleasePhase.class));
            return new TypeAdapter<ReleasePhase>(){

                public void write(JsonWriter out, ReleasePhase value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ReleasePhase read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ReleasePhase.validateJsonObject(jsonObj);
                    ReleasePhase instance = (ReleasePhase)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

