/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.AIConfig;
import com.launchdarkly.api.model.AIConfigPatch;
import com.launchdarkly.api.model.AIConfigPost;
import com.launchdarkly.api.model.AIConfigTargeting;
import com.launchdarkly.api.model.AIConfigTargetingPatch;
import com.launchdarkly.api.model.AIConfigVariation;
import com.launchdarkly.api.model.AIConfigVariationPatch;
import com.launchdarkly.api.model.AIConfigVariationPost;
import com.launchdarkly.api.model.AIConfigVariationsResponse;
import com.launchdarkly.api.model.AIConfigs;
import com.launchdarkly.api.model.AITool;
import com.launchdarkly.api.model.AIToolPatch;
import com.launchdarkly.api.model.AIToolPost;
import com.launchdarkly.api.model.AITools;
import com.launchdarkly.api.model.MetricByVariation;
import com.launchdarkly.api.model.Metrics;
import com.launchdarkly.api.model.ModelConfig;
import com.launchdarkly.api.model.ModelConfigPost;
import com.launchdarkly.api.model.RestrictedModelsRequest;
import com.launchdarkly.api.model.RestrictedModelsResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class AiConfigsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AiConfigsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AiConfigsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteAIConfigCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAIConfigValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteAIConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteAIConfig(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling deleteAIConfig(Async)");
        }
        return this.deleteAIConfigCall(ldAPIVersion, projectKey, configKey, _callback);
    }

    public void deleteAIConfig(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey) throws ApiException {
        this.deleteAIConfigWithHttpInfo(ldAPIVersion, projectKey, configKey);
    }

    public ApiResponse<Void> deleteAIConfigWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey) throws ApiException {
        Call localVarCall = this.deleteAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAIConfigAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteAIConfigVariationCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/variations/{variationKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString())).replace("{variationKey}", this.localVarApiClient.escapeString(variationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAIConfigVariationValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteAIConfigVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteAIConfigVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling deleteAIConfigVariation(Async)");
        }
        if (variationKey == null) {
            throw new ApiException("Missing the required parameter 'variationKey' when calling deleteAIConfigVariation(Async)");
        }
        return this.deleteAIConfigVariationCall(ldAPIVersion, projectKey, configKey, variationKey, _callback);
    }

    public void deleteAIConfigVariation(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey) throws ApiException {
        this.deleteAIConfigVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, variationKey);
    }

    public ApiResponse<Void> deleteAIConfigVariationWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey) throws ApiException {
        Call localVarCall = this.deleteAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAIConfigVariationAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteAIToolCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-tools/{toolKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{toolKey}", this.localVarApiClient.escapeString(toolKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAIToolValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteAITool(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteAITool(Async)");
        }
        if (toolKey == null) {
            throw new ApiException("Missing the required parameter 'toolKey' when calling deleteAITool(Async)");
        }
        return this.deleteAIToolCall(ldAPIVersion, projectKey, toolKey, _callback);
    }

    public void deleteAITool(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey) throws ApiException {
        this.deleteAIToolWithHttpInfo(ldAPIVersion, projectKey, toolKey);
    }

    public ApiResponse<Void> deleteAIToolWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey) throws ApiException {
        Call localVarCall = this.deleteAIToolValidateBeforeCall(ldAPIVersion, projectKey, toolKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAIToolAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAIToolValidateBeforeCall(ldAPIVersion, projectKey, toolKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteModelConfigCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs/{modelConfigKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{modelConfigKey}", this.localVarApiClient.escapeString(modelConfigKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteModelConfigValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteModelConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteModelConfig(Async)");
        }
        if (modelConfigKey == null) {
            throw new ApiException("Missing the required parameter 'modelConfigKey' when calling deleteModelConfig(Async)");
        }
        return this.deleteModelConfigCall(ldAPIVersion, projectKey, modelConfigKey, _callback);
    }

    public void deleteModelConfig(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey) throws ApiException {
        this.deleteModelConfigWithHttpInfo(ldAPIVersion, projectKey, modelConfigKey);
    }

    public ApiResponse<Void> deleteModelConfigWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey) throws ApiException {
        Call localVarCall = this.deleteModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteModelConfigAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteRestrictedModelsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RestrictedModelsRequest localVarPostBody = restrictedModelsRequest;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs/restricted".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteRestrictedModelsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteRestrictedModels(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteRestrictedModels(Async)");
        }
        if (restrictedModelsRequest == null) {
            throw new ApiException("Missing the required parameter 'restrictedModelsRequest' when calling deleteRestrictedModels(Async)");
        }
        return this.deleteRestrictedModelsCall(ldAPIVersion, projectKey, restrictedModelsRequest, _callback);
    }

    public void deleteRestrictedModels(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest) throws ApiException {
        this.deleteRestrictedModelsWithHttpInfo(ldAPIVersion, projectKey, restrictedModelsRequest);
    }

    public ApiResponse<Void> deleteRestrictedModelsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest) throws ApiException {
        Call localVarCall = this.deleteRestrictedModelsValidateBeforeCall(ldAPIVersion, projectKey, restrictedModelsRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteRestrictedModelsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteRestrictedModelsValidateBeforeCall(ldAPIVersion, projectKey, restrictedModelsRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAIConfigCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfig(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfig(Async)");
        }
        return this.getAIConfigCall(ldAPIVersion, projectKey, configKey, _callback);
    }

    public AIConfig getAIConfig(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey) throws ApiException {
        ApiResponse<AIConfig> localVarResp = this.getAIConfigWithHttpInfo(ldAPIVersion, projectKey, configKey);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfig> getAIConfigWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey) throws ApiException {
        Call localVarCall = this.getAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, null);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback<AIConfig> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, _callback);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigMetricsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/metrics".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (env != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("env", env));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigMetricsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigMetrics(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigMetrics(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfigMetrics(Async)");
        }
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling getAIConfigMetrics(Async)");
        }
        if (to == null) {
            throw new ApiException("Missing the required parameter 'to' when calling getAIConfigMetrics(Async)");
        }
        if (env == null) {
            throw new ApiException("Missing the required parameter 'env' when calling getAIConfigMetrics(Async)");
        }
        return this.getAIConfigMetricsCall(ldAPIVersion, projectKey, configKey, from, to, env, _callback);
    }

    public Metrics getAIConfigMetrics(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env) throws ApiException {
        ApiResponse<Metrics> localVarResp = this.getAIConfigMetricsWithHttpInfo(ldAPIVersion, projectKey, configKey, from, to, env);
        return localVarResp.getData();
    }

    public ApiResponse<Metrics> getAIConfigMetricsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env) throws ApiException {
        Call localVarCall = this.getAIConfigMetricsValidateBeforeCall(ldAPIVersion, projectKey, configKey, from, to, env, null);
        Type localVarReturnType = new TypeToken<Metrics>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigMetricsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env, ApiCallback<Metrics> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigMetricsValidateBeforeCall(ldAPIVersion, projectKey, configKey, from, to, env, _callback);
        Type localVarReturnType = new TypeToken<Metrics>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigMetricsByVariationCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/metrics-by-variation".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (env != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("env", env));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigMetricsByVariationValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (to == null) {
            throw new ApiException("Missing the required parameter 'to' when calling getAIConfigMetricsByVariation(Async)");
        }
        if (env == null) {
            throw new ApiException("Missing the required parameter 'env' when calling getAIConfigMetricsByVariation(Async)");
        }
        return this.getAIConfigMetricsByVariationCall(ldAPIVersion, projectKey, configKey, from, to, env, _callback);
    }

    public List<MetricByVariation> getAIConfigMetricsByVariation(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env) throws ApiException {
        ApiResponse<List<MetricByVariation>> localVarResp = this.getAIConfigMetricsByVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, from, to, env);
        return localVarResp.getData();
    }

    public ApiResponse<List<MetricByVariation>> getAIConfigMetricsByVariationWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env) throws ApiException {
        Call localVarCall = this.getAIConfigMetricsByVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, from, to, env, null);
        Type localVarReturnType = new TypeToken<List<MetricByVariation>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigMetricsByVariationAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull Integer from, @Nonnull Integer to, @Nonnull String env, ApiCallback<List<MetricByVariation>> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigMetricsByVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, from, to, env, _callback);
        Type localVarReturnType = new TypeToken<List<MetricByVariation>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigTargetingCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/targeting".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigTargetingValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigTargeting(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigTargeting(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfigTargeting(Async)");
        }
        return this.getAIConfigTargetingCall(ldAPIVersion, projectKey, configKey, _callback);
    }

    public AIConfigTargeting getAIConfigTargeting(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey) throws ApiException {
        ApiResponse<AIConfigTargeting> localVarResp = this.getAIConfigTargetingWithHttpInfo(ldAPIVersion, projectKey, configKey);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigTargeting> getAIConfigTargetingWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey) throws ApiException {
        Call localVarCall = this.getAIConfigTargetingValidateBeforeCall(ldAPIVersion, projectKey, configKey, null);
        Type localVarReturnType = new TypeToken<AIConfigTargeting>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigTargetingAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, ApiCallback<AIConfigTargeting> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigTargetingValidateBeforeCall(ldAPIVersion, projectKey, configKey, _callback);
        Type localVarReturnType = new TypeToken<AIConfigTargeting>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigVariationCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/variations/{variationKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString())).replace("{variationKey}", this.localVarApiClient.escapeString(variationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigVariationValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling getAIConfigVariation(Async)");
        }
        if (variationKey == null) {
            throw new ApiException("Missing the required parameter 'variationKey' when calling getAIConfigVariation(Async)");
        }
        return this.getAIConfigVariationCall(ldAPIVersion, projectKey, configKey, variationKey, _callback);
    }

    public AIConfigVariationsResponse getAIConfigVariation(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey) throws ApiException {
        ApiResponse<AIConfigVariationsResponse> localVarResp = this.getAIConfigVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, variationKey);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigVariationsResponse> getAIConfigVariationWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey) throws ApiException {
        Call localVarCall = this.getAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, null);
        Type localVarReturnType = new TypeToken<AIConfigVariationsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigVariationAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, ApiCallback<AIConfigVariationsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, _callback);
        Type localVarReturnType = new TypeToken<AIConfigVariationsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIConfigsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIConfigsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAIConfigs(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAIConfigs(Async)");
        }
        return this.getAIConfigsCall(ldAPIVersion, projectKey, sort, limit, offset, filter, _callback);
    }

    public AIConfigs getAIConfigs(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter) throws ApiException {
        ApiResponse<AIConfigs> localVarResp = this.getAIConfigsWithHttpInfo(ldAPIVersion, projectKey, sort, limit, offset, filter);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigs> getAIConfigsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter) throws ApiException {
        Call localVarCall = this.getAIConfigsValidateBeforeCall(ldAPIVersion, projectKey, sort, limit, offset, filter, null);
        Type localVarReturnType = new TypeToken<AIConfigs>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIConfigsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, ApiCallback<AIConfigs> _callback) throws ApiException {
        Call localVarCall = this.getAIConfigsValidateBeforeCall(ldAPIVersion, projectKey, sort, limit, offset, filter, _callback);
        Type localVarReturnType = new TypeToken<AIConfigs>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAIToolCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-tools/{toolKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{toolKey}", this.localVarApiClient.escapeString(toolKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAIToolValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getAITool(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAITool(Async)");
        }
        if (toolKey == null) {
            throw new ApiException("Missing the required parameter 'toolKey' when calling getAITool(Async)");
        }
        return this.getAIToolCall(ldAPIVersion, projectKey, toolKey, _callback);
    }

    public AITool getAITool(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey) throws ApiException {
        ApiResponse<AITool> localVarResp = this.getAIToolWithHttpInfo(ldAPIVersion, projectKey, toolKey);
        return localVarResp.getData();
    }

    public ApiResponse<AITool> getAIToolWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey) throws ApiException {
        Call localVarCall = this.getAIToolValidateBeforeCall(ldAPIVersion, projectKey, toolKey, null);
        Type localVarReturnType = new TypeToken<AITool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAIToolAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, ApiCallback<AITool> _callback) throws ApiException {
        Call localVarCall = this.getAIToolValidateBeforeCall(ldAPIVersion, projectKey, toolKey, _callback);
        Type localVarReturnType = new TypeToken<AITool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getModelConfigCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs/{modelConfigKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{modelConfigKey}", this.localVarApiClient.escapeString(modelConfigKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getModelConfigValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getModelConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getModelConfig(Async)");
        }
        if (modelConfigKey == null) {
            throw new ApiException("Missing the required parameter 'modelConfigKey' when calling getModelConfig(Async)");
        }
        return this.getModelConfigCall(ldAPIVersion, projectKey, modelConfigKey, _callback);
    }

    public ModelConfig getModelConfig(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey) throws ApiException {
        ApiResponse<ModelConfig> localVarResp = this.getModelConfigWithHttpInfo(ldAPIVersion, projectKey, modelConfigKey);
        return localVarResp.getData();
    }

    public ApiResponse<ModelConfig> getModelConfigWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey) throws ApiException {
        Call localVarCall = this.getModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigKey, null);
        Type localVarReturnType = new TypeToken<ModelConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getModelConfigAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String modelConfigKey, ApiCallback<ModelConfig> _callback) throws ApiException {
        Call localVarCall = this.getModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigKey, _callback);
        Type localVarReturnType = new TypeToken<ModelConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listAIToolVersionsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-tools/{toolKey}/versions".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{toolKey}", this.localVarApiClient.escapeString(toolKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAIToolVersionsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling listAIToolVersions(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling listAIToolVersions(Async)");
        }
        if (toolKey == null) {
            throw new ApiException("Missing the required parameter 'toolKey' when calling listAIToolVersions(Async)");
        }
        return this.listAIToolVersionsCall(ldAPIVersion, projectKey, toolKey, sort, limit, offset, _callback);
    }

    public AITools listAIToolVersions(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset) throws ApiException {
        ApiResponse<AITools> localVarResp = this.listAIToolVersionsWithHttpInfo(ldAPIVersion, projectKey, toolKey, sort, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<AITools> listAIToolVersionsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset) throws ApiException {
        Call localVarCall = this.listAIToolVersionsValidateBeforeCall(ldAPIVersion, projectKey, toolKey, sort, limit, offset, null);
        Type localVarReturnType = new TypeToken<AITools>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listAIToolVersionsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, ApiCallback<AITools> _callback) throws ApiException {
        Call localVarCall = this.listAIToolVersionsValidateBeforeCall(ldAPIVersion, projectKey, toolKey, sort, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<AITools>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listAIToolsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-tools".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAIToolsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling listAITools(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling listAITools(Async)");
        }
        return this.listAIToolsCall(ldAPIVersion, projectKey, sort, limit, offset, filter, _callback);
    }

    public AITools listAITools(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter) throws ApiException {
        ApiResponse<AITools> localVarResp = this.listAIToolsWithHttpInfo(ldAPIVersion, projectKey, sort, limit, offset, filter);
        return localVarResp.getData();
    }

    public ApiResponse<AITools> listAIToolsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter) throws ApiException {
        Call localVarCall = this.listAIToolsValidateBeforeCall(ldAPIVersion, projectKey, sort, limit, offset, filter, null);
        Type localVarReturnType = new TypeToken<AITools>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listAIToolsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, ApiCallback<AITools> _callback) throws ApiException {
        Call localVarCall = this.listAIToolsValidateBeforeCall(ldAPIVersion, projectKey, sort, limit, offset, filter, _callback);
        Type localVarReturnType = new TypeToken<AITools>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listModelConfigsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable Boolean restricted, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (restricted != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("restricted", restricted));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listModelConfigsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable Boolean restricted, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling listModelConfigs(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling listModelConfigs(Async)");
        }
        return this.listModelConfigsCall(ldAPIVersion, projectKey, restricted, _callback);
    }

    public List<ModelConfig> listModelConfigs(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable Boolean restricted) throws ApiException {
        ApiResponse<List<ModelConfig>> localVarResp = this.listModelConfigsWithHttpInfo(ldAPIVersion, projectKey, restricted);
        return localVarResp.getData();
    }

    public ApiResponse<List<ModelConfig>> listModelConfigsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable Boolean restricted) throws ApiException {
        Call localVarCall = this.listModelConfigsValidateBeforeCall(ldAPIVersion, projectKey, restricted, null);
        Type localVarReturnType = new TypeToken<List<ModelConfig>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listModelConfigsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable Boolean restricted, ApiCallback<List<ModelConfig>> _callback) throws ApiException {
        Call localVarCall = this.listModelConfigsValidateBeforeCall(ldAPIVersion, projectKey, restricted, _callback);
        Type localVarReturnType = new TypeToken<List<ModelConfig>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchAIConfigCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigPatch aiConfigPatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigPatch localVarPostBody = aiConfigPatch;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchAIConfigValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigPatch aiConfigPatch, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling patchAIConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchAIConfig(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling patchAIConfig(Async)");
        }
        return this.patchAIConfigCall(ldAPIVersion, projectKey, configKey, aiConfigPatch, _callback);
    }

    public AIConfig patchAIConfig(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigPatch aiConfigPatch) throws ApiException {
        ApiResponse<AIConfig> localVarResp = this.patchAIConfigWithHttpInfo(ldAPIVersion, projectKey, configKey, aiConfigPatch);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfig> patchAIConfigWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigPatch aiConfigPatch) throws ApiException {
        Call localVarCall = this.patchAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigPatch, null);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchAIConfigAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigPatch aiConfigPatch, ApiCallback<AIConfig> _callback) throws ApiException {
        Call localVarCall = this.patchAIConfigValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigPatch, _callback);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchAIConfigTargetingCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigTargetingPatch aiConfigTargetingPatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigTargetingPatch localVarPostBody = aiConfigTargetingPatch;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/targeting".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchAIConfigTargetingValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigTargetingPatch aiConfigTargetingPatch, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling patchAIConfigTargeting(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchAIConfigTargeting(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling patchAIConfigTargeting(Async)");
        }
        return this.patchAIConfigTargetingCall(ldAPIVersion, projectKey, configKey, aiConfigTargetingPatch, _callback);
    }

    public AIConfigTargeting patchAIConfigTargeting(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigTargetingPatch aiConfigTargetingPatch) throws ApiException {
        ApiResponse<AIConfigTargeting> localVarResp = this.patchAIConfigTargetingWithHttpInfo(ldAPIVersion, projectKey, configKey, aiConfigTargetingPatch);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigTargeting> patchAIConfigTargetingWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigTargetingPatch aiConfigTargetingPatch) throws ApiException {
        Call localVarCall = this.patchAIConfigTargetingValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigTargetingPatch, null);
        Type localVarReturnType = new TypeToken<AIConfigTargeting>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchAIConfigTargetingAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nullable AIConfigTargetingPatch aiConfigTargetingPatch, ApiCallback<AIConfigTargeting> _callback) throws ApiException {
        Call localVarCall = this.patchAIConfigTargetingValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigTargetingPatch, _callback);
        Type localVarReturnType = new TypeToken<AIConfigTargeting>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchAIConfigVariationCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, @Nullable AIConfigVariationPatch aiConfigVariationPatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigVariationPatch localVarPostBody = aiConfigVariationPatch;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/variations/{variationKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString())).replace("{variationKey}", this.localVarApiClient.escapeString(variationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchAIConfigVariationValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, @Nullable AIConfigVariationPatch aiConfigVariationPatch, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling patchAIConfigVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchAIConfigVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling patchAIConfigVariation(Async)");
        }
        if (variationKey == null) {
            throw new ApiException("Missing the required parameter 'variationKey' when calling patchAIConfigVariation(Async)");
        }
        return this.patchAIConfigVariationCall(ldAPIVersion, projectKey, configKey, variationKey, aiConfigVariationPatch, _callback);
    }

    public AIConfigVariation patchAIConfigVariation(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, @Nullable AIConfigVariationPatch aiConfigVariationPatch) throws ApiException {
        ApiResponse<AIConfigVariation> localVarResp = this.patchAIConfigVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, variationKey, aiConfigVariationPatch);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigVariation> patchAIConfigVariationWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, @Nullable AIConfigVariationPatch aiConfigVariationPatch) throws ApiException {
        Call localVarCall = this.patchAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, aiConfigVariationPatch, null);
        Type localVarReturnType = new TypeToken<AIConfigVariation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchAIConfigVariationAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull String variationKey, @Nullable AIConfigVariationPatch aiConfigVariationPatch, ApiCallback<AIConfigVariation> _callback) throws ApiException {
        Call localVarCall = this.patchAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, variationKey, aiConfigVariationPatch, _callback);
        Type localVarReturnType = new TypeToken<AIConfigVariation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchAIToolCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable AIToolPatch aiToolPatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIToolPatch localVarPostBody = aiToolPatch;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-tools/{toolKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{toolKey}", this.localVarApiClient.escapeString(toolKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchAIToolValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable AIToolPatch aiToolPatch, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling patchAITool(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchAITool(Async)");
        }
        if (toolKey == null) {
            throw new ApiException("Missing the required parameter 'toolKey' when calling patchAITool(Async)");
        }
        return this.patchAIToolCall(ldAPIVersion, projectKey, toolKey, aiToolPatch, _callback);
    }

    public AITool patchAITool(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable AIToolPatch aiToolPatch) throws ApiException {
        ApiResponse<AITool> localVarResp = this.patchAIToolWithHttpInfo(ldAPIVersion, projectKey, toolKey, aiToolPatch);
        return localVarResp.getData();
    }

    public ApiResponse<AITool> patchAIToolWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable AIToolPatch aiToolPatch) throws ApiException {
        Call localVarCall = this.patchAIToolValidateBeforeCall(ldAPIVersion, projectKey, toolKey, aiToolPatch, null);
        Type localVarReturnType = new TypeToken<AITool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchAIToolAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String toolKey, @Nullable AIToolPatch aiToolPatch, ApiCallback<AITool> _callback) throws ApiException {
        Call localVarCall = this.patchAIToolValidateBeforeCall(ldAPIVersion, projectKey, toolKey, aiToolPatch, _callback);
        Type localVarReturnType = new TypeToken<AITool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postAIConfigCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIConfigPost aiConfigPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigPost localVarPostBody = aiConfigPost;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAIConfigValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIConfigPost aiConfigPost, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling postAIConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postAIConfig(Async)");
        }
        if (aiConfigPost == null) {
            throw new ApiException("Missing the required parameter 'aiConfigPost' when calling postAIConfig(Async)");
        }
        return this.postAIConfigCall(ldAPIVersion, projectKey, aiConfigPost, _callback);
    }

    public AIConfig postAIConfig(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIConfigPost aiConfigPost) throws ApiException {
        ApiResponse<AIConfig> localVarResp = this.postAIConfigWithHttpInfo(ldAPIVersion, projectKey, aiConfigPost);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfig> postAIConfigWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIConfigPost aiConfigPost) throws ApiException {
        Call localVarCall = this.postAIConfigValidateBeforeCall(ldAPIVersion, projectKey, aiConfigPost, null);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postAIConfigAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIConfigPost aiConfigPost, ApiCallback<AIConfig> _callback) throws ApiException {
        Call localVarCall = this.postAIConfigValidateBeforeCall(ldAPIVersion, projectKey, aiConfigPost, _callback);
        Type localVarReturnType = new TypeToken<AIConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postAIConfigVariationCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull AIConfigVariationPost aiConfigVariationPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIConfigVariationPost localVarPostBody = aiConfigVariationPost;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/{configKey}/variations".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{configKey}", this.localVarApiClient.escapeString(configKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAIConfigVariationValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull AIConfigVariationPost aiConfigVariationPost, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling postAIConfigVariation(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postAIConfigVariation(Async)");
        }
        if (configKey == null) {
            throw new ApiException("Missing the required parameter 'configKey' when calling postAIConfigVariation(Async)");
        }
        if (aiConfigVariationPost == null) {
            throw new ApiException("Missing the required parameter 'aiConfigVariationPost' when calling postAIConfigVariation(Async)");
        }
        return this.postAIConfigVariationCall(ldAPIVersion, projectKey, configKey, aiConfigVariationPost, _callback);
    }

    public AIConfigVariation postAIConfigVariation(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull AIConfigVariationPost aiConfigVariationPost) throws ApiException {
        ApiResponse<AIConfigVariation> localVarResp = this.postAIConfigVariationWithHttpInfo(ldAPIVersion, projectKey, configKey, aiConfigVariationPost);
        return localVarResp.getData();
    }

    public ApiResponse<AIConfigVariation> postAIConfigVariationWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull AIConfigVariationPost aiConfigVariationPost) throws ApiException {
        Call localVarCall = this.postAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigVariationPost, null);
        Type localVarReturnType = new TypeToken<AIConfigVariation>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postAIConfigVariationAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String configKey, @Nonnull AIConfigVariationPost aiConfigVariationPost, ApiCallback<AIConfigVariation> _callback) throws ApiException {
        Call localVarCall = this.postAIConfigVariationValidateBeforeCall(ldAPIVersion, projectKey, configKey, aiConfigVariationPost, _callback);
        Type localVarReturnType = new TypeToken<AIConfigVariation>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postAIToolCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIToolPost aiToolPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AIToolPost localVarPostBody = aiToolPost;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-tools".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postAIToolValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIToolPost aiToolPost, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling postAITool(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postAITool(Async)");
        }
        if (aiToolPost == null) {
            throw new ApiException("Missing the required parameter 'aiToolPost' when calling postAITool(Async)");
        }
        return this.postAIToolCall(ldAPIVersion, projectKey, aiToolPost, _callback);
    }

    public AITool postAITool(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIToolPost aiToolPost) throws ApiException {
        ApiResponse<AITool> localVarResp = this.postAIToolWithHttpInfo(ldAPIVersion, projectKey, aiToolPost);
        return localVarResp.getData();
    }

    public ApiResponse<AITool> postAIToolWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIToolPost aiToolPost) throws ApiException {
        Call localVarCall = this.postAIToolValidateBeforeCall(ldAPIVersion, projectKey, aiToolPost, null);
        Type localVarReturnType = new TypeToken<AITool>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postAIToolAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull AIToolPost aiToolPost, ApiCallback<AITool> _callback) throws ApiException {
        Call localVarCall = this.postAIToolValidateBeforeCall(ldAPIVersion, projectKey, aiToolPost, _callback);
        Type localVarReturnType = new TypeToken<AITool>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postModelConfigCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ModelConfigPost modelConfigPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ModelConfigPost localVarPostBody = modelConfigPost;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postModelConfigValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ModelConfigPost modelConfigPost, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling postModelConfig(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postModelConfig(Async)");
        }
        if (modelConfigPost == null) {
            throw new ApiException("Missing the required parameter 'modelConfigPost' when calling postModelConfig(Async)");
        }
        return this.postModelConfigCall(ldAPIVersion, projectKey, modelConfigPost, _callback);
    }

    public ModelConfig postModelConfig(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ModelConfigPost modelConfigPost) throws ApiException {
        ApiResponse<ModelConfig> localVarResp = this.postModelConfigWithHttpInfo(ldAPIVersion, projectKey, modelConfigPost);
        return localVarResp.getData();
    }

    public ApiResponse<ModelConfig> postModelConfigWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ModelConfigPost modelConfigPost) throws ApiException {
        Call localVarCall = this.postModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigPost, null);
        Type localVarReturnType = new TypeToken<ModelConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postModelConfigAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ModelConfigPost modelConfigPost, ApiCallback<ModelConfig> _callback) throws ApiException {
        Call localVarCall = this.postModelConfigValidateBeforeCall(ldAPIVersion, projectKey, modelConfigPost, _callback);
        Type localVarReturnType = new TypeToken<ModelConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postRestrictedModelsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RestrictedModelsRequest localVarPostBody = restrictedModelsRequest;
        String localVarPath = "/api/v2/projects/{projectKey}/ai-configs/model-configs/restricted".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postRestrictedModelsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling postRestrictedModels(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postRestrictedModels(Async)");
        }
        if (restrictedModelsRequest == null) {
            throw new ApiException("Missing the required parameter 'restrictedModelsRequest' when calling postRestrictedModels(Async)");
        }
        return this.postRestrictedModelsCall(ldAPIVersion, projectKey, restrictedModelsRequest, _callback);
    }

    public RestrictedModelsResponse postRestrictedModels(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest) throws ApiException {
        ApiResponse<RestrictedModelsResponse> localVarResp = this.postRestrictedModelsWithHttpInfo(ldAPIVersion, projectKey, restrictedModelsRequest);
        return localVarResp.getData();
    }

    public ApiResponse<RestrictedModelsResponse> postRestrictedModelsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest) throws ApiException {
        Call localVarCall = this.postRestrictedModelsValidateBeforeCall(ldAPIVersion, projectKey, restrictedModelsRequest, null);
        Type localVarReturnType = new TypeToken<RestrictedModelsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postRestrictedModelsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull RestrictedModelsRequest restrictedModelsRequest, ApiCallback<RestrictedModelsResponse> _callback) throws ApiException {
        Call localVarCall = this.postRestrictedModelsValidateBeforeCall(ldAPIVersion, projectKey, restrictedModelsRequest, _callback);
        Type localVarReturnType = new TypeToken<RestrictedModelsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

