/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.ApprovalRequestSettingWithEnvs;
import com.launchdarkly.api.model.ApprovalRequestSettingsPatch;
import com.launchdarkly.api.model.FlagConfigApprovalRequestResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ApprovalsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ApprovalsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApprovalsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getApprovalRequestSettingsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String environmentKey, @Nullable String resourceKind, @Nullable String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/approval-requests/projects/{projectKey}/settings".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (environmentKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("environmentKey", environmentKey));
        }
        if (resourceKind != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceKind", resourceKind));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getApprovalRequestSettingsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String environmentKey, @Nullable String resourceKind, @Nullable String expand, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getApprovalRequestSettings(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getApprovalRequestSettings(Async)");
        }
        return this.getApprovalRequestSettingsCall(ldAPIVersion, projectKey, environmentKey, resourceKind, expand, _callback);
    }

    public Map<String, ApprovalRequestSettingWithEnvs> getApprovalRequestSettings(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String environmentKey, @Nullable String resourceKind, @Nullable String expand) throws ApiException {
        ApiResponse<Map<String, ApprovalRequestSettingWithEnvs>> localVarResp = this.getApprovalRequestSettingsWithHttpInfo(ldAPIVersion, projectKey, environmentKey, resourceKind, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, ApprovalRequestSettingWithEnvs>> getApprovalRequestSettingsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String environmentKey, @Nullable String resourceKind, @Nullable String expand) throws ApiException {
        Call localVarCall = this.getApprovalRequestSettingsValidateBeforeCall(ldAPIVersion, projectKey, environmentKey, resourceKind, expand, null);
        Type localVarReturnType = new TypeToken<Map<String, ApprovalRequestSettingWithEnvs>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getApprovalRequestSettingsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String environmentKey, @Nullable String resourceKind, @Nullable String expand, ApiCallback<Map<String, ApprovalRequestSettingWithEnvs>> _callback) throws ApiException {
        Call localVarCall = this.getApprovalRequestSettingsValidateBeforeCall(ldAPIVersion, projectKey, environmentKey, resourceKind, expand, _callback);
        Type localVarReturnType = new TypeToken<Map<String, ApprovalRequestSettingWithEnvs>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchApprovalRequestCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/approval-requests/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchApprovalRequestValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling patchApprovalRequest(Async)");
        }
        return this.patchApprovalRequestCall(id, _callback);
    }

    public FlagConfigApprovalRequestResponse patchApprovalRequest(@Nonnull String id) throws ApiException {
        ApiResponse<FlagConfigApprovalRequestResponse> localVarResp = this.patchApprovalRequestWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<FlagConfigApprovalRequestResponse> patchApprovalRequestWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.patchApprovalRequestValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<FlagConfigApprovalRequestResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchApprovalRequestAsync(@Nonnull String id, ApiCallback<FlagConfigApprovalRequestResponse> _callback) throws ApiException {
        Call localVarCall = this.patchApprovalRequestValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<FlagConfigApprovalRequestResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchApprovalRequestSettingsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable ApprovalRequestSettingsPatch approvalRequestSettingsPatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApprovalRequestSettingsPatch localVarPostBody = approvalRequestSettingsPatch;
        String localVarPath = "/api/v2/approval-requests/projects/{projectKey}/settings".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchApprovalRequestSettingsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable ApprovalRequestSettingsPatch approvalRequestSettingsPatch, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling patchApprovalRequestSettings(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchApprovalRequestSettings(Async)");
        }
        return this.patchApprovalRequestSettingsCall(ldAPIVersion, projectKey, approvalRequestSettingsPatch, _callback);
    }

    public Map<String, ApprovalRequestSettingWithEnvs> patchApprovalRequestSettings(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable ApprovalRequestSettingsPatch approvalRequestSettingsPatch) throws ApiException {
        ApiResponse<Map<String, ApprovalRequestSettingWithEnvs>> localVarResp = this.patchApprovalRequestSettingsWithHttpInfo(ldAPIVersion, projectKey, approvalRequestSettingsPatch);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, ApprovalRequestSettingWithEnvs>> patchApprovalRequestSettingsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable ApprovalRequestSettingsPatch approvalRequestSettingsPatch) throws ApiException {
        Call localVarCall = this.patchApprovalRequestSettingsValidateBeforeCall(ldAPIVersion, projectKey, approvalRequestSettingsPatch, null);
        Type localVarReturnType = new TypeToken<Map<String, ApprovalRequestSettingWithEnvs>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchApprovalRequestSettingsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable ApprovalRequestSettingsPatch approvalRequestSettingsPatch, ApiCallback<Map<String, ApprovalRequestSettingWithEnvs>> _callback) throws ApiException {
        Call localVarCall = this.patchApprovalRequestSettingsValidateBeforeCall(ldAPIVersion, projectKey, approvalRequestSettingsPatch, _callback);
        Type localVarReturnType = new TypeToken<Map<String, ApprovalRequestSettingWithEnvs>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFlagConfigApprovalRequestCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{id}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFlagConfigApprovalRequestValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchFlagConfigApprovalRequest(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchFlagConfigApprovalRequest(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchFlagConfigApprovalRequest(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling patchFlagConfigApprovalRequest(Async)");
        }
        return this.patchFlagConfigApprovalRequestCall(projectKey, featureFlagKey, environmentKey, id, _callback);
    }

    public FlagConfigApprovalRequestResponse patchFlagConfigApprovalRequest(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id) throws ApiException {
        ApiResponse<FlagConfigApprovalRequestResponse> localVarResp = this.patchFlagConfigApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, id);
        return localVarResp.getData();
    }

    public ApiResponse<FlagConfigApprovalRequestResponse> patchFlagConfigApprovalRequestWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id) throws ApiException {
        Call localVarCall = this.patchFlagConfigApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, id, null);
        Type localVarReturnType = new TypeToken<FlagConfigApprovalRequestResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFlagConfigApprovalRequestAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id, ApiCallback<FlagConfigApprovalRequestResponse> _callback) throws ApiException {
        Call localVarCall = this.patchFlagConfigApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, id, _callback);
        Type localVarReturnType = new TypeToken<FlagConfigApprovalRequestResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

