/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.Experiment;
import com.launchdarkly.api.model.ExperimentCollectionRep;
import com.launchdarkly.api.model.ExperimentPatchInput;
import com.launchdarkly.api.model.ExperimentPost;
import com.launchdarkly.api.model.IterationInput;
import com.launchdarkly.api.model.IterationRep;
import com.launchdarkly.api.model.RandomizationSettingsPut;
import com.launchdarkly.api.model.RandomizationSettingsRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ExperimentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExperimentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExperimentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createExperimentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull ExperimentPost experimentPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExperimentPost localVarPostBody = experimentPost;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createExperimentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull ExperimentPost experimentPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createExperiment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createExperiment(Async)");
        }
        if (experimentPost == null) {
            throw new ApiException("Missing the required parameter 'experimentPost' when calling createExperiment(Async)");
        }
        return this.createExperimentCall(projectKey, environmentKey, experimentPost, _callback);
    }

    public Experiment createExperiment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull ExperimentPost experimentPost) throws ApiException {
        ApiResponse<Experiment> localVarResp = this.createExperimentWithHttpInfo(projectKey, environmentKey, experimentPost);
        return localVarResp.getData();
    }

    public ApiResponse<Experiment> createExperimentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull ExperimentPost experimentPost) throws ApiException {
        Call localVarCall = this.createExperimentValidateBeforeCall(projectKey, environmentKey, experimentPost, null);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createExperimentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull ExperimentPost experimentPost, ApiCallback<Experiment> _callback) throws ApiException {
        Call localVarCall = this.createExperimentValidateBeforeCall(projectKey, environmentKey, experimentPost, _callback);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createIterationCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull IterationInput iterationInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IterationInput localVarPostBody = iterationInput;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments/{experimentKey}/iterations".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{experimentKey}", this.localVarApiClient.escapeString(experimentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIterationValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull IterationInput iterationInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createIteration(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createIteration(Async)");
        }
        if (experimentKey == null) {
            throw new ApiException("Missing the required parameter 'experimentKey' when calling createIteration(Async)");
        }
        if (iterationInput == null) {
            throw new ApiException("Missing the required parameter 'iterationInput' when calling createIteration(Async)");
        }
        return this.createIterationCall(projectKey, environmentKey, experimentKey, iterationInput, _callback);
    }

    public IterationRep createIteration(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull IterationInput iterationInput) throws ApiException {
        ApiResponse<IterationRep> localVarResp = this.createIterationWithHttpInfo(projectKey, environmentKey, experimentKey, iterationInput);
        return localVarResp.getData();
    }

    public ApiResponse<IterationRep> createIterationWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull IterationInput iterationInput) throws ApiException {
        Call localVarCall = this.createIterationValidateBeforeCall(projectKey, environmentKey, experimentKey, iterationInput, null);
        Type localVarReturnType = new TypeToken<IterationRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIterationAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull IterationInput iterationInput, ApiCallback<IterationRep> _callback) throws ApiException {
        Call localVarCall = this.createIterationValidateBeforeCall(projectKey, environmentKey, experimentKey, iterationInput, _callback);
        Type localVarReturnType = new TypeToken<IterationRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nullable String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments/{experimentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{experimentKey}", this.localVarApiClient.escapeString(experimentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nullable String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExperiment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExperiment(Async)");
        }
        if (experimentKey == null) {
            throw new ApiException("Missing the required parameter 'experimentKey' when calling getExperiment(Async)");
        }
        return this.getExperimentCall(projectKey, environmentKey, experimentKey, expand, _callback);
    }

    public Experiment getExperiment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nullable String expand) throws ApiException {
        ApiResponse<Experiment> localVarResp = this.getExperimentWithHttpInfo(projectKey, environmentKey, experimentKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Experiment> getExperimentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nullable String expand) throws ApiException {
        Call localVarCall = this.getExperimentValidateBeforeCall(projectKey, environmentKey, experimentKey, expand, null);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nullable String expand, ApiCallback<Experiment> _callback) throws ApiException {
        Call localVarCall = this.getExperimentValidateBeforeCall(projectKey, environmentKey, experimentKey, expand, _callback);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentationSettingsCall(@Nonnull String projectKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/experimentation-settings".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentationSettingsValidateBeforeCall(@Nonnull String projectKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExperimentationSettings(Async)");
        }
        return this.getExperimentationSettingsCall(projectKey, _callback);
    }

    public RandomizationSettingsRep getExperimentationSettings(@Nonnull String projectKey) throws ApiException {
        ApiResponse<RandomizationSettingsRep> localVarResp = this.getExperimentationSettingsWithHttpInfo(projectKey);
        return localVarResp.getData();
    }

    public ApiResponse<RandomizationSettingsRep> getExperimentationSettingsWithHttpInfo(@Nonnull String projectKey) throws ApiException {
        Call localVarCall = this.getExperimentationSettingsValidateBeforeCall(projectKey, null);
        Type localVarReturnType = new TypeToken<RandomizationSettingsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentationSettingsAsync(@Nonnull String projectKey, ApiCallback<RandomizationSettingsRep> _callback) throws ApiException {
        Call localVarCall = this.getExperimentationSettingsValidateBeforeCall(projectKey, _callback);
        Type localVarReturnType = new TypeToken<RandomizationSettingsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExperimentsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String filter, @Nullable String expand, @Nullable String lifecycleState, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if (lifecycleState != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lifecycleState", lifecycleState));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExperimentsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String filter, @Nullable String expand, @Nullable String lifecycleState, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExperiments(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExperiments(Async)");
        }
        return this.getExperimentsCall(projectKey, environmentKey, limit, offset, filter, expand, lifecycleState, _callback);
    }

    public ExperimentCollectionRep getExperiments(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String filter, @Nullable String expand, @Nullable String lifecycleState) throws ApiException {
        ApiResponse<ExperimentCollectionRep> localVarResp = this.getExperimentsWithHttpInfo(projectKey, environmentKey, limit, offset, filter, expand, lifecycleState);
        return localVarResp.getData();
    }

    public ApiResponse<ExperimentCollectionRep> getExperimentsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String filter, @Nullable String expand, @Nullable String lifecycleState) throws ApiException {
        Call localVarCall = this.getExperimentsValidateBeforeCall(projectKey, environmentKey, limit, offset, filter, expand, lifecycleState, null);
        Type localVarReturnType = new TypeToken<ExperimentCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExperimentsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String filter, @Nullable String expand, @Nullable String lifecycleState, ApiCallback<ExperimentCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getExperimentsValidateBeforeCall(projectKey, environmentKey, limit, offset, filter, expand, lifecycleState, _callback);
        Type localVarReturnType = new TypeToken<ExperimentCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExperimentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull ExperimentPatchInput experimentPatchInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExperimentPatchInput localVarPostBody = experimentPatchInput;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/experiments/{experimentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{experimentKey}", this.localVarApiClient.escapeString(experimentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExperimentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull ExperimentPatchInput experimentPatchInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExperiment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExperiment(Async)");
        }
        if (experimentKey == null) {
            throw new ApiException("Missing the required parameter 'experimentKey' when calling patchExperiment(Async)");
        }
        if (experimentPatchInput == null) {
            throw new ApiException("Missing the required parameter 'experimentPatchInput' when calling patchExperiment(Async)");
        }
        return this.patchExperimentCall(projectKey, environmentKey, experimentKey, experimentPatchInput, _callback);
    }

    public Experiment patchExperiment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull ExperimentPatchInput experimentPatchInput) throws ApiException {
        ApiResponse<Experiment> localVarResp = this.patchExperimentWithHttpInfo(projectKey, environmentKey, experimentKey, experimentPatchInput);
        return localVarResp.getData();
    }

    public ApiResponse<Experiment> patchExperimentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull ExperimentPatchInput experimentPatchInput) throws ApiException {
        Call localVarCall = this.patchExperimentValidateBeforeCall(projectKey, environmentKey, experimentKey, experimentPatchInput, null);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExperimentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String experimentKey, @Nonnull ExperimentPatchInput experimentPatchInput, ApiCallback<Experiment> _callback) throws ApiException {
        Call localVarCall = this.patchExperimentValidateBeforeCall(projectKey, environmentKey, experimentKey, experimentPatchInput, _callback);
        Type localVarReturnType = new TypeToken<Experiment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putExperimentationSettingsCall(@Nonnull String projectKey, @Nonnull RandomizationSettingsPut randomizationSettingsPut, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RandomizationSettingsPut localVarPostBody = randomizationSettingsPut;
        String localVarPath = "/api/v2/projects/{projectKey}/experimentation-settings".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putExperimentationSettingsValidateBeforeCall(@Nonnull String projectKey, @Nonnull RandomizationSettingsPut randomizationSettingsPut, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling putExperimentationSettings(Async)");
        }
        if (randomizationSettingsPut == null) {
            throw new ApiException("Missing the required parameter 'randomizationSettingsPut' when calling putExperimentationSettings(Async)");
        }
        return this.putExperimentationSettingsCall(projectKey, randomizationSettingsPut, _callback);
    }

    public RandomizationSettingsRep putExperimentationSettings(@Nonnull String projectKey, @Nonnull RandomizationSettingsPut randomizationSettingsPut) throws ApiException {
        ApiResponse<RandomizationSettingsRep> localVarResp = this.putExperimentationSettingsWithHttpInfo(projectKey, randomizationSettingsPut);
        return localVarResp.getData();
    }

    public ApiResponse<RandomizationSettingsRep> putExperimentationSettingsWithHttpInfo(@Nonnull String projectKey, @Nonnull RandomizationSettingsPut randomizationSettingsPut) throws ApiException {
        Call localVarCall = this.putExperimentationSettingsValidateBeforeCall(projectKey, randomizationSettingsPut, null);
        Type localVarReturnType = new TypeToken<RandomizationSettingsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call putExperimentationSettingsAsync(@Nonnull String projectKey, @Nonnull RandomizationSettingsPut randomizationSettingsPut, ApiCallback<RandomizationSettingsRep> _callback) throws ApiException {
        Call localVarCall = this.putExperimentationSettingsValidateBeforeCall(projectKey, randomizationSettingsPut, _callback);
        Type localVarReturnType = new TypeToken<RandomizationSettingsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

