/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.ExpiringTargetGetResponse;
import com.launchdarkly.api.model.ExpiringTargetPatchResponse;
import com.launchdarkly.api.model.ExpiringUserTargetGetResponse;
import com.launchdarkly.api.model.ExpiringUserTargetPatchResponse;
import com.launchdarkly.api.model.FeatureFlag;
import com.launchdarkly.api.model.FeatureFlagBody;
import com.launchdarkly.api.model.FeatureFlagStatusAcrossEnvironments;
import com.launchdarkly.api.model.FeatureFlagStatuses;
import com.launchdarkly.api.model.FeatureFlags;
import com.launchdarkly.api.model.FlagCopyConfigPost;
import com.launchdarkly.api.model.FlagSempatch;
import com.launchdarkly.api.model.FlagStatusRep;
import com.launchdarkly.api.model.MigrationSafetyIssueRep;
import com.launchdarkly.api.model.PatchFlagsRequest;
import com.launchdarkly.api.model.PatchWithComment;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class FeatureFlagsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FeatureFlagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FeatureFlagsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call copyFeatureFlagCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull FlagCopyConfigPost flagCopyConfigPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlagCopyConfigPost localVarPostBody = flagCopyConfigPost;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/copy".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call copyFeatureFlagValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull FlagCopyConfigPost flagCopyConfigPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling copyFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling copyFeatureFlag(Async)");
        }
        if (flagCopyConfigPost == null) {
            throw new ApiException("Missing the required parameter 'flagCopyConfigPost' when calling copyFeatureFlag(Async)");
        }
        return this.copyFeatureFlagCall(projectKey, featureFlagKey, flagCopyConfigPost, _callback);
    }

    public FeatureFlag copyFeatureFlag(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull FlagCopyConfigPost flagCopyConfigPost) throws ApiException {
        ApiResponse<FeatureFlag> localVarResp = this.copyFeatureFlagWithHttpInfo(projectKey, featureFlagKey, flagCopyConfigPost);
        return localVarResp.getData();
    }

    public ApiResponse<FeatureFlag> copyFeatureFlagWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull FlagCopyConfigPost flagCopyConfigPost) throws ApiException {
        Call localVarCall = this.copyFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, flagCopyConfigPost, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call copyFeatureFlagAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull FlagCopyConfigPost flagCopyConfigPost, ApiCallback<FeatureFlag> _callback) throws ApiException {
        Call localVarCall = this.copyFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, flagCopyConfigPost, _callback);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFeatureFlagCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFeatureFlagValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteFeatureFlag(Async)");
        }
        return this.deleteFeatureFlagCall(projectKey, featureFlagKey, _callback);
    }

    public void deleteFeatureFlag(@Nonnull String projectKey, @Nonnull String featureFlagKey) throws ApiException {
        this.deleteFeatureFlagWithHttpInfo(projectKey, featureFlagKey);
    }

    public ApiResponse<Void> deleteFeatureFlagWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey) throws ApiException {
        Call localVarCall = this.deleteFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteFeatureFlagAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getExpiringContextTargetsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/expiring-targets/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiringContextTargetsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringContextTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringContextTargets(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getExpiringContextTargets(Async)");
        }
        return this.getExpiringContextTargetsCall(projectKey, environmentKey, featureFlagKey, _callback);
    }

    public ExpiringTargetGetResponse getExpiringContextTargets(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey) throws ApiException {
        ApiResponse<ExpiringTargetGetResponse> localVarResp = this.getExpiringContextTargetsWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringTargetGetResponse> getExpiringContextTargetsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey) throws ApiException {
        Call localVarCall = this.getExpiringContextTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<ExpiringTargetGetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiringContextTargetsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback<ExpiringTargetGetResponse> _callback) throws ApiException {
        Call localVarCall = this.getExpiringContextTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<ExpiringTargetGetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExpiringUserTargetsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/expiring-user-targets/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiringUserTargetsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringUserTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringUserTargets(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getExpiringUserTargets(Async)");
        }
        return this.getExpiringUserTargetsCall(projectKey, environmentKey, featureFlagKey, _callback);
    }

    public ExpiringUserTargetGetResponse getExpiringUserTargets(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey) throws ApiException {
        ApiResponse<ExpiringUserTargetGetResponse> localVarResp = this.getExpiringUserTargetsWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringUserTargetGetResponse> getExpiringUserTargetsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey) throws ApiException {
        Call localVarCall = this.getExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetGetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiringUserTargetsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback<ExpiringUserTargetGetResponse> _callback) throws ApiException {
        Call localVarCall = this.getExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetGetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFeatureFlagCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env, @Nullable String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (env != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("env", env));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFeatureFlagValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env, @Nullable String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlag(Async)");
        }
        return this.getFeatureFlagCall(projectKey, featureFlagKey, env, expand, _callback);
    }

    public FeatureFlag getFeatureFlag(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env, @Nullable String expand) throws ApiException {
        ApiResponse<FeatureFlag> localVarResp = this.getFeatureFlagWithHttpInfo(projectKey, featureFlagKey, env, expand);
        return localVarResp.getData();
    }

    public ApiResponse<FeatureFlag> getFeatureFlagWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env, @Nullable String expand) throws ApiException {
        Call localVarCall = this.getFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, env, expand, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFeatureFlagAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env, @Nullable String expand, ApiCallback<FeatureFlag> _callback) throws ApiException {
        Call localVarCall = this.getFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, env, expand, _callback);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFeatureFlagStatusCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flag-statuses/{projectKey}/{environmentKey}/{featureFlagKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFeatureFlagStatusValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatus(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFeatureFlagStatus(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlagStatus(Async)");
        }
        return this.getFeatureFlagStatusCall(projectKey, environmentKey, featureFlagKey, _callback);
    }

    public FlagStatusRep getFeatureFlagStatus(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey) throws ApiException {
        ApiResponse<FlagStatusRep> localVarResp = this.getFeatureFlagStatusWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<FlagStatusRep> getFeatureFlagStatusWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey) throws ApiException {
        Call localVarCall = this.getFeatureFlagStatusValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<FlagStatusRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFeatureFlagStatusAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback<FlagStatusRep> _callback) throws ApiException {
        Call localVarCall = this.getFeatureFlagStatusValidateBeforeCall(projectKey, environmentKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<FlagStatusRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFeatureFlagStatusAcrossEnvironmentsCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flag-status/{projectKey}/{featureFlagKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (env != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("env", env));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatusAcrossEnvironments(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlagStatusAcrossEnvironments(Async)");
        }
        return this.getFeatureFlagStatusAcrossEnvironmentsCall(projectKey, featureFlagKey, env, _callback);
    }

    public FeatureFlagStatusAcrossEnvironments getFeatureFlagStatusAcrossEnvironments(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env) throws ApiException {
        ApiResponse<FeatureFlagStatusAcrossEnvironments> localVarResp = this.getFeatureFlagStatusAcrossEnvironmentsWithHttpInfo(projectKey, featureFlagKey, env);
        return localVarResp.getData();
    }

    public ApiResponse<FeatureFlagStatusAcrossEnvironments> getFeatureFlagStatusAcrossEnvironmentsWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env) throws ApiException {
        Call localVarCall = this.getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(projectKey, featureFlagKey, env, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatusAcrossEnvironments>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFeatureFlagStatusAcrossEnvironmentsAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nullable String env, ApiCallback<FeatureFlagStatusAcrossEnvironments> _callback) throws ApiException {
        Call localVarCall = this.getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(projectKey, featureFlagKey, env, _callback);
        Type localVarReturnType = new TypeToken<FeatureFlagStatusAcrossEnvironments>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFeatureFlagStatusesCall(@Nonnull String projectKey, @Nonnull String environmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flag-statuses/{projectKey}/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFeatureFlagStatusesValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatuses(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFeatureFlagStatuses(Async)");
        }
        return this.getFeatureFlagStatusesCall(projectKey, environmentKey, _callback);
    }

    public FeatureFlagStatuses getFeatureFlagStatuses(@Nonnull String projectKey, @Nonnull String environmentKey) throws ApiException {
        ApiResponse<FeatureFlagStatuses> localVarResp = this.getFeatureFlagStatusesWithHttpInfo(projectKey, environmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<FeatureFlagStatuses> getFeatureFlagStatusesWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey) throws ApiException {
        Call localVarCall = this.getFeatureFlagStatusesValidateBeforeCall(projectKey, environmentKey, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatuses>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFeatureFlagStatusesAsync(@Nonnull String projectKey, @Nonnull String environmentKey, ApiCallback<FeatureFlagStatuses> _callback) throws ApiException {
        Call localVarCall = this.getFeatureFlagStatusesValidateBeforeCall(projectKey, environmentKey, _callback);
        Type localVarReturnType = new TypeToken<FeatureFlagStatuses>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFeatureFlagsCall(@Nonnull String projectKey, @Nullable String env, @Nullable String tag, @Nullable Long limit, @Nullable Long offset, @Nullable Boolean archived, @Nullable Boolean summary, @Nullable String filter, @Nullable String sort, @Nullable Boolean compare, @Nullable String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (env != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("env", env));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tag", tag));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (archived != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("archived", archived));
        }
        if (summary != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("summary", summary));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (compare != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("compare", compare));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFeatureFlagsValidateBeforeCall(@Nonnull String projectKey, @Nullable String env, @Nullable String tag, @Nullable Long limit, @Nullable Long offset, @Nullable Boolean archived, @Nullable Boolean summary, @Nullable String filter, @Nullable String sort, @Nullable Boolean compare, @Nullable String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlags(Async)");
        }
        return this.getFeatureFlagsCall(projectKey, env, tag, limit, offset, archived, summary, filter, sort, compare, expand, _callback);
    }

    public FeatureFlags getFeatureFlags(@Nonnull String projectKey, @Nullable String env, @Nullable String tag, @Nullable Long limit, @Nullable Long offset, @Nullable Boolean archived, @Nullable Boolean summary, @Nullable String filter, @Nullable String sort, @Nullable Boolean compare, @Nullable String expand) throws ApiException {
        ApiResponse<FeatureFlags> localVarResp = this.getFeatureFlagsWithHttpInfo(projectKey, env, tag, limit, offset, archived, summary, filter, sort, compare, expand);
        return localVarResp.getData();
    }

    public ApiResponse<FeatureFlags> getFeatureFlagsWithHttpInfo(@Nonnull String projectKey, @Nullable String env, @Nullable String tag, @Nullable Long limit, @Nullable Long offset, @Nullable Boolean archived, @Nullable Boolean summary, @Nullable String filter, @Nullable String sort, @Nullable Boolean compare, @Nullable String expand) throws ApiException {
        Call localVarCall = this.getFeatureFlagsValidateBeforeCall(projectKey, env, tag, limit, offset, archived, summary, filter, sort, compare, expand, null);
        Type localVarReturnType = new TypeToken<FeatureFlags>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFeatureFlagsAsync(@Nonnull String projectKey, @Nullable String env, @Nullable String tag, @Nullable Long limit, @Nullable Long offset, @Nullable Boolean archived, @Nullable Boolean summary, @Nullable String filter, @Nullable String sort, @Nullable Boolean compare, @Nullable String expand, ApiCallback<FeatureFlags> _callback) throws ApiException {
        Call localVarCall = this.getFeatureFlagsValidateBeforeCall(projectKey, env, tag, limit, offset, archived, summary, filter, sort, compare, expand, _callback);
        Type localVarReturnType = new TypeToken<FeatureFlags>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExpiringTargetsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchFlagsRequest localVarPostBody = patchFlagsRequest;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/expiring-targets/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExpiringTargetsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringTargets(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchExpiringTargets(Async)");
        }
        if (patchFlagsRequest == null) {
            throw new ApiException("Missing the required parameter 'patchFlagsRequest' when calling patchExpiringTargets(Async)");
        }
        return this.patchExpiringTargetsCall(projectKey, environmentKey, featureFlagKey, patchFlagsRequest, _callback);
    }

    public ExpiringTargetPatchResponse patchExpiringTargets(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest) throws ApiException {
        ApiResponse<ExpiringTargetPatchResponse> localVarResp = this.patchExpiringTargetsWithHttpInfo(projectKey, environmentKey, featureFlagKey, patchFlagsRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringTargetPatchResponse> patchExpiringTargetsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest) throws ApiException {
        Call localVarCall = this.patchExpiringTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, patchFlagsRequest, null);
        Type localVarReturnType = new TypeToken<ExpiringTargetPatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExpiringTargetsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest, ApiCallback<ExpiringTargetPatchResponse> _callback) throws ApiException {
        Call localVarCall = this.patchExpiringTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, patchFlagsRequest, _callback);
        Type localVarReturnType = new TypeToken<ExpiringTargetPatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExpiringUserTargetsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchFlagsRequest localVarPostBody = patchFlagsRequest;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/expiring-user-targets/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExpiringUserTargetsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringUserTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringUserTargets(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchExpiringUserTargets(Async)");
        }
        if (patchFlagsRequest == null) {
            throw new ApiException("Missing the required parameter 'patchFlagsRequest' when calling patchExpiringUserTargets(Async)");
        }
        return this.patchExpiringUserTargetsCall(projectKey, environmentKey, featureFlagKey, patchFlagsRequest, _callback);
    }

    public ExpiringUserTargetPatchResponse patchExpiringUserTargets(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest) throws ApiException {
        ApiResponse<ExpiringUserTargetPatchResponse> localVarResp = this.patchExpiringUserTargetsWithHttpInfo(projectKey, environmentKey, featureFlagKey, patchFlagsRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringUserTargetPatchResponse> patchExpiringUserTargetsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest) throws ApiException {
        Call localVarCall = this.patchExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, patchFlagsRequest, null);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetPatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExpiringUserTargetsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull PatchFlagsRequest patchFlagsRequest, ApiCallback<ExpiringUserTargetPatchResponse> _callback) throws ApiException {
        Call localVarCall = this.patchExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, patchFlagsRequest, _callback);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetPatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchFeatureFlagCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull PatchWithComment patchWithComment, @Nullable Boolean ignoreConflicts, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchWithComment localVarPostBody = patchWithComment;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (ignoreConflicts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreConflicts", ignoreConflicts));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchFeatureFlagValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull PatchWithComment patchWithComment, @Nullable Boolean ignoreConflicts, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchFeatureFlag(Async)");
        }
        if (patchWithComment == null) {
            throw new ApiException("Missing the required parameter 'patchWithComment' when calling patchFeatureFlag(Async)");
        }
        return this.patchFeatureFlagCall(projectKey, featureFlagKey, patchWithComment, ignoreConflicts, _callback);
    }

    public FeatureFlag patchFeatureFlag(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull PatchWithComment patchWithComment, @Nullable Boolean ignoreConflicts) throws ApiException {
        ApiResponse<FeatureFlag> localVarResp = this.patchFeatureFlagWithHttpInfo(projectKey, featureFlagKey, patchWithComment, ignoreConflicts);
        return localVarResp.getData();
    }

    public ApiResponse<FeatureFlag> patchFeatureFlagWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull PatchWithComment patchWithComment, @Nullable Boolean ignoreConflicts) throws ApiException {
        Call localVarCall = this.patchFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, patchWithComment, ignoreConflicts, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchFeatureFlagAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull PatchWithComment patchWithComment, @Nullable Boolean ignoreConflicts, ApiCallback<FeatureFlag> _callback) throws ApiException {
        Call localVarCall = this.patchFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, patchWithComment, ignoreConflicts, _callback);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postFeatureFlagCall(@Nonnull String projectKey, @Nonnull FeatureFlagBody featureFlagBody, @Nullable String clone, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FeatureFlagBody localVarPostBody = featureFlagBody;
        String localVarPath = "/api/v2/flags/{projectKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clone != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("clone", clone));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postFeatureFlagValidateBeforeCall(@Nonnull String projectKey, @Nonnull FeatureFlagBody featureFlagBody, @Nullable String clone, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postFeatureFlag(Async)");
        }
        if (featureFlagBody == null) {
            throw new ApiException("Missing the required parameter 'featureFlagBody' when calling postFeatureFlag(Async)");
        }
        return this.postFeatureFlagCall(projectKey, featureFlagBody, clone, _callback);
    }

    public FeatureFlag postFeatureFlag(@Nonnull String projectKey, @Nonnull FeatureFlagBody featureFlagBody, @Nullable String clone) throws ApiException {
        ApiResponse<FeatureFlag> localVarResp = this.postFeatureFlagWithHttpInfo(projectKey, featureFlagBody, clone);
        return localVarResp.getData();
    }

    public ApiResponse<FeatureFlag> postFeatureFlagWithHttpInfo(@Nonnull String projectKey, @Nonnull FeatureFlagBody featureFlagBody, @Nullable String clone) throws ApiException {
        Call localVarCall = this.postFeatureFlagValidateBeforeCall(projectKey, featureFlagBody, clone, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postFeatureFlagAsync(@Nonnull String projectKey, @Nonnull FeatureFlagBody featureFlagBody, @Nullable String clone, ApiCallback<FeatureFlag> _callback) throws ApiException {
        Call localVarCall = this.postFeatureFlagValidateBeforeCall(projectKey, featureFlagBody, clone, _callback);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postMigrationSafetyIssuesCall(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String environmentKey, @Nonnull FlagSempatch flagSempatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlagSempatch localVarPostBody = flagSempatch;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{flagKey}/environments/{environmentKey}/migration-safety-issues".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{flagKey}", this.localVarApiClient.escapeString(flagKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postMigrationSafetyIssuesValidateBeforeCall(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String environmentKey, @Nonnull FlagSempatch flagSempatch, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postMigrationSafetyIssues(Async)");
        }
        if (flagKey == null) {
            throw new ApiException("Missing the required parameter 'flagKey' when calling postMigrationSafetyIssues(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postMigrationSafetyIssues(Async)");
        }
        if (flagSempatch == null) {
            throw new ApiException("Missing the required parameter 'flagSempatch' when calling postMigrationSafetyIssues(Async)");
        }
        return this.postMigrationSafetyIssuesCall(projectKey, flagKey, environmentKey, flagSempatch, _callback);
    }

    public List<MigrationSafetyIssueRep> postMigrationSafetyIssues(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String environmentKey, @Nonnull FlagSempatch flagSempatch) throws ApiException {
        ApiResponse<List<MigrationSafetyIssueRep>> localVarResp = this.postMigrationSafetyIssuesWithHttpInfo(projectKey, flagKey, environmentKey, flagSempatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<MigrationSafetyIssueRep>> postMigrationSafetyIssuesWithHttpInfo(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String environmentKey, @Nonnull FlagSempatch flagSempatch) throws ApiException {
        Call localVarCall = this.postMigrationSafetyIssuesValidateBeforeCall(projectKey, flagKey, environmentKey, flagSempatch, null);
        Type localVarReturnType = new TypeToken<List<MigrationSafetyIssueRep>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postMigrationSafetyIssuesAsync(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String environmentKey, @Nonnull FlagSempatch flagSempatch, ApiCallback<List<MigrationSafetyIssueRep>> _callback) throws ApiException {
        Call localVarCall = this.postMigrationSafetyIssuesValidateBeforeCall(projectKey, flagKey, environmentKey, flagSempatch, _callback);
        Type localVarReturnType = new TypeToken<List<MigrationSafetyIssueRep>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

