/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.FlagTriggerInput;
import com.launchdarkly.api.model.TriggerPost;
import com.launchdarkly.api.model.TriggerWorkflowCollectionRep;
import com.launchdarkly.api.model.TriggerWorkflowRep;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import okhttp3.Call;

public class FlagTriggersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public FlagTriggersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FlagTriggersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createTriggerWorkflowCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull TriggerPost triggerPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        TriggerPost localVarPostBody = triggerPost;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTriggerWorkflowValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull TriggerPost triggerPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createTriggerWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createTriggerWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling createTriggerWorkflow(Async)");
        }
        if (triggerPost == null) {
            throw new ApiException("Missing the required parameter 'triggerPost' when calling createTriggerWorkflow(Async)");
        }
        return this.createTriggerWorkflowCall(projectKey, environmentKey, featureFlagKey, triggerPost, _callback);
    }

    public TriggerWorkflowRep createTriggerWorkflow(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull TriggerPost triggerPost) throws ApiException {
        ApiResponse<TriggerWorkflowRep> localVarResp = this.createTriggerWorkflowWithHttpInfo(projectKey, environmentKey, featureFlagKey, triggerPost);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerWorkflowRep> createTriggerWorkflowWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull TriggerPost triggerPost) throws ApiException {
        Call localVarCall = this.createTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, triggerPost, null);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTriggerWorkflowAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull TriggerPost triggerPost, ApiCallback<TriggerWorkflowRep> _callback) throws ApiException {
        Call localVarCall = this.createTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, triggerPost, _callback);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTriggerWorkflowCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}/{id}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTriggerWorkflowValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteTriggerWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteTriggerWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteTriggerWorkflow(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTriggerWorkflow(Async)");
        }
        return this.deleteTriggerWorkflowCall(projectKey, environmentKey, featureFlagKey, id, _callback);
    }

    public void deleteTriggerWorkflow(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id) throws ApiException {
        this.deleteTriggerWorkflowWithHttpInfo(projectKey, environmentKey, featureFlagKey, id);
    }

    public ApiResponse<Void> deleteTriggerWorkflowWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTriggerWorkflowAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getTriggerWorkflowByIdCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}/{id}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTriggerWorkflowByIdValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getTriggerWorkflowById(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getTriggerWorkflowById(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getTriggerWorkflowById(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTriggerWorkflowById(Async)");
        }
        return this.getTriggerWorkflowByIdCall(projectKey, featureFlagKey, environmentKey, id, _callback);
    }

    public TriggerWorkflowRep getTriggerWorkflowById(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id) throws ApiException {
        ApiResponse<TriggerWorkflowRep> localVarResp = this.getTriggerWorkflowByIdWithHttpInfo(projectKey, featureFlagKey, environmentKey, id);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerWorkflowRep> getTriggerWorkflowByIdWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id) throws ApiException {
        Call localVarCall = this.getTriggerWorkflowByIdValidateBeforeCall(projectKey, featureFlagKey, environmentKey, id, null);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTriggerWorkflowByIdAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String id, ApiCallback<TriggerWorkflowRep> _callback) throws ApiException {
        Call localVarCall = this.getTriggerWorkflowByIdValidateBeforeCall(projectKey, featureFlagKey, environmentKey, id, _callback);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTriggerWorkflowsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTriggerWorkflowsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getTriggerWorkflows(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getTriggerWorkflows(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getTriggerWorkflows(Async)");
        }
        return this.getTriggerWorkflowsCall(projectKey, environmentKey, featureFlagKey, _callback);
    }

    public TriggerWorkflowCollectionRep getTriggerWorkflows(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey) throws ApiException {
        ApiResponse<TriggerWorkflowCollectionRep> localVarResp = this.getTriggerWorkflowsWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerWorkflowCollectionRep> getTriggerWorkflowsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey) throws ApiException {
        Call localVarCall = this.getTriggerWorkflowsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null);
        Type localVarReturnType = new TypeToken<TriggerWorkflowCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTriggerWorkflowsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, ApiCallback<TriggerWorkflowCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getTriggerWorkflowsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, _callback);
        Type localVarReturnType = new TypeToken<TriggerWorkflowCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchTriggerWorkflowCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id, @Nonnull FlagTriggerInput flagTriggerInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        FlagTriggerInput localVarPostBody = flagTriggerInput;
        String localVarPath = "/api/v2/flags/{projectKey}/{featureFlagKey}/triggers/{environmentKey}/{id}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchTriggerWorkflowValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id, @Nonnull FlagTriggerInput flagTriggerInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchTriggerWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchTriggerWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchTriggerWorkflow(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling patchTriggerWorkflow(Async)");
        }
        if (flagTriggerInput == null) {
            throw new ApiException("Missing the required parameter 'flagTriggerInput' when calling patchTriggerWorkflow(Async)");
        }
        return this.patchTriggerWorkflowCall(projectKey, environmentKey, featureFlagKey, id, flagTriggerInput, _callback);
    }

    public TriggerWorkflowRep patchTriggerWorkflow(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id, @Nonnull FlagTriggerInput flagTriggerInput) throws ApiException {
        ApiResponse<TriggerWorkflowRep> localVarResp = this.patchTriggerWorkflowWithHttpInfo(projectKey, environmentKey, featureFlagKey, id, flagTriggerInput);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerWorkflowRep> patchTriggerWorkflowWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id, @Nonnull FlagTriggerInput flagTriggerInput) throws ApiException {
        Call localVarCall = this.patchTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, id, flagTriggerInput, null);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchTriggerWorkflowAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String featureFlagKey, @Nonnull String id, @Nonnull FlagTriggerInput flagTriggerInput, ApiCallback<TriggerWorkflowRep> _callback) throws ApiException {
        Call localVarCall = this.patchTriggerWorkflowValidateBeforeCall(projectKey, environmentKey, featureFlagKey, id, flagTriggerInput, _callback);
        Type localVarReturnType = new TypeToken<TriggerWorkflowRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

