/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.InsightGroup;
import com.launchdarkly.api.model.InsightGroupCollection;
import com.launchdarkly.api.model.InsightScores;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.PostInsightGroupParams;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class InsightsScoresBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InsightsScoresBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InsightsScoresBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createInsightGroupCall(@Nonnull PostInsightGroupParams postInsightGroupParams, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PostInsightGroupParams localVarPostBody = postInsightGroupParams;
        String localVarPath = "/api/v2/engineering-insights/insights/group";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createInsightGroupValidateBeforeCall(@Nonnull PostInsightGroupParams postInsightGroupParams, ApiCallback _callback) throws ApiException {
        if (postInsightGroupParams == null) {
            throw new ApiException("Missing the required parameter 'postInsightGroupParams' when calling createInsightGroup(Async)");
        }
        return this.createInsightGroupCall(postInsightGroupParams, _callback);
    }

    public InsightGroup createInsightGroup(@Nonnull PostInsightGroupParams postInsightGroupParams) throws ApiException {
        ApiResponse<InsightGroup> localVarResp = this.createInsightGroupWithHttpInfo(postInsightGroupParams);
        return localVarResp.getData();
    }

    public ApiResponse<InsightGroup> createInsightGroupWithHttpInfo(@Nonnull PostInsightGroupParams postInsightGroupParams) throws ApiException {
        Call localVarCall = this.createInsightGroupValidateBeforeCall(postInsightGroupParams, null);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createInsightGroupAsync(@Nonnull PostInsightGroupParams postInsightGroupParams, ApiCallback<InsightGroup> _callback) throws ApiException {
        Call localVarCall = this.createInsightGroupValidateBeforeCall(postInsightGroupParams, _callback);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteInsightGroupCall(@Nonnull String insightGroupKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/insights/groups/{insightGroupKey}".replace("{insightGroupKey}", this.localVarApiClient.escapeString(insightGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteInsightGroupValidateBeforeCall(@Nonnull String insightGroupKey, ApiCallback _callback) throws ApiException {
        if (insightGroupKey == null) {
            throw new ApiException("Missing the required parameter 'insightGroupKey' when calling deleteInsightGroup(Async)");
        }
        return this.deleteInsightGroupCall(insightGroupKey, _callback);
    }

    public void deleteInsightGroup(@Nonnull String insightGroupKey) throws ApiException {
        this.deleteInsightGroupWithHttpInfo(insightGroupKey);
    }

    public ApiResponse<Void> deleteInsightGroupWithHttpInfo(@Nonnull String insightGroupKey) throws ApiException {
        Call localVarCall = this.deleteInsightGroupValidateBeforeCall(insightGroupKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteInsightGroupAsync(@Nonnull String insightGroupKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteInsightGroupValidateBeforeCall(insightGroupKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getInsightGroupCall(@Nonnull String insightGroupKey, @Nullable String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/insights/groups/{insightGroupKey}".replace("{insightGroupKey}", this.localVarApiClient.escapeString(insightGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInsightGroupValidateBeforeCall(@Nonnull String insightGroupKey, @Nullable String expand, ApiCallback _callback) throws ApiException {
        if (insightGroupKey == null) {
            throw new ApiException("Missing the required parameter 'insightGroupKey' when calling getInsightGroup(Async)");
        }
        return this.getInsightGroupCall(insightGroupKey, expand, _callback);
    }

    public InsightGroup getInsightGroup(@Nonnull String insightGroupKey, @Nullable String expand) throws ApiException {
        ApiResponse<InsightGroup> localVarResp = this.getInsightGroupWithHttpInfo(insightGroupKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<InsightGroup> getInsightGroupWithHttpInfo(@Nonnull String insightGroupKey, @Nullable String expand) throws ApiException {
        Call localVarCall = this.getInsightGroupValidateBeforeCall(insightGroupKey, expand, null);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInsightGroupAsync(@Nonnull String insightGroupKey, @Nullable String expand, ApiCallback<InsightGroup> _callback) throws ApiException {
        Call localVarCall = this.getInsightGroupValidateBeforeCall(insightGroupKey, expand, _callback);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInsightGroupsCall(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String query, @Nullable String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/insights/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInsightGroupsValidateBeforeCall(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String query, @Nullable String expand, ApiCallback _callback) throws ApiException {
        return this.getInsightGroupsCall(limit, offset, sort, query, expand, _callback);
    }

    public InsightGroupCollection getInsightGroups(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String query, @Nullable String expand) throws ApiException {
        ApiResponse<InsightGroupCollection> localVarResp = this.getInsightGroupsWithHttpInfo(limit, offset, sort, query, expand);
        return localVarResp.getData();
    }

    public ApiResponse<InsightGroupCollection> getInsightGroupsWithHttpInfo(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String query, @Nullable String expand) throws ApiException {
        Call localVarCall = this.getInsightGroupsValidateBeforeCall(limit, offset, sort, query, expand, null);
        Type localVarReturnType = new TypeToken<InsightGroupCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInsightGroupsAsync(@Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String query, @Nullable String expand, ApiCallback<InsightGroupCollection> _callback) throws ApiException {
        Call localVarCall = this.getInsightGroupsValidateBeforeCall(limit, offset, sort, query, expand, _callback);
        Type localVarReturnType = new TypeToken<InsightGroupCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInsightsScoresCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable String applicationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/engineering-insights/insights/scores";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (projectKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("projectKey", projectKey));
        }
        if (environmentKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("environmentKey", environmentKey));
        }
        if (applicationKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("applicationKey", applicationKey));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInsightsScoresValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable String applicationKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getInsightsScores(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getInsightsScores(Async)");
        }
        return this.getInsightsScoresCall(projectKey, environmentKey, applicationKey, _callback);
    }

    public InsightScores getInsightsScores(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable String applicationKey) throws ApiException {
        ApiResponse<InsightScores> localVarResp = this.getInsightsScoresWithHttpInfo(projectKey, environmentKey, applicationKey);
        return localVarResp.getData();
    }

    public ApiResponse<InsightScores> getInsightsScoresWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable String applicationKey) throws ApiException {
        Call localVarCall = this.getInsightsScoresValidateBeforeCall(projectKey, environmentKey, applicationKey, null);
        Type localVarReturnType = new TypeToken<InsightScores>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInsightsScoresAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable String applicationKey, ApiCallback<InsightScores> _callback) throws ApiException {
        Call localVarCall = this.getInsightsScoresValidateBeforeCall(projectKey, environmentKey, applicationKey, _callback);
        Type localVarReturnType = new TypeToken<InsightScores>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchInsightGroupCall(@Nonnull String insightGroupKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/engineering-insights/insights/groups/{insightGroupKey}".replace("{insightGroupKey}", this.localVarApiClient.escapeString(insightGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchInsightGroupValidateBeforeCall(@Nonnull String insightGroupKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (insightGroupKey == null) {
            throw new ApiException("Missing the required parameter 'insightGroupKey' when calling patchInsightGroup(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchInsightGroup(Async)");
        }
        return this.patchInsightGroupCall(insightGroupKey, patchOperation, _callback);
    }

    public InsightGroup patchInsightGroup(@Nonnull String insightGroupKey, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<InsightGroup> localVarResp = this.patchInsightGroupWithHttpInfo(insightGroupKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<InsightGroup> patchInsightGroupWithHttpInfo(@Nonnull String insightGroupKey, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchInsightGroupValidateBeforeCall(insightGroupKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchInsightGroupAsync(@Nonnull String insightGroupKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback<InsightGroup> _callback) throws ApiException {
        Call localVarCall = this.patchInsightGroupValidateBeforeCall(insightGroupKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<InsightGroup>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

