/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.IntegrationDeliveryConfiguration;
import com.launchdarkly.api.model.IntegrationDeliveryConfigurationCollection;
import com.launchdarkly.api.model.IntegrationDeliveryConfigurationPost;
import com.launchdarkly.api.model.IntegrationDeliveryConfigurationResponse;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import okhttp3.Call;

public class IntegrationDeliveryConfigurationsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public IntegrationDeliveryConfigurationsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationDeliveryConfigurationsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createIntegrationDeliveryConfigurationCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull IntegrationDeliveryConfigurationPost integrationDeliveryConfigurationPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IntegrationDeliveryConfigurationPost localVarPostBody = integrationDeliveryConfigurationPost;
        String localVarPath = "/api/v2/integration-capabilities/featureStore/{projectKey}/{environmentKey}/{integrationKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{integrationKey}", this.localVarApiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIntegrationDeliveryConfigurationValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull IntegrationDeliveryConfigurationPost integrationDeliveryConfigurationPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createIntegrationDeliveryConfiguration(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createIntegrationDeliveryConfiguration(Async)");
        }
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling createIntegrationDeliveryConfiguration(Async)");
        }
        if (integrationDeliveryConfigurationPost == null) {
            throw new ApiException("Missing the required parameter 'integrationDeliveryConfigurationPost' when calling createIntegrationDeliveryConfiguration(Async)");
        }
        return this.createIntegrationDeliveryConfigurationCall(projectKey, environmentKey, integrationKey, integrationDeliveryConfigurationPost, _callback);
    }

    public IntegrationDeliveryConfiguration createIntegrationDeliveryConfiguration(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull IntegrationDeliveryConfigurationPost integrationDeliveryConfigurationPost) throws ApiException {
        ApiResponse<IntegrationDeliveryConfiguration> localVarResp = this.createIntegrationDeliveryConfigurationWithHttpInfo(projectKey, environmentKey, integrationKey, integrationDeliveryConfigurationPost);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationDeliveryConfiguration> createIntegrationDeliveryConfigurationWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull IntegrationDeliveryConfigurationPost integrationDeliveryConfigurationPost) throws ApiException {
        Call localVarCall = this.createIntegrationDeliveryConfigurationValidateBeforeCall(projectKey, environmentKey, integrationKey, integrationDeliveryConfigurationPost, null);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfiguration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIntegrationDeliveryConfigurationAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull IntegrationDeliveryConfigurationPost integrationDeliveryConfigurationPost, ApiCallback<IntegrationDeliveryConfiguration> _callback) throws ApiException {
        Call localVarCall = this.createIntegrationDeliveryConfigurationValidateBeforeCall(projectKey, environmentKey, integrationKey, integrationDeliveryConfigurationPost, _callback);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfiguration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIntegrationDeliveryConfigurationCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-capabilities/featureStore/{projectKey}/{environmentKey}/{integrationKey}/{id}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{integrationKey}", this.localVarApiClient.escapeString(integrationKey.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIntegrationDeliveryConfigurationValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteIntegrationDeliveryConfiguration(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteIntegrationDeliveryConfiguration(Async)");
        }
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling deleteIntegrationDeliveryConfiguration(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteIntegrationDeliveryConfiguration(Async)");
        }
        return this.deleteIntegrationDeliveryConfigurationCall(projectKey, environmentKey, integrationKey, id, _callback);
    }

    public void deleteIntegrationDeliveryConfiguration(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id) throws ApiException {
        this.deleteIntegrationDeliveryConfigurationWithHttpInfo(projectKey, environmentKey, integrationKey, id);
    }

    public ApiResponse<Void> deleteIntegrationDeliveryConfigurationWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id) throws ApiException {
        Call localVarCall = this.deleteIntegrationDeliveryConfigurationValidateBeforeCall(projectKey, environmentKey, integrationKey, id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteIntegrationDeliveryConfigurationAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteIntegrationDeliveryConfigurationValidateBeforeCall(projectKey, environmentKey, integrationKey, id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getIntegrationDeliveryConfigurationByEnvironmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-capabilities/featureStore/{projectKey}/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIntegrationDeliveryConfigurationByEnvironmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getIntegrationDeliveryConfigurationByEnvironment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getIntegrationDeliveryConfigurationByEnvironment(Async)");
        }
        return this.getIntegrationDeliveryConfigurationByEnvironmentCall(projectKey, environmentKey, _callback);
    }

    public IntegrationDeliveryConfigurationCollection getIntegrationDeliveryConfigurationByEnvironment(@Nonnull String projectKey, @Nonnull String environmentKey) throws ApiException {
        ApiResponse<IntegrationDeliveryConfigurationCollection> localVarResp = this.getIntegrationDeliveryConfigurationByEnvironmentWithHttpInfo(projectKey, environmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationDeliveryConfigurationCollection> getIntegrationDeliveryConfigurationByEnvironmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey) throws ApiException {
        Call localVarCall = this.getIntegrationDeliveryConfigurationByEnvironmentValidateBeforeCall(projectKey, environmentKey, null);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfigurationCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIntegrationDeliveryConfigurationByEnvironmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, ApiCallback<IntegrationDeliveryConfigurationCollection> _callback) throws ApiException {
        Call localVarCall = this.getIntegrationDeliveryConfigurationByEnvironmentValidateBeforeCall(projectKey, environmentKey, _callback);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfigurationCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIntegrationDeliveryConfigurationByIdCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-capabilities/featureStore/{projectKey}/{environmentKey}/{integrationKey}/{id}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{integrationKey}", this.localVarApiClient.escapeString(integrationKey.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIntegrationDeliveryConfigurationByIdValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getIntegrationDeliveryConfigurationById(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getIntegrationDeliveryConfigurationById(Async)");
        }
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getIntegrationDeliveryConfigurationById(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getIntegrationDeliveryConfigurationById(Async)");
        }
        return this.getIntegrationDeliveryConfigurationByIdCall(projectKey, environmentKey, integrationKey, id, _callback);
    }

    public IntegrationDeliveryConfiguration getIntegrationDeliveryConfigurationById(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id) throws ApiException {
        ApiResponse<IntegrationDeliveryConfiguration> localVarResp = this.getIntegrationDeliveryConfigurationByIdWithHttpInfo(projectKey, environmentKey, integrationKey, id);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationDeliveryConfiguration> getIntegrationDeliveryConfigurationByIdWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id) throws ApiException {
        Call localVarCall = this.getIntegrationDeliveryConfigurationByIdValidateBeforeCall(projectKey, environmentKey, integrationKey, id, null);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfiguration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIntegrationDeliveryConfigurationByIdAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback<IntegrationDeliveryConfiguration> _callback) throws ApiException {
        Call localVarCall = this.getIntegrationDeliveryConfigurationByIdValidateBeforeCall(projectKey, environmentKey, integrationKey, id, _callback);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfiguration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIntegrationDeliveryConfigurationsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-capabilities/featureStore";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIntegrationDeliveryConfigurationsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getIntegrationDeliveryConfigurationsCall(_callback);
    }

    public IntegrationDeliveryConfigurationCollection getIntegrationDeliveryConfigurations() throws ApiException {
        ApiResponse<IntegrationDeliveryConfigurationCollection> localVarResp = this.getIntegrationDeliveryConfigurationsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationDeliveryConfigurationCollection> getIntegrationDeliveryConfigurationsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getIntegrationDeliveryConfigurationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfigurationCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIntegrationDeliveryConfigurationsAsync(ApiCallback<IntegrationDeliveryConfigurationCollection> _callback) throws ApiException {
        Call localVarCall = this.getIntegrationDeliveryConfigurationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfigurationCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchIntegrationDeliveryConfigurationCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/integration-capabilities/featureStore/{projectKey}/{environmentKey}/{integrationKey}/{id}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{integrationKey}", this.localVarApiClient.escapeString(integrationKey.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIntegrationDeliveryConfigurationValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchIntegrationDeliveryConfiguration(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchIntegrationDeliveryConfiguration(Async)");
        }
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling patchIntegrationDeliveryConfiguration(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling patchIntegrationDeliveryConfiguration(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchIntegrationDeliveryConfiguration(Async)");
        }
        return this.patchIntegrationDeliveryConfigurationCall(projectKey, environmentKey, integrationKey, id, patchOperation, _callback);
    }

    public IntegrationDeliveryConfiguration patchIntegrationDeliveryConfiguration(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<IntegrationDeliveryConfiguration> localVarResp = this.patchIntegrationDeliveryConfigurationWithHttpInfo(projectKey, environmentKey, integrationKey, id, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationDeliveryConfiguration> patchIntegrationDeliveryConfigurationWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchIntegrationDeliveryConfigurationValidateBeforeCall(projectKey, environmentKey, integrationKey, id, patchOperation, null);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfiguration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchIntegrationDeliveryConfigurationAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, @Nonnull List<PatchOperation> patchOperation, ApiCallback<IntegrationDeliveryConfiguration> _callback) throws ApiException {
        Call localVarCall = this.patchIntegrationDeliveryConfigurationValidateBeforeCall(projectKey, environmentKey, integrationKey, id, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfiguration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call validateIntegrationDeliveryConfigurationCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-capabilities/featureStore/{projectKey}/{environmentKey}/{integrationKey}/{id}/validate".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{integrationKey}", this.localVarApiClient.escapeString(integrationKey.toString())).replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call validateIntegrationDeliveryConfigurationValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling validateIntegrationDeliveryConfiguration(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling validateIntegrationDeliveryConfiguration(Async)");
        }
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling validateIntegrationDeliveryConfiguration(Async)");
        }
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling validateIntegrationDeliveryConfiguration(Async)");
        }
        return this.validateIntegrationDeliveryConfigurationCall(projectKey, environmentKey, integrationKey, id, _callback);
    }

    public IntegrationDeliveryConfigurationResponse validateIntegrationDeliveryConfiguration(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id) throws ApiException {
        ApiResponse<IntegrationDeliveryConfigurationResponse> localVarResp = this.validateIntegrationDeliveryConfigurationWithHttpInfo(projectKey, environmentKey, integrationKey, id);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationDeliveryConfigurationResponse> validateIntegrationDeliveryConfigurationWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id) throws ApiException {
        Call localVarCall = this.validateIntegrationDeliveryConfigurationValidateBeforeCall(projectKey, environmentKey, integrationKey, id, null);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfigurationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call validateIntegrationDeliveryConfigurationAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String integrationKey, @Nonnull String id, ApiCallback<IntegrationDeliveryConfigurationResponse> _callback) throws ApiException {
        Call localVarCall = this.validateIntegrationDeliveryConfigurationValidateBeforeCall(projectKey, environmentKey, integrationKey, id, _callback);
        Type localVarReturnType = new TypeToken<IntegrationDeliveryConfigurationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

