/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.IntegrationConfigurationCollectionRep;
import com.launchdarkly.api.model.IntegrationConfigurationPost;
import com.launchdarkly.api.model.IntegrationConfigurationsRep;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import okhttp3.Call;

public class IntegrationsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public IntegrationsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createIntegrationConfigurationCall(@Nonnull String integrationKey, @Nonnull IntegrationConfigurationPost integrationConfigurationPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        IntegrationConfigurationPost localVarPostBody = integrationConfigurationPost;
        String localVarPath = "/api/v2/integration-configurations/keys/{integrationKey}".replace("{integrationKey}", this.localVarApiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIntegrationConfigurationValidateBeforeCall(@Nonnull String integrationKey, @Nonnull IntegrationConfigurationPost integrationConfigurationPost, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling createIntegrationConfiguration(Async)");
        }
        if (integrationConfigurationPost == null) {
            throw new ApiException("Missing the required parameter 'integrationConfigurationPost' when calling createIntegrationConfiguration(Async)");
        }
        return this.createIntegrationConfigurationCall(integrationKey, integrationConfigurationPost, _callback);
    }

    public IntegrationConfigurationsRep createIntegrationConfiguration(@Nonnull String integrationKey, @Nonnull IntegrationConfigurationPost integrationConfigurationPost) throws ApiException {
        ApiResponse<IntegrationConfigurationsRep> localVarResp = this.createIntegrationConfigurationWithHttpInfo(integrationKey, integrationConfigurationPost);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationConfigurationsRep> createIntegrationConfigurationWithHttpInfo(@Nonnull String integrationKey, @Nonnull IntegrationConfigurationPost integrationConfigurationPost) throws ApiException {
        Call localVarCall = this.createIntegrationConfigurationValidateBeforeCall(integrationKey, integrationConfigurationPost, null);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIntegrationConfigurationAsync(@Nonnull String integrationKey, @Nonnull IntegrationConfigurationPost integrationConfigurationPost, ApiCallback<IntegrationConfigurationsRep> _callback) throws ApiException {
        Call localVarCall = this.createIntegrationConfigurationValidateBeforeCall(integrationKey, integrationConfigurationPost, _callback);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIntegrationConfigurationCall(@Nonnull String integrationConfigurationId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-configurations/{integrationConfigurationId}".replace("{integrationConfigurationId}", this.localVarApiClient.escapeString(integrationConfigurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIntegrationConfigurationValidateBeforeCall(@Nonnull String integrationConfigurationId, ApiCallback _callback) throws ApiException {
        if (integrationConfigurationId == null) {
            throw new ApiException("Missing the required parameter 'integrationConfigurationId' when calling deleteIntegrationConfiguration(Async)");
        }
        return this.deleteIntegrationConfigurationCall(integrationConfigurationId, _callback);
    }

    public void deleteIntegrationConfiguration(@Nonnull String integrationConfigurationId) throws ApiException {
        this.deleteIntegrationConfigurationWithHttpInfo(integrationConfigurationId);
    }

    public ApiResponse<Void> deleteIntegrationConfigurationWithHttpInfo(@Nonnull String integrationConfigurationId) throws ApiException {
        Call localVarCall = this.deleteIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteIntegrationConfigurationAsync(@Nonnull String integrationConfigurationId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllIntegrationConfigurationsCall(@Nonnull String integrationKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-configurations/keys/{integrationKey}".replace("{integrationKey}", this.localVarApiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllIntegrationConfigurationsValidateBeforeCall(@Nonnull String integrationKey, ApiCallback _callback) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getAllIntegrationConfigurations(Async)");
        }
        return this.getAllIntegrationConfigurationsCall(integrationKey, _callback);
    }

    public IntegrationConfigurationCollectionRep getAllIntegrationConfigurations(@Nonnull String integrationKey) throws ApiException {
        ApiResponse<IntegrationConfigurationCollectionRep> localVarResp = this.getAllIntegrationConfigurationsWithHttpInfo(integrationKey);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationConfigurationCollectionRep> getAllIntegrationConfigurationsWithHttpInfo(@Nonnull String integrationKey) throws ApiException {
        Call localVarCall = this.getAllIntegrationConfigurationsValidateBeforeCall(integrationKey, null);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllIntegrationConfigurationsAsync(@Nonnull String integrationKey, ApiCallback<IntegrationConfigurationCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getAllIntegrationConfigurationsValidateBeforeCall(integrationKey, _callback);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getIntegrationConfigurationCall(@Nonnull String integrationConfigurationId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration-configurations/{integrationConfigurationId}".replace("{integrationConfigurationId}", this.localVarApiClient.escapeString(integrationConfigurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getIntegrationConfigurationValidateBeforeCall(@Nonnull String integrationConfigurationId, ApiCallback _callback) throws ApiException {
        if (integrationConfigurationId == null) {
            throw new ApiException("Missing the required parameter 'integrationConfigurationId' when calling getIntegrationConfiguration(Async)");
        }
        return this.getIntegrationConfigurationCall(integrationConfigurationId, _callback);
    }

    public IntegrationConfigurationsRep getIntegrationConfiguration(@Nonnull String integrationConfigurationId) throws ApiException {
        ApiResponse<IntegrationConfigurationsRep> localVarResp = this.getIntegrationConfigurationWithHttpInfo(integrationConfigurationId);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationConfigurationsRep> getIntegrationConfigurationWithHttpInfo(@Nonnull String integrationConfigurationId) throws ApiException {
        Call localVarCall = this.getIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, null);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getIntegrationConfigurationAsync(@Nonnull String integrationConfigurationId, ApiCallback<IntegrationConfigurationsRep> _callback) throws ApiException {
        Call localVarCall = this.getIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, _callback);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateIntegrationConfigurationCall(@Nonnull String integrationConfigurationId, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/integration-configurations/{integrationConfigurationId}".replace("{integrationConfigurationId}", this.localVarApiClient.escapeString(integrationConfigurationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateIntegrationConfigurationValidateBeforeCall(@Nonnull String integrationConfigurationId, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (integrationConfigurationId == null) {
            throw new ApiException("Missing the required parameter 'integrationConfigurationId' when calling updateIntegrationConfiguration(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling updateIntegrationConfiguration(Async)");
        }
        return this.updateIntegrationConfigurationCall(integrationConfigurationId, patchOperation, _callback);
    }

    public IntegrationConfigurationsRep updateIntegrationConfiguration(@Nonnull String integrationConfigurationId, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<IntegrationConfigurationsRep> localVarResp = this.updateIntegrationConfigurationWithHttpInfo(integrationConfigurationId, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<IntegrationConfigurationsRep> updateIntegrationConfigurationWithHttpInfo(@Nonnull String integrationConfigurationId, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.updateIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, patchOperation, null);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateIntegrationConfigurationAsync(@Nonnull String integrationConfigurationId, @Nonnull List<PatchOperation> patchOperation, ApiCallback<IntegrationConfigurationsRep> _callback) throws ApiException {
        Call localVarCall = this.updateIntegrationConfigurationValidateBeforeCall(integrationConfigurationId, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<IntegrationConfigurationsRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

