/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.MetricCollectionRep;
import com.launchdarkly.api.model.MetricPost;
import com.launchdarkly.api.model.MetricRep;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class MetricsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteMetricCall(@Nonnull String projectKey, @Nonnull String metricKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/metrics/{projectKey}/{metricKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{metricKey}", this.localVarApiClient.escapeString(metricKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteMetricValidateBeforeCall(@Nonnull String projectKey, @Nonnull String metricKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteMetric(Async)");
        }
        if (metricKey == null) {
            throw new ApiException("Missing the required parameter 'metricKey' when calling deleteMetric(Async)");
        }
        return this.deleteMetricCall(projectKey, metricKey, _callback);
    }

    public void deleteMetric(@Nonnull String projectKey, @Nonnull String metricKey) throws ApiException {
        this.deleteMetricWithHttpInfo(projectKey, metricKey);
    }

    public ApiResponse<Void> deleteMetricWithHttpInfo(@Nonnull String projectKey, @Nonnull String metricKey) throws ApiException {
        Call localVarCall = this.deleteMetricValidateBeforeCall(projectKey, metricKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteMetricAsync(@Nonnull String projectKey, @Nonnull String metricKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteMetricValidateBeforeCall(projectKey, metricKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getMetricCall(@Nonnull String projectKey, @Nonnull String metricKey, @Nullable String expand, @Nullable String versionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/metrics/{projectKey}/{metricKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{metricKey}", this.localVarApiClient.escapeString(metricKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if (versionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionId", versionId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetricValidateBeforeCall(@Nonnull String projectKey, @Nonnull String metricKey, @Nullable String expand, @Nullable String versionId, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getMetric(Async)");
        }
        if (metricKey == null) {
            throw new ApiException("Missing the required parameter 'metricKey' when calling getMetric(Async)");
        }
        return this.getMetricCall(projectKey, metricKey, expand, versionId, _callback);
    }

    public MetricRep getMetric(@Nonnull String projectKey, @Nonnull String metricKey, @Nullable String expand, @Nullable String versionId) throws ApiException {
        ApiResponse<MetricRep> localVarResp = this.getMetricWithHttpInfo(projectKey, metricKey, expand, versionId);
        return localVarResp.getData();
    }

    public ApiResponse<MetricRep> getMetricWithHttpInfo(@Nonnull String projectKey, @Nonnull String metricKey, @Nullable String expand, @Nullable String versionId) throws ApiException {
        Call localVarCall = this.getMetricValidateBeforeCall(projectKey, metricKey, expand, versionId, null);
        Type localVarReturnType = new TypeToken<MetricRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMetricAsync(@Nonnull String projectKey, @Nonnull String metricKey, @Nullable String expand, @Nullable String versionId, ApiCallback<MetricRep> _callback) throws ApiException {
        Call localVarCall = this.getMetricValidateBeforeCall(projectKey, metricKey, expand, versionId, _callback);
        Type localVarReturnType = new TypeToken<MetricRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMetricsCall(@Nonnull String projectKey, @Nullable String expand, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/metrics/{projectKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetricsValidateBeforeCall(@Nonnull String projectKey, @Nullable String expand, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getMetrics(Async)");
        }
        return this.getMetricsCall(projectKey, expand, limit, offset, sort, filter, _callback);
    }

    public MetricCollectionRep getMetrics(@Nonnull String projectKey, @Nullable String expand, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter) throws ApiException {
        ApiResponse<MetricCollectionRep> localVarResp = this.getMetricsWithHttpInfo(projectKey, expand, limit, offset, sort, filter);
        return localVarResp.getData();
    }

    public ApiResponse<MetricCollectionRep> getMetricsWithHttpInfo(@Nonnull String projectKey, @Nullable String expand, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter) throws ApiException {
        Call localVarCall = this.getMetricsValidateBeforeCall(projectKey, expand, limit, offset, sort, filter, null);
        Type localVarReturnType = new TypeToken<MetricCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMetricsAsync(@Nonnull String projectKey, @Nullable String expand, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter, ApiCallback<MetricCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getMetricsValidateBeforeCall(projectKey, expand, limit, offset, sort, filter, _callback);
        Type localVarReturnType = new TypeToken<MetricCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchMetricCall(@Nonnull String projectKey, @Nonnull String metricKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/metrics/{projectKey}/{metricKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{metricKey}", this.localVarApiClient.escapeString(metricKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchMetricValidateBeforeCall(@Nonnull String projectKey, @Nonnull String metricKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchMetric(Async)");
        }
        if (metricKey == null) {
            throw new ApiException("Missing the required parameter 'metricKey' when calling patchMetric(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchMetric(Async)");
        }
        return this.patchMetricCall(projectKey, metricKey, patchOperation, _callback);
    }

    public MetricRep patchMetric(@Nonnull String projectKey, @Nonnull String metricKey, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<MetricRep> localVarResp = this.patchMetricWithHttpInfo(projectKey, metricKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<MetricRep> patchMetricWithHttpInfo(@Nonnull String projectKey, @Nonnull String metricKey, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchMetricValidateBeforeCall(projectKey, metricKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<MetricRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchMetricAsync(@Nonnull String projectKey, @Nonnull String metricKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback<MetricRep> _callback) throws ApiException {
        Call localVarCall = this.patchMetricValidateBeforeCall(projectKey, metricKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<MetricRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postMetricCall(@Nonnull String projectKey, @Nonnull MetricPost metricPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MetricPost localVarPostBody = metricPost;
        String localVarPath = "/api/v2/metrics/{projectKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postMetricValidateBeforeCall(@Nonnull String projectKey, @Nonnull MetricPost metricPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postMetric(Async)");
        }
        if (metricPost == null) {
            throw new ApiException("Missing the required parameter 'metricPost' when calling postMetric(Async)");
        }
        return this.postMetricCall(projectKey, metricPost, _callback);
    }

    public MetricRep postMetric(@Nonnull String projectKey, @Nonnull MetricPost metricPost) throws ApiException {
        ApiResponse<MetricRep> localVarResp = this.postMetricWithHttpInfo(projectKey, metricPost);
        return localVarResp.getData();
    }

    public ApiResponse<MetricRep> postMetricWithHttpInfo(@Nonnull String projectKey, @Nonnull MetricPost metricPost) throws ApiException {
        Call localVarCall = this.postMetricValidateBeforeCall(projectKey, metricPost, null);
        Type localVarReturnType = new TypeToken<MetricRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postMetricAsync(@Nonnull String projectKey, @Nonnull MetricPost metricPost, ApiCallback<MetricRep> _callback) throws ApiException {
        Call localVarCall = this.postMetricValidateBeforeCall(projectKey, metricPost, _callback);
        Type localVarReturnType = new TypeToken<MetricRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

