/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.MetricGroupCollectionRep;
import com.launchdarkly.api.model.MetricGroupPost;
import com.launchdarkly.api.model.MetricGroupRep;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class MetricsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public MetricsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createMetricGroupCall(@Nonnull String projectKey, @Nonnull MetricGroupPost metricGroupPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        MetricGroupPost localVarPostBody = metricGroupPost;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createMetricGroupValidateBeforeCall(@Nonnull String projectKey, @Nonnull MetricGroupPost metricGroupPost, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createMetricGroup(Async)");
        }
        if (metricGroupPost == null) {
            throw new ApiException("Missing the required parameter 'metricGroupPost' when calling createMetricGroup(Async)");
        }
        return this.createMetricGroupCall(projectKey, metricGroupPost, _callback);
    }

    public MetricGroupRep createMetricGroup(@Nonnull String projectKey, @Nonnull MetricGroupPost metricGroupPost) throws ApiException {
        ApiResponse<MetricGroupRep> localVarResp = this.createMetricGroupWithHttpInfo(projectKey, metricGroupPost);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupRep> createMetricGroupWithHttpInfo(@Nonnull String projectKey, @Nonnull MetricGroupPost metricGroupPost) throws ApiException {
        Call localVarCall = this.createMetricGroupValidateBeforeCall(projectKey, metricGroupPost, null);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createMetricGroupAsync(@Nonnull String projectKey, @Nonnull MetricGroupPost metricGroupPost, ApiCallback<MetricGroupRep> _callback) throws ApiException {
        Call localVarCall = this.createMetricGroupValidateBeforeCall(projectKey, metricGroupPost, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteMetricGroupCall(@Nonnull String projectKey, @Nonnull String metricGroupKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups/{metricGroupKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{metricGroupKey}", this.localVarApiClient.escapeString(metricGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteMetricGroupValidateBeforeCall(@Nonnull String projectKey, @Nonnull String metricGroupKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteMetricGroup(Async)");
        }
        if (metricGroupKey == null) {
            throw new ApiException("Missing the required parameter 'metricGroupKey' when calling deleteMetricGroup(Async)");
        }
        return this.deleteMetricGroupCall(projectKey, metricGroupKey, _callback);
    }

    public void deleteMetricGroup(@Nonnull String projectKey, @Nonnull String metricGroupKey) throws ApiException {
        this.deleteMetricGroupWithHttpInfo(projectKey, metricGroupKey);
    }

    public ApiResponse<Void> deleteMetricGroupWithHttpInfo(@Nonnull String projectKey, @Nonnull String metricGroupKey) throws ApiException {
        Call localVarCall = this.deleteMetricGroupValidateBeforeCall(projectKey, metricGroupKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteMetricGroupAsync(@Nonnull String projectKey, @Nonnull String metricGroupKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteMetricGroupValidateBeforeCall(projectKey, metricGroupKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getMetricGroupCall(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nullable String expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups/{metricGroupKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{metricGroupKey}", this.localVarApiClient.escapeString(metricGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetricGroupValidateBeforeCall(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nullable String expand, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getMetricGroup(Async)");
        }
        if (metricGroupKey == null) {
            throw new ApiException("Missing the required parameter 'metricGroupKey' when calling getMetricGroup(Async)");
        }
        return this.getMetricGroupCall(projectKey, metricGroupKey, expand, _callback);
    }

    public MetricGroupRep getMetricGroup(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nullable String expand) throws ApiException {
        ApiResponse<MetricGroupRep> localVarResp = this.getMetricGroupWithHttpInfo(projectKey, metricGroupKey, expand);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupRep> getMetricGroupWithHttpInfo(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nullable String expand) throws ApiException {
        Call localVarCall = this.getMetricGroupValidateBeforeCall(projectKey, metricGroupKey, expand, null);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMetricGroupAsync(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nullable String expand, ApiCallback<MetricGroupRep> _callback) throws ApiException {
        Call localVarCall = this.getMetricGroupValidateBeforeCall(projectKey, metricGroupKey, expand, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getMetricGroupsCall(@Nonnull String projectKey, @Nullable String filter, @Nullable String sort, @Nullable String expand, @Nullable Long limit, @Nullable Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (expand != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expand", expand));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMetricGroupsValidateBeforeCall(@Nonnull String projectKey, @Nullable String filter, @Nullable String sort, @Nullable String expand, @Nullable Long limit, @Nullable Long offset, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getMetricGroups(Async)");
        }
        return this.getMetricGroupsCall(projectKey, filter, sort, expand, limit, offset, _callback);
    }

    public MetricGroupCollectionRep getMetricGroups(@Nonnull String projectKey, @Nullable String filter, @Nullable String sort, @Nullable String expand, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        ApiResponse<MetricGroupCollectionRep> localVarResp = this.getMetricGroupsWithHttpInfo(projectKey, filter, sort, expand, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupCollectionRep> getMetricGroupsWithHttpInfo(@Nonnull String projectKey, @Nullable String filter, @Nullable String sort, @Nullable String expand, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        Call localVarCall = this.getMetricGroupsValidateBeforeCall(projectKey, filter, sort, expand, limit, offset, null);
        Type localVarReturnType = new TypeToken<MetricGroupCollectionRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getMetricGroupsAsync(@Nonnull String projectKey, @Nullable String filter, @Nullable String sort, @Nullable String expand, @Nullable Long limit, @Nullable Long offset, ApiCallback<MetricGroupCollectionRep> _callback) throws ApiException {
        Call localVarCall = this.getMetricGroupsValidateBeforeCall(projectKey, filter, sort, expand, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupCollectionRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchMetricGroupCall(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/projects/{projectKey}/metric-groups/{metricGroupKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{metricGroupKey}", this.localVarApiClient.escapeString(metricGroupKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchMetricGroupValidateBeforeCall(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchMetricGroup(Async)");
        }
        if (metricGroupKey == null) {
            throw new ApiException("Missing the required parameter 'metricGroupKey' when calling patchMetricGroup(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchMetricGroup(Async)");
        }
        return this.patchMetricGroupCall(projectKey, metricGroupKey, patchOperation, _callback);
    }

    public MetricGroupRep patchMetricGroup(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<MetricGroupRep> localVarResp = this.patchMetricGroupWithHttpInfo(projectKey, metricGroupKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<MetricGroupRep> patchMetricGroupWithHttpInfo(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchMetricGroupValidateBeforeCall(projectKey, metricGroupKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchMetricGroupAsync(@Nonnull String projectKey, @Nonnull String metricGroupKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback<MetricGroupRep> _callback) throws ApiException {
        Call localVarCall = this.patchMetricGroupValidateBeforeCall(projectKey, metricGroupKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<MetricGroupRep>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

