/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.Client;
import com.launchdarkly.api.model.ClientCollection;
import com.launchdarkly.api.model.OauthClientPost;
import com.launchdarkly.api.model.PatchOperation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import okhttp3.Call;

public class OAuth2ClientsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OAuth2ClientsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OAuth2ClientsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createOAuth2ClientCall(@Nonnull OauthClientPost oauthClientPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OauthClientPost localVarPostBody = oauthClientPost;
        String localVarPath = "/api/v2/oauth/clients";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOAuth2ClientValidateBeforeCall(@Nonnull OauthClientPost oauthClientPost, ApiCallback _callback) throws ApiException {
        if (oauthClientPost == null) {
            throw new ApiException("Missing the required parameter 'oauthClientPost' when calling createOAuth2Client(Async)");
        }
        return this.createOAuth2ClientCall(oauthClientPost, _callback);
    }

    public Client createOAuth2Client(@Nonnull OauthClientPost oauthClientPost) throws ApiException {
        ApiResponse<Client> localVarResp = this.createOAuth2ClientWithHttpInfo(oauthClientPost);
        return localVarResp.getData();
    }

    public ApiResponse<Client> createOAuth2ClientWithHttpInfo(@Nonnull OauthClientPost oauthClientPost) throws ApiException {
        Call localVarCall = this.createOAuth2ClientValidateBeforeCall(oauthClientPost, null);
        Type localVarReturnType = new TypeToken<Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createOAuth2ClientAsync(@Nonnull OauthClientPost oauthClientPost, ApiCallback<Client> _callback) throws ApiException {
        Call localVarCall = this.createOAuth2ClientValidateBeforeCall(oauthClientPost, _callback);
        Type localVarReturnType = new TypeToken<Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteOAuthClientCall(@Nonnull String clientId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/oauth/clients/{clientId}".replace("{clientId}", this.localVarApiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOAuthClientValidateBeforeCall(@Nonnull String clientId, ApiCallback _callback) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling deleteOAuthClient(Async)");
        }
        return this.deleteOAuthClientCall(clientId, _callback);
    }

    public void deleteOAuthClient(@Nonnull String clientId) throws ApiException {
        this.deleteOAuthClientWithHttpInfo(clientId);
    }

    public ApiResponse<Void> deleteOAuthClientWithHttpInfo(@Nonnull String clientId) throws ApiException {
        Call localVarCall = this.deleteOAuthClientValidateBeforeCall(clientId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteOAuthClientAsync(@Nonnull String clientId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteOAuthClientValidateBeforeCall(clientId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getOAuthClientByIdCall(@Nonnull String clientId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/oauth/clients/{clientId}".replace("{clientId}", this.localVarApiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOAuthClientByIdValidateBeforeCall(@Nonnull String clientId, ApiCallback _callback) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling getOAuthClientById(Async)");
        }
        return this.getOAuthClientByIdCall(clientId, _callback);
    }

    public Client getOAuthClientById(@Nonnull String clientId) throws ApiException {
        ApiResponse<Client> localVarResp = this.getOAuthClientByIdWithHttpInfo(clientId);
        return localVarResp.getData();
    }

    public ApiResponse<Client> getOAuthClientByIdWithHttpInfo(@Nonnull String clientId) throws ApiException {
        Call localVarCall = this.getOAuthClientByIdValidateBeforeCall(clientId, null);
        Type localVarReturnType = new TypeToken<Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOAuthClientByIdAsync(@Nonnull String clientId, ApiCallback<Client> _callback) throws ApiException {
        Call localVarCall = this.getOAuthClientByIdValidateBeforeCall(clientId, _callback);
        Type localVarReturnType = new TypeToken<Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOAuthClientsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/oauth/clients";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOAuthClientsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getOAuthClientsCall(_callback);
    }

    public ClientCollection getOAuthClients() throws ApiException {
        ApiResponse<ClientCollection> localVarResp = this.getOAuthClientsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ClientCollection> getOAuthClientsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getOAuthClientsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ClientCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOAuthClientsAsync(ApiCallback<ClientCollection> _callback) throws ApiException {
        Call localVarCall = this.getOAuthClientsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ClientCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchOAuthClientCall(@Nonnull String clientId, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/oauth/clients/{clientId}".replace("{clientId}", this.localVarApiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchOAuthClientValidateBeforeCall(@Nonnull String clientId, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling patchOAuthClient(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchOAuthClient(Async)");
        }
        return this.patchOAuthClientCall(clientId, patchOperation, _callback);
    }

    public Client patchOAuthClient(@Nonnull String clientId, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<Client> localVarResp = this.patchOAuthClientWithHttpInfo(clientId, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<Client> patchOAuthClientWithHttpInfo(@Nonnull String clientId, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchOAuthClientValidateBeforeCall(clientId, patchOperation, null);
        Type localVarReturnType = new TypeToken<Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchOAuthClientAsync(@Nonnull String clientId, @Nonnull List<PatchOperation> patchOperation, ApiCallback<Client> _callback) throws ApiException {
        Call localVarCall = this.patchOAuthClientValidateBeforeCall(clientId, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

