/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.CreateReleasePipelineInput;
import com.launchdarkly.api.model.ReleasePipeline;
import com.launchdarkly.api.model.ReleasePipelineCollection;
import com.launchdarkly.api.model.ReleaseProgressionCollection;
import com.launchdarkly.api.model.UpdateReleasePipelineInput;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ReleasePipelinesBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ReleasePipelinesBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReleasePipelinesBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteReleasePipelineCall(@Nonnull String projectKey, @Nonnull String pipelineKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/release-pipelines/{pipelineKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{pipelineKey}", this.localVarApiClient.escapeString(pipelineKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteReleasePipelineValidateBeforeCall(@Nonnull String projectKey, @Nonnull String pipelineKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteReleasePipeline(Async)");
        }
        if (pipelineKey == null) {
            throw new ApiException("Missing the required parameter 'pipelineKey' when calling deleteReleasePipeline(Async)");
        }
        return this.deleteReleasePipelineCall(projectKey, pipelineKey, _callback);
    }

    public void deleteReleasePipeline(@Nonnull String projectKey, @Nonnull String pipelineKey) throws ApiException {
        this.deleteReleasePipelineWithHttpInfo(projectKey, pipelineKey);
    }

    public ApiResponse<Void> deleteReleasePipelineWithHttpInfo(@Nonnull String projectKey, @Nonnull String pipelineKey) throws ApiException {
        Call localVarCall = this.deleteReleasePipelineValidateBeforeCall(projectKey, pipelineKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteReleasePipelineAsync(@Nonnull String projectKey, @Nonnull String pipelineKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteReleasePipelineValidateBeforeCall(projectKey, pipelineKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllReleasePipelinesCall(@Nonnull String projectKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/release-pipelines".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllReleasePipelinesValidateBeforeCall(@Nonnull String projectKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAllReleasePipelines(Async)");
        }
        return this.getAllReleasePipelinesCall(projectKey, filter, limit, offset, _callback);
    }

    public ReleasePipelineCollection getAllReleasePipelines(@Nonnull String projectKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        ApiResponse<ReleasePipelineCollection> localVarResp = this.getAllReleasePipelinesWithHttpInfo(projectKey, filter, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ReleasePipelineCollection> getAllReleasePipelinesWithHttpInfo(@Nonnull String projectKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        Call localVarCall = this.getAllReleasePipelinesValidateBeforeCall(projectKey, filter, limit, offset, null);
        Type localVarReturnType = new TypeToken<ReleasePipelineCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllReleasePipelinesAsync(@Nonnull String projectKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset, ApiCallback<ReleasePipelineCollection> _callback) throws ApiException {
        Call localVarCall = this.getAllReleasePipelinesValidateBeforeCall(projectKey, filter, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ReleasePipelineCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAllReleaseProgressionsForReleasePipelineCall(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/release-pipelines/{pipelineKey}/releases".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{pipelineKey}", this.localVarApiClient.escapeString(pipelineKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllReleaseProgressionsForReleasePipelineValidateBeforeCall(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getAllReleaseProgressionsForReleasePipeline(Async)");
        }
        if (pipelineKey == null) {
            throw new ApiException("Missing the required parameter 'pipelineKey' when calling getAllReleaseProgressionsForReleasePipeline(Async)");
        }
        return this.getAllReleaseProgressionsForReleasePipelineCall(projectKey, pipelineKey, filter, limit, offset, _callback);
    }

    public ReleaseProgressionCollection getAllReleaseProgressionsForReleasePipeline(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        ApiResponse<ReleaseProgressionCollection> localVarResp = this.getAllReleaseProgressionsForReleasePipelineWithHttpInfo(projectKey, pipelineKey, filter, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<ReleaseProgressionCollection> getAllReleaseProgressionsForReleasePipelineWithHttpInfo(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        Call localVarCall = this.getAllReleaseProgressionsForReleasePipelineValidateBeforeCall(projectKey, pipelineKey, filter, limit, offset, null);
        Type localVarReturnType = new TypeToken<ReleaseProgressionCollection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllReleaseProgressionsForReleasePipelineAsync(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nullable String filter, @Nullable Long limit, @Nullable Long offset, ApiCallback<ReleaseProgressionCollection> _callback) throws ApiException {
        Call localVarCall = this.getAllReleaseProgressionsForReleasePipelineValidateBeforeCall(projectKey, pipelineKey, filter, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<ReleaseProgressionCollection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getReleasePipelineByKeyCall(@Nonnull String projectKey, @Nonnull String pipelineKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/release-pipelines/{pipelineKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{pipelineKey}", this.localVarApiClient.escapeString(pipelineKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReleasePipelineByKeyValidateBeforeCall(@Nonnull String projectKey, @Nonnull String pipelineKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getReleasePipelineByKey(Async)");
        }
        if (pipelineKey == null) {
            throw new ApiException("Missing the required parameter 'pipelineKey' when calling getReleasePipelineByKey(Async)");
        }
        return this.getReleasePipelineByKeyCall(projectKey, pipelineKey, _callback);
    }

    public ReleasePipeline getReleasePipelineByKey(@Nonnull String projectKey, @Nonnull String pipelineKey) throws ApiException {
        ApiResponse<ReleasePipeline> localVarResp = this.getReleasePipelineByKeyWithHttpInfo(projectKey, pipelineKey);
        return localVarResp.getData();
    }

    public ApiResponse<ReleasePipeline> getReleasePipelineByKeyWithHttpInfo(@Nonnull String projectKey, @Nonnull String pipelineKey) throws ApiException {
        Call localVarCall = this.getReleasePipelineByKeyValidateBeforeCall(projectKey, pipelineKey, null);
        Type localVarReturnType = new TypeToken<ReleasePipeline>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReleasePipelineByKeyAsync(@Nonnull String projectKey, @Nonnull String pipelineKey, ApiCallback<ReleasePipeline> _callback) throws ApiException {
        Call localVarCall = this.getReleasePipelineByKeyValidateBeforeCall(projectKey, pipelineKey, _callback);
        Type localVarReturnType = new TypeToken<ReleasePipeline>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postReleasePipelineCall(@Nonnull String projectKey, @Nonnull CreateReleasePipelineInput createReleasePipelineInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateReleasePipelineInput localVarPostBody = createReleasePipelineInput;
        String localVarPath = "/api/v2/projects/{projectKey}/release-pipelines".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postReleasePipelineValidateBeforeCall(@Nonnull String projectKey, @Nonnull CreateReleasePipelineInput createReleasePipelineInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postReleasePipeline(Async)");
        }
        if (createReleasePipelineInput == null) {
            throw new ApiException("Missing the required parameter 'createReleasePipelineInput' when calling postReleasePipeline(Async)");
        }
        return this.postReleasePipelineCall(projectKey, createReleasePipelineInput, _callback);
    }

    public ReleasePipeline postReleasePipeline(@Nonnull String projectKey, @Nonnull CreateReleasePipelineInput createReleasePipelineInput) throws ApiException {
        ApiResponse<ReleasePipeline> localVarResp = this.postReleasePipelineWithHttpInfo(projectKey, createReleasePipelineInput);
        return localVarResp.getData();
    }

    public ApiResponse<ReleasePipeline> postReleasePipelineWithHttpInfo(@Nonnull String projectKey, @Nonnull CreateReleasePipelineInput createReleasePipelineInput) throws ApiException {
        Call localVarCall = this.postReleasePipelineValidateBeforeCall(projectKey, createReleasePipelineInput, null);
        Type localVarReturnType = new TypeToken<ReleasePipeline>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postReleasePipelineAsync(@Nonnull String projectKey, @Nonnull CreateReleasePipelineInput createReleasePipelineInput, ApiCallback<ReleasePipeline> _callback) throws ApiException {
        Call localVarCall = this.postReleasePipelineValidateBeforeCall(projectKey, createReleasePipelineInput, _callback);
        Type localVarReturnType = new TypeToken<ReleasePipeline>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putReleasePipelineCall(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nonnull UpdateReleasePipelineInput updateReleasePipelineInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateReleasePipelineInput localVarPostBody = updateReleasePipelineInput;
        String localVarPath = "/api/v2/projects/{projectKey}/release-pipelines/{pipelineKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{pipelineKey}", this.localVarApiClient.escapeString(pipelineKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putReleasePipelineValidateBeforeCall(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nonnull UpdateReleasePipelineInput updateReleasePipelineInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling putReleasePipeline(Async)");
        }
        if (pipelineKey == null) {
            throw new ApiException("Missing the required parameter 'pipelineKey' when calling putReleasePipeline(Async)");
        }
        if (updateReleasePipelineInput == null) {
            throw new ApiException("Missing the required parameter 'updateReleasePipelineInput' when calling putReleasePipeline(Async)");
        }
        return this.putReleasePipelineCall(projectKey, pipelineKey, updateReleasePipelineInput, _callback);
    }

    public ReleasePipeline putReleasePipeline(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nonnull UpdateReleasePipelineInput updateReleasePipelineInput) throws ApiException {
        ApiResponse<ReleasePipeline> localVarResp = this.putReleasePipelineWithHttpInfo(projectKey, pipelineKey, updateReleasePipelineInput);
        return localVarResp.getData();
    }

    public ApiResponse<ReleasePipeline> putReleasePipelineWithHttpInfo(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nonnull UpdateReleasePipelineInput updateReleasePipelineInput) throws ApiException {
        Call localVarCall = this.putReleasePipelineValidateBeforeCall(projectKey, pipelineKey, updateReleasePipelineInput, null);
        Type localVarReturnType = new TypeToken<ReleasePipeline>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call putReleasePipelineAsync(@Nonnull String projectKey, @Nonnull String pipelineKey, @Nonnull UpdateReleasePipelineInput updateReleasePipelineInput, ApiCallback<ReleasePipeline> _callback) throws ApiException {
        Call localVarCall = this.putReleasePipelineValidateBeforeCall(projectKey, pipelineKey, updateReleasePipelineInput, _callback);
        Type localVarReturnType = new TypeToken<ReleasePipeline>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

