/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.CreateReleaseInput;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.Release;
import com.launchdarkly.api.model.UpdatePhaseStatusInput;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import okhttp3.Call;

public class ReleasesBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ReleasesBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReleasesBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createReleaseForFlagCall(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull CreateReleaseInput createReleaseInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateReleaseInput localVarPostBody = createReleaseInput;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{flagKey}/release".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{flagKey}", this.localVarApiClient.escapeString(flagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createReleaseForFlagValidateBeforeCall(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull CreateReleaseInput createReleaseInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createReleaseForFlag(Async)");
        }
        if (flagKey == null) {
            throw new ApiException("Missing the required parameter 'flagKey' when calling createReleaseForFlag(Async)");
        }
        if (createReleaseInput == null) {
            throw new ApiException("Missing the required parameter 'createReleaseInput' when calling createReleaseForFlag(Async)");
        }
        return this.createReleaseForFlagCall(projectKey, flagKey, createReleaseInput, _callback);
    }

    public Release createReleaseForFlag(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull CreateReleaseInput createReleaseInput) throws ApiException {
        ApiResponse<Release> localVarResp = this.createReleaseForFlagWithHttpInfo(projectKey, flagKey, createReleaseInput);
        return localVarResp.getData();
    }

    public ApiResponse<Release> createReleaseForFlagWithHttpInfo(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull CreateReleaseInput createReleaseInput) throws ApiException {
        Call localVarCall = this.createReleaseForFlagValidateBeforeCall(projectKey, flagKey, createReleaseInput, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createReleaseForFlagAsync(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull CreateReleaseInput createReleaseInput, ApiCallback<Release> _callback) throws ApiException {
        Call localVarCall = this.createReleaseForFlagValidateBeforeCall(projectKey, flagKey, createReleaseInput, _callback);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteReleaseByFlagKeyCall(@Nonnull String projectKey, @Nonnull String flagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{flagKey}/release".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{flagKey}", this.localVarApiClient.escapeString(flagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteReleaseByFlagKeyValidateBeforeCall(@Nonnull String projectKey, @Nonnull String flagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteReleaseByFlagKey(Async)");
        }
        if (flagKey == null) {
            throw new ApiException("Missing the required parameter 'flagKey' when calling deleteReleaseByFlagKey(Async)");
        }
        return this.deleteReleaseByFlagKeyCall(projectKey, flagKey, _callback);
    }

    public void deleteReleaseByFlagKey(@Nonnull String projectKey, @Nonnull String flagKey) throws ApiException {
        this.deleteReleaseByFlagKeyWithHttpInfo(projectKey, flagKey);
    }

    public ApiResponse<Void> deleteReleaseByFlagKeyWithHttpInfo(@Nonnull String projectKey, @Nonnull String flagKey) throws ApiException {
        Call localVarCall = this.deleteReleaseByFlagKeyValidateBeforeCall(projectKey, flagKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteReleaseByFlagKeyAsync(@Nonnull String projectKey, @Nonnull String flagKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteReleaseByFlagKeyValidateBeforeCall(projectKey, flagKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getReleaseByFlagKeyCall(@Nonnull String projectKey, @Nonnull String flagKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/flags/{projectKey}/{flagKey}/release".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{flagKey}", this.localVarApiClient.escapeString(flagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReleaseByFlagKeyValidateBeforeCall(@Nonnull String projectKey, @Nonnull String flagKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getReleaseByFlagKey(Async)");
        }
        if (flagKey == null) {
            throw new ApiException("Missing the required parameter 'flagKey' when calling getReleaseByFlagKey(Async)");
        }
        return this.getReleaseByFlagKeyCall(projectKey, flagKey, _callback);
    }

    public Release getReleaseByFlagKey(@Nonnull String projectKey, @Nonnull String flagKey) throws ApiException {
        ApiResponse<Release> localVarResp = this.getReleaseByFlagKeyWithHttpInfo(projectKey, flagKey);
        return localVarResp.getData();
    }

    public ApiResponse<Release> getReleaseByFlagKeyWithHttpInfo(@Nonnull String projectKey, @Nonnull String flagKey) throws ApiException {
        Call localVarCall = this.getReleaseByFlagKeyValidateBeforeCall(projectKey, flagKey, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getReleaseByFlagKeyAsync(@Nonnull String projectKey, @Nonnull String flagKey, ApiCallback<Release> _callback) throws ApiException {
        Call localVarCall = this.getReleaseByFlagKeyValidateBeforeCall(projectKey, flagKey, _callback);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchReleaseByFlagKeyCall(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<PatchOperation> localVarPostBody = patchOperation;
        String localVarPath = "/api/v2/flags/{projectKey}/{flagKey}/release".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{flagKey}", this.localVarApiClient.escapeString(flagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchReleaseByFlagKeyValidateBeforeCall(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchReleaseByFlagKey(Async)");
        }
        if (flagKey == null) {
            throw new ApiException("Missing the required parameter 'flagKey' when calling patchReleaseByFlagKey(Async)");
        }
        if (patchOperation == null) {
            throw new ApiException("Missing the required parameter 'patchOperation' when calling patchReleaseByFlagKey(Async)");
        }
        return this.patchReleaseByFlagKeyCall(projectKey, flagKey, patchOperation, _callback);
    }

    public Release patchReleaseByFlagKey(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        ApiResponse<Release> localVarResp = this.patchReleaseByFlagKeyWithHttpInfo(projectKey, flagKey, patchOperation);
        return localVarResp.getData();
    }

    public ApiResponse<Release> patchReleaseByFlagKeyWithHttpInfo(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull List<PatchOperation> patchOperation) throws ApiException {
        Call localVarCall = this.patchReleaseByFlagKeyValidateBeforeCall(projectKey, flagKey, patchOperation, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchReleaseByFlagKeyAsync(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull List<PatchOperation> patchOperation, ApiCallback<Release> _callback) throws ApiException {
        Call localVarCall = this.patchReleaseByFlagKeyValidateBeforeCall(projectKey, flagKey, patchOperation, _callback);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updatePhaseStatusCall(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String phaseId, @Nonnull UpdatePhaseStatusInput updatePhaseStatusInput, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePhaseStatusInput localVarPostBody = updatePhaseStatusInput;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{flagKey}/release/phases/{phaseId}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{flagKey}", this.localVarApiClient.escapeString(flagKey.toString())).replace("{phaseId}", this.localVarApiClient.escapeString(phaseId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePhaseStatusValidateBeforeCall(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String phaseId, @Nonnull UpdatePhaseStatusInput updatePhaseStatusInput, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updatePhaseStatus(Async)");
        }
        if (flagKey == null) {
            throw new ApiException("Missing the required parameter 'flagKey' when calling updatePhaseStatus(Async)");
        }
        if (phaseId == null) {
            throw new ApiException("Missing the required parameter 'phaseId' when calling updatePhaseStatus(Async)");
        }
        if (updatePhaseStatusInput == null) {
            throw new ApiException("Missing the required parameter 'updatePhaseStatusInput' when calling updatePhaseStatus(Async)");
        }
        return this.updatePhaseStatusCall(projectKey, flagKey, phaseId, updatePhaseStatusInput, _callback);
    }

    public Release updatePhaseStatus(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String phaseId, @Nonnull UpdatePhaseStatusInput updatePhaseStatusInput) throws ApiException {
        ApiResponse<Release> localVarResp = this.updatePhaseStatusWithHttpInfo(projectKey, flagKey, phaseId, updatePhaseStatusInput);
        return localVarResp.getData();
    }

    public ApiResponse<Release> updatePhaseStatusWithHttpInfo(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String phaseId, @Nonnull UpdatePhaseStatusInput updatePhaseStatusInput) throws ApiException {
        Call localVarCall = this.updatePhaseStatusValidateBeforeCall(projectKey, flagKey, phaseId, updatePhaseStatusInput, null);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updatePhaseStatusAsync(@Nonnull String projectKey, @Nonnull String flagKey, @Nonnull String phaseId, @Nonnull UpdatePhaseStatusInput updatePhaseStatusInput, ApiCallback<Release> _callback) throws ApiException {
        Call localVarCall = this.updatePhaseStatusValidateBeforeCall(projectKey, flagKey, phaseId, updatePhaseStatusInput, _callback);
        Type localVarReturnType = new TypeToken<Release>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

