/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.BigSegmentTarget;
import com.launchdarkly.api.model.ContextInstanceSegmentMemberships;
import com.launchdarkly.api.model.ExpiringTargetGetResponse;
import com.launchdarkly.api.model.ExpiringTargetPatchResponse;
import com.launchdarkly.api.model.ExpiringUserTargetGetResponse;
import com.launchdarkly.api.model.ExpiringUserTargetPatchResponse;
import com.launchdarkly.api.model.Export;
import com.launchdarkly.api.model.ModelImport;
import com.launchdarkly.api.model.PatchSegmentExpiringTargetInputRep;
import com.launchdarkly.api.model.PatchSegmentRequest;
import com.launchdarkly.api.model.PatchWithComment;
import com.launchdarkly.api.model.SegmentBody;
import com.launchdarkly.api.model.SegmentUserState;
import com.launchdarkly.api.model.UserSegment;
import com.launchdarkly.api.model.UserSegments;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class SegmentsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SegmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createBigSegmentExportCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/exports".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBigSegmentExportValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createBigSegmentExport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createBigSegmentExport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling createBigSegmentExport(Async)");
        }
        return this.createBigSegmentExportCall(projectKey, environmentKey, segmentKey, _callback);
    }

    public void createBigSegmentExport(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        this.createBigSegmentExportWithHttpInfo(projectKey, environmentKey, segmentKey);
    }

    public ApiResponse<Void> createBigSegmentExportWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        Call localVarCall = this.createBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createBigSegmentExportAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createBigSegmentImportCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nullable File _file, @Nullable String mode, @Nullable Boolean waitOnApprovals, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/imports".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarFormParams.put("file", _file);
        }
        if (mode != null) {
            localVarFormParams.put("mode", mode);
        }
        if (waitOnApprovals != null) {
            localVarFormParams.put("waitOnApprovals", waitOnApprovals);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBigSegmentImportValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nullable File _file, @Nullable String mode, @Nullable Boolean waitOnApprovals, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createBigSegmentImport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling createBigSegmentImport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling createBigSegmentImport(Async)");
        }
        return this.createBigSegmentImportCall(projectKey, environmentKey, segmentKey, _file, mode, waitOnApprovals, _callback);
    }

    public void createBigSegmentImport(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nullable File _file, @Nullable String mode, @Nullable Boolean waitOnApprovals) throws ApiException {
        this.createBigSegmentImportWithHttpInfo(projectKey, environmentKey, segmentKey, _file, mode, waitOnApprovals);
    }

    public ApiResponse<Void> createBigSegmentImportWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nullable File _file, @Nullable String mode, @Nullable Boolean waitOnApprovals) throws ApiException {
        Call localVarCall = this.createBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, _file, mode, waitOnApprovals, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createBigSegmentImportAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nullable File _file, @Nullable String mode, @Nullable Boolean waitOnApprovals, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, _file, mode, waitOnApprovals, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteSegmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteSegmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling deleteSegment(Async)");
        }
        return this.deleteSegmentCall(projectKey, environmentKey, segmentKey, _callback);
    }

    public void deleteSegment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        this.deleteSegmentWithHttpInfo(projectKey, environmentKey, segmentKey);
    }

    public ApiResponse<Void> deleteSegmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        Call localVarCall = this.deleteSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteSegmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getBigSegmentExportCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String exportID, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/exports/{exportID}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString())).replace("{exportID}", this.localVarApiClient.escapeString(exportID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBigSegmentExportValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String exportID, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getBigSegmentExport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getBigSegmentExport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getBigSegmentExport(Async)");
        }
        if (exportID == null) {
            throw new ApiException("Missing the required parameter 'exportID' when calling getBigSegmentExport(Async)");
        }
        return this.getBigSegmentExportCall(projectKey, environmentKey, segmentKey, exportID, _callback);
    }

    public Export getBigSegmentExport(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String exportID) throws ApiException {
        ApiResponse<Export> localVarResp = this.getBigSegmentExportWithHttpInfo(projectKey, environmentKey, segmentKey, exportID);
        return localVarResp.getData();
    }

    public ApiResponse<Export> getBigSegmentExportWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String exportID) throws ApiException {
        Call localVarCall = this.getBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, exportID, null);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBigSegmentExportAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String exportID, ApiCallback<Export> _callback) throws ApiException {
        Call localVarCall = this.getBigSegmentExportValidateBeforeCall(projectKey, environmentKey, segmentKey, exportID, _callback);
        Type localVarReturnType = new TypeToken<Export>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBigSegmentImportCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String importID, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/imports/{importID}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString())).replace("{importID}", this.localVarApiClient.escapeString(importID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBigSegmentImportValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String importID, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getBigSegmentImport(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getBigSegmentImport(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getBigSegmentImport(Async)");
        }
        if (importID == null) {
            throw new ApiException("Missing the required parameter 'importID' when calling getBigSegmentImport(Async)");
        }
        return this.getBigSegmentImportCall(projectKey, environmentKey, segmentKey, importID, _callback);
    }

    public ModelImport getBigSegmentImport(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String importID) throws ApiException {
        ApiResponse<ModelImport> localVarResp = this.getBigSegmentImportWithHttpInfo(projectKey, environmentKey, segmentKey, importID);
        return localVarResp.getData();
    }

    public ApiResponse<ModelImport> getBigSegmentImportWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String importID) throws ApiException {
        Call localVarCall = this.getBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, importID, null);
        Type localVarReturnType = new TypeToken<ModelImport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBigSegmentImportAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String importID, ApiCallback<ModelImport> _callback) throws ApiException {
        Call localVarCall = this.getBigSegmentImportValidateBeforeCall(projectKey, environmentKey, segmentKey, importID, _callback);
        Type localVarReturnType = new TypeToken<ModelImport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContextInstanceSegmentsMembershipByEnvCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull Map<String, Object> requestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Map<String, Object> localVarPostBody = requestBody;
        String localVarPath = "/api/v2/projects/{projectKey}/environments/{environmentKey}/segments/evaluate".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContextInstanceSegmentsMembershipByEnvValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull Map<String, Object> requestBody, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getContextInstanceSegmentsMembershipByEnv(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getContextInstanceSegmentsMembershipByEnv(Async)");
        }
        if (requestBody == null) {
            throw new ApiException("Missing the required parameter 'requestBody' when calling getContextInstanceSegmentsMembershipByEnv(Async)");
        }
        return this.getContextInstanceSegmentsMembershipByEnvCall(projectKey, environmentKey, requestBody, _callback);
    }

    public ContextInstanceSegmentMemberships getContextInstanceSegmentsMembershipByEnv(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull Map<String, Object> requestBody) throws ApiException {
        ApiResponse<ContextInstanceSegmentMemberships> localVarResp = this.getContextInstanceSegmentsMembershipByEnvWithHttpInfo(projectKey, environmentKey, requestBody);
        return localVarResp.getData();
    }

    public ApiResponse<ContextInstanceSegmentMemberships> getContextInstanceSegmentsMembershipByEnvWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull Map<String, Object> requestBody) throws ApiException {
        Call localVarCall = this.getContextInstanceSegmentsMembershipByEnvValidateBeforeCall(projectKey, environmentKey, requestBody, null);
        Type localVarReturnType = new TypeToken<ContextInstanceSegmentMemberships>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContextInstanceSegmentsMembershipByEnvAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull Map<String, Object> requestBody, ApiCallback<ContextInstanceSegmentMemberships> _callback) throws ApiException {
        Call localVarCall = this.getContextInstanceSegmentsMembershipByEnvValidateBeforeCall(projectKey, environmentKey, requestBody, _callback);
        Type localVarReturnType = new TypeToken<ContextInstanceSegmentMemberships>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExpiringTargetsForSegmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{segmentKey}/expiring-targets/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiringTargetsForSegmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringTargetsForSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringTargetsForSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getExpiringTargetsForSegment(Async)");
        }
        return this.getExpiringTargetsForSegmentCall(projectKey, environmentKey, segmentKey, _callback);
    }

    public ExpiringTargetGetResponse getExpiringTargetsForSegment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        ApiResponse<ExpiringTargetGetResponse> localVarResp = this.getExpiringTargetsForSegmentWithHttpInfo(projectKey, environmentKey, segmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringTargetGetResponse> getExpiringTargetsForSegmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        Call localVarCall = this.getExpiringTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        Type localVarReturnType = new TypeToken<ExpiringTargetGetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiringTargetsForSegmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback<ExpiringTargetGetResponse> _callback) throws ApiException {
        Call localVarCall = this.getExpiringTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        Type localVarReturnType = new TypeToken<ExpiringTargetGetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExpiringUserTargetsForSegmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{segmentKey}/expiring-user-targets/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiringUserTargetsForSegmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringUserTargetsForSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringUserTargetsForSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getExpiringUserTargetsForSegment(Async)");
        }
        return this.getExpiringUserTargetsForSegmentCall(projectKey, environmentKey, segmentKey, _callback);
    }

    public ExpiringUserTargetGetResponse getExpiringUserTargetsForSegment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        ApiResponse<ExpiringUserTargetGetResponse> localVarResp = this.getExpiringUserTargetsForSegmentWithHttpInfo(projectKey, environmentKey, segmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringUserTargetGetResponse> getExpiringUserTargetsForSegmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        Call localVarCall = this.getExpiringUserTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetGetResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiringUserTargetsForSegmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback<ExpiringUserTargetGetResponse> _callback) throws ApiException {
        Call localVarCall = this.getExpiringUserTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetGetResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSegmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSegmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getSegment(Async)");
        }
        return this.getSegmentCall(projectKey, environmentKey, segmentKey, _callback);
    }

    public UserSegment getSegment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        ApiResponse<UserSegment> localVarResp = this.getSegmentWithHttpInfo(projectKey, environmentKey, segmentKey);
        return localVarResp.getData();
    }

    public ApiResponse<UserSegment> getSegmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey) throws ApiException {
        Call localVarCall = this.getSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSegmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, ApiCallback<UserSegment> _callback) throws ApiException {
        Call localVarCall = this.getSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, _callback);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSegmentMembershipForContextCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String contextKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/contexts/{contextKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString())).replace("{contextKey}", this.localVarApiClient.escapeString(contextKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSegmentMembershipForContextValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String contextKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSegmentMembershipForContext(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSegmentMembershipForContext(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getSegmentMembershipForContext(Async)");
        }
        if (contextKey == null) {
            throw new ApiException("Missing the required parameter 'contextKey' when calling getSegmentMembershipForContext(Async)");
        }
        return this.getSegmentMembershipForContextCall(projectKey, environmentKey, segmentKey, contextKey, _callback);
    }

    public BigSegmentTarget getSegmentMembershipForContext(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String contextKey) throws ApiException {
        ApiResponse<BigSegmentTarget> localVarResp = this.getSegmentMembershipForContextWithHttpInfo(projectKey, environmentKey, segmentKey, contextKey);
        return localVarResp.getData();
    }

    public ApiResponse<BigSegmentTarget> getSegmentMembershipForContextWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String contextKey) throws ApiException {
        Call localVarCall = this.getSegmentMembershipForContextValidateBeforeCall(projectKey, environmentKey, segmentKey, contextKey, null);
        Type localVarReturnType = new TypeToken<BigSegmentTarget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSegmentMembershipForContextAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String contextKey, ApiCallback<BigSegmentTarget> _callback) throws ApiException {
        Call localVarCall = this.getSegmentMembershipForContextValidateBeforeCall(projectKey, environmentKey, segmentKey, contextKey, _callback);
        Type localVarReturnType = new TypeToken<BigSegmentTarget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSegmentMembershipForUserCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String userKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/users/{userKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString())).replace("{userKey}", this.localVarApiClient.escapeString(userKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSegmentMembershipForUserValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String userKey, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSegmentMembershipForUser(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSegmentMembershipForUser(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling getSegmentMembershipForUser(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getSegmentMembershipForUser(Async)");
        }
        return this.getSegmentMembershipForUserCall(projectKey, environmentKey, segmentKey, userKey, _callback);
    }

    public BigSegmentTarget getSegmentMembershipForUser(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String userKey) throws ApiException {
        ApiResponse<BigSegmentTarget> localVarResp = this.getSegmentMembershipForUserWithHttpInfo(projectKey, environmentKey, segmentKey, userKey);
        return localVarResp.getData();
    }

    public ApiResponse<BigSegmentTarget> getSegmentMembershipForUserWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String userKey) throws ApiException {
        Call localVarCall = this.getSegmentMembershipForUserValidateBeforeCall(projectKey, environmentKey, segmentKey, userKey, null);
        Type localVarReturnType = new TypeToken<BigSegmentTarget>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSegmentMembershipForUserAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull String userKey, ApiCallback<BigSegmentTarget> _callback) throws ApiException {
        Call localVarCall = this.getSegmentMembershipForUserValidateBeforeCall(projectKey, environmentKey, segmentKey, userKey, _callback);
        Type localVarReturnType = new TypeToken<BigSegmentTarget>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSegmentsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSegmentsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getSegments(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getSegments(Async)");
        }
        return this.getSegmentsCall(projectKey, environmentKey, limit, offset, sort, filter, _callback);
    }

    public UserSegments getSegments(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter) throws ApiException {
        ApiResponse<UserSegments> localVarResp = this.getSegmentsWithHttpInfo(projectKey, environmentKey, limit, offset, sort, filter);
        return localVarResp.getData();
    }

    public ApiResponse<UserSegments> getSegmentsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter) throws ApiException {
        Call localVarCall = this.getSegmentsValidateBeforeCall(projectKey, environmentKey, limit, offset, sort, filter, null);
        Type localVarReturnType = new TypeToken<UserSegments>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSegmentsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nullable Long limit, @Nullable Long offset, @Nullable String sort, @Nullable String filter, ApiCallback<UserSegments> _callback) throws ApiException {
        Call localVarCall = this.getSegmentsValidateBeforeCall(projectKey, environmentKey, limit, offset, sort, filter, _callback);
        Type localVarReturnType = new TypeToken<UserSegments>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExpiringTargetsForSegmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchSegmentExpiringTargetInputRep localVarPostBody = patchSegmentExpiringTargetInputRep;
        String localVarPath = "/api/v2/segments/{projectKey}/{segmentKey}/expiring-targets/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExpiringTargetsForSegmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringTargetsForSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringTargetsForSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling patchExpiringTargetsForSegment(Async)");
        }
        if (patchSegmentExpiringTargetInputRep == null) {
            throw new ApiException("Missing the required parameter 'patchSegmentExpiringTargetInputRep' when calling patchExpiringTargetsForSegment(Async)");
        }
        return this.patchExpiringTargetsForSegmentCall(projectKey, environmentKey, segmentKey, patchSegmentExpiringTargetInputRep, _callback);
    }

    public ExpiringTargetPatchResponse patchExpiringTargetsForSegment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep) throws ApiException {
        ApiResponse<ExpiringTargetPatchResponse> localVarResp = this.patchExpiringTargetsForSegmentWithHttpInfo(projectKey, environmentKey, segmentKey, patchSegmentExpiringTargetInputRep);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringTargetPatchResponse> patchExpiringTargetsForSegmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep) throws ApiException {
        Call localVarCall = this.patchExpiringTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchSegmentExpiringTargetInputRep, null);
        Type localVarReturnType = new TypeToken<ExpiringTargetPatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExpiringTargetsForSegmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentExpiringTargetInputRep patchSegmentExpiringTargetInputRep, ApiCallback<ExpiringTargetPatchResponse> _callback) throws ApiException {
        Call localVarCall = this.patchExpiringTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchSegmentExpiringTargetInputRep, _callback);
        Type localVarReturnType = new TypeToken<ExpiringTargetPatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchExpiringUserTargetsForSegmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentRequest patchSegmentRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchSegmentRequest localVarPostBody = patchSegmentRequest;
        String localVarPath = "/api/v2/segments/{projectKey}/{segmentKey}/expiring-user-targets/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchExpiringUserTargetsForSegmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentRequest patchSegmentRequest, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringUserTargetsForSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringUserTargetsForSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling patchExpiringUserTargetsForSegment(Async)");
        }
        if (patchSegmentRequest == null) {
            throw new ApiException("Missing the required parameter 'patchSegmentRequest' when calling patchExpiringUserTargetsForSegment(Async)");
        }
        return this.patchExpiringUserTargetsForSegmentCall(projectKey, environmentKey, segmentKey, patchSegmentRequest, _callback);
    }

    public ExpiringUserTargetPatchResponse patchExpiringUserTargetsForSegment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentRequest patchSegmentRequest) throws ApiException {
        ApiResponse<ExpiringUserTargetPatchResponse> localVarResp = this.patchExpiringUserTargetsForSegmentWithHttpInfo(projectKey, environmentKey, segmentKey, patchSegmentRequest);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiringUserTargetPatchResponse> patchExpiringUserTargetsForSegmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentRequest patchSegmentRequest) throws ApiException {
        Call localVarCall = this.patchExpiringUserTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchSegmentRequest, null);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetPatchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchExpiringUserTargetsForSegmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchSegmentRequest patchSegmentRequest, ApiCallback<ExpiringUserTargetPatchResponse> _callback) throws ApiException {
        Call localVarCall = this.patchExpiringUserTargetsForSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchSegmentRequest, _callback);
        Type localVarReturnType = new TypeToken<ExpiringUserTargetPatchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchSegmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchWithComment patchWithComment, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PatchWithComment localVarPostBody = patchWithComment;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchSegmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchWithComment patchWithComment, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchSegment(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling patchSegment(Async)");
        }
        if (patchWithComment == null) {
            throw new ApiException("Missing the required parameter 'patchWithComment' when calling patchSegment(Async)");
        }
        return this.patchSegmentCall(projectKey, environmentKey, segmentKey, patchWithComment, _callback);
    }

    public UserSegment patchSegment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchWithComment patchWithComment) throws ApiException {
        ApiResponse<UserSegment> localVarResp = this.patchSegmentWithHttpInfo(projectKey, environmentKey, segmentKey, patchWithComment);
        return localVarResp.getData();
    }

    public ApiResponse<UserSegment> patchSegmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchWithComment patchWithComment) throws ApiException {
        Call localVarCall = this.patchSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchWithComment, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchSegmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull PatchWithComment patchWithComment, ApiCallback<UserSegment> _callback) throws ApiException {
        Call localVarCall = this.patchSegmentValidateBeforeCall(projectKey, environmentKey, segmentKey, patchWithComment, _callback);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postSegmentCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull SegmentBody segmentBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SegmentBody localVarPostBody = segmentBody;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postSegmentValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull SegmentBody segmentBody, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postSegment(Async)");
        }
        if (segmentBody == null) {
            throw new ApiException("Missing the required parameter 'segmentBody' when calling postSegment(Async)");
        }
        return this.postSegmentCall(projectKey, environmentKey, segmentBody, _callback);
    }

    public UserSegment postSegment(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull SegmentBody segmentBody) throws ApiException {
        ApiResponse<UserSegment> localVarResp = this.postSegmentWithHttpInfo(projectKey, environmentKey, segmentBody);
        return localVarResp.getData();
    }

    public ApiResponse<UserSegment> postSegmentWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull SegmentBody segmentBody) throws ApiException {
        Call localVarCall = this.postSegmentValidateBeforeCall(projectKey, environmentKey, segmentBody, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postSegmentAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull SegmentBody segmentBody, ApiCallback<UserSegment> _callback) throws ApiException {
        Call localVarCall = this.postSegmentValidateBeforeCall(projectKey, environmentKey, segmentBody, _callback);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateBigSegmentContextTargetsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SegmentUserState localVarPostBody = segmentUserState;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/contexts".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateBigSegmentContextTargetsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateBigSegmentContextTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling updateBigSegmentContextTargets(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling updateBigSegmentContextTargets(Async)");
        }
        if (segmentUserState == null) {
            throw new ApiException("Missing the required parameter 'segmentUserState' when calling updateBigSegmentContextTargets(Async)");
        }
        return this.updateBigSegmentContextTargetsCall(projectKey, environmentKey, segmentKey, segmentUserState, _callback);
    }

    public void updateBigSegmentContextTargets(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState) throws ApiException {
        this.updateBigSegmentContextTargetsWithHttpInfo(projectKey, environmentKey, segmentKey, segmentUserState);
    }

    public ApiResponse<Void> updateBigSegmentContextTargetsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState) throws ApiException {
        Call localVarCall = this.updateBigSegmentContextTargetsValidateBeforeCall(projectKey, environmentKey, segmentKey, segmentUserState, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateBigSegmentContextTargetsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateBigSegmentContextTargetsValidateBeforeCall(projectKey, environmentKey, segmentKey, segmentUserState, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateBigSegmentTargetsCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        SegmentUserState localVarPostBody = segmentUserState;
        String localVarPath = "/api/v2/segments/{projectKey}/{environmentKey}/{segmentKey}/users".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{segmentKey}", this.localVarApiClient.escapeString(segmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateBigSegmentTargetsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateBigSegmentTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling updateBigSegmentTargets(Async)");
        }
        if (segmentKey == null) {
            throw new ApiException("Missing the required parameter 'segmentKey' when calling updateBigSegmentTargets(Async)");
        }
        if (segmentUserState == null) {
            throw new ApiException("Missing the required parameter 'segmentUserState' when calling updateBigSegmentTargets(Async)");
        }
        return this.updateBigSegmentTargetsCall(projectKey, environmentKey, segmentKey, segmentUserState, _callback);
    }

    public void updateBigSegmentTargets(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState) throws ApiException {
        this.updateBigSegmentTargetsWithHttpInfo(projectKey, environmentKey, segmentKey, segmentUserState);
    }

    public ApiResponse<Void> updateBigSegmentTargetsWithHttpInfo(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState) throws ApiException {
        Call localVarCall = this.updateBigSegmentTargetsValidateBeforeCall(projectKey, environmentKey, segmentKey, segmentUserState, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateBigSegmentTargetsAsync(@Nonnull String projectKey, @Nonnull String environmentKey, @Nonnull String segmentKey, @Nonnull SegmentUserState segmentUserState, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateBigSegmentTargetsValidateBeforeCall(projectKey, environmentKey, segmentKey, segmentUserState, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

