/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.LinkResourceSuccessResponse;
import com.launchdarkly.api.model.UnlinkResourceSuccessResponse;
import com.launchdarkly.api.model.View;
import com.launchdarkly.api.model.ViewLinkRequest;
import com.launchdarkly.api.model.ViewLinkedResources;
import com.launchdarkly.api.model.ViewPatch;
import com.launchdarkly.api.model.ViewPost;
import com.launchdarkly.api.model.Views;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ViewsBetaApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ViewsBetaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ViewsBetaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createViewCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ViewPost viewPost, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ViewPost localVarPostBody = viewPost;
        String localVarPath = "/api/v2/projects/{projectKey}/views".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createViewValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ViewPost viewPost, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling createView(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling createView(Async)");
        }
        if (viewPost == null) {
            throw new ApiException("Missing the required parameter 'viewPost' when calling createView(Async)");
        }
        return this.createViewCall(ldAPIVersion, projectKey, viewPost, _callback);
    }

    public View createView(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ViewPost viewPost) throws ApiException {
        ApiResponse<View> localVarResp = this.createViewWithHttpInfo(ldAPIVersion, projectKey, viewPost);
        return localVarResp.getData();
    }

    public ApiResponse<View> createViewWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ViewPost viewPost) throws ApiException {
        Call localVarCall = this.createViewValidateBeforeCall(ldAPIVersion, projectKey, viewPost, null);
        Type localVarReturnType = new TypeToken<View>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createViewAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull ViewPost viewPost, ApiCallback<View> _callback) throws ApiException {
        Call localVarCall = this.createViewValidateBeforeCall(ldAPIVersion, projectKey, viewPost, _callback);
        Type localVarReturnType = new TypeToken<View>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteViewCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/views/{viewKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{viewKey}", this.localVarApiClient.escapeString(viewKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteViewValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling deleteView(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteView(Async)");
        }
        if (viewKey == null) {
            throw new ApiException("Missing the required parameter 'viewKey' when calling deleteView(Async)");
        }
        return this.deleteViewCall(ldAPIVersion, projectKey, viewKey, _callback);
    }

    public void deleteView(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey) throws ApiException {
        this.deleteViewWithHttpInfo(ldAPIVersion, projectKey, viewKey);
    }

    public ApiResponse<Void> deleteViewWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey) throws ApiException {
        Call localVarCall = this.deleteViewValidateBeforeCall(ldAPIVersion, projectKey, viewKey, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteViewAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteViewValidateBeforeCall(ldAPIVersion, projectKey, viewKey, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getLinkedResourcesCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sort, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/views/{viewKey}/linked/{resourceType}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{viewKey}", this.localVarApiClient.escapeString(viewKey.toString())).replace("{resourceType}", this.localVarApiClient.escapeString(resourceType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLinkedResourcesValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sort, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getLinkedResources(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getLinkedResources(Async)");
        }
        if (viewKey == null) {
            throw new ApiException("Missing the required parameter 'viewKey' when calling getLinkedResources(Async)");
        }
        if (resourceType == null) {
            throw new ApiException("Missing the required parameter 'resourceType' when calling getLinkedResources(Async)");
        }
        return this.getLinkedResourcesCall(ldAPIVersion, projectKey, viewKey, resourceType, limit, offset, sort, _callback);
    }

    public ViewLinkedResources getLinkedResources(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sort) throws ApiException {
        ApiResponse<ViewLinkedResources> localVarResp = this.getLinkedResourcesWithHttpInfo(ldAPIVersion, projectKey, viewKey, resourceType, limit, offset, sort);
        return localVarResp.getData();
    }

    public ApiResponse<ViewLinkedResources> getLinkedResourcesWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sort) throws ApiException {
        Call localVarCall = this.getLinkedResourcesValidateBeforeCall(ldAPIVersion, projectKey, viewKey, resourceType, limit, offset, sort, null);
        Type localVarReturnType = new TypeToken<ViewLinkedResources>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLinkedResourcesAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nullable Integer limit, @Nullable Integer offset, @Nullable String sort, ApiCallback<ViewLinkedResources> _callback) throws ApiException {
        Call localVarCall = this.getLinkedResourcesValidateBeforeCall(ldAPIVersion, projectKey, viewKey, resourceType, limit, offset, sort, _callback);
        Type localVarReturnType = new TypeToken<ViewLinkedResources>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLinkedViewsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String resourceType, @Nonnull String resourceKey, @Nullable String environmentId, @Nullable Integer limit, @Nullable Integer offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/view-associations/{resourceType}/{resourceKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{resourceType}", this.localVarApiClient.escapeString(resourceType.toString())).replace("{resourceKey}", this.localVarApiClient.escapeString(resourceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (environmentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("environmentId", environmentId));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLinkedViewsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String resourceType, @Nonnull String resourceKey, @Nullable String environmentId, @Nullable Integer limit, @Nullable Integer offset, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getLinkedViews(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getLinkedViews(Async)");
        }
        if (resourceType == null) {
            throw new ApiException("Missing the required parameter 'resourceType' when calling getLinkedViews(Async)");
        }
        if (resourceKey == null) {
            throw new ApiException("Missing the required parameter 'resourceKey' when calling getLinkedViews(Async)");
        }
        return this.getLinkedViewsCall(ldAPIVersion, projectKey, resourceType, resourceKey, environmentId, limit, offset, _callback);
    }

    public Views getLinkedViews(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String resourceType, @Nonnull String resourceKey, @Nullable String environmentId, @Nullable Integer limit, @Nullable Integer offset) throws ApiException {
        ApiResponse<Views> localVarResp = this.getLinkedViewsWithHttpInfo(ldAPIVersion, projectKey, resourceType, resourceKey, environmentId, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<Views> getLinkedViewsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String resourceType, @Nonnull String resourceKey, @Nullable String environmentId, @Nullable Integer limit, @Nullable Integer offset) throws ApiException {
        Call localVarCall = this.getLinkedViewsValidateBeforeCall(ldAPIVersion, projectKey, resourceType, resourceKey, environmentId, limit, offset, null);
        Type localVarReturnType = new TypeToken<Views>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLinkedViewsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String resourceType, @Nonnull String resourceKey, @Nullable String environmentId, @Nullable Integer limit, @Nullable Integer offset, ApiCallback<Views> _callback) throws ApiException {
        Call localVarCall = this.getLinkedViewsValidateBeforeCall(ldAPIVersion, projectKey, resourceType, resourceKey, environmentId, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<Views>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getViewCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/views/{viewKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{viewKey}", this.localVarApiClient.escapeString(viewKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getViewValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getView(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getView(Async)");
        }
        if (viewKey == null) {
            throw new ApiException("Missing the required parameter 'viewKey' when calling getView(Async)");
        }
        return this.getViewCall(ldAPIVersion, projectKey, viewKey, sort, limit, offset, filter, expand, _callback);
    }

    public View getView(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand) throws ApiException {
        ApiResponse<View> localVarResp = this.getViewWithHttpInfo(ldAPIVersion, projectKey, viewKey, sort, limit, offset, filter, expand);
        return localVarResp.getData();
    }

    public ApiResponse<View> getViewWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand) throws ApiException {
        Call localVarCall = this.getViewValidateBeforeCall(ldAPIVersion, projectKey, viewKey, sort, limit, offset, filter, expand, null);
        Type localVarReturnType = new TypeToken<View>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getViewAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand, ApiCallback<View> _callback) throws ApiException {
        Call localVarCall = this.getViewValidateBeforeCall(ldAPIVersion, projectKey, viewKey, sort, limit, offset, filter, expand, _callback);
        Type localVarReturnType = new TypeToken<View>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getViewsCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/views".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filter", filter));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "expand", expand));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getViewsValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling getViews(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getViews(Async)");
        }
        return this.getViewsCall(ldAPIVersion, projectKey, sort, limit, offset, filter, expand, _callback);
    }

    public Views getViews(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand) throws ApiException {
        ApiResponse<Views> localVarResp = this.getViewsWithHttpInfo(ldAPIVersion, projectKey, sort, limit, offset, filter, expand);
        return localVarResp.getData();
    }

    public ApiResponse<Views> getViewsWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand) throws ApiException {
        Call localVarCall = this.getViewsValidateBeforeCall(ldAPIVersion, projectKey, sort, limit, offset, filter, expand, null);
        Type localVarReturnType = new TypeToken<Views>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getViewsAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nullable String sort, @Nullable Integer limit, @Nullable Integer offset, @Nullable String filter, @Nullable List<String> expand, ApiCallback<Views> _callback) throws ApiException {
        Call localVarCall = this.getViewsValidateBeforeCall(ldAPIVersion, projectKey, sort, limit, offset, filter, expand, _callback);
        Type localVarReturnType = new TypeToken<Views>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call linkResourceCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ViewLinkRequest localVarPostBody = viewLinkRequest;
        String localVarPath = "/api/v2/projects/{projectKey}/views/{viewKey}/link/{resourceType}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{viewKey}", this.localVarApiClient.escapeString(viewKey.toString())).replace("{resourceType}", this.localVarApiClient.escapeString(resourceType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call linkResourceValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling linkResource(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling linkResource(Async)");
        }
        if (viewKey == null) {
            throw new ApiException("Missing the required parameter 'viewKey' when calling linkResource(Async)");
        }
        if (resourceType == null) {
            throw new ApiException("Missing the required parameter 'resourceType' when calling linkResource(Async)");
        }
        if (viewLinkRequest == null) {
            throw new ApiException("Missing the required parameter 'viewLinkRequest' when calling linkResource(Async)");
        }
        return this.linkResourceCall(ldAPIVersion, projectKey, viewKey, resourceType, viewLinkRequest, _callback);
    }

    public LinkResourceSuccessResponse linkResource(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest) throws ApiException {
        ApiResponse<LinkResourceSuccessResponse> localVarResp = this.linkResourceWithHttpInfo(ldAPIVersion, projectKey, viewKey, resourceType, viewLinkRequest);
        return localVarResp.getData();
    }

    public ApiResponse<LinkResourceSuccessResponse> linkResourceWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest) throws ApiException {
        Call localVarCall = this.linkResourceValidateBeforeCall(ldAPIVersion, projectKey, viewKey, resourceType, viewLinkRequest, null);
        Type localVarReturnType = new TypeToken<LinkResourceSuccessResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call linkResourceAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest, ApiCallback<LinkResourceSuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.linkResourceValidateBeforeCall(ldAPIVersion, projectKey, viewKey, resourceType, viewLinkRequest, _callback);
        Type localVarReturnType = new TypeToken<LinkResourceSuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unlinkResourceCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ViewLinkRequest localVarPostBody = viewLinkRequest;
        String localVarPath = "/api/v2/projects/{projectKey}/views/{viewKey}/link/{resourceType}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{viewKey}", this.localVarApiClient.escapeString(viewKey.toString())).replace("{resourceType}", this.localVarApiClient.escapeString(resourceType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unlinkResourceValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling unlinkResource(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling unlinkResource(Async)");
        }
        if (viewKey == null) {
            throw new ApiException("Missing the required parameter 'viewKey' when calling unlinkResource(Async)");
        }
        if (resourceType == null) {
            throw new ApiException("Missing the required parameter 'resourceType' when calling unlinkResource(Async)");
        }
        if (viewLinkRequest == null) {
            throw new ApiException("Missing the required parameter 'viewLinkRequest' when calling unlinkResource(Async)");
        }
        return this.unlinkResourceCall(ldAPIVersion, projectKey, viewKey, resourceType, viewLinkRequest, _callback);
    }

    public UnlinkResourceSuccessResponse unlinkResource(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest) throws ApiException {
        ApiResponse<UnlinkResourceSuccessResponse> localVarResp = this.unlinkResourceWithHttpInfo(ldAPIVersion, projectKey, viewKey, resourceType, viewLinkRequest);
        return localVarResp.getData();
    }

    public ApiResponse<UnlinkResourceSuccessResponse> unlinkResourceWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest) throws ApiException {
        Call localVarCall = this.unlinkResourceValidateBeforeCall(ldAPIVersion, projectKey, viewKey, resourceType, viewLinkRequest, null);
        Type localVarReturnType = new TypeToken<UnlinkResourceSuccessResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call unlinkResourceAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull String resourceType, @Nonnull ViewLinkRequest viewLinkRequest, ApiCallback<UnlinkResourceSuccessResponse> _callback) throws ApiException {
        Call localVarCall = this.unlinkResourceValidateBeforeCall(ldAPIVersion, projectKey, viewKey, resourceType, viewLinkRequest, _callback);
        Type localVarReturnType = new TypeToken<UnlinkResourceSuccessResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateViewCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull ViewPatch viewPatch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ViewPatch localVarPostBody = viewPatch;
        String localVarPath = "/api/v2/projects/{projectKey}/views/{viewKey}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{viewKey}", this.localVarApiClient.escapeString(viewKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (ldAPIVersion != null) {
            localVarHeaderParams.put("LD-API-Version", this.localVarApiClient.parameterToString(ldAPIVersion));
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateViewValidateBeforeCall(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull ViewPatch viewPatch, ApiCallback _callback) throws ApiException {
        if (ldAPIVersion == null) {
            throw new ApiException("Missing the required parameter 'ldAPIVersion' when calling updateView(Async)");
        }
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateView(Async)");
        }
        if (viewKey == null) {
            throw new ApiException("Missing the required parameter 'viewKey' when calling updateView(Async)");
        }
        if (viewPatch == null) {
            throw new ApiException("Missing the required parameter 'viewPatch' when calling updateView(Async)");
        }
        return this.updateViewCall(ldAPIVersion, projectKey, viewKey, viewPatch, _callback);
    }

    public View updateView(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull ViewPatch viewPatch) throws ApiException {
        ApiResponse<View> localVarResp = this.updateViewWithHttpInfo(ldAPIVersion, projectKey, viewKey, viewPatch);
        return localVarResp.getData();
    }

    public ApiResponse<View> updateViewWithHttpInfo(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull ViewPatch viewPatch) throws ApiException {
        Call localVarCall = this.updateViewValidateBeforeCall(ldAPIVersion, projectKey, viewKey, viewPatch, null);
        Type localVarReturnType = new TypeToken<View>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateViewAsync(@Nonnull String ldAPIVersion, @Nonnull String projectKey, @Nonnull String viewKey, @Nonnull ViewPatch viewPatch, ApiCallback<View> _callback) throws ApiException {
        Call localVarCall = this.updateViewValidateBeforeCall(ldAPIVersion, projectKey, viewKey, viewPatch, _callback);
        Type localVarReturnType = new TypeToken<View>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

