/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.model.CustomWorkflowInput;
import com.launchdarkly.api.model.CustomWorkflowOutput;
import com.launchdarkly.api.model.CustomWorkflowsListingOutput;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class WorkflowsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WorkflowsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteWorkflowCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/workflows/{workflowId}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{workflowId}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWorkflowValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteWorkflow(Async)");
        }
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling deleteWorkflow(Async)");
        }
        return this.deleteWorkflowCall(projectKey, featureFlagKey, environmentKey, workflowId, _callback);
    }

    public void deleteWorkflow(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId) throws ApiException {
        this.deleteWorkflowWithHttpInfo(projectKey, featureFlagKey, environmentKey, workflowId);
    }

    public ApiResponse<Void> deleteWorkflowWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId) throws ApiException {
        Call localVarCall = this.deleteWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, workflowId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteWorkflowAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, workflowId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getCustomWorkflowCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/workflows/{workflowId}".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString())).replace("{workflowId}", this.localVarApiClient.escapeString(workflowId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomWorkflowValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getCustomWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getCustomWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getCustomWorkflow(Async)");
        }
        if (workflowId == null) {
            throw new ApiException("Missing the required parameter 'workflowId' when calling getCustomWorkflow(Async)");
        }
        return this.getCustomWorkflowCall(projectKey, featureFlagKey, environmentKey, workflowId, _callback);
    }

    public CustomWorkflowOutput getCustomWorkflow(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId) throws ApiException {
        ApiResponse<CustomWorkflowOutput> localVarResp = this.getCustomWorkflowWithHttpInfo(projectKey, featureFlagKey, environmentKey, workflowId);
        return localVarResp.getData();
    }

    public ApiResponse<CustomWorkflowOutput> getCustomWorkflowWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId) throws ApiException {
        Call localVarCall = this.getCustomWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, workflowId, null);
        Type localVarReturnType = new TypeToken<CustomWorkflowOutput>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCustomWorkflowAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull String workflowId, ApiCallback<CustomWorkflowOutput> _callback) throws ApiException {
        Call localVarCall = this.getCustomWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, workflowId, _callback);
        Type localVarReturnType = new TypeToken<CustomWorkflowOutput>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWorkflowsCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nullable String status, @Nullable String sort, @Nullable Long limit, @Nullable Long offset, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/workflows".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWorkflowsValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nullable String status, @Nullable String sort, @Nullable Long limit, @Nullable Long offset, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getWorkflows(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getWorkflows(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getWorkflows(Async)");
        }
        return this.getWorkflowsCall(projectKey, featureFlagKey, environmentKey, status, sort, limit, offset, _callback);
    }

    public CustomWorkflowsListingOutput getWorkflows(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nullable String status, @Nullable String sort, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        ApiResponse<CustomWorkflowsListingOutput> localVarResp = this.getWorkflowsWithHttpInfo(projectKey, featureFlagKey, environmentKey, status, sort, limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<CustomWorkflowsListingOutput> getWorkflowsWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nullable String status, @Nullable String sort, @Nullable Long limit, @Nullable Long offset) throws ApiException {
        Call localVarCall = this.getWorkflowsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, status, sort, limit, offset, null);
        Type localVarReturnType = new TypeToken<CustomWorkflowsListingOutput>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWorkflowsAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nullable String status, @Nullable String sort, @Nullable Long limit, @Nullable Long offset, ApiCallback<CustomWorkflowsListingOutput> _callback) throws ApiException {
        Call localVarCall = this.getWorkflowsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, status, sort, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<CustomWorkflowsListingOutput>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postWorkflowCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull CustomWorkflowInput customWorkflowInput, @Nullable String templateKey, @Nullable Boolean dryRun, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CustomWorkflowInput localVarPostBody = customWorkflowInput;
        String localVarPath = "/api/v2/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/workflows".replace("{projectKey}", this.localVarApiClient.escapeString(projectKey.toString())).replace("{featureFlagKey}", this.localVarApiClient.escapeString(featureFlagKey.toString())).replace("{environmentKey}", this.localVarApiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (templateKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("templateKey", templateKey));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"ApiKey"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postWorkflowValidateBeforeCall(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull CustomWorkflowInput customWorkflowInput, @Nullable String templateKey, @Nullable Boolean dryRun, ApiCallback _callback) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postWorkflow(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postWorkflow(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postWorkflow(Async)");
        }
        if (customWorkflowInput == null) {
            throw new ApiException("Missing the required parameter 'customWorkflowInput' when calling postWorkflow(Async)");
        }
        return this.postWorkflowCall(projectKey, featureFlagKey, environmentKey, customWorkflowInput, templateKey, dryRun, _callback);
    }

    public CustomWorkflowOutput postWorkflow(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull CustomWorkflowInput customWorkflowInput, @Nullable String templateKey, @Nullable Boolean dryRun) throws ApiException {
        ApiResponse<CustomWorkflowOutput> localVarResp = this.postWorkflowWithHttpInfo(projectKey, featureFlagKey, environmentKey, customWorkflowInput, templateKey, dryRun);
        return localVarResp.getData();
    }

    public ApiResponse<CustomWorkflowOutput> postWorkflowWithHttpInfo(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull CustomWorkflowInput customWorkflowInput, @Nullable String templateKey, @Nullable Boolean dryRun) throws ApiException {
        Call localVarCall = this.postWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, customWorkflowInput, templateKey, dryRun, null);
        Type localVarReturnType = new TypeToken<CustomWorkflowOutput>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postWorkflowAsync(@Nonnull String projectKey, @Nonnull String featureFlagKey, @Nonnull String environmentKey, @Nonnull CustomWorkflowInput customWorkflowInput, @Nullable String templateKey, @Nullable Boolean dryRun, ApiCallback<CustomWorkflowOutput> _callback) throws ApiException {
        Call localVarCall = this.postWorkflowValidateBeforeCall(projectKey, featureFlagKey, environmentKey, customWorkflowInput, templateKey, dryRun, _callback);
        Type localVarReturnType = new TypeToken<CustomWorkflowOutput>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

