/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AIConfigMaintainer;
import com.launchdarkly.api.model.AIConfigVariation;
import com.launchdarkly.api.model.AiConfigsAccess;
import com.launchdarkly.api.model.ParentAndSelfLinks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AIConfig {
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    @Nullable
    private AiConfigsAccess access;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nullable
    private ParentAndSelfLinks links;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nonnull
    private String description;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_MAINTAINER = "_maintainer";
    @SerializedName(value="_maintainer")
    @Nullable
    private AIConfigMaintainer maintainer;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    @Nullable
    private ModeEnum mode = ModeEnum.COMPLETION;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nonnull
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    @Nonnull
    private Integer version;
    public static final String SERIALIZED_NAME_VARIATIONS = "variations";
    @SerializedName(value="variations")
    @Nonnull
    private List<AIConfigVariation> variations = new ArrayList<AIConfigVariation>();
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    @Nonnull
    private Long createdAt;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    @Nonnull
    private Long updatedAt;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_access", "_links", "description", "key", "_maintainer", "mode", "name", "tags", "version", "variations", "createdAt", "updatedAt"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("description", "key", "name", "tags", "version", "variations", "createdAt", "updatedAt"));

    public AIConfig access(@Nullable AiConfigsAccess access) {
        this.access = access;
        return this;
    }

    @Nullable
    public AiConfigsAccess getAccess() {
        return this.access;
    }

    public void setAccess(@Nullable AiConfigsAccess access) {
        this.access = access;
    }

    public AIConfig links(@Nullable ParentAndSelfLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    public ParentAndSelfLinks getLinks() {
        return this.links;
    }

    public void setLinks(@Nullable ParentAndSelfLinks links) {
        this.links = links;
    }

    public AIConfig description(@Nonnull String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nonnull String description) {
        this.description = description;
    }

    public AIConfig key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public AIConfig maintainer(@Nullable AIConfigMaintainer maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    @Nullable
    public AIConfigMaintainer getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(@Nullable AIConfigMaintainer maintainer) {
        this.maintainer = maintainer;
    }

    public AIConfig mode(@Nullable ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Nullable
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(@Nullable ModeEnum mode) {
        this.mode = mode;
    }

    public AIConfig name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public AIConfig tags(@Nonnull List<String> tags) {
        this.tags = tags;
        return this;
    }

    public AIConfig addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }

    public AIConfig version(@Nonnull Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull Integer version) {
        this.version = version;
    }

    public AIConfig variations(@Nonnull List<AIConfigVariation> variations) {
        this.variations = variations;
        return this;
    }

    public AIConfig addVariationsItem(AIConfigVariation variationsItem) {
        if (this.variations == null) {
            this.variations = new ArrayList<AIConfigVariation>();
        }
        this.variations.add(variationsItem);
        return this;
    }

    @Nonnull
    public List<AIConfigVariation> getVariations() {
        return this.variations;
    }

    public void setVariations(@Nonnull List<AIConfigVariation> variations) {
        this.variations = variations;
    }

    public AIConfig createdAt(@Nonnull Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(@Nonnull Long createdAt) {
        this.createdAt = createdAt;
    }

    public AIConfig updatedAt(@Nonnull Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nonnull
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(@Nonnull Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public AIConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AIConfig aiConfig = (AIConfig)o;
        return Objects.equals(this.access, aiConfig.access) && Objects.equals(this.links, aiConfig.links) && Objects.equals(this.description, aiConfig.description) && Objects.equals(this.key, aiConfig.key) && Objects.equals(this.maintainer, aiConfig.maintainer) && Objects.equals((Object)this.mode, (Object)aiConfig.mode) && Objects.equals(this.name, aiConfig.name) && Objects.equals(this.tags, aiConfig.tags) && Objects.equals(this.version, aiConfig.version) && Objects.equals(this.variations, aiConfig.variations) && Objects.equals(this.createdAt, aiConfig.createdAt) && Objects.equals(this.updatedAt, aiConfig.updatedAt) && Objects.equals(this.additionalProperties, aiConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.access, this.links, this.description, this.key, this.maintainer, this.mode, this.name, this.tags, this.version, this.variations, this.createdAt, this.updatedAt, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AIConfig {\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    maintainer: ").append(this.toIndentedString(this.maintainer)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in AIConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            AiConfigsAccess.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINKS) != null && !jsonObj.get(SERIALIZED_NAME_LINKS).isJsonNull()) {
            ParentAndSelfLinks.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LINKS));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER).isJsonNull()) {
            AIConfigMaintainer.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MAINTAINER));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODE) != null && !jsonObj.get(SERIALIZED_NAME_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODE) != null && !jsonObj.get(SERIALIZED_NAME_MODE).isJsonNull()) {
            ModeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MODE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VARIATIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `variations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIATIONS).toString()));
        }
        JsonArray jsonArrayvariations = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIATIONS);
        for (int i = 0; i < jsonArrayvariations.size(); ++i) {
            AIConfigVariation.validateJsonElement(jsonArrayvariations.get(i));
        }
    }

    public static AIConfig fromJson(String jsonString) throws IOException {
        return (AIConfig)JSON.getGson().fromJson(jsonString, AIConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AIConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AIConfig.class));
            return new TypeAdapter<AIConfig>(){

                public void write(JsonWriter out, AIConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AIConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AIConfig.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    AIConfig instance = (AIConfig)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ModeEnum {
        AGENT("agent"),
        COMPLETION("completion"),
        JUDGE("judge");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ModeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ModeEnum> {
            public void write(JsonWriter jsonWriter, ModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ModeEnum.fromValue(value);
            }
        }
    }
}

